REM Copyright 2000 by Robert J. Sawyer

rem   |   A batch file for creating Adobe Acrobat PDF files
rem   |   from WordStar documents.

rem   |   This is a 4DOS batch file; you can select 4DOS as you
rem   |   your command interpreter in DOSBox-X.conf under the
rem   |   [config] section by setting "shell=4DOS.COM".

rem   |   You'll need to customzie the pathing below to match
rem   |   where Acrobat files are located on your computer

rem   |   NOTE:  If Acrobat Distiller is not available locally, then 
rem   |   simply go to http://www.ps2pdf.com and upload the WORDSTAR.PS 
rem   |   file produced by this batch file.

rem   |  Revision history:
rem   |   * Tuesday, October 17, 2000
rem   |   * Updated Thursday, September 13, 2001
rem   |   * Instructions clarified Monday, December 17, 2001
rem   |   * Updated for Acrobat 5.0 on Friday, February 22, 2002
rem   |   * Updated for Acrobat 7.0 on Saturday, December 16, 2006
rem   |   * Updated to keep copy of PDFs produced on Sunday, December 29, 2019

rem   |  Make sure the WordStar file is set to use the "ACROBAT" print driver.
rem   |                                                 =======

REM    1. Make sure Acrobat Distiller font locations include C:\WS\FONTS\PS
      
REM    2. Make sure "View PDF when using Distiller" option is set in 
REM       Acrobat Distiller preferences
      
REM    3. Make sure the WordStar file has .po set to 1"
      
REM    4. To use, invoke "PDF" from DOS command line.  If an argument is given, 
REM       that will be passed to WordStar as filename.

md c:\wspdf > nul

*copy c:\ws\fonts\ps\no-ps.ps c:\WSpdf\WordStar.ps > nul

c:\ws\ws %1 /m _SetAcro

on break goto AfterWS1
:AfterWS1

@cls

c:\ws\ws  %1 /p /x

on break goto AfterWS2
:AfterWS2

OPTION //Win95LFN=YES

REM TEXT
REM 
REM Ŀ
REM                                              
REM   Once the PDF has been created and opened   
REM   (which can take some time; be patient),    
REM   use <Alt><Tab> to move focus back to       
REM   DOSBox-X, and then issue ^C to Distiller.  
REM                                              
REM 
REM 
REM ENDTEXT
REM 
TEXT

     Ŀ
                                                          
       Now creating a PDF file from a WordStar document.  
                                                          
       DOSBox-X takes a while to load Acrobat Distiller.  
       Be patient.  Distiller will close automatically    
       once the PDF has been created and opened.          
                                                          
     


ENDTEXT

REM "/N /Q" go before file names and cause Distiller to exit when the job is done
start "C:\Program Files\Adobe\Acrobat 7.0\Distillr\acrodist.exe" /N /Q C:\WSpdf\WordStar.ps
OPTION //Win95LFN=NO

@cls
TEXT

     Ŀ
                                                             
       PDF file C:\WSPDF\WORDSTAR.PDF successfully created.  
               Save the file under a new filename.           
                                                             
     

ENDTEXT
