.. Holy Macro! by Charles Maher
..
.. All files condolidated into this one and cleaned up for printing 
.. by RJS on Sunday, November 16, 2014.
..
.mt5
.mb6 
.hm2
.lm1
.rm65
..cw12
..ls1
.po1i
.lh8
..pl66
.ps off
.pn0
.op











                      H o l y   M a c r o !  


                           Version 5

     
  A Handbook of Macros for WordStar 4.0, 5.0, 5.5, 6.0 and 7.0

































     
     
     
                                                   Charles Maher
.pn0

     
     
     
     





                  Copyright 1992 Charles Maher



























               WordStar is a registered trademark

             of WordStar International Incorporated
     












.fo
                         
.pn0

     
     
     
     

















             James Burton of WordStar International     

             reviewed the macros in this handbook.

             His assistance is gratefully acknowledged.


























     
     
.pn0

     
     
     










          C o n t e n t s 




     1/To Begin With  1



     2/Creating Macros  4

         Function Keys  4

         Shorthand  8

         WordStar 7.0 Macros  13
   


     3/Checklist  16



     4/Macro Library  22

          Backing Up Files  22

          Blocking Lines  27

          Blocking Paragraphs 29

          Blocking Sentences  32

          Blocking Words  37

          Boldfacing and Italicizing  39  
     
          Case Conversion  44
     
     
                               iv
.pn0


     
          Changing Fonts  47
     
          Dating and Signing Letters  51
     
          Deleting BAK Files  54

          Deleting to the End of a File  55

          Deleting to the End of a Page  57

          Deleting to the End of a Paragraph  58

          Deleting to the End of a Sentence  60

          Deleting Paragraphs  62

          Deleting Sentences  63

          Deleting to the Start of a File  65

          Deleting to the Start of a Paragraph  66

          Deleting to the Start of a Sentence  68

          Deleting Words  69

          Directory A:  70

          Directory C:  72

          Directory Swapping  74

          Ellipses  76

          Finding a Specified Page  78

          Footnotes  79 

          Headings  81 

          Highlighting Lines and Paragraphs  83
     
          Importing BAK Files  85
     
          Importing Other Files  87
     
          Indenting Blocks of Text  89

          Junk Closet  93
     
     
                                v 
.pn0


     
          Line Spacing  95

          Marking and Finding a Place  96

          Moving Files Between Directories  99

          Name-and-Address Lists  102

          Name Lists and Merge Printing  112

          Numbering Pages in Letters  116

          Opening Windows  119

          Parking  121

          Printing Blocks of Text  123

          Printing Envelopes  125

          Printing Files  129

          Reforming Files  131

          Reforming Paragraphs  133

          Reopening Files  135

          Running DOS Programs  137

          Saving and Returning  139
     
          Scrolling Continuously by Screen  140

          Scrolling by Page  141

          Scrolling by Paragraph  142

          Scrolling by Sentence  144
     
          Searching  146

          Searching and Replacing  148
     
          Searching Plus  150
         
          Spellchecking Files  151
     
          Spellchecking and Previewing  152
     
     
                               vi
.pn0


     
          Spellchecking a Word  154

          Speller/Thesaurus  155

          Swapping Shorthand Files  156 

          Synonyms  158

          Telephone Numbers  159

          Time and Date  161

          Transposing Paragraphs  164

          Transposing Words  165

          Viewing Shorthand Definitions  166

          Window Sizing  167

          Word Counts  168
     


     5/Testing, Testing  169 



     6/Batch Files  176

          Access Menu  176

          Changing Directories  181

          Deleting CRT files  182 



     Notes  184



     Index  286
                         
     
                               
     
     
     
     
     
                               vii
     
.heHOLY MACRO!                                                  #
.pn1
.fo                               #













     1 / T o   B e g i n   W i t h









If you use macros only sparingly, or not at all, you may be doing 
a lot of work WordStar could do for you.

A macro can carry out dozens of orders one after another and get 
the job done in a fraction of the time it would take you to type 
the instructions one by one.  Using macros, you can:

.lm 6
.rm 60

          Delete a word, a sentence or a paragraph.

          Delete all BAK files in the logged directory 
     (whether you're at the opening screen or at the editing 
     screen).  

          Delete to the end of a sentence.

          Delete to the end of a paragraph.

          Delete to the beginning of a paragraph.

          Block a line, sentence or paragraph.
          
          Boldface or italicize a word, sentence or 
     paragraph. 

          Change directories. 

          Move a file to a different directory. 

          Display the list of files on Drive A.
               
.fo

          Display lists of files in all WordStar 
     directories, one directory at a time.
               
          Call up a list of names, addresses and telephone           
     numbers while a file remains onscreen.  

          Copy a name and address from an address list to a      
     letter.

          Copy an address from a letter to an envelope.

          Store a block of text in a junk file.

          Start a utility program (while working at the 
     opening screen or at the editing screen).  

          Display two files at once with WordStar 4.0, using 
     a substitute for the windows feature found in later      
     WordStar releases.

          Save a copy of a file on the hard disk and send a           
     backup copy to a floppy disk in Drive A.  

.lm 1
.rm 65
  
For ease of illustration, it will be assumed that you use a 
computer with one hard-disk drive, designated Drive C, and one  
floppy-disk drive, designated Drive A.  Most of the macros to be 
described later will also work on dual-floppy systems, though 
they may not work as fast.  (Drive A on a dual-floppy system is 
the counterpart of Drive C on a hard-disk system.  Drive B on a 
dual-floppy system is the counterpart of Drive A on a hard-disk 
system.)  
    
Important:  If you're using WordStar 5.0, 5.5 or 6.0, it will be 
assumed that you use the traditional opening menu, not the 
optional opening screen with pull-down menus.  You can program 
WordStar to display the traditional menu automatically.  
(Procedure:  At the pull-down screen, press F X.  Type WSCHANGE 
WS and press Return.  Press DBAA.  Type the number 1 and press 
Return.  Hit X's to back out of WSCHANGE.)  Some macros won't 
work if you use the pull-down menus.  
    
If you're using WordStar 7.0, you can work from the traditional 
menu or from the new opening screen with pull-down menus.

If you're using WordStar 4.0, the traditional menu appears when 
you start the program.  
  
Please read the parts of chapter 2 that refer to your WordStar 
release.  Then read all of chapter 3.  (It's a short one.)  


All the macros in the Holy Macro! package are described in 
chapter 4.  
           
Chapter 5 explains how to test a sampling of macros for WordStar 
4.0, 5.0, 5.5 and 6.0.  If you're using one of those releases, 
you may want to skip the fourth chapter for the time being and 
try the sample macros.  You can later refer to chapter 4 for more 
information about those macros and for descriptions of many other 
macros.  

Chapter 6 describes some simple batch files.  It is followed by 
an extended notes section in which all the macros introduced in 
chapter 4 are broken down step by step.  This is not a section 
you'll want to read from start to finish.  It's there in case 
you're curious about how some macros work.  

Finally, a few terms:

.lm 6
.rm 60

          Define.  To enter the characters of a macro 
     sequence so that they can be stored by WordStar.

          Definition.  What you get after defining a 
     sequence.  Example:  ^QS^KB^KH^QD^KK is the definition 
     of a macro that works with WordStar 4.0, 5.0, 5.5 or 
     6.0

          Return.  The key you press at the end of a 
     paragraph.  On many keyboards it's called Enter.  
               
               
.lm 1
.rm 65
.pa
.he
.fo                               #


     











     2 / C r e a t i n g    M a c r o s









The first two sections of this chapter are for users of WordStar 
releases 4.0 through 6.0.  The third section is for users of 
WordStar 7.0.


     1. Function Keys

If you already know how to define function keys, turn to 
Shorthand on page 8.  If you're not familiar with the procedure, 
follow these steps:

At the opening menu in the main WordStar directory, press X.

At the prompt, type WSCHANGE WS and press Return.  You'll see the 
main WSCHANGE installation menu.  
  
Press A, then B.  You'll see a display similar to the one on the 
next page.  (Note:  The display is supposed to be in a box.  Some 
printers may use odd characters, rather than unbroken straight 
lines, to create a border around this and other displays.)
     
.pa
.heHOLY MACRO!                                                  #
.fo










.po .3i
.rm 79

                                                                             
 Use arrow keys to move the cursor to the function key you want to change and
 press Return.  When done, type X.  To turn onscreen function key labels on  
 or off here and on the editing screen, type L.                              
                                                                             
                 F1        Ctrl+F1       Shift+F1        Alt+F1              
                 F2        Ctrl+F2       Shift+F2        Alt+F2              
 Highlighted     F3        Ctrl+F3       Shift+F3        Alt+F3              
 if already      F4        Ctrl+F4       Shift+F4        Alt+F4              
 defined.        F5        Ctrl+F5       Shift+F5        Alt+F5              
                 F6        Ctrl+F6       Shift+F6        Alt+F6              
 Remaining       F7        Ctrl+F7       Shift+F7        Alt+F7              
 space: 135K     F8        Ctrl+F8       Shift+F8        Alt+F8              
                 F9        Ctrl+F9       Shift+F9        Alt+F9              
                 F10       Ctrl+F10      Shift+F10       Alt+F10             
                                                                             
                                                                             
                                                                             
                                                                             
                                                                             
                                                                             
                                                                             
                                                                             
                                                                             
                                                                             
Display Center  ChkRest ChkWord Del Blk HideBlk MoveBlk CopyBlk BegBlk1EndBlk 
                                                                              
1Help   2Undo   3Undrlin4Bold   5DelLine6DelWord7Align  8Ruler  9Save&0Done
                                                                              

.rr--!---------------------------!---------------------------------------------R
.rm 65
.po 1i




Move the cursor to F1 in the first column of key numbers and 
press Return. 

Below the column of F keys, you'll see a new line confirming your 
key selection (F1).  Two lines below that, you'll see the 
definition of the key's present function, as shown on the 
following page. 
     
.pa
     






.po .3i
.rm 79
                                                            /\                   
               /\              /\        /\    /\      /\  /t+\    /\           
              /  \  /\    /\  /l+\  /\  / S\  /+F\    /  \/lt+F\  /  \      /\ 
   /\    /\  /    \/  \  /  \/rl+F\/  \/  Sh\/t+F8\  /    Alt+F8\/    \    /  
\/  \  /  \/     F9   \/   Ctrl+F9       Shift+F9 \/     Alt+F9       \  /   
     \/          F10       Ctrl+F10      Shift+F10       Alt+F10       \/    
                                                                             
        Function Key: F1                                                     
          Characters: 1                                                      
          Definition: ^J                                                     
     Change it (Y/N)?                                                        
                                                                             
                                                                             
                                                                             
                                                                             
Display Center  ChkRest ChkWord Del Blk HideBlk MoveBlk CopyBlk BegBlk1EndBlk 
                                                                              
1Help   2Undo   3Undrlin4Bold   5DelLine6DelWord7Align  8Ruler  9Save&0Done
                                                                              

.rr--!---------------------------!---------------------------------------------R
.rm 65
.po 1i



The next line will ask if you want to change the definition.  
Answer Y.  Two new lines will appear.  The first will say 
"WordStar keystrokes?"  Hold down Ctrl and press K.  Release Ctrl 
and type Q.  (You'll see ^KQ.)  Press the End key.

The cursor will appear at the extreme lower left corner of the 
screen, on the letter H in Help.  You may now label the F1 key, 
using seven characters or less.  ^KQ is the command used to 
abandon a file and return to the opening menu.  Give it the label 
Abandon.  Then press the End key.  You've finished defining F1. 

The cursor will return to the first column of key numbers in the 
upper part of the screen.  Move the cursor to F2.  Press Return 
and tell WordStar you want to change the definition.  You'll 
define a macro that reopens the most recently active file and 
returns the cursor to the last position it occupied while the 
file was active.  For present purposes, the definition D^R^M^QP 
will work with all WordStar releases (though a different 
definition may be prescribed for your release in the Reopening 
Files section of chapter 4).  After entering the definition, 
press the End key.  Type the label Reopen after the number 2 in 
the bottom row of the display.  Press the End key again.  F2 is 
defined.  

If you don't want function-key labels displayed at the bottom of 
the editing screen, press L before leaving the function-key 
screen.  Suggestion:  Leave the labels on for the time being. 
To work your way back to the opening menu, press X three times 
and answer Y when asked if you're finished making changes.  Then 
type WS and press Return.  

To test the two function keys you've just defined, open a file 
called TEST and type "The quick brown fox jumped over the lazy 
dogs."  Position the cursor on the letter "b" in "brown" and 
press ^KS to save the text without closing the file.  Now press 
F1.  The file will be abandoned and you'll be returned to the 
opening menu. 

Press F2.  The file should reopen and the cursor should be where 
you left it, on the "b" in "brown." 

If you haven't switched off the function-key labels at the bottom 
of your editing screen, you'll notice that Abandon appears after 
the number 1 and Reopen after the number 2 in the lower row of 
labels.

If you want to restore the two keys to their original settings, 
reopen WSCHANGE and press AB to display the function-key screen.  
For F1, the default definition is ^J and the label is Help.  For 
F2, the definition is ^U and the label is Undo.    

WordStar comes from the factory with 40 function-key macros 
already defined.  Ten are first-level macros, meaning that you 
can execute any one of them by pressing a single key--one of the 
F keys.  To execute one of the other 30 macros, you press a 
function key while holding down Ctrl, Shift or Alt.  You can 
redefine the keys to perform more elaborate functions, or you can 
leave the settings as they are and use Shorthand keys to execute 
customized macros.  Or you can load some macros into function 
keys and some into Shorthand keys.  We'll take a closer look at 
Shorthand in the next section.

Note:  The Alt+F keys are used for drawing boxes.  It's probably 
not a good idea to redefine any of those keys.  If you do, you'll 
need to reinstall WordStar to restore the original settings.

Some of the macros described in chapter 4 are too long to fit on 
the function-key definition line.  But you can still execute 
these macros with function keys (by defining the macros on the 
Shorthand screen and then assigning the macros to function keys).  
See the Shorthand section, below.

If you redefine some function keys and later decide you want to 
restore the default key functions, you can copy the original 
command characters from the chart on the following page.  
     
.pa
     
     
         F keys alone  Ctrl plus F  Shift plus F  Alt plus F
          
    F1       ^J           ^Q^F         ^O^D           
                                                          
    F2       ^U           ^Q^A         ^O^C           
                                                          
    F3      ^P^S           ^L          ^Q^L           
                                                          
    F4      ^P^B          ^Q^I         ^Q^N           
                                                          
    F5       ^Y         ^Q^S.LM^N      ^K^Y           
                                                          
    F6       ^T         ^Q^S.RM^N      ^K^H           
                                                           
    F7     ^B^Q^P       ^Q^S.PM6^M     ^K^V           
                                                          
    F8    ^Q^S^O^O      ^Q^S.PA^M      ^K^C           
                                                          
    F9      ^K^S          ^Q^S         ^K^B           
                                                           
   F10      ^K^D          ^Q^D         ^K^K           



Note:  Some printers may not properly reproduce the box-drawing 
characters in the Alt plus F column.

If you're not sure what functions are performed by some of the 
commands in the chart, consult the index of your WordStar manual.  
(In some manuals, commands are listed in a special index of their 
own.)


                                o


     2. Shorthand

A Shorthand macro is much like a function-key macro.  It just has 
a different name and address.  Most macros can be executed either 
with Shorthand keys or with function keys.

You can define up to 36 Shorthand macros, assigning one to each 
of the 26 letter keys and one to each of the 10 number keys.  You 
can also create a second set of Shorthand macros and switch 
between the two sets.  (See Swapping Shorthand Files in chapter 
4.)
 
Programming Shorthand keys is simple, even faster than 
programming function keys.  If you already know the procedure, 
skip to the indented paragraph on page 11.  If you're unfamiliar 
with Shorthand, follow these steps:  
     
At the opening menu, press Esc.  The Shorthand menu will appear.  
A facsimile of the menu used by WordStar 5.0, 5.5 and 6.0 is 
shown below.  The WordStar 4.0 version is nearly the same. 



.rm 80
.po .3i
                                  WordStar
 S H O R T H A N D   M E N U 
 ? display and/or change definitions              F1 help                   
                                                                            
 = result from last ^QM or ^KM math                @ today's date           
 $ formatted result from last ^QM or ^KM math      ! current time           
 # last ^QM math equation                                                   

.rm 65
.po 1i




Note the first line in the menu box.  Press the ? key.  You'll 
see a new display.  The upper part will look like this if you're 
using WordStar 5.0, 5.5 or 6.0:




.rm 80
.po .3i
 S H O R T H A N D 
 Type the shorthand character for the macro to create or modify.            
 Press Return if finished making macro changes.                             
                                                                            
 Shorthand character                                                        
                                                                            
 Press F1 for help, ^U to cancel.                                           

MENU & KEY DEFINITIONS   Bytes available:       ^W scroll up   ^Z scroll down
     
.rm 65
.po 1i



Or like this if you're using WordStar 4.0:




.rm 80
.po .3i
 S H O R T H A N D 
 To change a definition, enter a number or letter from the table below.     
 To create a new definition, enter a new number or letter.                  
 To include control commands, press ^P before each control character.       
 Character to be defined?    (Press Return when done, ^U to cancel.)        
                                                                            
                                                                            

MENU & KEY DEFINITIONS   Bytes available:       ^W scroll up   ^Z scroll down

.rm 65
.po 1i
            
     
.heHOLY MACRO!                                                 #
     
Several Shorthand keys have already been defined for you.  C, for 
example, has been set up to perform a centering function.  If you 
type a title at the left end of a line and then use the C macro, 
the title will be centered on the line.  Let's program C to do 
something else.  When asked which Shorthand character you want to 
define, press C.  You'll be asked for a description.  The 
description will be like one of the labels used for function 
keys, except that it may contain more than seven characters.  For 
practice, we'll have C execute a macro that sends the cursor to 
the center of a 65-character line (if the tabs are at their 
default settings).  Type CtrLine on the line reserved for the 
macro description.  Then press Return.  WordStar will ask for a 
definition.  You want the macro to run these commands:


^QS^V^I^I^I^I^I^I^D^D^D^V

  
But you can't enter the definition exactly the way you would if 
you were setting up a function key.  Shorthand uses ^P as a 
command prefix.  Whenever you see a control character (^) in 
front of a letter, you must hold down Ctrl while you press P and 
whatever letter follows the control character.  To enter the ^Q 
at the start of the CtrLine definition, press ^P^Q (holding down 
Ctrl while you strike PQ).  Then release Ctrl and type the 
following S (which is not preceded by a control character).  To 
enter the next command, ^V, press ^P^V.  To enter ^I, press ^P^I.  
And so on.  The ^P prefix keeps WordStar from reading your 
entries as commands to be executed immediately rather than as 
commands to be stored.  If you tried to enter a carriage-return 
command by holding down Ctrl and pressing M (instead of keeping 
Ctrl down while you pressed PM), WordStar would execute a Return 
on the spot and terminate the sequence you were trying to enter.  
So the CtrLine definition has to be entered like this:  


^P^QS^P^V^P^I^P^I^P^I^P^I^P^I^P^I^P^D^P^D^P^D^P^V 


The ^P's won't show on your screen.  Note how the definition 
comes out at the bottom of the WordStar 4.0 box:



.rm 80
.po .3i
 S H O R T H A N D 
 To change a definition, enter a number or letter from the table below.     
 To create a new definition, enter a new number or letter.                  
 To include control commands, press ^P before each control character.       
 Character to be defined? C  (Press Return when done, ^U to cancel.)        
 Description for Esc menu: CtrLine                                          
 Definition? ^QS^V^I^I^I^I^I^I^D^D^D^V                                      

MENU & KEY DEFINITIONS   Bytes available:       ^W scroll up   ^Z scroll down
.rm 65
.po 1i
               
After entering the definition, press Return.  Then look below the 
Shorthand box.  After the letter C, you'll see the descriptive 
name CtrLine.  And, on the next line, you'll see the macro 
sequence you just entered.  Press Return again.  When asked 
whether to store the changes on disk, press Y.  
      
Now open any file containing a full line of text.  With the 
cursor at the left end of the line, tap Esc, then press C.  (Esc 
is the trigger key for all macros.)  The cursor should move to 
the center of the line.  For most people, such a macro probably 
serves no useful purpose.  So, for practice, you might reopen 
Shorthand and get rid of the definition.  When asked which 
character you want to define, press C.  If you're using WordStar 
4.0, just hit Return three times and answer Y when asked whether 
to store the changes.  If you're using WordStar 5.0, 5.5 or 6.0, 
use ^Y to clear the two lines reserved for the macro description 
and definition.  Then press Return twice and answer Y when asked 
whether to store the changes.  That will leave C undefined.  If 
you want to reinstate the command that came installed on the C 
key, the definition is ^OC.

A Shorthand macro can handle just about any job a function key 
can.  One exception:  You'll have problems if you use a Shorthand 
command in place of a function-key command to run Word Finder, 
the WordStar 4.0 synonym program.  The command ^QP also presents 
a problem.  Programmed as a function-key command, ^QP returns the 
cursor to the position it occupied one step before the command 
was given.  ^QP can be used after other characters in a Shorthand 
sequence, but it won't work as a free-standing Shorthand macro.  
(Reason:  The Esc code used to trigger a Shorthand macro blots 
out WordStar's memory of the last cursor position.  Once WordStar 
has executed any part of a Shorthand sequence, however, it can 
remember where the cursor was one step earlier in the same 
sequence.  So ^QP can be used in step 3 of a sequence to return 
the cursor to the position it occupied at step 2.  But WordStar 
can't remember where the cursor was one step before the first 
part of the macro was triggered by Esc.)

.lm 6
.rm 60

     Note:  Some of the macros described in chapter 4 are      
     too long to fit on the Shorthand definition line if      
     entered in the usual way.  But you can get around that      
     limitation by using a variation of an approach      
     suggested in Walter A. Ettlin's "WordStar 4 Made Easy"      
     (Osborne McGraw-Hill, 1987).  If there's not enough      
     room on the definition line for all the characters in a      
     macro, pick out a character roughly halfway through the      
     definition.  Make a pencil mark before that character.       
     Then, on the Shorthand definition line, enter the last           
part of the sequence first, beginning with the           
character after the pencil mark.  When finished, use           
the left-arrow key to move back to the start of the           
definition line.  Then enter the first part of the           
definition, stopping when you reach the pencil mark.            
By the time you get there, one or more characters at           the end of the sequence will have been pushed off 
the           right side of the screen.  Don't worry.  
All the           characters will be stored when you 
save the definition.    
               
          When a macro is so long that it must be entered on 
     the Shorthand definition line as described in the 
     previous paragraph, you'll be told that a two-step 
     Shorthand definition is required.

          Caution:  Only so many characters will fit on the      
     Shorthand definition line even when a macro is entered      
     in two steps.  After entering the last part of a very      
     long definition and moving back to the start of the      
     line to define the first part, erase any incorrectly      
     typed characters as soon as you enter them.  Don't push      
     them along in front of the cursor and wait until you've      
     finished the definition before deleting them.  If you      
     do, some characters at the end of the definition may be      
     lost because they've been pushed too far right.

.lm 1
.rm 65

Tip:  Though defining a macro in two steps leaves some characters 
offscreen, you can still look at an entire two-step definition at 
once.  If you're using WordStar 5.0, 5.5 or 6.0, you'll notice 
that characters entered on the definition line are mirrored on 
the next line up.  With the help of the mirror, you can display 
complete definitions.  To begin, place the cursor on the 
definition line and start deleting characters at the left end of 
the definition.  Keep deleting until the right end of the 
definition comes into view.  The first part of the definition 
will still be displayed in the mirror just above the definition 
line, and the last part will be displayed on the definition line 
itself.  Important:  After looking over the definition, switch 
off the Shorthand screen by pressing ^U twice.  If you clear the 
screen by entering two Returns and pressing Y to save your 
changes, you'll lose part of the definition. 

If you're using WS4.0, you can accomplish the same thing with a 
different approach.  Assume you want to see a two-step definition 
that has been assigned to the S key.  To begin, display the 
Shorthand definition screen.  Without entering any characters, 
press ^Z until the S definition appears on the lower part of the 
screen.  Then display the S definition on the upper part of the 
screen by typing S and pressing ^R Return ^R.  Delete characters 
until the right end of the definition comes into view.  You can 
then read the first part of the definition on the lower part of 
the screen and the last part on the definition line.  Important:  
Press ^U twice after looking over the definition. 
     
     
                                o
     
.pa
     

     3. WordStar 7.0 Macros 

The WordStar 7.0 macro system is described in detail in the 
program documentation.  See the sections beginning on pages 12-21 
and D-1 of the WordStar Reference manual.  Also see chapter 8 of 
Using WordStar.  The new system is quite different from the one 
used by earlier WordStar releases.  You'll find it helpful to 
know the basics of the system before attempting to use the 
WordStar 7.0 macros described in chapter 4 of this handbook.
      
About the macro formats:
  
As the documentation explains, you can create WS7.0 macros with 
"classic commands"--the ones you're familiar with if you have 
used WordStar's traditional opening menu.  Or you can use the 
Alt-key combinations that work with pull-down menus.  
  
You can enter many commands in a macro file using any of several 
styles.  Example:  To enter the command that advances the cursor 
one space, you can:

1. Type {CTRL+D} or {CTRL-D} or {CTRL D}.  (Note that the command 
characters are enclosed by braces, not parentheses.  To enter 
left and right braces, hold down Shift and use the two keys to 
the right of the P key.) 

2. Hold down Ctrl and press PD.  (This produces the characters ^D 
on the screen.  It's the old WordStar Shorthand method.)

3. Hold down Shift, press the 6 key to type a control character 
(^) and then press the letter D.  (This also produces the 
characters ^D on the screen.)

The last method was used to produce most of the commands in the 
macro files supplied with the Holy Macro! package.  If you've 
created many Shorthand macros with past WordStar releases, you 
may be more comfortable with the second method.  The first method 
is clearly the least simple of the three.  Typing {CTRL+D} 
instead of ^D requires you to use eight characters when two would 
do.  This method may give macro files a more techie look.  Apart 
from that dubious virtue, it appears to have little to recommend 
it.  

After consulting the program documentation to get a grasp of the 
WordStar 7.0 macro system, look through chapter 4 of this 
handbook and decide which macros you want to try out.  You'll 
find files for those macros in the Holy Macro! package.  Each 
macro is in a separate file.

All the macro files have WSM extensions.  (Examples:  The LineBlk 
macro is in a file called LINEBLK.WSM.  The GrafBlk macro is in a 
file called GRAFBLK.WSM.)  You can use WordStar or DOS to copy 
macros from the Holy Macro! package to the WordStar 7.0 macro subdirectory (whose default name is \WS\MACROS).  Two methods 
will be described.  In the following illustrations, it will be 
assumed that the macros in the Holy Macro! package have been 
copied to a WordStar subdirectory called \WS\HOLYMAC.

Method 1:  Copy the macro files one at a time.  Example:  To copy 
the LineBlk macro to the WordStar macro subdirectory, follow 
these steps:

.lm 6
.rm 60

     Press the letter O at the opening screen to display the 
     file-copy box.  

     Type \WS\HOLYMAC\LINEBLK.WSM. 

     Press the Tab key.

     Type \WS\MACROS\LINEBLK.WSM.  

     Press Return.

.lm 1
.rm 65

Method 2:  If you don't mind loading a lot of files into your 
WordStar 7.0 macro subdirectory, you can save time by copying the 
files wholesale.  Procedure:

.lm 6
.rm 60

     At the opening screen, press R to display a DOS command 
     line.

     Type COPY \WS\HOLYMAC\*.WSM  \WS\MACROS\*.*

     Press Return.

.lm 1
.rm 65

That will copy all the macro files to the WordStar macro 
subdirectory.

If you like, you may next assign hotkeys to some of the macros, 
following the instructions in the WordStar documentation.  (See 
pages 12-22 and 12-23 of the Reference manual.)

Note:  Numbers are appended to the labels of some macros in 
chapter 4.  Examples:  CopFlop-1, DownZap-2.  The numbers are 
retained in the names of the macro files, but the hyphens are 
omitted.  The CopFlop-1 macro, for instance, is in a file called 
COPFLOP1.WSM.  DownZap-2 is in a file called DOWNZAP2.WSM.  
      
A few of the macro files may require simple modifications.  You 
may need to change a directory name, for example, if you run 
WordStar out of a directory called WS7 instead of WS.  You may 
need to change a subdirectory name so that it will match one of 
the names you use.  Or you may need to change the name of a 
utility program used as an example in a macro definition.  To 

edit a macro file, press MD at the opening screen or Ctrl MD at 
the editing screen.
     
You may also want to change the names of some macros.  Creating 
your own names may make it easier for you to identify the macro 
functions.  Many of the macro names in chapter 4 were contrived 
so that they would begin with certain letters.  In sample 
Shorthand setups for WordStar 4.0-6.0, the first letters of the 
names were matched with the keys to which the macros were 
assigned.  That made it possible to use all 26 letter keys in the 
sample setups.  But it also produced some names that could easily 
be improved on.  
     
     
.pa
.fo                                #  














     3 / C h e c k l i s t 









To ensure proper operation of the macros described in the next 
chapter, you may need to modify several settings in WSCHANGE.  At 
the DOS prompt in the WordStar directory, type WSCHANGE WS and 
press Return to display the WSCHANGE main installation menu.

If you're using WordStar 4.0, press DBFL.  If you're using a 
later release, press DBFB.  You'll see an eight-column display.  
With one exception, each entry from 21 (in column 3) through 7E 
(in column 8) should be preceded by an asterisk.  5C should not 
be preceded by an asterisk.  These settings are needed to ensure 
proper cursor movement during the execution of some macros.  

Again at the WSCHANGE main installation menu, press DBEA.  Type 
the number 2,500.  Purpose:  to enlarge the unerase buffer.  Some 
macros delete blocks.  You can restore a deleted block by 
pressing ^U (if you do it before deleting anything else).  By 
default, ^U will restore a maximum of about 80 words.  But a 
macro may delete more than that.  If the buffer size is 2,500, 
you'll be able to restore nearly a page of single-spaced text. 

Unless you're using WordStar 7.0, press DCDB at the main 
installation menu.  Type 12 and press Return.  This will enlarge 
your Shorthand buffer so that you'll have ample room to store all 
macro definitions.  

If you're using WordStar 7.0, press CCG at the main installation 
menu.  Type 12 and press Return.  This will enlarge your macro 
hotkey buffer.      
                         

.rm 64
                               o
.rm 65
.heHOLY MACRO!                                                 #
.fo

Each of the macros described in chapter 4 has been given a label 
of seven characters or less.  Longer labels won't fit in the 
allotted space when macros are assigned to function keys and the 
labels are displayed at the bottom of the editing screen.  (Note:  
This display is not used by WordStar 7.0A.)  If macros are 
assigned to Shorthand keys, longer labels may be used.


                                o


Macro definitions appear below the labels.  The definitions are 
preceded by appropriate release numbers.

References to "WordStar 5.x" and "WS5.x" apply to WordStar 
releases 5.0 and 5.5.  A WS5.x macro will work with WS5.0, WS5.5 
and Revision C of WS5.5.  If you're using WordStar 5.5C and you 
find no WS5.5C version of a macro, use the WS5.5 version, or, if 
there is none, the WS5.x version.  

References to "WordStar 6.0D" and "WS6.0D" apply to Revision D of 
WordStar 6.0.  If you use WordStar 6.0D and find no WS6.0D 
version of a macro, use the WS6.0 version.  In sections where 
there are no WS6.0D macros, references to 6.0 apply to Revision D 
as well as to earlier versions of 6.0.  

References to "WordStar 7.0C" and "WS7.0C" apply to Revision C of 
WordStar 7.0.  If you use WordStar 7.0C and find no WS7.0C 
version of a macro, use the WS7.0 version.  In sections where 
there are no WS7.0C macros, references to 7.0 apply to Revision C 
as well as to WS7.0A (the only earlier version generally 
available to single users).


                                o

  
Each macro definition is followed by a parenthetical number.  
Example:  ^QS^KB^KH^QD^KK  (12).  The number refers to the notes 
section after chapter 6.  Some of the techniques described there 
can be used in many macros.  


                                o


Below the definition field is a description of the function the 
macro performs.  The description may be followed by a 
parenthetical note telling users of WordStar 4.0, 5.x and 6.0 
that a macro sequence requires Shorthand definition.  That means 
the macro must be defined first on the Shorthand screen, though 
it may later be assigned to a function key (as will be described 
below).  A Shorthand definition is required when a sequence is 
too long to fit on the function-key definition line.
     
To assign a Shorthand macro to a function key, follow these 
steps:

At the DOS prompt in the WordStar directory, type WSCHANGE WS and 
press Return to display the WSCHANGE installation menu.  Press AB 
to display the function-key screen.  Choose the function key 
you'll use to execute the macro.  Let's say you've used the 
Shorthand key D to define the macro and you want to execute it 
with function key F4.  When asked for a definition for F4, hold 
down Ctrl and press Esc, then release Ctrl and type D.  (On your 
screen, you'll see ^[D.)  Save the definition.  WordStar will run 
the macro whenever you press F4. 

WordStar 6.0D users:  Revision D of WS6.0 provides reduced space 
for storage of function-key definitions.  To avoid running out of 
space, you may want to define all but the briefest macros on the 
Shorthand screen.  If you wish, you can execute the macros with 
function keys, using the procedure described above.  


                                o


In many macro definitions you'll notice the characters <SP>.  If 
you see <SP> while copying a macro definition, enter a blank 
space by pressing the Spacebar once.  If you see <SP><SP>, press 
the Spacebar twice.  Do not type the characters <SP>.  Note:  
<SP> is not used when there is little danger that the amount of 
spacing required will be misunderstood.  


                                o


If you're using WordStar 4.0, 5.x or 6.0, you'll notice the 
command ^Q<DELETE> in some macros.  To enter the command on the 
Shorthand definition screen, hold down Ctrl, press PQP, then 
release Ctrl and press the Delete key.  A small delta-shaped 
character will appear on the screen after ^Q.  

If you're using WordStar 7.0, you'll notice the characters 
^Q{DEL} in some definitions.  These characters must be entered 
exactly as shown in the definitions.  (Note that DEL is enclosed 
by braces, not parentheses.  See the fifth paragraph on page 13.)


                                o


Text-blocking macros in early versions of Holy Macro! presented a 
minor problem.  If a block created with one of these macros was 
hidden with the ^KH command, the same macro could not be used to 
reblock the text so long as the hidden block markers were in 
place.  The problem has been cured.  If you execute a text-blocking macro, then hide the block with ^KH, then decide 
you want the text blocked after all, you can reblock it with the 
same macro.
          
       
                                o


Some blocking macros won't work properly with WordStar 4.0 when 
executed in a paragraph that is not preceded by a Return.  This 
should rarely cause problems.  Before typing the first paragraph 
of a document, you'll normally enter one or more Returns (after 
the date and salutation in a letter, or after a heading).  


                                o
     

Some macros use ^B to reform paragraphs or to advance the cursor.  
WordStar 4.0 users may occasionally have line-spacing problems if 
they use these macros after switching between single spacing and 
double spacing with the commands ^OS1 and ^OS2.  Illustration:  
In WSCHANGE, you have set default line spacing at 2.  You want 
the fifth paragraph of a WordStar 4.0 document single-spaced.  
So, before that paragraph, you press ^OS1.  After the paragraph, 
you press ^OS2 to resume double spacing.  If you later go back to 
the first line of the fifth paragraph to make a change, and use 
^B to reform the paragraph, the spacing will be changed from 
single to double.  The same thing will happen if you go back to 
that paragraph and execute a macro with a ^B in it.  Solution:  
Use the dot commands .LS1 and .LS2 to change spacing.  Once 
spacing is set with a dot command, it stays set so long as the 
command remains in place.  (Later WordStar releases automatically 
insert .LS dot commands when the ^OS spacing commands are used.) 


                                o
    

A macro may come in two or more configurations.  When that 
happens, numbers are appended to the labels (e.g., CopFlop-1, 
CopFlop-2) so that one configuration can be distinguished from 
another in the text and endnotes.  Note:  Hyphens are not used 
before the numbers in the names of WordStar 7.0 macro files.  
(Example:  The CopFlop-1 macro is in a file called COPFLOP1.WSM.)


                                o


All letters used as command characters in macro definitions are 
capitalized (on the theory that ^QS^KB^KH^QD^KK looks less 
jumbled than ^Qs^Kb^Kh^Qd^Kk).  To avoid confusion between the 
capital letter O and the number 0, the letter is underlined in 
macro definitions when there is any danger of ambiguity.  For the same reason, the letter O is underlined in illustrative dot 
commands.   (The underline characters are of course visible only 
on printouts.  You won't see them if you read the Holy Macro! 
files onscreen.) 
     
     
                                o

Many WordStar commands can be entered two ways.  You can order a 
file abandoned, for example, by pressing either ^KQ or ^K^Q.  (In 
the former instance, the Ctrl key is released before Q is 
pressed; in the latter, it is not.)  Using double control 
characters (as in ^K^Q) is sometimes undesirable in Shorthand 
sequences because each control character takes up space on the 
Shorthand definition line.


                                o


Important:  If you're using WordStar 4.0 or 5.x, it's assumed 
your WordStar program files are in a directory called WS4 or WS5.  
If you're using WordStar 6.0 or 7.0, it's assumed the program 
files are in a directory called WS (the name used by default 
during the WS6.0 and 7.0 installation procedures).  If your 
WordStar directory name doesn't fit this pattern, you'll need to 
change some macro definitions.  Example:  If you run WordStar 7.0 
out of a directory called WS7, the directory designation WS in a 
WordStar 7.0 macro definition must be changed to WS7.  


                                o


There will be many references to directories and subdirectories.  
Sometimes, for ease of illustration, the term "directory" will be 
used to mean either the main WordStar directory or a 
subdirectory.  To move to "another directory," for example, may 
mean to move to a subdirectory from the main directory, or to the 
main directory from a subdirectory, or to one subdirectory from 
another.        


                                o


WordStar 5.0 users:  If you store a Shorthand macro that includes 
the command ^OA or ^OK and later redisplay the macro definition 
on the Shorthand screen, you won't be able to see the O.  The O 
will reappear if you run the cursor through the definition line 
with the right-arrow key.  But that's not necessary.  The macro 
will work as is.   


                                o
^PP is used in the definitions of some macros for WordStar 5.5C, 
6.0 and 6.0D.  To enter ^PP while copying a definition onto the 
Shorthand screen, hold down Ctrl, press P twice, release Ctrl and 
type P.  To enter any other two-letter combination beginning with 
^P, hold down Ctrl, press P twice, release Ctrl and type the 
second letter.
     
^PP is also used in some WordStar 7.0 macros.  If you use the 
Shorthand method to enter commands on the WS7.0 macro editing 
screen, enter ^PP as you would on the Shorthand screen.  


                                o


Some paragraphs in the next chapter are indented five spaces on 
either side.  

.lm 6
.rm 60

     Like this one.  The purpose is to indicate that the 
     paragraphs contain cautionary notes or other 
     information that may merit special attention.


                                o

.lm 1
.rm 65

It's assumed that you work with Insert on and that you have the 
auto-align feature on if you're using a release later than 
WordStar 4.0.  It's also assumed that your documents are 
single-spaced or double-spaced and that you leave a blank line 
after each paragraph in single-spaced documents.
.pa
.mt5
.mb6
.cw12

.heHOLY MACRO!                                                 #
.hm2
.fm2
.lm1
.rm65
.ls1
.po1i
.lh8
.pl66
.ps off
.op
.fo                                #  
.pn22
     
..         This file will be difficult to read onscreen unless
..      the print-control characters are hidden.  To hide those
..      characters, hold down Ctrl and press the letters O and D.












     4 / M a c r o    L i b r a r y 









     Backing Up Files



Label:  CopFlop-1 

WS4.0:       ^KDP^R^M^M^UO^R^MA:^R^MY^MP^R^G^G^M
             ^M^U  (1) 

WS5.x, 6.0:  ^KS^KTA:^X  (2)  

WS6.OD:      ^KDP^LNUL^MP^UO^QD^A^Q<DELETE>^MA:^R
             ^MR^Y^M  (3)    
  
WS7.0A:       Sub Main
              WSQuiet (On)
              Key ("^KD")
              WSQuiet (Off)
              Key ("O^QD^A^Q{DEL}") 
              PauseForInput ("{ENTER}", ' Check filename. ')
              Key ("{TAB}A:^R{F10}")
              IfException
              Def: Key ("Y") 
              End IfException
              WSQuiet (On)
              Key ("D^G^G{F10}^KQ")
              WSQuiet (Off)
              End Sub  (4)
    
     
     
WS7.0C:       Sub Main
              WSQuiet (On)
              Key ("^KDO^QD^A^Q{DEL}{TAB}A:^R{F10}")
              IfException
              Def: Key ("Y")
              End IfException
              Key ("D^G^G{F10}^KQ")
              WSQuiet (Off)
              End Sub  (5)

        Function:  Saves a file and makes a backup copy on a 
floppy disk in Drive A.  (Shorthand definition required for 
WS6.0D macro.)  
.op
.fo
     
The macros for WordStar 4.0, 6.0D and 7.0C are fully automatic.  
Any previous backup version of a file on Drive A is overwritten.  
               
The other macros are semiautomatic.  The WS5.x/6.0 macro saves 
the file on Drive C, then places the cursor in a directory file 
list.  The user moves the cursor to the name of the file being 
backed up and presses Return to send a copy of the file to Drive 
A.  Tip:  You can move to the filename quickly by pressing the 
first character in the filename.  (If more than one filename 
begins with that character, you may have to repeat the 
keystroke.)  If there is a previous backup version of the file on 
Drive A, you'll be asked whether to overwrite.  

The WordStar 7.0A macro pauses after displaying a file-copy 
screen.  If you're working on the file WOMBAT and have not opened 
any windows, the filename WOMBAT will appear on the copy screen.  
Just press Return to back up the file.  If you've opened a window 
while working on WOMBAT, the name of the window file will appear 
on the copy screen.  If that's not the file you want to back up, 
enter the right name and press Return.  A message at the top of 
the screen will remind you to check the filename before pressing 
Return. 

If you're using WordStar 4.0 or 6.0D, don't run CopFlop-1 while 
printing.  




Label:  CopFlop-2

WS4.0:   ^KDP^R^M^M^UO^R^MA:^R^MY^MP^R^G^G^M^M^UR
          DIR A: | SORT | MORE^M  (6)

WS6.0D:  ^KDP^LNUL^MP^UO^QD^A^Q<DELETE>^MA:^R^MR^Y^M
          RDIR A: | SORT | MORE^M  (7)
     
.pa
     
     
WS7.0A:    Sub Main
           WSQuiet (On)
           Key ("^KD")
           WSQuiet (Off)
           Key ("O^QD^A^Q{DEL}")
           PauseForInput ("{ENTER}", ' Check filename. ')
           Key ("{TAB}A:^R{F10}")
           IfException
           Def: Key ("Y")
           End IfException
           WSQuiet (On)
           Key ("D^G^G{F10}^KQ")
           WSQuiet (Off)
           Key ("RDIR A: | SORT | MORE {F10}")
           End Sub  (8)

WS7.0C:    Sub Main
           WSQuiet (On)
           Key ("^KDO^QD^A^Q{DEL}{TAB}A:^R{F10}")
           IfException
           Def: Key ("Y")
           End IfException
           Key ("D^G^G{F10}^KQ")
           WSQuiet (Off)
           Key ("RDIR A: | SORT | MORE {F10}")
           End Sub  (9)

        Function:  Saves the file on Drive C, makes a backup copy 
on Drive A and displays a list of the files on Drive A.  
(Shorthand definitions required for WS4.0 and WS6.0D macros.)  
     

CopFlop-2 can be used to confirm a backup, to see which files 
have been copied to Drive A and to see how much storage space 
remains on the Drive A floppy.  Any previous backup copy of a 
file on Drive A is overwritten.  The macro drops you off at the 
opening screen after displaying the Drive A file list.
  
The macros for WordStar 4.0, 6.0D and 7.0C are fully automatic.  
The WordStar 7.0A macro is semiautomatic.  Use it the same way 
you would the WS7.0A version of CopFlop-1.

There is no CopFlop-2 macro for WordStar 5.x or 6.0.

The DOS SORT command is used to alphabetize the Drive A file 
list.  The DOS MORE command is used to display the file list a 
screenful at a time when there are too many filenames to fit on 
one screen.
     
.pa
     
Label:  CopFlop-3 

WS4.0:       ^KS^KPN^R^M^M^U^KB<SP>^KK^S^KO^R^MA:^R^MY^KY
             ^KPN^R^M^M^U  (10) 
     
WS5.5, 6.0:  ^KS^KPP^LNUL^M^KP^U^KO^MA:^X  (11)  
          
WS6.0D:      ^KS^KPP^LNUL^M^KP^U^KB<SP>^KK^S^KO^QD^A
             ^Q<DELETE>^MA:^R^MY^KY  (12)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^KS")
              WSQuiet (Off)
              Key ("^KO^QD^A^Q{DEL}")
              PauseForInput ("{ENTER}", ' Check filename. ')
              Key ("{TAB}A:^R{F10}")
              IfException
              Def: Key ("Y")
              End IfException
              End Sub  (13)

        Function:  Saves the file on Drive C and keeps it 
onscreen after a copy is sent to Drive A.  (Shorthand definitions 
required for WS4.0 and WS6.0D macros.)  

The WS4.0 and WS6.0D macros are fully automatic.  Any previous 
backup version of a file on Drive A is overwritten.  

The other macros are semiautomatic.  The WS5.x/6.0 macro leaves 
the cursor in a file list.  The user moves the cursor to the name 
of the file being backed up and presses Return to send a copy to 
Drive A.  See CopFlop-1.
          
The WordStar 7.0 macro works with WS7.0A and WS7.0C.  Use it like 
the WS7.0A version of CopFlop-1.

After running CopFlop-3, you're returned to your place in the 
file so that you can resume working where you left off.  The 
macro can be used periodically to save on two disks at once 
without closing a file.  

There is no CopFlop-3 for WordStar 5.0.

If you're using WordStar 4.0 or 6.0D, don't execute CopFlop-3 
while printing.
       
.lm 6
.rm 60

     WordStar 4.0 users:  While editing a document, you can                
     display the list of files in the logged directory by                
     pressing ^KO or ^KE.  One way to turn off the display                
     after checking the file list is to press Return.  Don't 
     do it if you want to any of the CopFlop macros.  If you 
     hit Return, the name of the active file will be knocked      out of memory for copying purposes.  The problem is 
     easily averted:  Turn off the file list by pressing ^U 
     instead of Return.
                
     WordStar 6.0D users:  Note the ^Q<DELETE> sequences in      
     the CopFlop macros.  All three macros must be defined 
     first as Shorthand macros even though the first of the 
     three is not too long to fit on the function-key 
     definition line.  Reason:  ^Q<DELETE> cannot be entered           
     on that definition line.  See page 18.  


                                o

.lm 1
.rm 65
.pa









     Blocking Lines 



Label:  LineBlk

WS4.0, 5.x, 6.0: ^QS^KB^KH^QD^KK  (14)  

WS7.0:  Sub Main
        Key ("^QS^KB^KH")
        PauseForInput ("<SP>", Press Spacebar to block.')
        Key ("^QD^KK")
        End Sub  (15)

        Function:  Blocks a line of text.  WS7.0 macro also 
blocks multiple lines.


If you're using WordStar 7.0 and want to block a single line, 
execute LineBlk with the cursor anywhere on the line and press 
the Spacebar.  To block two or more lines, execute LineBlk with 
the cursor anywhere on the first line, then place the cursor 
anywhere on the last line to be blocked and press the Spacebar. 

The macro for WordStar 4.0, 5.x or 6.0 blocks a single line.  It 
may be used with TagLine (below).  Do not press the Spacebar 
after executing the macro.




Label:  TagLine

WS4.0, 5.x, 6.0:  ^F^F^QD^KK  (16)  

        Function:  Adds a line to a block. 


Note that the macro is for users of WordStar 4.0, 5.x and 6.0.  

TagLine will add any number of lines, one at a time, to an 
already-highlighted block.  Example:  You want to block the 
first, second and third lines of a paragraph.  You have used 
LineBlk to block line 1.  If you now execute TagLine twice, the 
second and third lines will be added to the block.  Note:  After 
    
LineBlk blocks line 1, you don't have to move the cursor down a 
line before executing TagLine.  
    
To block 20 consecutive lines, execute LineBlk with the cursor 
anywhere in the first line, then execute TagLine with the cursor 
anywhere to the left of the last word in line 20.  

Another application:  You have just blocked the first paragraph 
of a file.  You can add the first line of paragraph 2 to the 
block by executing TagLine.  If you want to add the second line, 
execute TagLine again. 
     
     
                                o
     
.pa
        








     Blocking Paragraphs 



Label:  GrafBlk 

WS4.0, 5.0, 5.5C, 6.0: ^QH^M^KB^KH^F^B^S^S^QD^D^KK  (17)

WS5.5:                 ^OJ^QH^M^Y^S^KB^KH^F^B^S^S^QD
                       ^D^KK  (18)

WS7.0:  Sub Main
        WSQuiet (On)
        Key ("^QF^P^M^P^J{TAB}B{F10}")
        Key ("^KB^KH^F")
        WSQuiet (Off)
        PauseForInput ("<SP>", 'Press Spacebar to block.')
        Key ("^B^S^S^QD^D^KK")
        End Sub  (19)

        Function:  Blocks a paragraph.  WS7.0 macro also blocks 
multiple paragraphs.  

  
If you're using WordStar 7.0 and want to block a single 
paragraph, execute GrafBlk with the cursor anywhere in the 
paragraph.  A "Paused for input" message will appear in the upper 
part of the screen.  Press the Spacebar to block the paragraph.   
To block two or more paragraphs, execute GrafBlk with the cursor 
anywhere in the first of those paragraphs, then place the cursor 
anywhere in the last paragraph to be blocked and press the 
Spacebar.  

If you're using WordStar 4.0, 5.x or 6.0, your version of the 
GrafBlk blocks a single paragraph.  Execute the macro with the 
cursor anywhere in the paragraph.  Do not press the Spacebar. 

Once you've created a block, you can insert a copy of it between 
two paragraphs by pressing ^KC with the cursor on the blank line 
separating those paragraphs.  To move the block instead of 
copying it, press ^KV.  

Users of Release 7.0 will find an alternative macro (MvGrafs) 
later in this section.  
          
         
         
Label:  EndBlk 

WS4.0, 5.x, 6.0:  ^F^F^B^S^S^QD^D^KK  (20)
          
        Function:  Works in combination with GrafBlk to create 
blocks of two or more paragraphs. 
     

Note that the macro is for users of WordStar 4.0, 5.x and 6.0.       
          
To block two consecutive paragraphs, execute GrafBlk with the 
cursor anywhere in the first paragraph and then execute EndBlk 
without moving the cursor.  To block four paragraphs, execute 
GrafBlk with the cursor anywhere in the first paragraph, then 
place the cursor anywhere in the fourth paragraph and execute 
EndBlk.  If you decide you should have included the next 
paragraph in the block, place the cursor anywhere in that 
paragraph and execute EndBlk again.  If you then decide you had 
it right the first time, go back to the fourth paragraph and 
execute EndBlk once more.  The fifth paragraph will be dropped 
from the block.

To place a copy of the block between two paragraphs, press ^KC 
with the cursor on the blank line separating those paragraphs.  
To move the block instead of copying it, press ^KV.  




Label:  MvGrafs

WS7.0:  Sub Main
        WSQuiet (On)
        Key ("^QF^P^M^P^J{TAB}B{F10}^KB^KH^F")
        WSQuiet (Off)
        PauseForInput ("<SP>", 'Press Spacebar to block.')
        Key ("^B^S^S^QD^D^KK")
        PauseForInput ("<SP>", 'Press Spacebar to move.')
        Key ("^QS^KV^KH")
        End Sub  (21)

        Function:  Blocks one or more paragraphs and moves the 
blocked text to a specified location.


After executing MvGrafs, you can block and move a paragraph with 
two taps of the Spacebar.  Procedure:
    
Execute MvGrafs with the cursor anywhere in the paragraph.  A 
"Paused for input" message will appear in the upper part of the 
screen.  Press the Spacebar to block the paragraph.
           
Position the cursor wherever you want to move the block and press 
the Spacebar again.  (If the block is to be inserted between two paragraphs, the cursor should be on the blank line separating 
those paragraphs.)  

To block two or more paragraphs, execute MvGrafs with the cursor 
anywhere in the first paragraph to be blocked, then press the 
Spacebar with the cursor anywhere in the last paragraph to be 
blocked.  To move the block, press the Spacebar with the cursor 
positioned wherever the block is to be moved.  
  
Some of the macros described elsewhere in this chapter leave 
blank spaces on open lines between paragraphs.  If you create a 
block several paragraphs long, you may notice that part of an 
open line between paragraphs is highlighted like the rest of the 
block.  That's because one or more macros have left spaces on the 
line (for use as place markers).  Don't worry about them.  They 
won't hurt anything.  
        
See also Deleting Paragraphs.
      
          
                                o 
          
.pa
  
     







     Blocking Sentences 



Label:  SentBlk-1 

WS4.0:  ^QF<SP><SP>^MB^M^F^KB^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D
        ^D^QY^QB^QF<SP><SP>^M^M^D^D^KK  (22) 

        Function:  Blocks a sentence in an indented paragraph.  
(Shorthand definition required.)  


Note that the macro is for WordStar 4.0 users only.  If you're 
using a later WordStar release, see SentBlk-2.  
  
SentBlk-1 can be executed with the cursor anywhere in the 
sentence to be blocked.  To delete a blocked sentence, just press 
^KY (or, better yet, use one of the macros described in Deleting 
Sentences).  

.lm 6
.rm 60

     SentBlk-1 will work in any WordStar 4.0 document with      
     indented paragraphs.  In a document without indentions      
     (e.g., a letter in which the first line of each      
     paragraph is flush left), the macro will not properly      
     block the first sentence of a paragraph.  If you often      
     prepare documents without paragraph indentions, see      
     SentBlk-2.

.lm 1
.rm 65



Label:  SentBlk-2

WS4.0:  ^KK^KH^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG<SP>^D^D
        ^QY^QK^QF<SP><SP>^MB^M^F^QG<SP>^A^KB^QF<SP><SP>^M^M
        ^D^D^KK  (23) 

WS5.0:  ^OA^KK^KH^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG<SP>
        ^D^D^QY^QK^OA^QF<SP><SP>^MB^M^F^QG<SP>^A^KB^QF<SP>
        <SP>^M^Y^M^D^D^KK  (24)  
     
.pa
WS5.5:       ^KK^KH^OJ^QH^M^Y^A<SP><SP>^F^B^S^S^QD<SP><SP>
             ^A^QG<SP>^D^D^QY^QK^QF<SP><SP>^MB^M^F^QG<SP>
             ^A^KB^QF<SP><SP>^M^Y^M^D^D^KK  (25)  

WS5.5C, 6.0: ^PP^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG<SP>
             ^D^D^QY^QH^PP^G^QF<SP><SP>^MB^M^F^QG<SP>^A^KB
             ^KH^QF<SP><SP>^M^Y^M^D^D^KK  (26)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>")
              Key ("^QF^PP{TAB}^Y{F10}^G")
              Key ("^QF<SP><SP>{TAB}B{F10}")
              Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH")
              WSQuiet (Off)
              PauseForInput ("<SP>", 'Press Spacebar to block.')
              WSQuiet (On)
              Key ("^PP^B^S^S^QD<SP><SP>^A")
              Key ("^QF<SP>{TAB}^Y{F10}^D^D^QY")
              Key ("^QF^PP{TAB}B{F10}^G")
              Key ("^QF<SP><SP>{TAB}^Y{F10}^D^D^KK")
              WSQuiet (Off)
              End Sub  (27)
  
        Function:  Blocks a sentence in an indented or unindented 
paragraph.  WS7.0 macro also blocks multiple sentences.  
(Two-step Shorthand definitions required for WS4.0, WS5.0, WS5.5 
and WS5.5C/6.0 macros.)  

                    
If you're using WordStar 7.0:

To block a single sentence, execute SentBlk-2 with the cursor 
anywhere in the sentence.  Press the Spacebar when a "Paused for 
input" message appears in the upper part of the screen.  
    
To block two or more sentences, execute the macro with the cursor 
anywhere in the first sentence, then place the cursor anywhere in 
the last sentence to be blocked and press the Spacebar.  

Users of Release 7.0 will find an alternative macro (MvSents) 
later in this section.

The SentBlk-2 macro for WS7.0 is slower than the corresponding 
macros for earlier WordStar releases.  Though the WS7.0 macro is 
functionally similar to the others, it takes somewhat longer to 
run several search routines.  

If you're using WordStar 4.0, 5.x or 6.0:
    
The SentBlk-2 macro for your version of WordStar blocks a single 
sentence.  Execute the macro with the cursor anywhere in the 
sentence.  Do not press the Spacebar.  
     
.lm 6
.rm 60
          
     To use any of the SentBlk macros, you must follow           
     conventional typing practice by leaving two blank                
spaces after each sentence except the final sentence in                
a paragraph.  The macros need to find double spaces to      
be able to tell where sentences begin and end.  They      
can't look for a period when trying to find the end of      
a sentence because a sentence may end with a question      
mark, exclamation point, single quotation mark, double      
quotation mark, closing parenthesis, closing square      
bracket or footnote symbol.  And a period may be used      
in mid-sentence as part of an ellipsis or as a decimal      
point.  ("The population . . . has grown 1.27 million      
in five years.")  If you inadvertently leave three      
blank spaces after a sentence, the macros will still      
work.  If you switch on ^OJ to justify your copy, so      
that all lines end flush right, WordStar will increase      
the spacing between some words.  This won't affect the      
operation of the SentBlk macros.  They'll disregard the      
extra spacing.
     
.lm 1
.rm 65



Label:  AddSent

WS4.0:       ^F^D^D^KK^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
             ^QK^QF<SP><SP>^M^M^D^D^KK  (28)

WS5.0:       ^OA^F^D^D^KK^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
             ^QK^OA^QF<SP><SP>^M^Y^M^D^D^KK  (29)
     
WS5.5, 6.0:  ^F^D^D^KK^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
             ^QK^QF<SP><SP>^M^Y^M^D^D^KK  (30)

        Function:  Adds one or more sentences to a block.  
(Shorthand definitions required.)  
        

Note that AddSent is for users of WordStar 4.0, 5.x and 6.0.

To block two sentences, execute one of the SentBlk macros with 
the cursor anywhere in the first sentence, then execute AddSent 
without moving the cursor.

The SentBlk and AddSent macros can also be used to create longer 
blocks.  To block three sentences, execute a SentBlk macro with 
the cursor on any word in the first sentence, then execute 
AddSent twice.

You can use the macros to create a block that starts in the 
middle of one paragraph and ends several paragraphs later.  After 
blocking the first sentence with a SentBlk macro, scroll down to 
the last sentence you want blocked and execute AddSent with the 
cursor on any word except the last one in that sentence.    
     
You can also block a paragraph with GrafBlk and use AddSent to 
append one or more sentences of the next paragraph to the block.
     
After using a SentBlk macro to block the last sentence of one 
     
paragraph, you may need to execute AddSent twice to extend the 
block to the next paragraph.
     
The sentence to be added to a block by AddSent must be           
at least two words long.  If you want to extend a block to a one-
word sentence (e.g., "Beware!"), do it manually.  

.lm 6
.rm 60
              
     All users:  If you block one or more sentences in the      
     middle of a paragraph and move the blocked text to      
     another paragraph with the ^KV command, the text in      
     both paragraphs may be left out of alignment.  
     Suggestion:  After creating the block, delete it with      
     ^KY.  Then use ^U to restore the block at its new 
     location.  

.lm 1
.rm 65



Label:  MvSents

WS7.0:  Sub Main
        WSQuiet (On)     
        Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>") 
        Key ("^QF^PP{TAB}^Y{F10}^G")
        Key ("^QF<SP><SP>{TAB}B{F10}")
        Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH^K2^KH")
        WSQuiet (Off)
        PauseForInput ("<SP>", 'Press Spacebar to block.')
        WSQuiet (On)
        Key ("^PP^B^S^S^QD<SP><SP>")
        Key ("^A^QF<SP>{TAB}^Y{F10}^D^D^QY")
        Key ("^QF^PP{TAB}B{F10}^G")
        Key ("^QF<SP><SP>{TAB}^Y{F10}^D^D^KK")
        WSQuiet (Off)
        PauseForInput ("<SP>", 'Press Spacebar to move.')
        Key ("^KV^B^Q2^K2^B^QB^KH")
        End Sub  (31)

        Function:  Blocks one or more sentences and moves the 
blocked text to a specified location.


After executing MvSents, you can block and move a sentence with 
two taps of the Spacebar.  Procedure:
      
Execute MvSents with the cursor anywhere in the sentence.  A 
"Paused for input" message will appear in the upper part of the 
screen.  Press the Spacebar to block the sentence. 
       
Position the cursor wherever you want to move the blocked 
sentence and press the Spacebar again.  (If the block is to be 
inserted between two sentences, the cursor should be on the first 
character of the second sentence.)  
     
To block and move two or more sentences:  
             
Execute MvSents with the cursor anywhere in the first sentence to 
be blocked.  Then press the Spacebar with the cursor anywhere in 
the last sentence to be blocked.  To move the block, press the 
Spacebar again with the cursor positioned wherever the block is 
to be moved.  

.lm 6
.rm 60

     To use MvSents, you must leave two blank spaces after 
     each sentence except the last one in a paragraph.  See      
     the indented paragraph on page 34.
     
          
                                o 
          
.lm 1
.rm 65
.pa                









     Blocking Words



Label:  WordBlk

WS4.0, 5.x, 6.0: ^D^A^KB^KH^F^KK  (32)

WS7.0:  Sub Main
        Key ("^D^A^KB^KH")
        PauseForInput ("<SP>", 'Press Spacebar to block.')
        Key ("^F^KK")
        End Sub  (33)

        Function:  Blocks a word.  WS7.0 macro also blocks 
multiple words.  

    
If you're using WordStar 7.0 and want to block the 10th through 
25th words of a paragraph, execute WordBlk with the cursor on any 
character in word 10.  A "Paused for input" message will appear 
in the upper part of the screen.  Move the cursor to any 
character in word 25 and press the Spacebar.  To block a 
sentence, execute WordBlk with the cursor on any character in the 
first word of the sentence, then move the cursor to any character 
in the last word of the sentence and press the Spacebar.  To 
place a copy of the block between two sentences elsewhere in the 
file, press ^KC with the cursor on the first word of the second 
sentence.  To move the block instead of copying it, press ^KV.
    
Users of Release 7.0 will find an alternative macro (MvMisc) 
later in this section.

If you're using WordStar 4.0, 5.x or 6.0:

The WordBlk macro for your version of WordStar blocks a single 
word.  It is used with AddWord (below) to block two or more 
words.  Execute WordBlk with the cursor on any character in the 
word to be blocked.  Do not press the Spacebar. 
          
           
          
     
Label:  AddWord

WS4.0, 5.x, 6.0:  ^F^KK  (34)
           
        Function:  Works in combination with WordBlk to create 
blocks of two or more words.  

    
Note that the macro is for users of WordStar 4.0, 5.x and 6.0.
          
To block 10 words, execute WordBlk with the cursor on any 
character in the first word, then execute AddWord with the cursor 
on any character in the 10th word.  

WordBlk and AddWord can be used as general-purpose macros--to 
block phrases, sentences, paragraphs or whole pages.  To create 
blocks manually with ^KB and ^KK, you must position the cursor 
precisely before entering block markers.  You can work faster 
with WordBlk and AddWord because one macro can be executed with 
the cursor anywhere in the first word to be blocked and the other 
with the cursor anywhere in the last word.




Label:  MvMisc

WS7.0:  Sub Main
        Key ("^D^A^KB^KH^K2^KH")
        PauseForInput ("<SP>", 'Press Spacebar to block.')
        Key ("^F^KK")
        PauseForInput ("<SP>", 'Press Spacebar to move.')
        Key ("^KV^B^Q2^K2^B^QB^KH")
        End Sub  (35)

        Function:  Blocks a string of words and moves the blocked 
text to a specified location.


MvMisc can be used to move parts of sentences, paragraphs or 
pages, or to move whole sentences, paragraphs or pages.

Once the macro is set in motion, a block can be created and moved 
with two taps of the Spacebar.  Procedure:

Execute MvMisc with the cursor on any character in the first word 
to be blocked.  A "Paused for input" message will appear in the 
upper part of the screen.  Place the cursor on any character in 
the last word to be blocked and press the Spacebar.  A block will 
be created.  
       
Position the cursor wherever you want to move the block and press 
the Spacebar again.  (If the block is to be inserted between two 
sentences, the cursor should be on the first character of the 
second sentence.)  
     
             
                                o
          
     







     Boldfacing and Italicizing



Label:  Bold

WS4.0, 5.x, 6.0:  ^D^A^PB^T^PB^S^U^F  (36)

WS7.0:             Sub Main
                   Key ("^D^A^PB^T^PB^S^U^F")
                   End Sub  (37)  

        Function:  Encloses a word in print-control symbols so 
that it will print in boldface.  
  

Execute the macro with the cursor on any character in the word to 
be boldfaced, or on a punctuation mark after the word.  

Bold can be used to mark several consecutive words.  It's not 
necessary to move the cursor before repeating the macro unless 
you've just boldfaced a word at the end of a line.  In that case, 
move the cursor down a line before using the macro again.

WordStar 5.0 users:  When you use Bold to boldface the last word 
of a paragraph, the print-control symbol placed after that word 
may fall off the end of the line, landing one line down.  If that 
happens, tap the Spacebar.  The symbol will pop back into place.




Label:  XBold

WS4.0, 5.5, 6.0:  ^K2^QH^B^G^Q2^K2^KH^PB^T^S^U^F  (38)

WS5.0:            ^OA^K2^QH^B^G^Q2^K2^KH^OA^PB^T^S^U^F  (39)
     
WS7.0:             Sub Main
                   WSQuiet (On)
                   Key ("^K2^QF^PB{TAB}B{F10}^G^Q2^K2^KH")
                   Key ("^PB^T^S^U^F")
                   WSQuiet (Off)
                   End Sub  (40)

        Function:  Extends a boldface string.  
        
Procedure:  To boldface the first through 10th words in a 
sentence, execute Bold with the cursor on any character in the 
first word, then move the cursor to any character in the 10th 
word and execute XBold. 

But note:  Assume that you want to boldface the first 10 words of 
a sentence but that word No. 5 has already been boldfaced.  If 
you execute Bold with the cursor on word 1 and XBold with the 
cursor on word 10, the second through fourth words will be left 
unboldfaced.  Reason:  When XBold is executed with the cursor on 
word 10, it searches backward for the last boldfaced word (No. 5) 
and makes that word the starting point of the boldface string.  

WordStar 5.0 users:  See the last paragraph under Bold (above).  
It also applies to XBold.




Label:  SBold

WS4.0:        ^K2^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG<SP>
              ^D^D^QY^Q2^K2^QF<SP><SP>^MB^M^F^QG<SP>^A^PB
              ^QF<SP><SP>^M^M^PB  (41)

WS5.0:        ^OA^K2^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG
              <SP>^D^D^QY^Q2^K2^OA^QF<SP><SP>^MB^M^F^QG<SP>
              ^A^PB^QF<SP><SP>^M^Y^M^PB  (42)  

WS5.5:        ^K2^OJ^QH^M^Y^A<SP><SP>^F^B^S^S^QD<SP><SP>^A
               ^QG<SP>^D^D^QY^Q2^K2^QF<SP><SP>^MB^M^F^QG<SP>
               ^A^PB^QF<SP><SP>^M^Y^M^PB  (43)  

WS5.5C, 6.0:  ^PP^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG<SP>^D
              ^D^QY^QH^PP^G^QF<SP><SP>^MB^M^F^QG<SP>^A^PB^QF
              <SP><SP>^M^Y^M^PB  (44)

WS7.0:         Sub Main
               WSQuiet (On)
               Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>")
               Key ("^F^B^S^S^QD<SP><SP>")
               Key ("^A^QF<SP>{TAB}^Y{F10}^D^D^QY")
               Key ("^QF^PP{TAB}B{F10}^G")
               Key ("^QF<SP><SP>{TAB}B{F10}")
               Key ("^F^QF<SP>{TAB}^Y{F10}^A^PB")
               Key ("^QF<SP><SP>{TAB}^Y{F10}^PB")
               WSQuiet (Off)
               End Sub  (45)

        Function:  Boldfaces an entire sentence.  (Two-step 
Shorthand definitions required for WS4.0, WS5.0, WS5.5 and 
WS5.5C/6.0 macros.)
     
       
Execute SBold with the cursor anywhere in the sentence.  To 
boldface two sentences, execute the macro once in each sentence.  
     
Note:  If there's already a boldfaced word in a sentence, the 
macro will unboldface that word.  Example:  Assume the word 
"already" in the previous sentence has been boldfaced.  If you 
try to boldface the entire sentence with SBold, you'll wind up 
with four boldface symbols:  one left by SBold at the start of 
the sentence, one previously entered before "already," one 
previously entered after "already" and one left by SBold at the 
end of the sentence.  The symbol before "already" will interrupt 
the boldface string begun at the start of the sentence, and the 
symbol after "already" will become the start of a boldface string 
extending to the end of the sentence.  Result:  The word 
"already" will be an island in a boldface sea.  

.lm 6
.rm 60

     To use SBold, you must leave two blank spaces after           
     each sentence except the last one in a paragraph.  See                
     the indented paragraph on page 34.  
.lm 1
.rm 65
     



Label:  PBold

WS4.0, 5.5C, 6.0:  ^QH^M^F^PB^B^S^S^QD<SP>^A^QG<SP>^PB
                   ^QY  (46)

WS5.0:             ^OA^QH^M^F^PB^B^S^S^QD<SP>^A^QG<SP>^PB
                   ^QY^OA  (47)

WS5.5:             ^OJ^QH^M^Y^S^F^PB^B^S^S^QD<SP>^A^QG
                   <SP>^PB^QY  (48)

WS7.0:              Sub Main
                    WSQuiet (On)
                    Key ("^QF^P^M^P^J{TAB}B{F10}^F^PB")
                    Key ("^B^S^S^QD<SP>^A")
                    Key ("^QF<SP>{TAB}^Y{F10}^PB^QY")
                    WSQuiet (Off)
                    End Sub  (49)

        Function: Boldfaces a paragraph.


Execute the macro with the cursor anywhere in the paragraph.  To 
boldface two paragraphs, execute the macro once in each 
paragraph.

Note:  If you use the macro to boldface a paragraph in which a 
word has already been boldfaced, that word will be unboldfaced.  
See the note under SBold, above.
     
     
Label:  UnBold

WS4.0, 5.x, 6.0:  ^QG^B^G^L^G^L  (50)

WS7.0:             Sub Main
                   WSQuiet (On)
                   Key ("^QF^PB{TAB}^Y{F10}^G^L^G^L}")
                   WSQuiet (Off)
                   End Sub  (51) 
     
        Function:  Deletes the print-control symbols enclosing a 
boldfaced word or a string of boldfaced words.

      
You're not likely to need this macro every day.  But you may want 
to set it up occasionally to handle a special job.  Example:  
You're revising a long document in which dozens of words have 
been boldfaced.  You decide most of them should not have been.  
Using UnBold will spare you the trouble of having to find and 
delete boldface print-control symbols one by one.  

Procedure:  Place the cursor in front of the first word you want 
unboldfaced.  Execute UnBold.  The macro will strip the boldface 
symbols from both ends of the word and move the cursor to the 
start of the next boldfaced word.  If you want to unboldface that 
word, execute UnBold again.  If you want to leave the word 
boldfaced, press ^L twice to skip to the next boldfaced word.  
And so on.

UnBold strips print-control symbols from boldfaced phrases, 
sentences and paragraphs as well as from individual words.  
     



Label:  Ital

WS4.0, 5.x, 6.0:  ^D^A^PY^T^PY^S^U^F  (52)

WS7.0:             Sub Main
                   Key ("^D^A^PY^T^PY^S^U^F")
                   End Sub  (53)

        Function:  Encloses a word in print-control symbols so 
that it will print in italic.  


Ital is identical to Bold except for the print-control symbols.
     
     
     
     
Label:  XItal

WS4.0, 5.5, 6.0:  ^K2^QH^Y^G^Q2^K2^KH^PY^T^S^U^F  (54)
     
WS5.0:            ^OA^K2^QH^Y^G^Q2^K2^KH^OA^PY^T^S^U^F  (55)

WS7.0:             Sub Main
                   WSQuiet (On)
                   Key ("^K2^QF^PY{TAB}B{F10}^G^Q2^K2^KH")
                   Key ("^PY^T^S^U^F")
                   WSQuiet (Off)
                   End Sub  (56)
      
        Function:  Extends an italic string. 
     
     
XItal is identical to XBold except for the print-control symbol.

.lm 6
.rm 60

     Note:  You can use the SBold and PBold definitions as      
     patterns for macros that will italicize sentences and      
     paragraphs.  And you can use the UnBold definition as a      
     pattern for a macro that will strip print-control      
     symbols from italicized strings.  Just substitute ^PY      
     for each ^PB in SBold, PBold and UnBold.

     You can also use the Bold definition as a pattern for a 
     macro that will doublestrike or underline words.  To 
     set up a doublestrike macro, substitute the print-
     control symbol ^PD for each ^PB in the Bold sequence.  
     For an underline macro, substitute ^PS for ^PB.  

          Macros incorporating doublestrike and underline 
     symbols can also be patterned after XBold, SBold,
     PBold and UnBold.   
          
          
                                o
               
.lm 1
.rm 65
.pa









     Case Conversion



Label:  UpCase-1

WS4.0, 5.x, 6.0:  ^QK^K"^KH  (57)

WS7.0:             Sub Main
                   Key ("^QK^K""^KH")
                   End Sub  (58) 

        Function:  Capitalizes all the words in a block that has 
been marked with ^KB (at the beginning) and ^KK (at the end).


The cursor can be inside the block when you execute the macro, or 
it can be above or below the block.  




Label:  LoCase-1

WS4.0:       ^QK^K'^KH  (59) 

WS5.x, 6.0:  ^QK^K.^KH  (60)

WS7.0:        Sub Main
              Key ("^QK^K.^KH")
              End Sub  (61)

        Function:  Lowercases a block of capitalized words.


LoCase-1 is the mirror image of UpCase-1.  The WordStar 4.0 macro 
lowercases all letters in the block.  The WordStar 5.x/6.0 and 
7.0 macros lowercase all letters except the first one in a 
sentence and the letter I when that letter is used standing alone 
as a personal pronoun or Roman numeral.  Note:  Even a capital 
letter at the start of a proper name is converted to lowercase 
unless the name starts a sentence.  (See case conversion in your 
WordStar manual.)
     
     
     
     
You can use UpCase-1 and LoCase-1 after marking blocks manually 
or after using any of the automatic blocking macros described 
earlier.  To uppercase a paragraph, for example, you can block 
the paragraph with GrafBlk and then execute UpCase-1.  




Label:  UpCase-2

WS4.0, 5.x, 6.0:  ^KK^QB^D^A^S^KB^QK^F^KK^K"^KH  (62)

WS7.0:  Sub Main
        Key ("^D^A^KB^KH")
        PauseForInput ("<SP>", 'Press Spacebar to uppercase.")
        Key ("^F^KK^K""^KH")
        End Sub  (63)

        Function:   Uppercases an unblocked string of words.  


UpCase-2 can be used to capitalize all or part of a sentence or a 
paragraph that has not been blocked.  You may find it simpler to 
use than UpCase-1.  
  
If you're using WordStar 7.0, execute the macro with the cursor 
on any character in the first word you want uppercased.  Then 
move the cursor to any character in the last word to be 
uppercased and press the Spacebar.  

If you're using an earlier version of WordStar, mark the start of 
a block by pressing ^KB with the cursor on any character in the 
first word you want uppercased.  Then, with the cursor on any 
character in the last word to be uppercased, execute UpCase-2.




Label:  LoCase-2

WS4.0:      ^KK^QB^D^A^S^KB^QK^F^KK^K'^KH  (64)

WS5.x, 6.0: ^KK^QB^D^A^S^KB^QK^F^KK^K.^KH  (65) 

WS7.0:  Sub Main
        Key ("^D^A^KB^KH")
        PauseForInput ("<SP>", 'Press Spacebar to lowercase.')
        Key ("^F^KK^K.^KH")
        End Sub  (66)
     
        Function:  Lowercases an unblocked string of words.  
      
     
     
LoCase-2 is the mirror image of UpCase-2.  It is used to 
lowercase a string of capitalized words.  The procedure is the 
same as that for UpCase-2.  


                                o
     
.pa









     Changing Fonts 



Label:  AltFont

WS4.0:  ^QS.PS OFF^M.RM80^M.CW10^M.PO12^M  (67)  

     Function:  Switches on an alternate (elite) font.  


This macro and the next two are for WordStar 4.0 users.  If you 
use a later WordStar release, see TsRoman, below.   

The margin settings used in this and the two following font-
swapping macros are merely examples, not recommended settings.  
For present purposes, it's assumed that your normal font is pica 
and that you're using the default setting of 65 characters per 
line.  A 65-character line of pica type is about the same width 
as an 80-character line of elite type.   If you're not using 65-
character lines with your normal font, the .RM number in the 
macro will have to be changed to make lines of alternate-font 
characters print at the same width as lines of normal-font 
characters. 

If your printer does not have a proportional font, you may omit 
the .PS OFF^M from the definition.  But it won't hurt to leave it 
in.




Label:  NorFont

WS4.0:  ^QS.PS OFF^M.RM65^M.CW12^M.PO8^M  (68)  

        Function:  Switches on a normal font.  


If your printer does not have a proportional font, you may omit 
the .PS OFF^M from the definition.
     
.pa
     
Label:  ProFont 

WS4.0:  ^QS.PS^M.RM65^M.PO14^M  (69) 

        Function:  Switches on a proportional font.  

    
The settings in ProFont expand the amount of white space on 
either side of the page.  You may want to adjust the .RM and .PO 
values.  




Label: TsRoman

WS5.0:       .PO1.35"^M.RM5.40"^M^P=Times US 12^M  (70)

WS5.5, 6.0:  .PO1.35"^M^OFSTimes^M  (71)

WS7.0:        Sub Main
              Key (".PO1.35""{ENTER}^OFSTimes{F10}")
              End Sub  (72)

        Function:  Switches on a 12-point Times Roman text font.


The WS5.0 macro establishes a page offset of 1.35 inches, sets 
the right margin at 5.40 inches and displays a font tag on the 
screen.  Like this:


.PO1.35"
.RM5.40"
<Times US 12>

    
(Note:  The font tag won't show if you have pressed ^OD to 
suppress tag displays.)

The WS5.0 macro definition assumes that the font is identified as 
Times US 12 in the Directory of Fonts on the font screen.  When 
you enter the name of the font in your macro definition, you must 
type the name as it appears on that screen.  To display the 
screen so that you can see which fonts are available, press ^P=.  

If you use WS5.5. 6.0 or 7.0, you'll need a paragraph style for 
Times Roman.  To create a paragraph style, press ^OFD with any 
file onscreen.  Type a name (such as Times) on the first line of 
the paragraph-style box.  Move to the second line.  A list of 
available fonts will appear below the box.  Use the arrow keys to 
highlight the desired font (e.g., Times US 12) and press Return.  
Then move the cursor to the right-margin line in the paragraph-
style box.  Type 5.40".  If you're using WordStar 5.5 or 6.0, press ^K and type Y when asked whether to store your changes in 
the paragraph-style library.  If you're using WordStar 7.0, move 
the cursor to the "Update Style Library" checkoff box on the 
lower right side of the screen and type Y.  Then press Return.
      
In the WS5.5/6.0 and 7.0 macros, note that the name Times appears 
after ^OFS.  The name is used as an example.  You can give your 
paragraph style any name you like (Times Roman, TsRoman, Tms or 
whatever).  The name you choose must be entered after ^OFS in the 
macro definition and must be typed as it appears on the first 
line of the paragraph-style box.

Note:  The 1.35-inch page offset and the 5.4-inch right margin 
expand the amount of white space on either side of a page.  These 
values are used because the Times Roman typeface is proportional 
and more condensed than a nonproportional typeface such as 
Courier.  Using a 12-point Times Roman font with a 5.4-inch right 
margin actually yields more characters per line than using a 12-
point Courier font with a 6.5-inch right margin.  You may of 
course omit the page offset on the left side and leave the right-
margin value at the default of 6.5 inches when you create your 
macro.  If you do, however, a line of text will typically run 90 
characters or more (counting blank spaces).  That is more 
characters by far than are usually printed on a line in a book, 
even on a page broad enough to accommodate lines of well over 90 
characters.  Reason:  Proportional type tends to look too dense 
when set in lines 6.5 inches wide.  A page is less dark, and less 
daunting, when the average line runs no more than about 75 
characters (or roughly 5 1/2 inches).  Contrary to an apparently 
widespread impression, there is no law that says typewritten text 
must extend to within one inch of the edges of the paper.

A second reason to reduce line length is that a 90-character line 
won't fit on the screen.  The last 10 characters will run off the 
right side, making editing more awkward.

TsRoman will normally be executed with the cursor on or above the 
first line of text in a file.  But you can also use it between 
paragraphs of a file, to switch to Times Roman from another font.  
If two fonts use different margin settings, and if most of the 
file is to be printed in Times Roman, you may want to make the 
margins of the other font conform to those used by TsRoman.  




Label:  BodyTxt

WS5.0:       ^P=COURIER 10 R8^M  (73)
     
WS5.5, 6.0:  ^OFSBody Text^M  (74)
     
.pa
WS7.0:        Sub Main
              Key ("^OFSBody Text{F10}")
              End Sub  (75)
          
        Function:  Switches on a text font (typically a 
nonproportional font such as Courier).  


The font name after ^P= in the WS5.0 macro is an example.  The 
name must be typed as it appears on the WordStar 5.0 font screen.  
The paragraph-style name after ^OFS in the WS5.5/6.0 and WS7.0 
macros must be typed as it appears on the top line of the 
paragraph-style box.  (See TsRoman, above.)  
     
.lm 6
.rm 60

     Note:  You can use WSCHANGE to select a default font 
     and an alternate font.  (If you have created a file 
     without selecting a font, the file will automatically 
     print in the default font.)  To choose a default font, 
     type WSCHANGE WS and press Return at the DOS prompt in 
     the WordStar directory.  If you're using WordStar 5.0, 
     press BD.  If you're using a later release, press BC.  
     Then press G and choose a default font from the 
     displayed list.  After selecting a default font, press 
     H to select an alternate font.

     If you normally use only two fonts, you may not need 
     any font-swapping macros.  To switch from your normal 
     font to your alternate, simply press ^PA.  To switch 
     back to the normal font, press ^PN. 

          
                                o
               
.lm 1
.rm 65
.pa









     Dating and Signing Letters



Label:  DateLtr

WS4.0:  ^QS^[@^M^M^KR\WS4\DATECOMP^M^Y  (76)

        Function:  Enters the current date in a blank letter 
file, then types a complimentary close and the sender's name.


Note that the macro is for WordStar 4.0 users.  If you're using a 
later release, see OpenLtr (below).

Before using DateLtr, you'll create a file called DATECOMP.  It 
goes in the main WordStar 4.0 directory.  The file will include a 
complimentary close, the name and title of the person sending the 
letter, and, optionally, the initials of the sender and a 
secretary.  The file might look something like this:


.LS1



Sincerely,


Ella B. Landers
Vice President, Sales

EBL/jac


How to use the macro:  Open a new letter file and execute 
DateLtr.  The macro will insert the current date two lines below 
the .LS1 dot command and place the cursor two lines below the 
date, leaving you in position to enter a name and address.  (If 
you have an address file, you can use another macro that will 
insert the address for you.  See Name-and-Address Lists.)
    
The complimentary close is pushed down the screen as you type the 
body of the letter.
     
For a suggestion on naming letter files, see OpenLtr (below). 
     
Label:  OpenLtr

WS5.x:  S^KR\WS5\DATECOMP^M^QG*^Y^[@^M^M  (77)

WS6.0:  S^KR\WS\DATECOMP^M^QG*^Y^[@^M^M  (78)

WS7.0:  Sub Main
        WSQuiet (On)
        Key ("S^KR\WS\DATECOMP{F10}")
        Key ("^QF*{TAB}^Y{F10}^Y^M@")
        Key ("{ENTER}{ENTER}")
        WSQuiet (Off)
        End Sub  (79)

        Function:  Opens a new letter file, enters the current 
date, then types a complimentary close and the sender's name.


Before using the macro, create a file called DATECOMP.  It goes 
in the main WordStar directory.  The file will follow the form of 
the one used by DateLtr (above), except that you'll type an 
asterisk two or three lines below the .LS1 dot command and two or 
three lines above Sincerely.  Like this:


.LS1

*

Sincerely,


Ella B. Landers
Vice President, Sales

EBL/jac


The asterisk is replaced by the current date when the macro runs.  
The cursor lands two lines below the date, leaving you in 
position to enter the recipient's name and address.  (If you have 
an address file, you can use another macro that will enter the 
address for you.  See Name-and-Address Lists.)  
     
The complimentary close is pushed down the screen as you type the 
body of the letter.
     
When you've completed the letter, press ^KD.  WordStar will ask 
for a filename. 
     
Tip:  Any of several methods may be used to incorporate dates in 
letter filenames.  Here's one:
     
Use up to seven characters of the filename for the name of the recipient, abbreviating when necessary.  Then type a single 
number representing the year.  The number 2 represents 1992.  The 
number 3 would represent 1993, and so on.  Use a filename 
extension to indicate the month and the day of the month.  The 
first character in the extension stands for the month.  The last 
two characters stand for the day of the month.  Example:  A 
letter written to Janice J. Jamison on July 4, 1992, might be 
given the filename JAMISON2.704.

The 2 after JAMISON tells you that the letter was written in 
1992.  The 7 in 704 stands for July.  The 04 indicates the day of 
the month.  
     
You can't use numbers to indicate the 10th, 11th and 12th months 
of the year (because only three digits will fit in a filename 
extension).  But you can use the letters X, Y and Z to represent 
October, November and December.  It's easy to associate the 
letters with the months they represent.  X, Y and Z are the last 
three letters of the alphabet, and October, November and December 
are the last three months of the year.  (Coincidentally, X is 
also the Roman numeral for 10, and October is the 10th month of 
the year.)  So a letter written to Janice J. Jamison on October 
12, 1992, might be given the filename JAMISON2.X12.

If this method is used, the filenames of all letters to any one 
person appear in date order in the directory file list.  If you 
think you might confuse the letter Z with the number 2, you can 
use A, B and C to represent the last three months of the year.  
You could also use O for October, N for November and D for 
December, but the filenames of letters written in those months 
would then appear out of date order in the file list.  D 
(December) would come before N (November), which would come 
before O (October).  

.lm 6
.rm 60

     Note that the directory designations in the DateLtr 
     definition and in the first OpenLtr definition include      
     numbers.  See the second full paragraph on page 20.
          
          
                                o
                    
.lm 1
.rm 65
.pa









     Deleting BAK Files



Label:  KillBak 

WS4.0:        R^H^K^FDEL<SP>*.BAK^M  (80)  

WS5.0, 5.5:   R^H^FDEL<SP>*.BAK^KK^KH^QHD^KB^KY^A^KJ
              *.BAK^M  (81)    

WS5.5C, 6.0:  R$^H^H^FDEL<SP>*.BAK^KK^KH^QHD^KB^KY^A
              ^KJ*.BAK^M  (82)

WS6.0D:       S^S^G^KFDEL<SP>*.BAK^M^KQN^[^[  (83)    

WS7.0:        Sub Main
              SetHelpLevel (4) : AutoRestore (On)
              Key ("{ALT+F}RDEL<SP>*.BAK{F10}{ESC}")
              End Sub  (84)

        Function:  Erases all BAK files in the logged directory.  
(Shorthand definitions required for WS5.0/5.5 and WS5.5C/6.0 
macros.) 


Execute KillBak at the opening screen or while editing a file.  
If you're using WordStar 4.0, 5.x or 6.0, press any key to return 
to the menu, or to your place in the file you were editing.  If 
you're using WordStar 7.0, you don't have to press a key to 
return to WordStar. 

If you operate WordStar 7.0 at help level 4, do not assign 
KillBak to a function key.
    

                                o
         
.pa









     Deleting to the End of a File



Label:  JunkBtm-1

WS4.0, 5.0, 5.5C, 6.0:  ^KS^QH^M^D^QT^Z  (85)  

WS5.5:                  ^KS^OJ^QH^M^Y^QT^Z  (86) 

WS7.0:                   Sub Main
                         WSQuiet (On)
                         Key ("^KS^QF^P^M^P^J{TAB}B{F10}")
                         Key ("^D^QT^Z")
                         WSQuiet (Off)
                         End Sub  (87)

        Function:  Erases to the bottom of a file.


The deleted text includes all of the paragraph in which the 
cursor is positioned when the macro is executed.  Execute 
JunkBtm-1 with the cursor anywhere in the uppermost paragraph you 
want deleted.  (For an option, see JunkBtm-2, below.)
  
Oops Department:  If you've used JunkBtm-1 to delete the last 
half of a long document and decide you should not have, abandon 
the file at once by pressing ^KQY.  Then reopen the file.  The 
text will be just as it was before you executed the macro.  
That's because JunkBtm-1 executes a save before it does anything 
else.  

If you've lopped off the last half of a file with JunkBtm-1 and 
have already saved the file in its shortened form, you can 
retrieve the deleted block from the BAK copy of the file.  




Label:  JunkBtm-2

WS4.0, 5.x, 6.0:  ^KS^D^A^QT^Z  (88) 

WS7.0:             Sub Main
                   Key ("^KS^D^A^QT^Z")
                   End Sub  (89)
     
        Function:  Erases to the bottom of a file from the word 
at the cursor.


JunkBtm-2 works like JunkBtm-1 except that the deletion begins 
with the word the cursor is on when JunkBtm-2 is executed.  The 
cursor can be on any character in the first word to be erased.
         
     
                                o
     
.pa









     Deleting to the End of a Page



Label: ZapPage

WS5.x, 6.0:  ^QS^KB^KH^QI+^M^KK^KY  (90)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QS^KB^KH^QI+{F10}^KK^KY")
              WSQuiet (Off)
              End Sub  (91)

        Function:  Erases to the bottom of a page.


If ZapPage is executed with the cursor anywhere on the top line 
of a page, the entire page is erased.  If the macro is executed 
with the cursor on a line part way down the page, the page is 
deleted from that line down.  Note:  You'll get an error message 
if you execute the macro with the cursor on the last page of a 
file.  If that happens, press Esc, move the cursor to the end of 
the file and press ^KK^KY.  

There is no ZapPage macro for WordStar 4.0.  
         
     
                                o
          
.pa









     Deleting to the End of a Paragraph



Label:  DownZap-1

WS4.0:        ^KK^KH^QH^M<SP><SP>^QK^QF<SP><SP>^MB^M^F^QG
              <SP>^A^KB^B^S^S^QD^KK^KY  (92)
  
WS5.0:        ^OA^KK^KH^QH^M<SP><SP>^QK^OA^QF<SP><SP>^MB^M
              ^F^QG<SP>^A^KB^B^S^S^QD^KK^KY  (93)  

WS5.5:        ^KK^KH^OJ^QH^M^Y^A<SP><SP>^QK^QF<SP><SP>^MB^M
              ^F^QG<SP>^A^KB^B^S^S^QD^KK^KY  (94)

WS5.5C, 6.0:  ^PP^QH^M<SP><SP>^QG^PP^G^QF<SP><SP>^MB^M^F^QG
              <SP>^A^KB^KH^B^S^S^QD^KK^KY  (95)  
  
WS7.0:         Sub Main
               WSQuiet (On)
               Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>")
               Key ("^QF^PP{TAB}^Y{F10}^G")
               Key ("^QF<SP><SP>{TAB}B{F10}")
               Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH")
               Key ("^B^S^S^QD^KK^KY")
               WSQuiet (Off)
               End Sub  (96) 

        Function:  Erases to the end of a paragraph.  (Shorthand 
definitions required for WS4.0, 5.0, 5.5 and 5.5C/6.0 macros.)  


The deleted text includes all of the sentence in which the cursor 
is positioned when the macro is executed.  (For an option, see 
DownZap-2, below.)
     
DownZap-1 is executed with the cursor anywhere in the uppermost 
sentence you want erased.        
                
You can delete a full paragraph by executing the macro with the 
cursor anywhere in the first sentence of the paragraph.  If you 
do so, one or two extra line spaces will be left before the next 
paragraph.  The same thing will happen if the first sentence 
deleted by DownZap-1 is one that started at the left end of a 
line in the middle of a paragraph.  You can quickly remove the 
extra line spaces with ^G's.  (Note:  If you use ^Y's or ^T's instead of G's, you won't be able to restore the deleted text 
later with ^U.)   

.lm 6
.rm 60
          
     To use DownZap-1, you must leave two blank spaces after      
     each sentence except the last one in a paragraph.  See           
     the indented paragraph on page 34.  

.lm 1
.rm 65



Label: DownZap-2

WS4.0, 5.x, 6.0:  ^D^A^KB^KH^B^S^S^QD^KK^KY  (97)

WS7.0:             Sub Main
                   Key ("^D^A^KB^KH^B^S^S^QD^KK^KY")
                   End Sub  (98)

        Function:  Erases to the end of a paragraph, beginning 
with the word at the cursor.


Execute the macro with the cursor on any character in the first 
word you want deleted.  
     
     
                                o 
             
.pa









     Deleting to the End of a Sentence



Label:  NxtZap

WS4.0:       ^D^A^KB^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY^QB
             ^QF<SP><SP>^M^M^KK^KY^B^QP  (99) 

WS5.0:       ^OA^D^A^KB^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
             ^QB^OA^QF<SP><SP>^M^Y^M^KK^KY  (100)

WS5.5, 6.0:  ^D^A^KB^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY^QB
             ^QF<SP><SP>^M^Y^M^KK^KY  (101) 

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^D^A^KB^KH^B^S^S^QD<SP><SP>")
              Key ("^A^QF<SP>{TAB}^Y{F10}^D^D^QY")
              Key ("^QB^QF<SP><SP>{TAB}^Y{F10}^KK^KY")
              WSQuiet (Off)
              End Sub  (102) 

        Function:  Deletes to the start of the next sentence.  
(Shorthand definitions required for WS4.0, WS5.0 and WS5.5/6.0 
macros.)
  
    
Illustration:  While copyreading a document, you decide that the 
last half of a long sentence needs a complete overhaul.  
Procedure:  Execute NxtZap with the cursor on any character in 
the first word you want deleted, or in a blank space after that 
word.  

NxtZap deletes an entire sentence when executed with the cursor 
on any character in the first word of the sentence or in a blank 
space after that word.  The macro erases sentences somewhat 
faster than the SentZap macros described later in this chapter  
(see Deleting Sentences), although the difference is negligible 
if you're using a machine that runs at 286 speed or faster.  If 
you want to use NxtZap primarily for deleting full sentences, 
insert ^D^D before the ^KK near the end of the sequence.  
(Otherwise, two extra blank spaces will be left after a sentence 
is deleted from the middle of a paragraph.)  

With a simple modification, NxtZap can also be used as a substitute for one of the macros described in Blocking Sentences.  
Just insert ^D^D before ^KK and delete the characters after ^KK.  
The macro will then block a sentence when executed with the 
cursor on any character in the first word of the sentence or in a 
blank space after that word.  The modified NxtZap macro is faster 
than SentBlk-1 and SentBlk-2.

But note that there is a tradeoff in versatility when NxtZap is 
modified to block or delete sentences.  You can execute a SentBlk 
or SentZap macro with the cursor anywhere in the sentence you 
want blocked or deleted.  To block or erase a sentence with a 
modified NxtZap macro, you must position the cursor on or 
immediately after the first word of the sentence.                

.lm 6
.rm 60

     To use NxtZap, you must leave two blank spaces after      
     each sentence except the last one in a paragraph.  See 
     the indented paragraph on page 34.
              
          
                                o
             
.lm 1
.rm 65
.pa









     Deleting Paragraphs 



Label:  ZapGraf

WS4.0, 5.0, 5.5C, 6.0: ^QH^M^KB^KH^F^B^S^S^QD^D^KK
                       ^KY  (103)  

WS5.5:                 ^OJ^QH^M^Y^S^KB^KH^F^B^S^S^QD
                       ^D^KK^KY  (104) 
    
WS7.0:  Sub Main
        WSQuiet (On)
        Key ("^QF^P^M^P^J{TAB}B{F10}")
        Key ("^KB^KH")
        WSQuiet (Off)
        PauseForInput ("<SP>", 'Press Spacebar to delete.')
        Key ("^F^B^S^S^QD^D^KK^KY")
        End Sub  (105)
   
        Function:  Erases a paragraph.  WS7.0 macro also deletes 
multiple paragraphs.

     
If you're using WordStar 7.0 and want to delete a single 
paragraph, execute ZapGraf with the cursor anywhere in the 
paragraph.  A "Paused for input" message will appear in the upper 
part of the screen.  Tap the Spacebar to erase the paragraph.  To 
delete two or more paragraphs, execute ZapGraf with the cursor 
anywhere in the first of those paragraphs, then place the cursor 
anywhere in the last paragraph to be erased and press the 
Spacebar.

If you're using an earlier WordStar release, your version of 
ZapGraf deletes one paragraph at a time.  Execute the macro with 
the cursor anywhere in the paragraph.  Do not press the Spacebar.

You can delete a paragraph with ZapGraf and restore the paragraph 
at a new location.  If you've deleted the sixth paragraph of a 
file and want to insert it between the second and third 
paragraphs, place the cursor on the blank line below paragraph 2 
and press ^U.  
            
     
                                o 
          








     Deleting Sentences 



Label:  SentZap-1

WS4.0:  ^QF<SP><SP>^MB^M^F^KB^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D
        ^D^QY^QB^QF<SP><SP>^M^M^D^D^KK^KY^B^QP  (106) 

        Function:  Erases a sentence.  (Two-step Shorthand 
definition required.)


The macro is for WordStar 4.0 users.  It works in any document 
with indented paragraphs.  

If you're using WordStar 5.x, 6.0 or 7.0, see SentZap-2.      

SentZap-1 can be executed with the cursor anywhere in the 
sentence you want erased.  The macro realigns the paragraph from 
which the sentence is deleted.  The cursor returns to the point 
of deletion, in case you want to write a replacement sentence.  
SentZap-1 won't work in the first sentence of an unindented 
paragraph.  But there's an option:  




Label:  SentZap-2

WS4.0:        ^KK^KH^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG
              <SP>^D^D^QY^QK^QF<SP><SP>^MB^M^F^QG<SP>^A^KB
              ^QF<SP><SP>^M^M^D^D^KK^KY^B^QP  (107) 

WS5.0:        ^OA^KK^KH^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG
              <SP>^D^D^QY^QK^OA^QF<SP><SP>^MB^M^F^QG<SP>^A
              ^KB^QF<SP><SP>^M^Y^M^D^D^KK^KY  (108)  

WS5.5:        ^KK^KH^OJ^QH^M^Y^A<SP><SP>^F^B^S^S^QD<SP><SP>
              ^A^QG<SP>^D^D^QY^QK^QF<SP><SP>^MB^M^F^QG<SP>
              ^A^KB^QF<SP><SP>^M^Y^M^D^D^KK^KY  (109)  

WS5.5C, 6.0:  ^PP^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG<SP>
              ^D^D^QY^QH^PP^G^QF<SP><SP>^MB^M^F^QG<SP>^A^KB
              ^KH^QF<SP><SP>^M^Y^M^D^D^KK^KY  (110)
     
WS7.0:         Sub Main
               WSQuiet (On)
               Key ("^PP^QF^P^M^P^J{TAB}B{F10}")
               Key ("<SP><SP>^F^B^S^S^QD<SP><SP>")
               Key ("^A^QF<SP>{TAB}^Y{F10}^D^D^QY")
               Key ("^QF^PP{TAB}B{F10}^G")
               Key ("^QF<SP><SP>{TAB}B{F10}")
               Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH") 
               Key ("^QF<SP><SP>{TAB}^Y{F10}^D^D^KK^KY")
               WSQuiet (Off)
               End Sub  (111)
     
        Function:  Deletes any sentence in an indented or 
unindented paragraph.  (Two-step Shorthand definitions required 
for WS4.0, WS5.0, WS5.5 and WS55C/6.0 macros.)  

          
Tip:  You can also use SentZap-1 or SentZap-2 to delete part of a 
sentence.  To erase all characters from the cursor to the start 
of the next sentence, tap the Spacebar twice before executing the 
macro.  

WordStar 7.0 users:  The SentZap-2 macro for WS7.0 is slower than 
the corresponding macros for earlier WordStar releases.  Though 
the WS7.0 macro is functionally similar to the others, it takes 
somewhat longer to run several search routines.  

.lm 6
.rm 60

     To use any of the SentZap macros, you must leave two 
     blank spaces after each sentence except the last one in      
     a paragraph.  See the indented paragraph on page 34.  
      
          
                                o 
          
.lm 1
.rm 65
.pa









     Deleting to the Start of a File



Label:  JunkTop-1

WS4.0, 5.x, 6.0:  ^KS^B^KK^KH^QR^KB^KY  (112) 

WS7.0:             Sub Main
                   Key ("^KS^B^KK^KH^QR^KB^KY")
                   End Sub  (113) 

        Function:  Erases to the top of a file.


The erasure includes all of the paragraph in which the cursor is 
positioned when the macro is executed.  

Application:  You decide the first four paragraphs of a memo must 
be rewritten from scratch.  Execute JunkTop-1 with the cursor 
anywhere in paragraph 4.




Label:  JunkTop-2

WS4.0, 5.x, 6.0:  ^KS^F^KK^KH^QR^KB^KY  (114) 

WS7.0:             Sub Main
                   Key ("^KS^F^KK^KH^QR^KB^KY")
                   End Sub  (115)

        Function:  Erases to the top of a file beginning with the 
word at the cursor.  


Both JunkTop macros perform saves before deleting anything.  If 
you've used either macro to erase the top part of a file and then 
decide you should not have, abandon the file immediately.  Then 
reopen it.  The text will be just as it was before you executed 
the macro.  
     
      
                                o 
.pa

     
     
     
     
     
     
     

     Deleting to the Start of a Paragraph



Label:  UpZap-1 

WS4.0:        ^KK^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
              ^QK^QF<SP><SP>^M^M^D^D^KK^QH^M^F^KB^KY^B
              ^QP  (116) 

WS5.0:        ^OA^KK^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D
              ^QY^QK^OA^QF<SP><SP>^M^Y^M^D^D^KK^QH^M^F
              ^KB^KY  (117)

WS5.5:        ^KK^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
              ^QK^QF<SP><SP>^M^Y^M^D^D^KK^OJ^QH^M^Y^S
              ^F^KB^KY  (118)

WS5.5C, 6.0:  ^PP^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY^QH
              ^M^F^KB^KH^QG^PP^G^QF<SP><SP>^M^Y^M^D^D
              ^KK^KY  (119) 

WS7.0:         Sub Main
               WSQuiet (On)
               Key ("^PP^B^S^S^QD<SP><SP>")
               Key ("^A^QF<SP>{TAB}^Y{F10}")
               Key ("^D^D^QY^QF^P^M^P^J{TAB}B{F10}")
               Key ("^F^KB^KH^QF^PP{TAB}^Y{F10}^G")
               Key ("^QF<SP><SP>{TAB}^Y{F10}^D^D")
               Key ("^KK^KY")
               WSQuiet (Off)
               End Sub  (120)
 
        Function:  Erases to the top of a paragraph.  (Shorthand 
definition required for WS4.0 macro; two-step Shorthand 
definitions required for WS5.0, 5.5 and 5.5C/6.0 macros.)


The deletion includes all of the sentence in which the cursor is 
positioned when the macro is executed.  The cursor winds up at 
the start of the shortened paragraph, leaving you in position to 
rewrite the top of the paragraph if you choose.  
     
     
     
.lm 6
.rm 60
          
     To use UpZap-1, you must leave two blank spaces after 
     each sentence except the last one in a paragraph. See           
     the indented paragraph on page 34.  

.lm 1
.rm 65
     
     
     
Label:  UpZap-2

WS4.0:        ^F^KK^KH^QH^M^F^KB^KY^B^QP  (121) 
     
WS5.0:        ^F^KK^KH^QH^M^F^KB^KY  (122) 

WS5.5:        ^F^KK^KH^OJ^QH^M^Y^S^F^KB^KY  (123)

WS5.5C, 6.0:  ^F^PP^QH^M^F^KB^KH^QG^PP^G^KK^KY  (124)
     
WS7.0:         Sub Main
               WSQuiet (On)
               Key ("^F^PP^QF^P^M^P^J{TAB}B{F10}")
               Key ("^F^KB^KH^QF^PP{TAB}^Y{F10}^G")
               Key ("^KK^KY")
               WSQuiet (Off)
               End Sub  (125)

        Function:  Deletes to the top of a paragraph, beginning 
with the word at the cursor.  


To delete the first 10 words of a paragraph, execute UpZap-2 with 
the cursor on any character in the 10th word.

UpZap-2 is faster than UpZap-1.  
  

                                o 
     
.pa


     






     Deleting to the Start of a Sentence 



Label:  PvsZap

WS4.0:        ^KK^KH^QH^M<SP><SP>^QK^QF<SP><SP>^MB^M^F^QG
              <SP>^A^KB^QK^F^KK^KY^B^QP  (126) 

WS5.0:        ^OA^KK^KH^QH^M<SP><SP>^QK^QF<SP><SP>^MB^M^F
              ^QG<SP>^A^KB^QK^OA^F^KK^KY  (127)   

WS5.5:        ^KK^KH^OJ^QH^M^Y^A<SP><SP>^QK^QF<SP><SP>^MB^M
              ^F^QG<SP>^A^KB^QK^F^KK^KY  (128)

WS5.5C, 6.0:  ^PP^QH^M<SP><SP>^QG^PP^QF<SP><SP>^MB^M^F^QG
              <SP>^A^KB^KH^QG^PP^G^F^KK^KY  (129)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>")
              Key ("^QF^PP{TAB}^Y{F10}")
              Key ("^QF<SP><SP>{TAB}B{F10}")
              Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH")
              Key ("^QF^PP{TAB}^Y{F10}^G^F^KK^KY")
              WSQuiet (Off)
              End Sub  (130)

        Function: Deletes from the word at the cursor to start of 
the sentence.  (Shorthand definitions required.)

              
Application:  After writing half a sentence, you see you've made 
a botch of it and decide to start over.  PvsZap will erase to the 
end of the previous sentence, saving you the trouble of deleting 
word by word.  After the erasure, you can start rewriting the 
sentence without having to move the cursor.  
                                                          
.lm 6
.rm 60

     To use PvsZap, you must leave two blank spaces after 
     each sentence except the last one in a paragraph.  See           
     the indented paragraph on page 34.
          
          
                                o  
.pa
.mt5
.mb6
.cw12
.heHOLY MACRO!                                                 #
.hm2
.fm2
.lm1
.rm65
.ls1
.po 1i
.lh8
.pl66
.ps off
.op
.fo
.pn69

..         This file will be difficult to read onscreen unless
..      the print-control characters are hidden.  To hide those
..      characters, hold down Ctrl and press the letters O and D.
.lm 1
.rm 65








     Deleting Words 



Label:  WordZap

WS4.0:       ^D^A^T^B^QP  (131)  

WS5.x, 6.0:  ^D^A^T  (132)

WS7.0:        Sub Main
              Key ("^D^A^T")
              End Sub  (133)

        Function:  Erases a word.
  
    
You can also delete a word with ^T.  But if you press ^T with the 
cursor on the third letter of a five-letter word, only the last 
three letters are erased.  WordZap erases an entire word when 
executed with the cursor on any character in the word.  

The WordStar 4.0 macro reforms the paragraph from which the word 
is deleted and returns the cursor to the point of deletion.  (In 
a document prepared with a later WordStar release, the paragraph 
is reformed automatically if auto-align is switched on.)  


                                o
     
.pa









     Directory A: 



Label:  ADirect 

WS4.0:        R^H^K^FDIR A: | SORT | MORE^M  (134)  

WS5.0, 5.5:   R^H^FDIR A: | SORT | MORE^KK^KH^QHD^KB^KY
             ^A^KFDIR A: | SORT | MORE^M  (135)   

WS5.5C, 6.0:  R$^H^H^FDIR A: | SORT | MORE^KK^KH^QHD^KB
             ^KY^A^KFDIR A: | SORT | MORE^M  (136)   

WS6.0D:       S^S^G^KFDIR A: | SORT | MORE^M^KQN
             ^[^[  (137)

WS7.0A:       Sub Main
              Key ("S^S^G^KFDIR A: | SORT | MORE {F10}")
              PauseForInput ("{F10}", 'Press F10.')
              Key ("^D^KQ")
              IfException
              Def: Key ("N")
              End IfException
              End Sub  (138) 

WS7.0C:       Sub Main
              SetHelpLevel (4) : AutoRestore (On)
              Key ("{ALT+F}RDIR A: | SORT | MORE {F10}")
              End Sub  (139)
 
        Function: Lists the files on Drive A.  (Two-step 
Shorthand definitions required for WS5.0/5.5 and WS5.5C/6.0 
macros; Shorthand definition required for WS6.0D macro.)  
  

The macro displays the Drive A file list in sorted form, pausing 
when the screen fills.  
  
Execute ADirect at the opening screen or while editing a file.  
If you're using WordStar 4.0, 5.x, 6.0 or 7.0C, press any key to 
return to the opening screen or to the editing screen after 
viewing the Drive A file list.  If you're using WordStar 7.0A, 
tap F10 when told to press any key to return to WordStar.  (If
     
     
you forget and press another key, a message at the top of the 
screen will prompt you to press F10.)

If you operate WordStar 7.0 at help level 4, do not assign 
ADirect to a function key.
          
                                o 
      
.pa









     Directory C:



Label:  ViewCee

WS4.0:        R^H^K^FCDIR^M  (140)  

WS5.0, 5.5:   R^H^FCDIR^KK^KH^QHC^KB^KY^A^KFCDIR^M  (141) 

WS5.5C, 6.0:  R$^H^H^FCDIR^KK^KH^QHC^KB^KY^A^KFCDIR^M  (142) 

WS6.0D:       S^S^G^KFCDIR^M^KQN^[^[  (143)

WS7.0A:       Sub Main
              Key ("S^S^G^KFCDIR{F10}")
              PauseForInput ("{F10}", 'Press F10.')
              Key ("^D^KQ")
              IfException
              Def: Key ("N")
              End IfException
              End Sub  (144)

WS7.0C:       Sub Main
              SetHelpLevel (4) : AutoRestore (On)
              Key ("{ALT+F}RCDIR{F10}")
              End Sub  (145)

        Function:  Displays lists of files in the main WordStar 
directory and in all WordStar subdirectories on Drive C.

  
ViewCee shows you which WordStar files are stored where.  The 
macro first displays a list of the files in the main WordStar 
directory.  After viewing that list, press any key to view the 
file list in the first WordStar subdirectory.  Then press any key 
to view the file list in the next subdirectory, and so on.  

Execute ViewCee at the opening screen or with a file onscreen.  
If you're using WordStar 4.0, 5.x, 6.0 or 7.0C, press any key to 
return to the opening screen or to the editing screen after 
viewing the file lists.  If you're using WordStar 7.0A, tap F10 
when told to press any key to return to WordStar.  (If you forget 
and press another key, a message at the top of the screen will 
prompt you to press F10.)  
     
If you operate WordStar 7.0 at help level 4, do not assign 
ViewCee to a function key.

Before using ViewCee, you'll need to set up a short batch file to 
help run the macro.  At any WordStar opening screen, press N.  If 
you have a C:\BATCH directory for batch files, type the filename 
\BATCH\CDIR.BAT and press Return.  If you don't have a batch 
directory, type the filename \CDIR.BAT.  (The file will then 
reside in the root directory.)  
                    
If you use WordStar 7.0 and have two WordStar subdirectories, the 
body of your batch file might look something like this:  
          

@ECHO OFF
DIR \WS | SORT | MORE
PAUSE
DIR \WS\BIZ | SORT | MORE
PAUSE
DIR \WS\LTRS | SORT | MORE
     

If you're using a version of DOS earlier than 3.3, omit the @ 
symbol before ECHO at the start of the file.  
  
A batch file patterned after the one shown above will display the 
names of all files in the main WordStar directory, including the 
names of WordStar program files.  That can make for a long file 
list.  Option:  Use the main WordStar directory only for storage 
of WordStar program files and do all your editing in WordStar 
subdirectories.  That way, you can have ViewCee display only the 
subdirectory file lists, and you won't have to deal with the long 
list in the main directory.  You might then use a batch file 
something like this:   


@ECHO OFF
DIR \WS\BIZ | SORT | MORE
PAUSE
DIR \WS\HOME | SORT | MORE
PAUSE
DIR \WS\LTRS | SORT | MORE

  
In both sample batch files, the DOS SORT and MORE commands are 
used to alphabetize file lists and display filenames one 
screenful at a time when there are too many names to fit on one 
screen.  


                                o
     
.pa

     
     






     Directory Swapping



Label:  LogMain 

WS4.0:       ^KD^ML\WS4^M  (146) 

WS5.0, 5.5:  ^R^K^DL\WS5^M  (147) 

WS5.5C:      ^R$^H^K^DL\WS5^M  (148)

WS6.0:       ^R$^H^K^DL\WS^M  (149)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("{F10}L\WS{F10}")
              WSQuiet (Off)
              End Sub  (150)

        Function:  Logs on to the main WordStar directory from a 
WordStar subdirectory. 




Label:  LogBiz 

WS4.0:       ^KD^ML\WS4\BIZ^M  (151)  

WS5.0, 5.5:  ^R^K^DL\WS5\BIZ^M  (152)  

WS5.5C:      ^R$^H^K^DL\WS5\BIZ^M  (153)

WS6.0:       ^R$^H^K^DL\WS\BIZ^M  (154)

WS7.0:        Sub Main
              WSQuit (On)
              Key ("{F10}L\WS\BIZ{F10}")
              WSQuit (Off)
              End Sub  (155)

        Function:  Logs on to a subdirectory called BIZ from 
another subdirectory or from the main directory. 
     
     
A directory-swapping macro can be executed at the opening screen 
or at the editing screen.  Examples:  If you're at the opening 
screen in the main WordStar directory or have a file onscreen in 
that directory, you can move to the BIZ subdirectory by executing 
LogBiz.  If you're at the opening screen in the BIZ subdirectory 
or have a file onscreen in that subdirectory, you can move to the 
main WordStar directory by executing LogMain.  If a file is 
onscreen, the macro saves it before swapping directories.

See also Changing Directories in chapter 6.

.lm 6
.rm 60

     Note that the directory designations in some macro      
     definitions include numbers.  See the second full 
     paragraph on page 20.


                                o  
          
.lm 1
.rm 65
.pa









     Ellipses 



Label:  Omit

WS4.0:       ^PV^PV.^PO.^PO.<SP>^B^QP  (156) 

WS5.x, 6.0:  ^PV^PV.^PO.^PO.<SP>  (157) 

WS7.0:        Sub Main
              Key ("^PV^PV.^PO.^PO.<SP>")
              End Sub  (158)

        Function:  Enters three spaced-out periods, usually to 
indicate that one or more words have been omitted from a direct 
quotation.


You can of course just type in the ellipsis dots, like this:  
"Give me liberty or . . . death."  But that won't always work.  
Reason:  The ellipsis may fall at the start of a line.  If that 
happens, WordStar will interpret the first period in the ellipsis 
as the opening character of a dot command--and the line won't 
print.   

One solution:  If you have to use an ellipsis at the start of a 
line, put the cursor on the first dot of the ellipsis and press 
^PV^PV.   That will keep WordStar from mistaking the dot for the 
start of a dot command.  (When you press ^PV^PV, you won't see 
the ^P's on your screen.  Only ^V^V will be displayed.)   

An ellipsis should not begin near the end of one line and 
continue on the next.  To make sure all three dots wind up on the 
same line, no matter how much copy you shift around while 
editing, use the binding-space command, ^PO, after the first and 
second periods.
    
If you use ellipses often, the easiest way to enter them is with 
a macro, like one of those defined at the head of this section.  
Note that each definition includes a blank space (<SP>).  When an 
ellipsis is used in the interior of a sentence, there should be 
one space between the last dot of the ellipsis and the next word.  
Ordinarily, there should also be a space before the first dot of 
an ellipsis.  The Omit macro doesn't begin with a blank space 
     
because an ellipsis may have to start in column 1, and it won't 
be able to if the definition begins with a space.

To insert an ellipsis between two words in the middle of a line, 
execute the macro with the cursor on the first character of the 
second word.   

If you're using WordStar 5.x, 6.0 or 7.0 and have auto-align 
switched on, you'll generally have no trouble entering ellipses 
manually.  If you start to type an ellipsis near the end of a 
line and there's not room for all three dots on that line, 
WordStar will move the dots down to the next line and will move 
the preceding word down with them to keep the line from starting 
with a dot.  (The same thing will sometimes happen even if you 
have auto-align off.)  But:  If you enter an ellipsis at the 
start of a line, WordStar won't move the dots.  And the line 
won't print.  
  
WordStar 4.0 users:  If you discover you forgot to put an 
ellipsis in the middle of a paragraph and you correct the 
omission by entering the ellipsis from the keyboard, the 
paragraph may be thrown out of alignment.  But the problem won't 
arise if you use the WS4.0 version of Omit.  The macro will 
reform the paragraph after entering the ellipsis.  


                                o  
     
.pa









     Finding a Specified Page



Label:  Go2Page

WS4.0, 5.x, 6.0:  ^K1^KH^QI  (159)

WS7.0:             Sub Main
                   Key ("^K1^KH^QI")
                   End Sub  (160)

        Function: Leaves a place mark and displays a screen used 
to find a page.


If you're on page 20 and need to check something on page 15, 
execute Go2Page, type 15 and press Return.
  
To return to your place on page 20, just press ^Q1 or execute 
YMark (see Marking and Finding a Place).  If you don't need to 
return to your place, forget about the place mark.  

                                
                                o  
     
.pa









     Footnotes



Label:  Footsie-1 

WS4.0:  ^QS.LS1^M____________________^M.LS2^M^QH_^F
        ^M^M  (161) 

        Function:  Creates a footnote format.  (Shorthand 
definition required.)   


Note that the macro is for WordStar 4.0 users.  Later WordStar 
releases have a built-in footnoting feature.

The ruled line after .LS1^M is 20 spaces wide.  It is created 
with the underline key (not the hyphen key).  The character after 
^QH is also an underline. 

When called onscreen, the format will look like this: 


.ls1
.LS1
____________________


.LS2


The cursor will be positioned in column 1, two lines below the 
ruled line, so you'll be in position to begin typing the 
footnote.  The .LS1 at the start of the macro turns on single 
spacing and the .LS2 at the end restores double spacing.  If the 
body of your document is single-spaced, shorten the macro 
sequence to ^QS____________________^M^M.  




Label:  Footsie-2 

WS4.0:  ^QS.LS1^M.RM80^M.CW10^M____________________^M.LS2^M
        .RM65^M.CW12^M^QH_^F^M^M  (162) 
     
     
        Function:  Creates a format for a footnote in alternate 
(elite) font.  (Two-step Shorthand definition required.) 


It's assumed that you're using normal (pica) font for your body 
text and that the body-text lines are 65 characters wide and 
double-spaced.  If your text is single-spaced, omit the .LS1^M 
and .LS2^M from the macro sequence.  




Label:  Footsie-3 

WS4.0:  ^QS.LS1^M.RM80^M____________________^M^M^PT^PT^M
        .LS2^M.RM65^M^QH^T  (163) 

        Function:  Creates a format for a footnote using 
half-height characters in a proportional font.  (Two-step 
Shorthand definition required.) 


Note the commands ^PT^PT.  The P's won't show on your screen when 
the macro is executed.  You'll see two ^T's: 


.LS1
.RM80
____________________ 

^T^T
.LS2
.RM65


The cursor will land on the second ^T.  The ^T will be pushed 
along as you type the footnote and will wind up at the end of the 
last line of the footnote.

If your text is single-spaced, omit the .LS1^M and .LS2^M from 
the macro sequence.

The sub/superscript roll must be set at 0 for half-height notes.  
To change the setting, type WSCHANGE WS and press Return at the 
DOS prompt in the WordStar directory.  Press DBIM.  Type 0 and 
press Return.  If you're using proportional font and don't want 
half-height footnotes, leave the sub/superscript roll at the 
default setting.  You can then use Footsie-1.  


                                o   
     
.pa









     Headings



Label:  WideHd

WS4.0:  ^QS.XW1B0E1B67^M.XR1B50^M^PW^PR^M^QH^R  (164) 

        Function:  Creates a format for a heading.


The macros in this section are for WordStar 4.0 users.  If you're 
using a later WordStar release, you can use TsRoman as a rough 
pattern for a heading macro.  See Changing Fonts.

The 1B0E1B67 and the 1B50 in the definition are font codes.  
They're used by a conventional dot-matrix printer to switch on 
and switch off one style of head type.  Consult your printer 
manual for a type that suits your purposes.  (Note:  The 
character after 1B in 1B0E1B67 is a zero.  There are no letter 
O's in any of the definitions in this section.)  

When called onscreen, the WideHd format looks like this: 


.XW1B0E1B67
.XR1B50
^W^R


Note that the P's in the commands ^PW and ^PR don't show when the 
format is displayed in a file. 

The cursor lands on the ^R in the last line and pushes the ^R 
along as the characters of the heading are entered.  The ^R winds 
up at the end of the heading line.




Label:  SubHd 

WS4.0:  ^QS.XE1B0E1B0F^M.XR1B50^M^PE^PR^M^QH^R  (165)

        Function:  Creates a format for a smaller heading.
     
The 1B0E1B0F and 1B50 in the definition are font codes.  They're 
used as examples.  

If you use a proportional font as your normal type, you may have 
to put a .PS OFF dot command above the heading and a .PS below 
it.  You can work the dot commands into the SubHd sequence while 
defining it.  Just insert .PS OFF^M after the ^QS at the start of 
the sequence and insert ^M.PS^M after ^PR near the end of the 
definition.  Here's what you'll see when you call the format 
onscreen: 


.PS OFF
.XE1B0E1B0F
.XR1B50

^E^R

.PS


Note that the P's in the commands ^PE and ^PR don't show when the 
format is called onscreen.  The cursor winds up on the ^R and 
pushes the ^R along as the characters of the heading are entered.  

Some printers can switch off the heading fonts in WideHd and 
SubHd with the same code:  1B50.  If your printer allows you to 
do that, you may want to combine the two heading macros, like 
this: 




Label:  DblHd 

WS4.0:  ^QS.XW1B0E1B67^M.XE1B0E1B0F^M.XR1B50^M  (166) 

        Function:  Creates a format for large and small headings.  
(Shorthand definition required.) 


Now (printer permitting) one macro will allow you to choose 
either size heading.  If you want the larger of the two, press 
^PW at the start of the head and ^PR at the end.  If you want the 
smaller heading, press ^PE at the start and ^PR at the end.


                                o   
     
.pa









     Highlighting Lines and Paragraphs  



Label:  DownBar  

WS4.0, 5.x, 6.0:  ^QS^KB^KH^QD^KK^F^F  (167) 

WS7.0:             Sub Main
                   HideDots (On) : AutoRestore (On)
                   Key ("^QS^KB^KH^QD^KK^F^F")
                   End Sub  (168)  

        Function:  Displays a line of text as a highlighted bar.  


By repeating DownBar, you can move the bar downscreen one line at 
a time.  To start, run the macro with the cursor anywhere in the 
first line to be highlighted.  DownBar can be used to call 
another person's attention to a sequence of lines in a document.  
Or it can be used to leave a conspicuous place mark in a file 
when you have to turn away from your screen momentarily.      

   
  

Label:  UpBar    

WS4.0, 5.x, 6.0:  ^QD^KK^KH^QS^KB^A^A  (169)

WS7.0:             Sub Main
                   HideDots (On) AutoRestore (On)
                   Key ("^QD^KK^KH^QS^KB^A^A")
                   End Sub  (170)

        Function:  Same as that of DownBar except that the bar 
moves upscreen when the macro is repeated.      
  

If you're moving the bar downscreen with DownBar and want to 
start moving it upscreen, you'll need to execute UpBar twice to 
reverse directions.  And vice versa.  

If extra blank space has been left between paragraphs and DownBar 
or UpBar lands in that space, there will be nothing for the macro 
to block.  If you get an empty block, repeat the macro.  
     
Label:  DownBlk  

WS4.0, 5.x, 6.0:  ^QH^M^D^KB^KH^B^S^S^QD<SP>^A^QG<SP>^KK^QD
                  ^F^F  (171)

WS7.0:             Sub Main
                   HideDots (On) : WSQuiet (On)
                   AutoRestore (On)
                   Key ("^QF^P^M^P^J{TAB}B{F10}")
                   Key ("^D^KB^KH^B^S^S^QD<SP>^A")
                   Key ("^QF<SP>{TAB}^Y{F10}^KK")
                   Key ("^QD^F^F")
                   End Sub  (172)

        Function:  Displays a paragraph as a highlighted block.  


By repeating DownBlk, you can move the block highlighting 
downscreen one paragraph at a time.  To start, run the macro with 
the cursor anywhere in the first paragraph to be highlighted.   




Label:  UpBlk

WS4.0, 5.x, 6.0:  ^QH^M^D^KB^KH^B^S^S^QD<SP>^A^QG<SP>^KK^QB
                  ^QS^A^A  (173)

WS7.0:             Sub Main
                   HideDots (On) : WSQuiet (On)
                   AutoRestore (On)
                   Key ("^QF^P^M^P^J{TAB}B{F10}")
                   Key ("^D^KB^KH^B^S^S^QD<SP>")
                   Key ("^A^QF<SP>{TAB}^Y{F10}^KK")
                   Key ("^QB^QS^A^A")
                   End Sub  (174)

        Function:  Same as that of DownBlk except that the block 
highlighting moves upscreen when the macro is repeated.  
 

If you're moving the highlight display downscreen with DownBlk 
and want to start moving it upscreen, you'll need to execute 
UpBlk twice to reverse directions.  And vice versa.            

If extra blank space has been left between paragraphs and  
DownBlk or UpBlk lands in that space, there will be nothing for 
the macro to block.  If you get an empty block, repeat the macro.       
      
        
                                o  
     
.pa
     
     







     Importing BAK Files 



Label:  BakFile 

WS4.0:  ^QS^KB^K3^N^N^X^X^K4^KK^E^KPN^R^M^M^U^KR^R^M  (175) 

        Function:  Brings a BAK copy of a file onscreen, in 
highlighted form. 


Note that the macro is for WordStar 4.0 users.  Later WordStar 
releases have a windows feature that performs a similar function.

BakFile lets you compare the file you're working on with the 
previous version of the same file.  The macro imports the BAK 
file as a highlighted block.  After looking it over, you can 
delete the entire block by pressing ^KY.  (If the file had been 
imported conventionally, in unblocked form, you could block and 
delete it manually, but only after figuring out where it started 
and ended.)

Two place marks left by the macro will remain onscreen after you 
delete the BAK file.  If you don't like their looks, press ^KH.  
But it won't hurt to leave them.  They won't affect the layout of 
your file and won't print.  

You can also borrow text from a BAK file and incorporate it in 
the file you're working on.  If you want to lift a paragraph from 
the BAK file, for example, just put the cursor anywhere in that 
paragraph and use the GrafBlk macro to create a block.  Then copy 
the block wherever you like. 

When you use this blocking procedure, the highlighting on the 
rest of the BAK file is extinguished (because the block you 
created to copy the paragraph replaces the block that 
enclosed the entire BAK file).  So how to you erase the backup 
file when you're finished with it? 

Fairly easily.  On the chance that you might want to borrow text, 
the macro leaves one place mark at the beginning of the BAK file 
and another at the end.  You can use the place marks to delete a 
BAK file that is no longer highlighted.  Here's how:
     
Press ^Q3^KB to mark the start of a block at the first place mark.  (You don't have to move the cursor to the place mark 
beforehand.  The ^Q3 will find the mark for you.)  Press ^Q4^KK 
to mark the end of the block at the other place mark.  Press ^KY.  
The BAK file will disappear.  

Don't execute BakFile with the cursor in a dot-command field.


                                o  
     
.pa









     Importing Other Files 



Label:  Import

WS4.0, 5.x, 6.0:  ^QS^KB^K3^N^N^X^X^K4^KK^E^KR  (176)

WS7.0:             Sub Main
                   Key ("^QS^KB^K3^N^N^X^X^K4^KK^E^KR")
                   End Sub  (177)    

        Function:  Triggers a macro used to import a file in 
highlighted block form.

  
The macro is intended for use with WordStar 4.0 as a substitute 
for the windows feature found in later WordStar releases.  It can 
also be used with WordStar 4.0, 5.x, 6.0 and 7.0 to import any 
document.  Here's how the macro works with WordStar 4.0 as a 
windows substitute:

You have the file WOMBAT onscreen.  You need to check the 
spelling of a name in the file AARDVARK.  Procedure:  Execute 
Import, type the filename AARDVARK and press Return.  The 
AARDVARK file will come onscreen in highlighted block form.  
After checking the spelling of the name, clear AARDVARK from the 
screen by pressing ^KY.  (If you imported the same file 
conventionally, in unblocked form, it would take considerably 
longer to get rid of it.)

The macro uses place marks that remain onscreen after you delete 
the block with ^KY.  The place marks won't affect the layout of 
your file and won't print.  You can dissolve them by pressing 
^KH.    

You can also copy text from the imported file, using the 
procedure described in Importing BAK Files.  Or you can leave the 
whole file in the document you're editing.

Don't execute Import with the cursor in a dot-command field.

If you often import boilerplate files, see the next page.  
     
     
     
Label:  ImpBoil

WS4.0:  ^QS^KB^N^N^X^X^KK^E^KR\WS4\BOIL\  (178)

WS5.x:  ^QS^KB^N^N^X^X^KK^E^KR\WS5\BOIL\  (179)

WS6.0:  ^QS^KB^N^N^X^X^KK^E^KR\WS\BOIL\  (180)

WS7.0:   Sub Main
         Key ("^QS^KB^N^N^X^X^KK^E^KR\WS\BOIL\")
         End Sub  (181)

         Function:  Triggers a macro used to import boilerplate 
files.  


The macro definitions assume that the boilerplate files are in a 
subdirectory called BOIL.  

Procedure:  To insert a boilerplate file between the 10th and 
11th paragraphs of the file you're editing, place the cursor 
anywhere on the first line of the 11th paragraph and execute 
ImpBoil.  Then type the name of the boilerplate file and press 
Return.  The file will be imported in highlighted block form.  If 
you have imported the wrong file, you can clear it from the 
screen by pressing ^KY.  Otherwise, press ^KH to dissolve the 
block highlighting.   

Suggestion:  Give your boilerplate files short names such as B1, 
B2 and B3.  The shorter the names, the fewer characters you'll 
have to type before setting ImpBoil in motion.  If you use many 
boilerplate files, type out a list describing each file and keep 
the list handy.  One entry might look like this:


     B17. New products. 


If you want to insert a paragraph plugging your company's newest 
products, you'll know B17 is the boilerplate file you're looking 
for. 
     

.lm 6
.rm 60

     Note that the directory designations in some macros      
     include numbers.  See the second full paragraph on page 
     20.  


                                o 
           
.lm 1
.rm 65
.pa









     Indenting Blocks of Text



Label:  Indent-1

WS4.0:       ^QS.LM6^M.RM60^M  (182)

WS5.x, 6.0:  ^QS.RR1^M  (183)

WS7.0:        Sub Main
              Key ("^QS.RR1{ENTER}")
              End Sub  (184)

        Function:  Indents margins on both sides of the page.


Use Indent when you want quotations or other matter set off in 
the text.  Execute the macro after placing the cursor on the line 
where the indention is to begin.

The numbers in the WS4.0 macro are examples.  They assume that 
your default margins are 1 and 65.  If they're not, use different 
numbers in the macro definition.  The macros for WS5.x/6.0 and 
WS7.0 indent one-half inch on the left and right regardless of 
the default margin settings.  

Using WordStar 5.x, 6.0 or 7.0, you can accomplish the same 
purpose by typing .RR1 at the left margin and entering a Return.  
But Indent does the job with one or two keystrokes instead of 
five.  And you can save several more keystrokes when you use 
Outdent (below) to restore normal margins.  It may be a 
consideration if you change margins often.  




Label:  Outdent-1

WS4.0:       ^QS.LM1^M.RM65^M  (185)

WS5.x, 6.0:  ^QS.RR0^M  (186)

WS7.0:        Sub Main
              Key ("^QS.RR0{ENTER}")
              End Sub  (187)
     
        Function:  Restores normal margins.  

  
Execute the macro after placing the cursor on the line where you 
want to resume normal margin settings.

The margin numbers in the WordStar 4.0 macro are again only 
examples.  




Label:  Indent-2

WS4.0:       ^QH^M^D.LM6^M.RM60^M.PM6^M^B^QP  (188)

WS5.x, 6.0:  ^QH^M^D.RR1^M  (189)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QF^P^M^P^J{TAB}B{F10}^D.RR1{ENTER}")
              WSQuiet (Off)
              End Sub  (190)   

        Function:  Changes margins from normal to indented.


The difference between Indent-1 and Indent-2 is that the latter 
can be used two ways.  When executed with the cursor anywhere in 
a paragraph that has been typed with normal margins, it reforms 
the paragraph, indenting the margins on either side.  When 
executed above a paragraph that has not yet been typed, it sets 
up indented margins for that paragraph.  

Assume that paragraph 1 of a file looks like this:


     In my younger and more vulnerable years my father gave me 
some advice that I've been turning over in my mind ever since.  


If you executed Indent-2 with the cursor anywhere in that 
paragraph, the macro would reformat the paragraph, like this:


          In my younger and more vulnerable years my father
     gave me some advice that I've been turning over in my
     mind ever since.  


Second application:  If you're adding a paragraph to a file and 
want the paragraph indented, place the cursor on the blank line 
where the new paragraph is to begin and execute Indent-2.  The 
     
macro prints out three dot commands and leaves the cursor below 
the third command.  When you began typing, text will be indented 
on either side.




Label:  Outdent-2

WS4.0:       ^QH^M^D.LM1^M.RM65^M.PM0^M^B^QP  (191)

WS5.x, 6.0:  ^QH^M^D.RR0^M  (192)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QF^P^M^P^J{TAB}B{F10}^D.RR0{ENTER}")
              WSQuiet (Off)
              End Sub  (193)
  
        Function:  Changes margins from indented to normal.


Use Outdent-2 to restore normal margin settings after a block of 
copy has been indented by Indent-2.  

Example:  A page of text originally consisted of five paragraphs 
with normal margins.  You have just indented paragraph 2 with 
Indent-2 and want normal margins resumed in paragraph 3.  Place 
the cursor anywhere in the third paragraph and execute Outdent-2.  

Example 2:  At the end of a file, you're adding a paragraph.  The 
preceding paragraph has been indented.  You want normal margins 
in the new paragraph.  Place the cursor on the line where the 
paragraph is to begin and execute Outdent-2.  

WordStar 4.0 users:  The Indent-2 and Outdent-2 definitions 
assume that you normally indent the first line of each paragraph 
five spaces, using the Tab key or Spacebar.  If you normally do 
not indent, omit the .PM6^M sequence from the Indent-2 definition 
and the .PM0^M sequence from the Outdent-2 definition.  




Label:  Hanger

WS4.0:       ^QS.PM1^M.LM4^M  (194)

WS5.x, 6.0:  ^QS.PM0.0"^M.LM0.3"^M  (195)

WS7.0:        Sub Main
              Key ("^QS.PM0.0""{ENTER}.LM0.3""{ENTER}")
              End Sub  (196)  

        Function:  Creates a hanging indention.
     
Use the macro when you want the first line of a paragraph flush 
left and the remaining lines indented.  Hanging indentions are 
used to make first lines stand out from surrounding text in 
enumerations, instruction lists and the like.  Example:  


1. Place a small nail between the left thumb and forefinger and
   hold the nail upright on the top of the cabinet assembly as
   illustrated in Figure 1.

2. Grasp a hammer firmly with the right hand.  Bring the hammer
   down forcefully to drive in the nail with a single stroke as
   shown in Figure 2.

3. Proceed to the medicine cabinet and treat split left thumb
   with iodine or Mercurochrome as illustrated in Figure 3.
   Screaming is permitted but not encouraged.


Execute the macro with the cursor at the start of a series of 
paragraphs in which you want to use hanging indentions.

To reinstate normal margin settings after using hanging 
indentions, execute Outdent-1 or Outdent-2, above.

The numbers after .LM in the Hanger definitions are examples.  
You can change the numbers to adjust the amount of indention.
   
   
                                o
     
.pa









     Junk Closet 



Label:  HoldBlk

WS4.0:       ^KH^F^D^B^S^S^QD^D^KK^QB^X^QS^N---->^N
             ^KW$^M^KFY^KF^Y^M^X^Y^Y^KFCOPY<SP>HOLD+$ 
             <SP>HOLD^M  (197)

WS5.x, 6.0:  ^KH^F^D^B^S^S^QD^D^KK^OA^QB^X^QS^N---->^N
             ^KWHOLD^M^A^X^Y^Y^OA  (198)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QF^P^M^P^J{TAB}B{F10}^KB^KH^F")
              WSQuiet (Off)
              PauseForInput ("<SP>", 'Press Spacebar to copy.')
              WSQuiet (On)
              Key ("^B^S^S^QD^D^KK^OA^QB^X^QS^N---->^N")
              Key ("^KWHOLD{F10}")
              IfException
              Def: Key ("A")
              End IfException 
              Key ("^X^Y^Y^OA")
              WSQuiet (Off)
              End Sub  (199)

        Function:  Copies a block of text to a temporary holding 
file.  (Two-step Shorthand definition required for WS4.0 macro; 
Shorthand definition required for WS5.x/6.0 macro.) 


HoldBlk can perform several functions.  One is to create a copy 
of a block of text that you may want to use later in another 
document.  

If you're using WordStar 7.0, place the cursor anywhere in the 
first paragraph you want copied to the holding file.  Execute 
HoldBlk.  Then place the cursor anywhere in last paragraph to be 
copied and press the Spacebar.  A copy of the block will be sent 
to a file called HOLD.  To send a single paragraph to the HOLD 
file, execute HoldBlk with the cursor anywhere in the paragraph 
and press the Spacebar without moving the cursor.  

If you're using WordStar 4.0, 5.x or 6.0, place the cursor anywhere in the first paragraph you want copied to the holding 
file and block that paragraph by executing GrafBlk (see Blocking 
Paragraphs).  Then place the cursor anywhere in the last 
paragraph to be copied and execute HoldBlk.  A copy of the block 
will be sent to a file called HOLD.  To create a holding block 
only one paragraph long, block the paragraph with GrafBlk, then 
move the cursor back into the paragraph and execute HoldBlk.  If 
you haven't programmed GrafBlk, press ^KB with the cursor on the 
blank line above the first paragraph to be copied to the HOLD 
file.  (If there's a dot command immediately above the paragraph, 
press ^KB with the cursor to the right of the dot command.)  Then 
execute HoldBlk with the cursor anywhere in the last paragraph to 
be copied.  To send a copy of a single paragraph to the HOLD file 
without using GrafBlk, press ^KB on the blank line above the 
paragraph and execute HoldBlk without moving the cursor. 
     
All users:  To delete the marked block from the file you're 
working on, press ^KY after executing HoldBlk.  If you don't want 
the block deleted, press ^KH to dissolve the block highlighting. 
     
Subject to storage-space availability, you can send any number of 
blocks to the HOLD file.  To make it easy to tell where one block 
ends and another begins, HoldBlk leaves extra line spaces and a 
separator mark (---->) between blocks.  (To enter the separator 
mark while defining the macro, type four hyphens and a right 
angle bracket.)  

You can erase the HOLD file at the end of each work session or 
just leave it until it gets too large to manage efficiently.  

Though HoldBlk's main job is to toss stuff into a storage closet, 
it can also be used to string together key parts of a document.  
Example:  A file is broken into 20 sections, each beginning with 
a heading and a summary paragraph.  You want to summarize the 
entire file by creating a document consisting only of the section 
headings and summary paragraphs.  Procedure:  

If you're using WordStar 7.0:  At the start of each section, 
execute HoldBlk with the cursor on the heading line.  Then move 
the cursor into the summary paragraph and press the Spacebar. 

If you're using an earlier release:  At the start of each 
section, press ^KB with the cursor on the line above the heading.  
(If there's a dot command on that line, press ^KB with the cursor 
to the right of the dot command.)  Then execute HoldBlk with the 
cursor anywhere in the summary paragraph.  

The WordStar 4.0 macro creates a dummy file called $.  Before a 
block is moved to HOLD, it is sent to $.  The $ file is 
overwritten each time the macro is run, so it won't keep growing.  
               
     
                                o 
.pa

     
          
     
                
     
     
     
     
     Line Spacing



Label:  SglSpc 

WS4.0:  ^QS.LS1^M  (200) 

        Function:  Sets line spacing at 1. 




Label:  DblSpc 

WS4.0:  ^QS.LS2^M  (201) 

        Function:  Sets line spacing at 2. 
  

These simple macros are mentioned to avert problems that may 
arise if you use ^OS1 and ^OS2 to change line spacing in WordStar 
4.0 documents.   

One WordStar 4.0 line-spacing problem, involving the effect ^B 
has on text spaced with ^OS commands, has already been described 
(in the second full paragraph on page 19).  Here's another: 

Using ^OS1 and ^OS2, you prepare a WordStar 4.0 document 
containing both single-spaced and double-spaced text.  Then you 
go to the top of the file and press ^QU to reform the document.  
If your default line spacing is 2, the entire document, including 
the parts you have single-spaced, will be double-spaced. 

The dot commands .LS1 and .LS2 cure the problem.  They're easy to 
enter from the keyboard, but you may find it helpful to use the 
SglSpc and DblSpc macros if you're constantly switching between 
single spacing and double spacing.
  
WordStar 5.x, 6.0 and 7.0 automatically insert .LS commands when 
you use ^OS to change line spacing.  


                                o 
          
.pa









     Marking and Finding a Place 



Label:  Mark 

WS4.0, 5.x, 6.0:  ^K1^KH  (202)

WS7.0:             Sub Main
                   Key ("^K1^KH")
                   End Sub  (203) 

        Function:  Leaves a place mark at the cursor.




Label:  YMark 

WS4.0, 5.x, 6.0:  ^Q1^K1^KH  (204)

WS7.0:             Sub Main
                   Key ("^Q1^K1^KH")
                   End Sub  (205) 

        Function:  Finds and erases the place mark. 


Application:  You're on page 10.  You need to go back a page to 
check the spelling of a name.  Execute Mark before leaving page 
10, then use ^YMark to return to your place.  (Note:  The place 
mark left by Mark is hidden.  But YMark can still find it.)




Label:  TopFile

WS4.0, 5.x, 6.0:  ^K1^KH^QR  (206)

WS7.0:             Sub Main
                   Key ("^K1^KH^QR")
                   End Sub (207)
     
        Function:  Leaves a place mark and sends the cursor to 
the top of the file.
Label:  BtmFile

WS4.0, 5.x, 6.0:  ^K1^KH^QC  (208)

WS7.0:             Sub Main
                   Key ("^K1^KH^QC")
                   End Sub  (209)
     
        Function:  Leaves a place mark and sends the cursor to 
the bottom of the file.


TopFile and BtmFile are used when you want to go to one end of a 
document or the other and then return to your place.  If you're 
in the middle of a 10-page file and want to go to the top to 
review the opening paragraphs, execute TopFile.  To return to 
your place in the middle of the file, execute YMark.  If you've 
inserted material in the middle of a document and want to see how 
many pages the lengthened file runs, execute BtmFile.  Then use 
YMark to return to your place.

You can sometimes accomplish the same purpose by pressing ^QP to 
return to your previous cursor position after using ^QR to go to 
the top of a file or ^QC to go to the bottom.  But ^QP won't get 
you back to the previous position if you've made changes while at 
the top or bottom.

The place marks left by TopFile and BtmFile are hidden.  If you 
don't want to return to your place after using either macro, 
never mind the place mark.  It will be removed when you use 
another mark with the same number or when you close the file. 
 



Label:  LMargin

WS4.0, 5.x, 6.0:  ^K1^KH^QS  (210)

WS7.0:             Sub Main
                   Key ("^K1^KH^QS")
                   End Sub  (211)

        Function:  Leaves a place mark and moves the cursor to 
the left end of a line.

     

Label:  RMargin

WS4.0, 5.x, 6.0:  ^K1^KH^QD  (212)

WS7.0:             Sub Main
                   Key ("^K1^KH^QD")
                   End Sub  (213)
     
        Function:  Leaves a place mark and moves the cursor to 
the right end of a line.


LMargin and RMargin can be used simply to jump the cursor from 
one end of a line to the other.  But they have a second use:  If 
you're in the middle of a line and want to change a word at the 
start of the line, execute LMargin.  Then, to get back to the 
middle of the line without having to use ^F or the right arrow 
key, execute YMark.  Note:  You won't see the place mark in the 
middle of the line.  Marks left by LMargin and RMargin are 
hidden.  If you don't need to return to a mark, forget it.  It 
won't hurt anything. 

.lm 6
.rm 60

     Note:  Five macros in this section (and several in 
     other sections) leave ^K1 place marks.  Whether you use 
     one, two or all of these macros, YMark will get you 
     back to your place.  But:  If you execute Mark at the 
     top of a page and then execute LMargin at the bottom of 
     the page, you'll lose the place mark left by Mark.  Two 
     place marks with the same number cannot coexist.  The 
     assumption is that you'll seldom use one place-marking 
     macro and then execute a second such macro before 
     returning to the mark left by the first macro.  You may 
     of course assign different mark numbers to different 
     macros.  But you'll then have to keep the numbers 
     straight.  

.lm 1
.rm 65

See also Searching.


                                o
     
.pa









     Moving Files Between Directories



Label:  Mv2Main

WS4.0:   ^KQE^R^M\WS4\^R^M  (214) 

WS5.0:   ^KT\WS5\^R^ME^T^T^M$^MRDEL $^M  (215)

WS5.5:   ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS5\^M^X^KB<SP>^E
         ^KK^KY^KR^T^T^M^KD^KQE^T^T^M$^MY$^M  (216)

WS6.0:   ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS\^M^X^KB<SP>^E
         ^KK^KY^KR^T^T^M^KD^KQE^T^T^M$^MY$^M  (217)

WS6.0D:  ^KQE^QD^A^Q<DELETE>^M\WS\^R^M  (218)

WS7.0A:   Sub Main
          Key ("^KQE^QD^A^Q{DEL}")
          PauseForInput ("{ENTER}", ' Check filename. ')
          Key ("{TAB}\WS\^R{F10}")
          End Sub  (219)

WS7.0C:   Sub Main
          WSQuiet (On)
          Key ("^KDE^QD^A^Q{DEL}{TAB}\WS\^R{F10}")
          WSQuiet (Off)
          End Sub  (220)


        Function:  Moves a file to the main WordStar directory 
from a WordStar subdirectory.  (Two-step Shorthand definitions 
required for WS5.5 and WS6.0 macros.) 




Label:  Mv2Biz 

WS4.0:   ^KQE^R^M\WS4\BIZ\^R^M  (221)   

WS5.0:   ^KT\WS5\BIZ\^R^ME^T^T^T^M$^MRDEL $^M  (222)
     
.pa
.heHOLY MACRO!                                                #


WS5.5:   ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS5\BIZ\^M^X
         ^KB<SP>^E^KK^KY^KR^T^T^T^M^KD^KQE^T^T^T^M$
         ^MY$^M  (223)

WS6.0:   ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS\BIZ\^M^X
         ^KB<SP>^E^KK^KY^KR^T^T^T^M^KD^KQE^T^T^T^M$
         ^MY$^M  (224)

WS6.0D:  ^KQE^QD^A^Q<DELETE>^M\WS\BIZ\^R^M  (225)
     
WS7.0A:   Sub Main
          Key ("^KQE^QD^A^Q{DEL}")
          PauseForInput ("{ENTER}", ' Check filename. ')
          Key ("{TAB}\WS\BIZ\^R{F10}")
          End Sub  (226)

WS7.0C:   Sub Main
          WSQuiet (On)
          Key ("^KDE^QD^A^Q{DEL}{TAB}\WS\BIZ\^R")
          Key ("{F10}")
          WSQuiet (Off)
          End Sub  (227)

        Function:  Moves a file to a subdirectory called BIZ from 
another subdirectory or from the main WordStar directory.  
(Shorthand definitions required for WS4.0, WS5.0 and WS6.0D 
macros; two-step Shorthand definitions required for WS5.5 and 
WS6.0 macros.)
     

Assume that a file is in the BIZ subdirectory and you want to 
move it to the main WordStar directory.  Call up the file in the 
BIZ subdirectory and execute Mv2Main.  To move a file from the 
main directory to the BIZ subdirectory, open the file in the main 
directory and execute Mv2Biz.  In each case, the macro drops you 
off at the opening screen in the source directory after moving 
the file to the destination directory.  
    
If you open a document with the idea of moving it and decide to 
make some changes first, save with ^KS before executing a 
file-moving macro.  Exception:  The save is unnecessary if you're 
using WordStar 7.0C.  

If you're editing a WordStar 4.0 file and you use ^KR or ^KW to 
import or export data, save the file with ^KD and reopen it 
before executing a file-moving macro.  Do the same thing if you 
call up a WordStar 5.x or 6.0 file with the idea of moving it but 
decide to open a window first.  If you don't follow this 
procedure, the macro may misfire because the filename in memory 
has been changed.  If you're using WordStar 7.0A or 7.0C, you can 
move a file without saving it even if you've opened a window.  
The WS7.0A macro will prompt you to check the filename, to make 
sure it's the right one.  If it is, press Return.  If it is not, 
     
enter the correct name and press Return.  The WS7.0C macro always 
keeps track of the correct filename and will not ask you to check 
it.  

Assume that you try to move a file called WOMBAT from the main 
WordStar directory to the BIZ subdirectory but that there's 
already a file named WOMBAT in that subdirectory.  If you're 
using WordStar 4.0 or 6.0D, an error message will tell you that 
the file cannot be renamed.  If you're using WordStar 5.0, the 
macro will be interrupted and you'll be asked whether you want to 
overwrite the WOMBAT file already in the BIZ subdirectory.  If 
you're using WordStar 5.5 or 6.0, the macro will fail by design 
and an error message will tell you that an end-block marker is at 
or before a begin-block marker.  If you're using WordStar 7.0A or 
7.0C, an error message will tell you:  "That file already 
exists."
     
.lm 6
.rm 60

     Note that the directory designations in some macro      
     definitions include numbers.  See the second full 
     paragraph on page 20.
          
     WordStar 6.0D users:  Note the ^Q<DELETE> sequences in      
     Mv2Main and Mv2Biz.  See the fifth paragraph on page 
     18. 


                                o 
                   
.lm 1
.rm 65
.pa









     Name-and-Address Lists



Label:  Go2Name 

WS4.0:  ^QS^KB^K3^N^N^X^X^K4^KK^E^KR\WS4\NAME&AD^M
        ^KH^QF  (228)

WS5.x:  ^QS^OK\WS5\NAME&AD^M^QF<SP>^XU^E^G  (229)

WS6.0:  ^QS^OK\WS\NAME&AD^M^QF<SP>^XU^E^G  (230)

WS7.0:   Sub Main
         WSQuiet (On)
         Key ("^QS^OK\WS\NAME&AD{F10}")
         WSQuiet (Off)
         Key ("^QF<SP>^XU^E^G")
         End Sub  (231)
 
         Function:  Calls up an address file and displays a 
search prompt.  (Shorthand definition required for WS4.0 macro.)
  
        
Go2Name lets you look up names, street addresses and telephone 
numbers without having to close the file you're editing.  You 
just execute the macro and supply a name.  

Before using the macro, you'll create an address file.  The 
filename NAME&AD is used as an example in the macro definitions.  

There are two types of address files.  The first can be used with 
the companion macro CopName-1, described later in this section.  
CopName-1 copies a name and address to the top of a letter.

To create a Type 1 address file, follow these steps:

At the opening screen in the main WordStar directory, press N.  
Type NAME&AD and press Return.  Begin typing a listing:  


Amelia A. Addleson
123456 Seventh Street
Wishwash, Washington 99999-0000 
Dear Ms. Addleson:
*509 000-0000
You can leave one or more blank lines after each listing.
     
Note the Dear Ms. Addleson: in the sample listing.  When Go2Name 
is used with the companion macro CopName-1, a salutation is 
copied to the top of a letter along with a name-and-address 
block.

Important:  Note the asterisk before the telephone number.  If 
you're missing a phone number for someone on your list, leave an 
asterisk by itself on the last line of the listing.  Don't omit 
it.  If there's any chance you'll correspond with people who 
actually have asterisks in their addresses (the syndicators of 
the "M*A*S*H" television series come to mind), use a caret (^) or 
some other symbol in place of the asterisk.  (And use the same 
symbol in place of the asterisk in the definition of the 
companion macro CopName-1, below.)

You can enter additional information on the phone-number line, 
using it as a remarks line.  Example:
          

*509 000-0000.  Stanford grad.  Husband: Bob.  Son: John.  


Since NAME&AD is a nondocument file, you don't have to worry 
about running past the right margin on the remarks line.  If you 
type 250 characters, you'll still be on the same line, with room 
to spare.

The Type 2 address file is used with the companion macro CopName-
2 (below) and with the Merge macro (described in the next 
section).  Merge helps you convert an address file to a data file 
for use in merge-printing simple form letters.  If you won't need 
the file for that purpose, you may prefer to use the Type 1 
address list.  (But note that listings in a Type 1 file cannot be 
sorted.)

To create a Type 2 address file, follow these steps:

At the opening screen in the main WordStar directory, press N.  
Type NAME&AD and press Return.  Begin entering the first listing.  
Type the person's last name first (to make it easy to spot when 
you scroll through the file).  After the last name, type a 
backslash and the first name, with no intervening spaces.  The 
finished listing might look something like this:  


Andersen\Jerald B.
Vice President, Sales
Ipswich Tool & Die Company
12345 Junipero Serra Boulevard
Los Angeles, California 90000-0000
Dear Mr. Andersen:
213 000-0000
     ***
Note that Andersen's title occupies line 2.  If Andersen had no 
title, an asterisk would be entered on the second line of the 
listing.  Like this:


Andersen\Jerald B.
*
Ipswich Tool & Die Company
12345 Junipero Serra Boulevard
Los Angeles, California 90000-0000
Dear Mr. Andersen:
213 000-0000
     ***


In an address listing that includes neither a title nor a company 
name, one asterisk is entered on line 2 and one on line 3:  


Andersen\Jerald B.
*
*
12345 Junipero Serra Boulevard
Los Angeles, California 90000-0000
Dear Mr. Andersen:
213 000-0000
     ***

  
Important:  Each listing must have eight lines, counting the 
triple-asterisk line at the bottom.  The City-State-ZIP line is 
always line 5.  A comma must follow the name of the city.  

If you live in the United States and have a listing for someone 
in Canada, don't type the name of the country on a separate line.  
Put it on the same line as the name of the province.  Like this:


Cornwall, Ontario, Canada K6K-1N5


In a nine-digit ZIP code, a hyphen must join the first five 
digits to the last four.  In a Canadian postal code, a hyphen 
must join the first three characters to the last three.  Each 
listing must include a ZIP or postal code.

Note the Dear Mr. Andersen: below the City-State-ZIP line in the 
Jerald B. Andersen listing.  It's used as a salutation line when 
the listing is copied to the top of a letter by the CopName-2 
macro (below).  
     
If you're missing a telephone number for someone on your list, 
type several x's on the line below the salutation line.  (You can 
also use this line for remarks.  See page 103.)
          
If there's a chance you'll correspond with people who have 
asterisks in their addresses, use a caret (^) or some other 
symbol to mark an empty field, and to create the three-character 
divider between listings.  (Use the same symbol in place of each 
asterisk in the definition of the companion macro CopName-2, 
below.)

When you've finished the first listing, begin the second on the 
next line.  Do not leave blank lines between listings.  Example:  
     

Addleson\Amelia A.
*
*
123456 Seventh Street
Wishwash, Washington 99999-0000
Dear Ms. Addleson:
509 000-0000
     ***
Andersen\Jerald B.
Vice President, Sales
Ipswich Tool & Die Company
12345 Junipero Serra Boulevard
Los Angeles, California 90000-0000
Dear Mr. Andersen:
213 000-0000
     ***


If you use "M.D." in an address listing for a doctor, put it 
after the last name, not after the first name and middle initial.  
The same rule applies to such abbreviations as "Esq.," "Ph.D." 
and "Jr."  Example:  The name of Annette J. Henderson, M.D., 
would be typed Henderson, M.D.\Annette J., not Henderson\Annette 
J., M.D.  Reason:  When the address listing is read by either of 
the companion macros, Annette J. is moved in front of Henderson, 
M.D., so that the name comes out Annette J. Henderson, M.D.  If 
you put the "M.D." after the middle initial, instead of after the 
last name, you'll get Annette J., M.D. Henderson.

Whether you use a Type 1 or Type 2 address list, you'll see a 
search screen when you execute the Go2Name macro to call up the 
NAME&AD file.  To find an address listing, type the last name of 
any person on the list and press Return once (if you're using 
WordStar 7.0) or twice (if you're using an earlier WordStar 
release).  You needn't bother capitalizing any letters if you're 
using WordStar 5.x, 6.0 or 7.0.  Tip:  You may be able to save 
keystrokes by typing only the first four or five letters of a 
name.  If that sequence of letters occurs twice in the address 
file, the search command will find the first of the two 
occurrences.  If you've landed in the wrong listing, press ^L.  
The cursor will move to the second occurrence.  
     
To browse the address file, press ^U when the search screen 
appears.  
     
If you're using WordStar 4.0, the address file will be inserted 
in the document you're working on.  If you just want to look up 
something in the address file, press ^KY after getting the 
information you need.  That will delete the address file and 
leave your working file as it was before you executed Go2Name.  
If you're using WordStar 5.x, 6.0 or 7.0, the address file will 
appear in a window.  When you've found what you need, press ^KQ 
to close the window.  

     


Label:  CopName-1

WS4.0:       ^QS^KB^QG*^E^QD^KK^E^QD^M^Q3^S^KC^Q3^K3^KB
             ^Q4^K4^KK^KY  (232)

WS5.x, 6.0:  ^QS^KB^QG*^E^QD^KK^E^QD^M^OK^KA^OK^KQY  (233)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QS^KB^QF*{TAB}^Y{F10}^E^QD^KK")
              Key ("^E^QD{ENTER}^OK^KA^OK^KQ")
              IfException
              Def: Key ("Y")
              End IfException  
              WSQuiet (Off)
              End Sub  (234)

        Function:  Copies a listing from an address file to the 
top of a letter.  (Shorthand definition required for WS4.0 
macro.)
     
     
CopName-1 works with the Type 1 address file described earlier.  
Procedure:  With the cursor two lines above the first paragraph 
in a letter file, execute the Go2Name macro to find an address.  
(If you're using WordStar 4.0, make sure the cursor is not on the 
top line of the letter file when you execute Go2Name.)  When the 
cursor lands on the first line of the address, execute CopName-1.  
The address listing (minus the telephone number) will be copied 
to the letter.  Example:  
 
Here's how a listing looks in the address file:


Cynthia A. Bardelson
Chief Executive Officer
Bardelson Incorporated
1234 Fifth Street
Wildfire, Colorado 81111-0000 
Dear Ms. Bardelson:
*503 000-0000
           
And here's how it comes out at the top of the letter: 


Cynthia A. Bardelson
Chief Executive Officer
Bardelson Incorporated
1234 Fifth Street
Wildfire, Colorado 81111-0000

Dear Ms. Bardelson:


The macro works with addresses containing any number of lines.  
If you're using WordStar 4.0, the address file brought onscreen 
by the Go2Name macro will be erased automatically after an 
address is copied by CopName-1.  If you're using WordStar 5.x, 
6.0 or 7.0, the window in which the address file is displayed 
will close automatically after the address is copied.


 

Label:  CopName-2

WS4.0:        ^QS^KB^QG\^G^Q<DELETE>^QD<SP>^A^QG<SP>^D^U
              ^QF***^M^M^E^E^QD^KK^E^QD^M^QB^QG*^G^S^T^L
              ^G^S^T^Q3^S^KC^Q3^K3^KB^Q4^K4^KK^KY^Y  (235)

WS5.x, 6.0:   ^QS^KB^QG\^G^Q<DELETE>^QD<SP>^A^QG<SP>^D^U
              ^QF***^M^Y^M^E^E^QD^KK^E^QD^M^QB^QG*^G^S^T
              ^L^G^S^T^OK^KA^OK^KQY (236)

WS7.0:         Sub Main
               WSQuiet (On)
               Key ("^QS^KB^QF\{TAB}^Y{F10}^G^Q{DEL}")
               Key ("^QD<SP>^A^QF<SP>{TAB}^Y{F10}")
               Key ("^D^U^QF***{TAB}^Y{F10}^E^E^QD^KK")
               Key ("^E^QD{ENTER}^QB^QF*{TAB}^Y{F10}^G")
               Key ("^S^T^L^G^S^T^OK^KA^OK^KQ")
               IfException
               Def: Key ("Y")
               End IfException 
               WSQuiet (Off)
               End Sub  (237) 

        Function:  Same as that of CopName-1.  (Two-step 
Shorthand definitions required for WS4.0 and WS5.x/6.0 macros.)


CopName-2 works with the Type 2 address file described earlier.  
Procedure:  With the cursor two lines above the first paragraph 
in a letter file, execute Go2Name to find an address.  (If you're 
using WordStar 4.0, make sure the cursor is not on the top line 
of the letter file when you execute Go2Name.)  When the cursor 
     
lands on the first line of the address, execute CopName-2.  The 
address listing (minus the last two lines) will be reformatted 
and copied to the letter.  Example:  

Here's how a listing looks in the address file:


Andersen\Jerald B.
*
Ipswich Tool & Die Company
12345 Junipero Serra Boulevard
Los Angeles, California 90000-0000
Dear Mr. Andersen:
213 000-0000
     ***


And here's how it comes out at the top of a letter:


Jerald B. Andersen
Ipswich Tool & Die Company
12345 Junipero Serra Boulevard
Los Angeles, California 90000-0000

Dear Mr. Andersen:


The macro works with addresses of three, four or five lines.  
     
If you're using WordStar 4.0, the address file brought onscreen 
by the Go2Name macro will be erased automatically after an 
address is copied by CopName-2.  If you're using a later WordStar 
release, the window in which the address file is displayed will 
close automatically after the address is copied.

.lm 6
.rm 60

     If you're using WordStar 4.0, 5.x or 6.0, note the 
     ^Q<DELETE> sequences in the CopName-2 macros.  See the 
     fifth paragraph on page 18.

     Note that the directory designations in some of the 
     macros described in this section include numbers.  See      
     the second full paragraph on page 20.

.lm 1
.rm 65



Label:  PreSort

WS4.0, 5.x, 6.0:  ^QS^QG^M*^T^S^L*^T^S^L*^T^L*^T^L*^T^L*
                  ^T^L*^T^X^[P  (238)
     
.pa
     

WS7.0:             Sub Main
                   WSQuiet (On)
                   Loop:  Key ("^QS^QF^P^M^P^J{TAB}^Y{F10}")
                   Key ("*^T^S^L*^T^S^L*^T^L*^T^L*^T^L*^T")
                   Key ("^L*^T^X")
                   GoTo Loop
                   WSQuiet (Off)
                   End Sub  (239)

        Function:  Reformats an address file so that it can be 
sorted.
     
     
The letter P at the end of the definition for WS4.0, 5.x and 6.0 
is used as an example.  P is the letter you would use if you 
assigned the macro to the Shorthand key P.  You may assign it to 
any Shorthand key.  

You don't need to run PreSort before using the Go2Name and 
CopName macros (above).  It makes no difference to those macros 
whether an address list is sorted.  But PreSort may be helpful if 
you need an alphabetized list.  If you're adding 25 names to the 
NAME&AD file, you can enter them in any order and then use 
PreSort to prepare them for sorting.  

Note:  The macro works only with the Type 2 address file 
described earlier in this section.  (It won't work with Type 1 
files because address listings in those files may not all contain 
the same number of lines.)

Procedure:  Open NAME&AD as a nondocument (by pressing N before 
typing the filename).  Execute PreSort with the cursor anywhere 
on the top line of the file.  The macro reformats the address 
listings, leaving all fields in each listing on a single line.  
(That format is needed for sorting.  The file will later be 
reconverted to its original format by the Rebuild macro, below.)  

If you're using WordStar 4.0, 5.x or 6.0, press Esc to terminate 
the macro after the last address listing has been reformatted.  
You may have to press Esc several times, at irregular intervals.  

If you're using WordStar 7.0, hold down Ctrl and press the Break 
key after the last listing has been reformatted.  Then clear the 
screen of messages by pressing Esc.  You may have to press twice.  
At some point, you'll get an error message.  Disregard it.  The 
macro will not have malfunctioned.  

Next step:  If you're using WordStar 5.x, 6.0 or 7.0, block the 
entire address file by pressing ^KB at the start of the first 
line and ^KK below the bottom line.  Then press ^KZ to sort the 
listings.  When asked whether to sort in ascending or descending 
     
.pa
      
order, press A to choose ascending.  When the file is sorted, 
press ^KH to extinguish the block highlighting.  If you're using 
WordStar 4.0, you can't sort with ^KZ.  You'll need to run the 
DOS SORT command.  (See your DOS manual.)
           
If any stray characters have been left below the last listing, 
remove them.



          
Label:  Rebuild

WS4.0:       ^QS^QG*^G^M^D^L^G^M^D^L^G^M^L^G^M^L^G^M
             ^L^G^M^L^G^M^X^[R  (240)

WS5.x, 6.0:  ^QS^QG*^G^M^L^G^M^L^G^M^L^G^M^L^G^M^L^G^M
             ^L^G^M^X^[R  (241)  

WS7.0:       Sub Main
             WSQuiet (On)
             Loop:  Key ("^QS^QF*{TAB}^Y{F10}^G{ENTER}")
             Key ("^L^G{ENTER}^L^G{ENTER}^L^G{ENTER}")
             Key ("^L^G{ENTER}^L^G{ENTER}^L^G{ENTER}")
             Key ("^X")
             GoTo Loop
             WSQuiet (Off)
             End Sub  (242)

        Function:  Restores a sorted address file to its original 
format.  


The letter R at the end of the definitions for WS4.0 and 
WS5.x/6.0 is used as an example.  R is the letter you would use 
if you assigned the macro to the Shorthand key R.  You may assign 
it to any Shorthand key.  

After running PreSort and sorting an address file, keep the file 
onscreen and execute Rebuild with the cursor anywhere on the top 
line of the file.  The macro will restore the original file 
format, so that each listing will again occupy eight lines.  The 
listings will appear exactly as originally typed, except that 
they will be arranged alphabetically by last name.
 
If you're using WordStar 4.0, 5.x or 6.0, press Esc to terminate 
the macro after the last address listing has been reformatted.  
You may have to press Esc several times, at irregular intervals.

If you're using WordStar 7.0, hold down Ctrl and press the Break 
key after the last listing is reformatted.  You'll get an error 
message.  Disregard it and press Esc.  
     
     
If any stray characters have been left below the last listing, 
remove them.
     
     
                                o
     
.pa









     Name Lists and Merge Printing



Label:  Merge

WS4.0, 5.x, 6.0:  ^QS^K2^QG*^G^L^G^Q2^K2^QG\^G^Q<DELETE>^QD
                  <SP>^A^QG<SP>^D^U^QG^M*^T^S^L*^T^S^L*^T^L*
                  ^T^QG,^F*^QD^A*^QG^M*^T^X^Y^Y^[M  (243)

WS7.0:             Sub Main
                   WSQuiet (On)
                   Loop: Key ("^QS^K2^QF*{TAB}^Y{F10}^G^L")
                   Key ("^G^Q2^K2^QF\{TAB}^Y{F10}^G^Q{DEL}")
                   Key ("^QD<SP>^A^QF<SP>{TAB}^Y{F10}^D^U")
                   Key ("^QF^P^M^P^J{TAB}^Y{F10}*^T^S^L")
                   Key ("*^T^S^L*^T^L*^T^QF,{TAB}^Y{F10}")
                   Key ("^F*^QD^A*^QD*^T^X^Y^Y")
                   GoTo Loop
                   WSQuiet (Off)
                   End Sub  (244)

        Function:  Reformats an address file so that it can be 
used for merge printing.  (Two-step Shorthand definition required 
for WS4.0/5.x/6.0 macro.)


The letter M at the end of the definition of the macro for 
WordStar 4.0, 5.x, and 6.0 is used as an example.  M is the 
letter you would use if you assigned the macro to the Shorthand 
key M.  You may assign it to any Shorthand key.
      
Merge works with the Type 2 NAME&AD file described in the 
previous section.  The macro helps convert NAME&AD to a data file 
for use in merge-printing simple form letters.  Procedure:

Make a copy of the NAME&AD file, calling the copy NAME&AD.DAT.

Press N at the opening screen and open the NAME&AD.DAT file. 

Place the cursor anywhere on the top line of the file and execute 
Merge.  The file will be reformatted.  

If you're using WordStar 4.0, 5.x or 6.0, press Esc to terminate 
the macro after all listings have been reformatted.  You may have 
to press the key several times, at irregular intervals.  
If you're using WordStar 7.0, hold down Ctrl and press the Break 
key after all listings have been reformatted.  Then press Esc 
once or twice to clear the screen of messages.  At some point, 
you'll get an error message.  Disregard it.

Delete any characters or blank lines below the last listing.  If 
you see a blocked number 2, it's a place mark.  Ignore it.  Save 
the file.

NAME&AD.DAT is now ready for use as a merge-printing data file.  
To merge-print, you'll need to create a master file that will 
extract data from NAME&AD.DAT.  To open the master file, press D 
at the opening screen.  The file might be called FORMLTR.MAS and 
might be structured something like this:
     
     
.LS1
.OP
.DF NAME&AD.DAT,*
.RV NAME
.RV TITLE
.RV COMPANY
.RV STREET-ADDRESS
.RV CITY 
.RV STATE
.RV ZIP
.RV SALUTATION

September 18, 1992

&NAME&
&TITLE/O&
&COMPANY/O&
&STREET-ADDRESS&
&CITY& &STATE& &ZIP&

&SALUTATION&

After years of intensive research, we're about to introduce a 
line of self-embedding thumb tacks.  We'll have a brochure in the 
mail to you within two weeks.  We at Super Max Tacks are 
confident you'll find this latest product of special interest.  

Sincerely,


Thomas Thumb 
Vice President, Sales
.PA
     

Note the comma and asterisk at the end of the .DF NAME&AD.DAT,* 
line near the top of the master file.  The last character tells 
WordStar that the asterisk is to be used as a data separator in 
place of the comma.  The comma is the default separator, but using that character complicates matters if you want to include 
commas in any of your data fields.  If there's any chance you'll 
correspond with people who have asterisks in their addresses, use 
a caret (^) or some other symbol in place the asterisk.  (And use 
the same symbol in place of each asterisk in the definition of 
the Merge macro.) 
     
Note the lines &TITLE/O& and &COMPANY/O& several lines above 
&SALUTATION& in the master file.  The slash and letter O are 
there in case some addresses have fewer than five lines.  If the 
/O option is not used, and if WordStar finds an address with only 
three or four lines, one or two lines will be left blank when the 
address prints.  

Finally, note the .PA dot command after the last line of the 
letter.  It's needed for proper page breaks. 

To merge-print the master file, press P at the opening screen if 
you're using WordStar 7.0.  Press M if you're using an earlier 
WordStar release.  Enter the filename FORMLTR.MAS (if it's not 
already displayed).  Start printing.  

You can also merge-print the envelopes in which you'll mail 
copies of the form letter.  For envelope printing, you'll need a 
separate master file.  It will extract names and addresses from 
NAME&AD.DAT.  At the opening screen, press D, type the filename 
ENVELOPE.MAS and press Return to open the file.  When finished, 
the file might look something like this:


.LS1
.MT10
.MB0
.LM0
.RM9.5"
.PO4.5"
.PL4.0"
.OP
.DF NAME&AD.DAT,*
.RV NAME
.RV TITLE
.RV COMPANY
.RV STREET-ADDRESS
.RV CITY
.RV STATE
.RV ZIP
.RV SALUTATION
..
..
&NAME&
&TITLE/O&
&COMPANY/O&
&STREET-ADDRESS&
&CITY& &STATE& &ZIP&
.PA
     
If you're using WordStar 4.0, change the .RM9.5" line to .RM95, 
the .PO4.5" line to .PO45 and the .PL4.0" line to .PL24.

The file you want to merge-print is ENVELOPE.MAS.  If you have a 
laser printer, remember to put it in landscape mode.  Tell the 
printer to pause between pages if you'll feed the envelopes 
manually.  

If the addresses don't print exactly where you want them, try 
changing the numbers in the .MT and .PO dot commands in the 
ENVELOPE.MAS file.  (The .MT command sets the top margin.  The 
.PO command controls the page offset, telling WordStar how far 
from the left side of an envelope to start printing.) 

You may want to preserve the ENVELOPE.MAS file.  It can be used 
for other print jobs.  If the names and addresses in the data 
file you use for your next print job are structured like those in 
NAME&AD.DAT, all you'll need to do is put the name of your new 
data file in the ENVELOPE.MAS file.  Example:  If the new data 
file is called NEWDATA.DAT, just substitute .DF NEWDATA.DAT,* for 
the .DF NAME&AD.DAT,* line in ENVELOPE.MAS.  

Note:  This section touches on only a few basic merge-printing 
procedures.  For a further explanation of these procedures, and 
for illustrations of many more elaborate procedures, see Merge 
printing in the WordStar manual.

.lm 6
.rm 60

     Note the ^Q<DELETE> sequence in the Merge definition 
     for WordStar 4.0, 5.x and 6.0 and the ^Q{DEL} sequence 
     in the definition for WordStar 7.0.  See the fifth 
     paragraph on page 18.  
         
         
                                o

.pa
.mt5
.mb6
.cw12
.heHOLY MACRO!                                                #
.hm2
.fm2
.lm1
.rm65
.ls1
.po 1i
.lh8
.pl66
.op
.ps off
.fo
.pn116
  
  
  
  
  
  
  
  
  
     Numbering Pages in Letters



Label:  Header-1

WS4.0, 5.x, 6.0:  ^QS^KB^KH^QD^KK^QR.MT6^M^M^M^E.H1<SP>^KC
                  ^KH^QD^M.H2<SP>Page<SP>#<SP>of<SP><SP>
                   pages^M.H3<SP>^[@^E^QD^QH<SP>  (245)

WS7.0:             Sub Main
                   WSQuiet (On)
                   Key ("^QS^KB^KH^QD^KK^QR.MT6{ENTER}")
                   Key ("{ENTER}{ENTER}^E.H1<SP>^KC^KH^QD")
                   Key ("{ENTER}.H2<SP>Page<SP>#<SP>of<SP>")
                   Key ("<SP>pages{ENTER}.H3<SP>^M@^E^QD")
                   Key ("^QF<SP>{TAB}B{F10}")
                   WSQuiet (Off)
                   End Sub  (246)

        Function:  Creates a three-line header for numbering 
inside pages of a business letter.  (Two-step Shorthand 
definition required for WS4.0/5.x/6.0 macro.)

  
On the second page of a four-page letter written on September 22, 
1992, the header might come out something like this:


Janice J. Jamison
Page 2 of 4 pages
September 22, 1992


The first line of the header prints the addressee's name at the 
top of each page, beginning with page 2.  The second line double-
paginates, printing both a page number and a number indicating 
the overall length of the letter in pages.  A sequence built into 
the macro prints the current date on the third line.  (If you 
want only the page number on the second line, see the macro 
described later in this section.)  

Procedure:  When you've finished drafting a letter and know how 
     
.pa     
     
many pages it runs, move the cursor to the address block near the 
top of the letter.  Assume that the block looks like this:
  
     
Janice J. Jamison
Jamison Electronics Company
100 Parque Avenue
New York, New York 10000


Position the cursor anywhere on the Janice J. Jamison line.  
Execute Header-1.  The header format will be displayed at the top 
of your screen:  


.MT6

.H1 Janice J. Jamison
.H2 Page # of  pages
.H3 September 22, 1992


Note the blank line below the .MT6 dot command.  Don't remove it.  
It keeps the header from printing on the first page of the 
letter.  (The .MT6 command sets the top margin at six lines.  The 
number is just an example.  You can use any top margin, so long 
as it's large enough to accommodate a three-line header.  The 
default margin of three lines, or 0.5 inches, is not large 
enough.  You may want to experiment with several different 
settings.) 

Note the two blank spaces between "of" and "pages" on the .H2 
line.  After the macro has run, the cursor will be in the second 
of those two spaces.  Without moving the cursor, type the number 
of pages in the letter.  The header might now look something like 
this:


.H1 Janice J. Jamison
.H2 Page # of 4 pages
.H3 September 22, 1991

      
When you print the letter, WordStar enters the number of each 
inside page at the position occupied by the # symbol on the .H2 
line.        

Note:  It's assumed you have line spacing set at 1.  If you've 
entered dot commands at the top of your letter, Header-1 will 
move them down, leaving them below the third line of the header.  
     
     
.pa     
Label:  Header-2

WS4.0, 5.x, 6.0:  ^QS^KB^KH^QD^KK^QR.MT6^M^M^M^E.H1<SP>
                  ^KC^KH^QD^M.H2<SP>Page<SP>#^M.H3<SP>
                  ^[@  (247)

WS7.0:             Sub Main
                   Key ("^QS^KB^KH^QD^KK^QR.MT6{ENTER}")
                   Key ("{ENTER}{ENTER}^E.H1<SP>^KC^KH^QD")
                   Key ("{ENTER}.H2<SP>Page<SP>#{ENTER}")
                   Key (".H3<SP>^M@")
                   End Sub  (248)

        Function:  Same as that of Header-1 except that the total 
number of pages in the letter is omitted.  (Shorthand definition 
required for WS4.0/5.x/6.0 macro.)


Like the previous macro, Header-2 prints the addressee's name on 
the first header line and the date on the third line.  The page 
number only is printed on the second line.  There are no 
keystrokes to add when the macro has run.  The header is 
complete.  When the second page of the letter is printed, the 
header comes out like this:


Janice J. Jamison
Page 2
September 22, 1991


Note:  You can use Go2Name and one of the CopName macros to set 
up the inside address used by Header-1 or Header-2.  (See Name-
and-Address Lists.)


                                o
    
.pa









     Opening Windows



Label:  WinMain

WS5.x:  ^OK\WS5\  (249)

WS6.0:  ^OK\WS\  (250)

WS7.0:   Sub Main
         Key ("^OK\WS\")
         End Sub  (251) 

         Function:  Displays a prompt and enters the directory 
designation used to open a window on a file in the main WordStar 
directory.  




Label:  WinBiz

WS5.x:  ^OK\WS5\BIZ\  (252)

WS6.0:  ^OK\WS\BIZ\  (253)

WS7.0:   Sub Main
         Key ("^OK\WS\BIZ\")
         End Sub  (254)

         Function:  Displays a prompt and enters the directory 
designation used to open a window on a file in a subdirectory 
called BIZ.


The macros are for users who often need to open windows and call 
up files from a directory other than the one they're working in.  

Application:  To open a window on a file in the subdirectory 
\WS\BIZ, just execute WinBiz, type the filename and press Return.  
The macro saves you the trouble of typing the path \WS\BIZ\ in 
front of the filename (and perhaps also the trouble of having to 
do it a second time because you made a typing error).  
     
.lm 6
.rm 60
          
     Note that the directory designations in two of the 
     macro definitions include numbers.  See the second      
     full paragraph on page 20.  


                                o
          
.lm 1
.rm 65
.pa    









     Parking  



Label:  Park 

WS4.0:        ^KS^KQRSHIPDISK^M  (255) 

WS5.0, 5.5:   ^R^K^DRSHIPDISK^M  (256)

WS5.5C, 6.0:  ^R$^H^K^DRSHIPDISK^M  (257)

WS7.0A:        Sub Main
               Key ("{F10}<SP>^S^G^KFSHIPDISK{F10}")
               PauseForInput ("{F10}", 'Press F10.')
               Key ("^D^KQ")
               IfException
               Def: Key ("N")
               End IfException
               End Sub  (258)

WS7.0C:        Sub Main
               SetHelpLevel (4) : AutoRestore (On)
               Key ("{F10}{ALT+F}RSHIPDISK{F10}")
               End Sub  (259)

        Function:  Parks the hard disk.


The name of the parking utility SHIPDISK is used in the macro 
definitions as an example.  

Park can be executed at the opening screen or at the editing 
screen.  If a file is onscreen, it will be saved.  Use the macro 
to keep your hard disk out of harm's way when you have to leave 
your computer unattended temporarily.  If you're using WordStar 
4.0, 5.x, 6.0 or 7.0C, you can unpark the disk and go back to 
WordStar by pressing Return twice.  If you're using WordStar 
7.0A, press Return once and tap F10 when told to press any key to 
return to WordStar.  (If you forget and press another key, a 
message at the top of the screen will prompt you to press F10.) 

If you operate WordStar 7.0A or 7.0C at help level 4, do not 
assign Park to a function key.
     
     
If you're quitting for the day, you should leave WordStar before 
parking.  Enter the name of the parking utility at the DOS prompt 
in the WordStar directory and press Return.            
     
     
                                o 
     
.pa
           
     
     






     Printing Blocks of Text



Label:  PrtBlk

WS4.0:       ^KH^F^D^B^S^S^QD^KK^KWPRINT^MY^Q<DELETE>^KPN
              PRINT^[^KH  (260)

WS5.x, 6.0:  ^KH^F^D^B^S^S^QD^KK^KWPRINT^MY^Q<DELETE>^KPP
              PRINT^K^KH  (261)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QF^P^M^P^J{TAB}B{F10}^KB^KH")
              WSQuiet (Off)
              PauseForInput ("<SP>", 'Press Spacebar to print.')
              WSQuiet (On)
              Key ("^F^D^B^S^S^QD^KK^KWPRINT{F10}")
              IfException
              Def: Key ("Y")
              End IfException
              Key ("^KPPRINT^K^KH")
              WSQuiet (Off)
              End Sub  (262)

        Function:  Prints a defined block of text.  (Shorthand 
definitions required for WS4.0 and WS5.x/6.0 macros.) 


PrtBlk writes the block of text to a file called PRINT and then 
prints that file.  

If you're using WordStar 7.0:

Execute PrtBlk with the cursor anywhere in the first paragraph 
you want to print.  Then place the cursor anywhere in the last 
paragraph to be printed and press the Spacebar.  To print a 
single paragraph, execute the macro with the cursor anywhere in 
that paragraph and press the Spacebar without moving the cursor.
 
If you're using an earlier WordStar release:

Execute GrafBlk to block the first paragraph you want to print.  
Then execute PrtBlk with the cursor anywhere in the last 
paragraph to be printed.  To print a single paragraph, block the paragraph with GrafBlk, move the cursor back into the blocked 
paragraph and execute PrtBlk.  If you have not programmed 
GrafBlk, place the cursor on the blank line above the first 
paragraph to be printed and press ^KB.  (If there's a dot command 
immediately above the paragraph, press ^KB with the cursor to the 
right of the dot command.)  Then execute PrtBlk with the cursor 
anywhere in the last paragraph to be printed.  To print a single 
paragraph without using GrafBlk, press ^KB with the cursor on the 
blank line above the paragraph and execute PrtBlk without moving 
the cursor.
     
     
.lm 6
.rm 60

     Note the ^Q<DELETE> sequences in the PrtBlk definitions      
     for WordStar 4.0 and 5.x/6.0.  See the fifth paragraph 
     on page 18.
          

                                o
                     
.lm 1
.rm 65
.pa









     Printing Envelopes



Label:  PrtEnvl-1

WS4.0:       ^QS^N^K2^KRENV1^M^QF^P^M^P^J^P^M^P^J^M^M
             ^X^X^X^KB^L^X^X^X^KK^KY^L^X^X^KK^Q2^K2^KB
             ^KWENV1^MY^KPNENV1^[^L^X^X^X^KK^KY  (263)

WS5.x. 6.0:  ^QS^KB^KH^QF^P^M^P^J^P^M^P^J^M^Y^M^KK^OK
             \WS\ENV1^M^L^M^M^M^QT^Z^KA^KD^KPP\WS\ENV1
             ^K^KH  (264)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QS^KB^KH^QF^P^M^P^J^P^M^P^J{TAB}")
              Key ("^Y{F10}^KK^OK\WS\ENV1{F10}^L{ENTER}")
              Key ("{ENTER}{ENTER}^QT^Z^KA^KD^KP\WS\ENV1")
              Key ("^K^KH")
              WSQuiet (Off)
              End Sub  (265)

        Function:  Copies an inside address to an envelope.  
(Two-step Shorthand definitions required for WS4.0 and WS5.x/6.0 
macros.) 


If you're using WordStar 5.x, 6.0 or 7.0 and your WordStar 
directory is called WS5, WS6 or WS7 (rather than WS), insert the 
number 5, 6 or 7 after \WS near the middle of the macro 
definition, and again toward the end.  

To copy an address from the top of a business letter to an 
envelope, execute PrtEnvl-1 with the cursor anywhere on the top 
line of the address.  The address must be single-spaced.  There 
must be one blank line above the salutation.  Example:


Jerald B. Andersen
12345 Junipero Serra Boulevard
Los Angeles, California 90000-0000

Dear Mr. Andersen:
               
     
Before using the macro, you'll need to set up a special file.  At 
the opening screen in the main WordStar directory, press D, type 
the filename ENV1 and press Return to open the file.  Beginning 
at the left margin, type:  
     
     
.MT10
.LM0
.PO4.25"
.LS1
.OP
<Blank line>
<Blank line>
X
     

If you're using WordStar 4.0, substitute .PO42 for .PO4.25" on 
line 3.

.lm 6
.rm 60

     WordStar 7.0 users:  If you have used WSCHANGE to 
     switch off command tags, leave a blank line at the top 
     of the ENV1 file and change the .MT10 line to .MT9.  

.lm 1
.rm 65

The address should print on the right half of a standard business 
envelope, slightly below center.  Exactly where the address will 
print may vary from printer to printer.  If you're using a 
dot-matrix or daisy-wheel printer, insert the envelope with the 
top edge slightly above the point at which the printing mechanism 
strikes.  You may need to spend a few envelopes experimenting.  
If the address prints too high, open the ENV1 file and put a 
number greater than 10 in the .MT dot command.  If the address 
prints too far to the left, change 4.25" in the .PO dot command 
to 4.5" or 4.6".  (If you're using WordStar 4.0, change 42 to 45 
or 46.) 

If you use a laser printer, you'll need to tell it to print the 
envelope in landscape mode.  Depending on the printer, you may be 
able to do this by inserting the dot command .PR OR=L in the ENV1 
file.  If that won't work, you may be able to insert a printer 
code in the ENV1 file to put the printer in landscape 
orientation.  Or you may be able to set the orientation at the 
printer's front panel.  

WordStar 4.0 users:  If you normally write letters in a      
WordStar subdirectory, put a copy of the ENV1 file in that 
subdirectory.  If you do letters in two subdirectories, put 
copies of the file in both.  
     
.pa


Label:  PrtEnvl-2

WS4.0:       ^QS^N^K2^KRENV2^M^QG@^X^QS^KB^QF^P^M^P^J
             ^P^M^P^J^M^M^X^X^X^KK^KY^L^X^X^KK^Q2^K2
             ^KB^KWENV2^MY^KPNENV2^[^QT@^Y^KH  (266)
     
WS5.x, 6.0:  ^QS^KB^KH^QF^P^M^P^J^P^M^P^J^M^Y^M^X^X^KK
             ^OK\WS\ENV2^M^QG@^QS^X^QT^Z^KA^KD^KPP\WS
             \ENV2^K^KH  (267)
          
WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QS^KB^KH^QF^P^M^P^J^P^M^P^J{TAB}")
              Key ("^Y{F10}^X^X^KK^OK\WS\ENV2{F10}")
              Key ("^QF@{TAB}{F10}^QS^X^QT^Z^KA^KD")
              Key ("^KP\WS\ENV2^K^KH")
              WSQuiet (Off)
              End Sub  (268)

        Function:  Copies a return address and a destination 
address to an envelope.  (Two-step Shorthand definitions required 
for WS4.0 and WS5.x/6.0 macros.)

.lm 6
.rm 60

     If you're using WordStar 5.x, 6.0 or 7.0 and your 
     WordStar directory is called WS5, WS6 or WS7 (rather 
     than WS), insert the number 5, 6 or 7 after \WS near 
     the middle of the macro definition, and again toward 
     the end.   

.lm 1
.rm 65

Use the macro when you want your address to appear in the upper 
left corner of an envelope on which no letterhead is printed.

Before using PrtEnvl-2, you'll need to create a special file.  At 
the opening screen in the main WordStar directory, press D, type 
the filename ENV2 and press Return to open the file.  Beginning 
at the left margin on line 1, type:


.MT0
.LM0
.PO0
.LS1
.OP
<Your name>
<Your street address>
<City, State, ZIP>
.PO4.25"
.RM9.5"
     
.pa
     
If you're using WordStar 4.0, substitute .PO42 for .PO4.25" and 
.RM95 for .RM9.5". 

After .RM9.5" (or .RM95), enter eight Returns.  Then, at the left 
margin, enter:


..@
X
<Blank line>
<Blank line>
<Blank line>

  
Execute PrtEnvl-2 with the cursor anywhere on the first line of 
the address above the body of your letter.  

It may be necessary to experiment to get the destination address 
to print exactly where you want it.  If the address prints too 
high or too low, increase or reduce the number of Returns after 
the .RM9.5" line in the ENV2 file.  To adjust the horizontal 
position of the address, change the numbers in the .PO dot 
command.

.lm 6
.rm 60

     WordStar 7.0 users:  If you have used WSCHANGE to 
     switch off display of command tags, omit the ..@ line 
     from the ENV2 file and replace the last two Key lines 
     in the PrtEnvl-2 definition with these lines:

     Key ("^QC^QF^P^M^P^J^P^M^P^J{TAB}B{F10}^L^X^X")
     Key ("^QT^Z^KA^KD^KP\WS\ENV2^K^KY^U^OD^OD")

     WordStar 4.0 users:  If you normally write letters in a      
WordStar subdirectory, put a copy of the ENV2 file in      
that subdirectory.  If you do letters in 
two      subdirectories, put copies of the file in 
both.  

     Note the ^P^M^P^J sequences in the PrtEnvl macros.  To 
     enter ^P^M^P^J in a definition using Shorthand style, 
     hold down Ctrl and press PPPMPPPJ. 

.lm 1
.rm 65

Tip:  You can use one of the CopName macros described in 
Name-and-Address Lists to copy an address to a letter, and then 
use PrtEnvl-1 or PrtEnvl-2 to copy the address from the letter to 
an envelope. 

If you need to print envelopes for mass mailings, see Name Lists 
and Merge Printing.  

                                o
               
.pa









     Printing Files



Label:  QuikPrt-1

WS4.0:       ^KDP^R^[  (269)

WS5.x, 6.0:  ^KDP^K  (270)

WS7.0A:       Sub Main
              Key ("^KDP")
              PauseForInput ("{ENTER}", ' Check filename. ')
              Key ("^K")
              End Sub  (271)

WS7.0C:       Sub Main
              WSQuiet (On)
              Key ("^KDP^K")
              WSQuiet (Off)
              End Sub  (272)   

        Function: Saves and prints the onscreen file.   


If you're using WordStar 7.0A, a message will tell you to check 
the filename before printing.  (If you've opened a window while 
editing the file, the wrong filename may be in memory.)  If the 
name is correct, press Return.  If not, type the correct name 
before pressing Return.  The WS7.0C macro omits the filename 
check.  The right name will always be in memory.  




Label:  QuikPrt-2

WS4.0:       ^KS^KPN^R^[  (273)

WS5.x, 6.0:  ^KS^KPP^K  (274)

WS7.0A:       Sub Main
              Key ("^KS^KP")
              PauseForInput ("{ENTER}", ' Check filename. ')
              Key ("^K")
              End Sub  (275)
     
WS7.0C:  Sub Main
         WSQuiet (On)
         Key ("^KS^KP^K")
         WSQuiet (Off)
         End Sub  (276)

        Function:  Same as that of QuikPrt-1 except that the file 
remains open.  

  
WordStar 5.0 users:  If you're working on the file WOMBAT and you 
display the file AARDVARK in a window, AARDVARK replaces WOMBAT 
as the filename in memory.  If you then execute QuikPrt-1 or 
QuikPrt-2, the file AARDVARK will print.  If you have opened any 
windows, save the file with ^KD and print it by using the P 
command at the opening screen.  




Label:  QuikPrt-3

WS7.0:  Sub Main
        Key ("^QR^QL")
        IfException
        Def: Key ("^U")
        End IfException
        Key ("^OP")
        PauseForKey ("")
        Key ("^KDP")
        PauseForInput ("{ENTER}", 'Press Enter to print.')
        Key ("^K")
        End Sub  (277)

        Function:  Spellchecks the document, runs Page Preview, 
then saves and prints the file.


Page Preview is turned on automatically when the spelling check 
is completed.  After viewing the file on the Preview screen, 
press Esc.  A message in the upper part of the screen will tell 
you:  "Press Enter to print."  If you're using WS7.0A, check the 
filename first.  If it's not the right one, enter the correct 
name and press Return.

If you decide you don't want to go ahead with the print job, you 
can terminate the macro when the print screen appears.  Just hold 
down Ctrl and press the Break key.  Then press Esc three times.

See also Spellchecking and Previewing.


                                o
     
     
     







     Reforming Files 



Label:  RfmFile-1 

WS4.0, 5.x, 6.0:  ^QR^QU  (278)

WS7.0:             Sub Main
                   Key ("^QR^QU")
                   End Sub  (279)    

        Function:  Reforms an entire file. 


Used alone, ^QU will reform a file from the cursor down.  
RfmFile-1 realigns a file top to bottom, regardless of the 
position of the cursor when the macro is executed.  The cursor 
comes to rest at the end of the file. 




Label:  RfmFile-2 

WS4.0, 5.x, 6.0:  ^QR^QU^QR  (280)

WS7.0:             Sub Main
                   Key ("^QR^QU^QR")
                   End Sub  (281) 

        Function:  Realigns an entire file and leaves the cursor 
at the top of the file. 




Label:  RfmFile-3 

WS4.0, 5.x, 6.0:  ^K2^QR^QU^Q2^K2^KH  (282)

WS7.0:             Sub Main
                   Key ("^K2^QR^QU^Q2^K2^KH")
                   End Sub  (283)  
     
     
        Function:  Realigns an entire file and returns the cursor 
to the position it occupied when the macro was executed. 


WordStar 4.0 users:  Line spacing will be disturbed if you 
execute any of the RfmFile macros after using ^OS1 and ^OS2 to 
switch between single spacing and double spacing.  (See Line 
Spacing.) 


                                o   
     
.pa









     Reforming Paragraphs 



Label:  Justify-1 

WS4.0:  ^D^K2^QH^M^F^B^Q2^K2^KH^S  (284)  

        Function:  Reforms a paragraph in which text has been 
thrown out of alignment by insertions or deletions. 


Note that the macro is for WordStar 4.0 users.  You won't need it 
if you're using a later WordStar release and have the auto-align 
feature on. 

In working with an unaligned paragraph in a WordStar 4.0 
document, you may find that you can't read all the lines above 
the cursor because some words have run off the right side of the 
screen.  The usual way to realign a paragraph is to press ^B 
after moving the cursor to the top line (or to the first line 
requiring realignment).  But it's faster to use Justify-1.  The 
macro can be executed with the cursor anywhere in a paragraph.  
It reforms the paragraph top to bottom, then returns the cursor 
to the position it occupied when the macro was executed.  




Label:  Justify-2 

WS4.0:  ^QH^M^F^B^F  (285)  

        Function:  Reforms a paragraph but leaves the cursor at 
the beginning of the next paragraph rather than at the previous 
cursor position. 

    


Label:  Justify-3 

WS4.0:  ^QH^M^F^B^QP  (286) 

        Function:  Reforms a paragraph and leaves the cursor at 
the start of the same paragraph. 
     
Justify-3 leaves you in position to begin rereading the 
paragraph, to see if any rewriting is necessary.  If everything 
looks OK, you can press ^B to move the cursor down to the next 
paragraph.


                                o 
     
.pa









     Reopening Files 



Label:  Reopen-1 

WS4.0:        D^R^M^QP  (287) 

WS5.0, 6.0D:  D^M^QP  (288) 

WS5.5, 6.0:   P^LNUL^MP^UD^M^QP  (289)

WS7.0:        Sub Main
              Key ("D{F10}^QP")
              End Sub  (290) 

        Function:  Reopens the last active file and returns the 
cursor to its last position in the file.


Illustration:  You press ^KD to save a 50-paragraph file after 
rewriting a sentence in the 33rd paragraph.  It occurs to you 
that the next sentence also should have been revised.  If you 
execute Reopen-1, the file will pop back onscreen and you'll be 
returned to the last cursor position in paragraph 33. 

Reopen-1 may not work on files of more than about 25 pages 
(double-spaced).  Reason:  The command ^QP is used to find the 
last cursor position after a file is reopened.  If the file runs 
30 or 40 pages, ^QP may die of exhaustion short of its 
destination.  




Label:  Reopen-2 

WS4.0:        D^R^M  (291)  

WS5.5, 6.0:   P^LNUL^MP^UD^M  (292)

        Function:  Reopens the last active file and places the 
cursor at the beginning of the file.
     
     
There is no WordStar 5.0, 6.0D or 7.0 version of the macro.  If you're using one of those releases, just press D and Return.  
(But see the first indented paragraph at the end of this section 
if you're using WS5.0 or 7.0.)  




Label:  Reopen-3 

WS4.0:        D^R^M^QC  (293)  

WS5.0, 6.0D:  D^M^QC  (294) 

WS5.5, 6.0:   P^LNUL^MP^UD^M^QC  (295)

WS7.0:        Sub Main
              Key ("D{F10}^QC")
              End Sub  (296)

        Function:  Reopens the last active file and places the 
cursor at the end of the file.

.lm 6
.rm 60
       
     If you're using WordStar 5.0:  

     Don't try to call a file back onscreen with a Reopen 
     macro after backing up the file with CopFlop-1 or 
     CopFlop-2.  If you do, the wrong file will be reopened.  
     Also:  Don't try to recall a file with a Reopen macro 
     if you opened a window while the file was still 
     onscreen.  The wrong file may be called up.  

     If you're using WordStar 5.5 or 6.0: Don't execute a 
     Reopen macro while printing.  If you do, printing will 
     stop.  Also:  If you use any of the Reopen macros after 
     backing up a file with CopFlop-1, the wrong file will 
     be reopened.  (Neither caveat applies to WS6.0D.)  


                                o   
          
.lm 1
.rm 65
.pa









     Running DOS Programs 



Label:  XTree

WS4.0:        R^H^K^FXTREE^M  (297)

WS5.0, 5.5:   R^H^FXTREE^KK^KH^QHX^KB^KY^A^KFXTREE^M  (298)  

WS5.5C, 6.0:  R$^H^H^FXTREE^KK^KH^QHX^KB^KY^A^KF
              XTREE^M  (299)

WS6.0D:       S^S^G^KFXTREE^M^KQN^[^[  (300)

WS7.0A:       Sub Main
              Key ("S^S^G^KFXTREE{F10}")
              PauseForInput ("{F10}", 'Press F10.')
              Key ("^D^KQ")
              IfException
              Def: Key ("N")
              End IfException
              End Sub  (301)

WS7.0C:       Sub Main
              SetHelpLevel (4) : AutoRestore (On)
              Key ("{ALT+F}RXTREE{F10}")
              End Sub  (302)

        Function:  Calls up a utility program when executed 
either at the opening screen or at the editing screen.  


The file-management program XTREE is used in this section as an 
example.  The call name XTREE (used to open one version of that 
program) appears in each of the macro definitions.  To run a 
different program, substitute the appropriate call name for 
XTREE.  

If you run the macro at the opening screen, you'll be returned to 
that screen after leaving the utility program.  If you have a 
file onscreen, you'll be returned to your place in the file.  If 
you're using WordStar 4.0, 5.x, 6.0 or 7.0C, you can press any 
key to return to WordStar.  If you're using WordStar 7.0A, tap 
F10 when told to press any key to return to WordStar.  (If you
      
forget and press another key, a message at the top of the screen 
will prompt you to press F10.) 
  
WordStar 7.0A users can use another termination key in place of 
F10.  The key must be specified on the PauseForInput line in the 
macro definition.  It must be a key that will not be used while 
you're running the utility.  Otherwise, when you try to return to 
WordStar (which will still be running in the background), the 
macro will misfire because you will have already spent your 
termination key.  If you have to use F10 while running a utility, 
you may be able to use a character such as = or # as a substitute 
for F10.  If your keyboard has F11 and F12 keys, you can use one 
of those as the termination key.  (To make the F11 and F12 keys 
usable, you must go into WSCHANGE.  At the DOS prompt in the 
WordStar directory, type WSCHANGE WS and press Return.  Press E 
and an equal sign.  Type EXTKB and press Return.  Type 01.  Press 
X's to back out of WSCHANGE.)  

Assigning a key to terminate a macro does not mean that you've 
given up the key.  You can still use it to run one of your 
macros.  The termination function is merely a job the key 
performs on the side.  

Do not assign XTree to a function key if you operate WordStar 
7.0A or 7.0C at help level 4.

If you use WordStar 5.x or 6.0, you may need to change the ^QHX 
sequence in your macro definition.  The ^QH is used to search 
backward for the first letter in the call name of the program 
you're running.  So if you were running a utility called SMAKBAK, 
the ^QH would be followed by an S instead of an X.  If you were 
running a utility with the call name SMAKSAK, in which the letter 
S occurs twice, you would enter ^QHS^L.  The ^L would repeat the 
search so that the cursor would move to the second S back.  If a 
utility used the call name SASSBAK, in which there are three S's, 
you'd enter ^QHS^L^L.


                                o  
     
.pa









     Saving and Returning



Label:  QuikSav

WS4.0:  ^KDD^R^M^QP  (303) 

        Function:  Saves and then reopens a file, returning the 
cursor to its last position in the text. 


Note that the macro is for WordStar 4.0 users.  ^KS, the standard 
save-and-resume-editing command, should be used with later 
WordStar releases.  

You can of course use ^KS with WordStar 4.0.  But unless you're 
at or near the end of a file, QuikSav will do the job faster. 

The macro may not work on files of more than about 25 pages.  See 
page 135.  


                                o   
     
.pa









     Scrolling Continuously by Screen



Label:  HiScree

WS4.0, 5.x, 6.0:  ^K1^KH^QQ^R9  (304)

WS7.0:             Sub Main
                   Key ("^K1^KH^QQ^R9")
                   End Sub  (305)

        Function:  Leaves a place mark and moves the cursor up 
continuously, one screen at a time.




Label:  LoScree

WS4.0, 5.x, 6.0:  ^K1^KH^QQ^C9  (306)

WS7.0:             Sub Main
                   Key ("^K1^KH^QQ^C9")
                   End Sub  (307)

        Function:  Leaves a place mark and moves the cursor down 
continuously, one screen at a time.


Example:  HiScree or LoScree can be used when you want to look at 
a section of text within a few pages of the cursor position.  To 
stop scrolling, press the Spacebar.  To return to the position 
occupied by the cursor before scrolling began, press ^Q1 or 
execute YMark (see Marking and Finding a Place).  If you don't 
want to return to the place where you executed the macro, forget 
the place mark.  It's not necessary to remove it. 

Note the 9 in each of the definitions.  You can speed up 
scrolling by using a lower number.  


                                o
         
.pa









     Scrolling by Page



Label:  NxtPage

WS5.x, 6.0:  ^QI+^M  (308)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QI+{F10}")
              WSQuiet (Off)
              End Sub  (309)   

        Function:  Moves the cursor to the top of the next page.




Label:  PvsPage

WS5.x, 6.0:  ^QI-^M  (310)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^QI-{F10}")
              WSQuiet (Off)
              End Sub  (311) 

        Function:  Moves the cursor to the top of the previous 
page.


The macros are short enough to be performed manually, but the 
characters are somewhat difficult to enter from the keyboard, 
especially if you have to execute the commands repeatedly, as 
when scrolling up or down a half dozen pages.

There is no NxtPage or PvsPage macro for WordStar 4.0.  


                                o
     
.pa









     Scrolling by Paragraph 



Label:  NxtGraf 

WS4.0, 5.x, 6.0:        ^B^QG<SP>^F^D^QS^S^F  (312)

WS7.0:                   Sub Main
                         HideDots (On) : WSQuiet On)
                         AutoRestore (On)
                         Key ("^B^QF<SP>{TAB}^Y{F10}^F^D")
                         Key ("^QS^S^F")
                         End Sub  (313)

        Function:  Moves the cursor to the beginning of the next 
paragraph. 




Label:  PvsGraf 

WS4.0, 5.0, 5.5C, 6.0:  ^QS^S^A^QH<SP>^QH^M^F  (314) 

WS5.5:                  ^QS^S^A^QH<SP>^QH^I^F  (315)

WS7.0:                   Sub Main
                         HideDots (On) : WSQuiet (On)
                         AutoRestore (On)
                         Key ("^QS^S^A^QF<SP>{TAB}B{F10}")
                         Key ("^QF^P^M^P^J{TAB}B{F10}^F")
                         End Sub  (316)   

        Function:  Moves the cursor from the start of one 
paragraph to the start of the previous paragraph.


You may find these macros useful alternatives to the scroll-
upscreen (^R) and scroll-downscreen (^C) commands.  NxtGraf and 
PvsGraf normally move the cursor in shorter steps.

The macros for WordStar 4.0, 5.x and 6.0 usually jump the cursor 
over any dot commands encountered between paragraphs.  The 
WordStar 7.0 macros always bypass dot commands.
      
If the cursor is not on the first line of a paragraph when 
PvsGraf is executed, the macro moves the cursor back to the start 
of the paragraph.  Each subsequent execution of the macro moves 
the cursor up a full paragraph.  This means PvsGraf serves two 
purposes:  It can be used when you want to go to the top of a 
paragraph from any point below the first line.  And it can be 
executed repeatedly to move the cursor up the screen a paragraph 
at a time.  

Neither macro can find the start of a paragraph consisting of 
only one word.

WordStar 5.5 users:  The WS5.5 version of PvsGraf works only in 
paragraphs indented with the Tab key, and not in paragraphs that 
are unindented or indented with the Spacebar.  Note that you can 
use the first PvsGraf definition if you have revision C of WS5.5.


                                o  
     
.pa









     Scrolling by Sentence



Label:  NxtSent 

WS4.0, 5.x, 6.0:  ^QG.^F^QG<SP>^F^QH<SP>^L^F^F^S^QH
                  <SP>^F^QG<SP>^A (317)

WS7.0:             Sub Main
                   HideDots (On):  WSQuiet (On)
                   AutoRestore (On)
                   Key ("^QF.{TAB}^Y{F10}")
                   Key ("^F^QF<SP>{TAB}^Y{F10}^A")
                   End Sub  (318)

        Function:  Moves the cursor to the start of the next 
sentence.




Label:  PvsSent 

WS4,0, 5.x, 6.0:  ^A^A^QH<SP>^A^QH.^F^QG<SP>^F^QH
                  <SP>^L^F^F^S^QH<SP>^F^QG<SP>^A  (319)
                                
WS7.0:             Sub Main
                   HideDots (On) : WSQuiet (On)
                   AutoRestore (On)
                   Key ("^QF.{TAB}B{F10}^L")
                   Key ("^F^QF<SP>{TAB}^Y{F10}^A")
                   End Sub  (320)
  
        Function:  Moves the cursor to the start of the previous 
sentence.  
  

The macros for WordStar 4.0, 5.x and 6.0 usually jump the cursor 
over any dot commands encountered between paragraphs.  The 
WordStar 7.0 macros always bypass dot commands.  

The PvsSent macro for WordStar 4.0, 5.x and 6.0 moves the cursor 
from the start of one sentence to the start of the previous 
sentence.  If executed in the middle of a sentence, the macro 
generally moves the cursor to the start of that sentence rather than to the start of the previous sentence.  Each subsequent 
execution will move the cursor back a full sentence.

NxtSent and PvsSent may leave the cursor somewhat out of position 
when moving from one paragraph to another if extra line spaces 
have been left between the paragraphs or if there are blank 
spaces on the line separating the paragraphs. 

The macros look for periods to locate sentence endings.  
Sometimes a period is used in the interior of a sentence (as a 
decimal point, for example, or as part of an ellipsis).  If the 
cursor stops for a mid-sentence period, simply repeat the macro.  

NxtSent and PvsSent jump over sentences that do not end with 
periods.  The macros could be defined so that they would stop 
after terminal marks other than periods, but they would then have 
other limitations.  Since they are used only for scrolling--not 
for blocking or erasing--precise movement is not critical.


                                o 
     
.pa









     Searching



Label:  Quest

WS5.x, 6.0:  ^K1^KH^QF<SP>^XU^E^G  (321)

WS7.0:        Sub Main
              Key ("^K1^KH^QF<SP>^XU^E^G")
              End Sub  (322) 

        Function:  Leaves a place mark and displays a search 
screen.


The macro won't work with WordStar 4.0.

Using Quest, you can search forward for a proper name without 
having to capitalize the first letter, and without having to 
pause to select any search options.  The macro also makes it easy 
to find your previous place after conducting a search.

Assume that you start a search manually by pressing ^QF.  You 
type "corporation" on the top line of the search screen.  If you 
want WordStar to find the word regardless of whether the first 
letter is capitalized, you must enter a U on the second prompt 
line.  When Quest displays the search screen, it goes to the 
second line and enters the U for you, then moves the cursor back 
to the top line.  So you can just type whatever you're looking 
for and start the search by tapping Return once (if you're using 
WordStar 7.0) or twice (if you're using an earlier release).
  
If you're searching for something above the cursor, of course, 
you'll need to enter a B on the second prompt line to tell 
WordStar to search backward.  You can modify the Quest definition 
so that the macro will search backward and forward, finding a 
string of characters either above or below your position in the 
text.  Just insert the letter G after U in the definition.  
Drawback:  If you're near the end of a long file and want to find 
a phrase below your cursor position, Quest will go to the top of 
the file before it starts searching.  Result:  The macro will 
take longer to run.  And if the phrase you're looking for has 
been used above your cursor position as well as below it, the 
macro will locate the earlier occurrence.  You'll have to press 
^L to find the next occurrence.  
     
Tip:  If you press ^R when Quest displays the search screen, the 
string of characters you last searched for will appear on the top 
line of the screen.
     
Before Quest displays the search screen, it leaves a place mark 
at your cursor position.  If a search takes you some distance 
from that position, you can return to your place after the search 
by pressing ^Q1.  If you've set up the macros Mark and YMark, 
getting back to the previous cursor position is even easier.  
Just execute YMark.  (See Marking and Finding a Place.)
  
You could conduct the same search manually and use ^QP to return 
to your place--but not under all conditions.  Example:  You're on 
line 5 of page 1.  You need to check something farther down in 
the file.  A search takes you to the bottom of the page.  If you 
make any changes in the text there, ^QP won't get you back to 
line 5.  But if you've used Quest to initiate the search, YMark 
will know the way back.  (If you're using WordStar 6.0D or 7.0, 
you have an option:  ^QV will return the cursor to the position 
at which the last find command was issued.)

If you don't want to return to the previous cursor position after 
a search, forget the place mark.  It won't hurt anything.  

See also Searching Plus                         


                                o 
          
.pa









     Searching and Replacing



Label:  FindRep

WS5.x, 6.0:  ^K1^KH^QA<SP>^X^Y^XANR^E^E^Y  (323)

WS7.0:        Sub Main
              Key ("^K1^KH^QA<SP>^X^Y^XANR^E^E^Y")
              End Sub  (324)   

        Function: Leaves a place mark and displays a modified 
find-and-replace screen.


Using FindRep, you can find and replace character strings faster 
than you could by performing a find-and-replace routine manually.  
And, after running FindRep, you can quickly return the cursor to 
the position it occupied when the macro was executed.  

Procedure:  Execute FindRep.  On the top line of the find-and-
replace screen, type the words or characters you want to replace.  
On the second line, type the words or characters you want to 
replace them with.  You don't have to select any options on the 
third prompt line.  The macro has already selected them, telling 
WordStar that you want to align text after replacing words or 
characters (option A), that you don't want to be asked before the 
changes are made (option N) and that you want the find-and-
replace procedure performed from the cursor position down (option 
R).  If you want to be able to make replacements throughout the 
file--even though the cursor may be near the end of the 
file--change the ANR in the FindRep sequence to AGN.  You can 
make other changes, selecting whichever third-line options you 
use most often.  Just enter those options in place of ANR in the 
macro definition. 
  
If you perform a find-and-replace routine manually, the 
characters you type on the first two prompt lines are redisplayed 
the next time you call up the find-and-replace screen.  But when 
FindRep displays that screen, the first two lines are always 
blank.  The macro clears anything left on those lines the last 
time around.  That means you can use FindRep as a find-and-delete 
command by typing something on the first line and nothing on the 
second.  Illustration:  
     
In a long report, you've repeatedly identified a company as 
"Jarndyce & Waite Inc."  But it turns out the company name has 
been changed.  It's now just "Jarndyce Inc."  You can fix the 
name without even going to the second line on the find-and-
replace screen.  Procedure:  Execute FindRep.  Type & Waite on 
the first prompt line.  Leave the second line blank.  Press ^K.  
You have told the macro to replace something with nothing.  (The 
something is the & Waite you typed on the first line.  The 
nothing is what you entered on the second line.)  Result:  Every 
"& Waite" in the file will be removed, so that each occurrence of 
"Jarndyce & Waite Inc." will be changed to "Jarndyce Inc."  
(Note:  To retain proper spacing, you would need to enter a blank 
space before typing & Waite on the first line.  Otherwise, you 
would wind up with an extra space in the text.  Reason:  The 
space before "& Waite" would not be erased, and neither would the 
space after "& Waite."  So the shortened name would come out 
Jarndyce  Inc. (with two spaces between the words instead of 
one).  

FindRep leaves a place mark at the point of execution so that you 
can return to that place after using the macro.  Just press ^Q1 
or execute YMark (see Marking and Finding a Place).  If you don't 
want to return to your place, forget the place mark.  

See also Searching Plus.

                                
                                o
     
.pa









     Searching Plus



Label:  DblFind

WS7.0:  Sub Main
        Key ("^K1^KH^QF<SP>^XU^E^G")
        PauseForInput ("{ENTER}")
        IfException
        NCM: Key ("^U^QA<SP>^X^Y^XANR^E^E^Y")
        Stop
        End IfException
        Key ("{ENTER}")
        End Sub  (325)

        Function:  Leaves a place mark and gives the user the 
option of conducting either a search or a search-and-replace 
operation.  


DblFind is a double-purpose macro.  It lets you load two types of 
search commands into a single macro key and then choose which of 
the two to run.

When executed, DblFind displays a search screen.  You can enter a 
string of characters and press Return to find the string, just as 
you would if you were using Quest (see page 146).

If you execute DblFind and press Return without entering anything 
on the search screen, that screen will be replaced by a 
search-and-replace screen.  You can then type a string of 
characters and have those characters replaced with a different 
string, just as you could if you were using FindRep (see page 
148).  

DblFind leaves a place mark at the point of execution, so you can 
return to your place after running the macro.  Just press ^Q1 or 
execute YMark (see Marking and Finding a Place).  
     

                                o
     
.pa

          

     
     
     
     


     Spellchecking Files 



Label:  SplFile 

WS4.0, 5.x, 6.0:  ^K1^KH^QR^QL  (326)

WS7.0:             Sub Main
                   Key ("^K1^KH^QR^QL")
                   End Sub  (327)

        Function:  Checks the spelling of an entire file. 


If you press ^QL, WordStar checks the spelling from the cursor to 
the end of the file.  SplFile starts checking at the top of the 
file, no matter where the cursor is when the macro is executed.

Before starting the spelling check, SplFile leaves a hidden place 
mark.  To return to that mark after running the macro, press ^Q1 
or execute YMark (see Marking and Finding a Place).  If you don't 
want to return to your place, forget the place mark.  It won't 
hurt to leave it.

WordStar 7.0 users will find an alternative macro in the next 
section.
        

                                o   
     
.pa









     Spellchecking and Previewing



Label:  SplPrev

WS7.0:  Sub Main
        Key ("^K1^KH^QR^QL")
        IfException
        Def: Key ("^U")
        End IfException
        Key ("^KS^QR^OP")
        End Sub  (328)  

        Function:  Spellchecks and saves a file, then runs Page 
Preview.


Execute SplPrev with the cursor anywhere in a file.  The macro 
starts checking spelling at the top of the file.  When the 
spelling check is finished, the macro executes a save, moves the 
cursor to the top of the file and switches on Page Preview.  If 
you don't want to use Preview, press Esc. 

Before starting the spelling check, SplPrev leaves a hidden place 
mark.  To return to that mark after running the macro, press ^Q1 
or execute YMark (see Marking and Finding a Place).  If you don't 
want to return to your place, there's no need to erase the place 
mark.  

You can modify the macro so that Preview will start with a 
multiple-page display.  Just change the next-to-last line in the 
SplPrev definition.  The replacement line should look like this:


     Key ("^KS^QR^OPVM")  
     
     
     
To have Preview display pages in double magnification, use this 
line instead:


     Key ("^KS^QR^OPV2")
     
     
Note:  When you use Preview, WordStar creates files with CRT 
extensions.  If not erased, they'll accumulate.  See chapter 6.

See also QuikPrt-3 in Printing Files. 


                                o
     
.pa





  



     Spellchecking a Word



Label:  SplWord

WS4.0, 5.x, 6.0:  ^QN  (329)

WS7.0:             Sub Main
                   Key ("QN")
                   End Sub  (330)

        Function: Checks the spelling of a word.

        
If you use the default WordStar function-key settings, you can 
check the spelling of a word by pressing Shift+F4.  If you're a 
habitual user of the spelling checker, you may prefer to do the 
job with a first-level function-key macro--a macro you can run by 
striking an F key without holding down any other key.  
      
To set up the macro, you'll need to program one of the F keys.  
Pick a key that runs a macro you don't need.  For illustration 
only, we'll assume you've chosen the F3 key.  If you're using 
WordStar 7.0, follow these steps:  
       
Press MD at the opening screen.  Type SplWord.  Press Tab.  Type 
F3.  You'll be told that the key is already in use.  Disregard 
the message and press Return.  Delete the description (if any) on 
the next line.  Press Return.  Enter the WS7.0 SplWord 
definition.  
     
If your keyboard has F11 and F12 keys, you can assign SplWord to 
one of those keys.  (See the first full paragraph on page 138.)  

If you're using WordStar 4.0, 5.x or 6.0 and you're not sure how 
to program function keys, see chapter 2.
     
WordStar 7.0 users will find an alternative macro (SplSyn) in the 
next section. 
          
     
                                o
     
.pa
           
     
     
     





     Speller/Thesaurus


     
Label:  SplSyn

WS7.0:  Sub Main
        Key ("^QN")
        Key ("^QJ")
        End Sub (331)

        Function: Spellchecks a word and/or finds synonyms for 
the word at the user's option.

  
When you execute SplSyn, it checks the spelling of the word at 
the cursor.  If you want to find synonyms for the word instead of 
checking the spelling, press the Esc key.  That will switch off 
the spellchecker and display the thesaurus screen.  If you don't 
want to look for synonyms, tap the Esc key twice after checking 
the spelling. 
  
See also Spellchecking a Word and Synonyms. 


                                o
                
.pa



 





     Swapping Shorthand Files



Label:  Short-1

WS4.0:  O\WS4\SET1^M\WS4\WSSHORT.OVR^MYX  (332)

WS5.x:  O\WS5\SET1^M\WS5\WSSHORT.OVR^MYX  (333)

WS6.0:  O\WS\SET1^M\WS\WSSHORT.OVR^MYX  (334)

        Function:  Loads a set of Shorthand macros.




Label:  Short-2

WS4.0:  O\WS4\SET2^M\WS4\WSSHORT.OVR^MYX  (335)

WS5.x:  O\WS5\SET2^M\WS5\WSSHORT.OVR^MYX  (336)

WS6.0:  O\WS\SET2^M\WS\WSSHORT.OVR^MYX  (337)

        Function:  Loads an alternate set of Shorthand macros. 

  
Short-1 and Short-2 let you switch between two sets of Shorthand 
macros.  You may find this flexibility useful if you share your 
machine with another user.  Or you may find it handy to have one 
set of macros to use with conventional documents and a second set 
to use with specialized documents.  The two sets need not be 
entirely different.  Some or even most macros may be common to 
both sets.  

Procedure:  
          
1. After creating one set of Shorthand macros, press the letter O 
at the opening menu in the main WordStar directory.  The file-
copy screen will be displayed.  Type the filename WSSHORT.OVR and 
press Return.  Type the filename SET1 and press Return again.

2. Go to the Shorthand screen and create a second set of macros, 
overwriting the definitions you entered while defining the first 
set.  
             
3. Answer Y when asked if you want to store your macros on disk.  
  
4. At the opening menu in the main WordStar directory, make a 
copy of the second macro set.  The procedure is the same as in 
step 1, above, except that the second macro set is copied to a 
file called SET2 instead of SET1.  

5. Set up two function-key macros.  You'll use the macros to 
switch from one Shorthand set to the other.  Procedure:  Type 
WSCHANGE WS and press Return at the DOS prompt in the WordStar 
directory.  Press AB to display the function-key definition 
screen.  Select the keys you'll use to execute the macros.  
Example:  You've selected the Shift+F1 and Shift+F2 combinations.  
Move the cursor to Shift+F1 and press Return.  When prompted to 
enter WordStar keystrokes, type the appropriate Short-1 
definition.  Store the macro by pressing the End key.  Move the 
cursor to Shift+F2.  When asked for WordStar keystrokes, type the 
Short-2 definition.  Store the macro.  (Note:  The Shift+F1 and 
Shift+F2 combinations are used as examples because it takes two 
keystrokes to execute a Shift+ macro.  Using such combinations 
makes it impossible to switch macro sets inadvertently by hitting 
just one wrong key.)  
  
When you return to the opening menu from WSCHANGE, your second 
Shorthand macro set will be loaded.  To switch to your first 
macro set, hold down the Shift key and press F1.  After the macro 
has run, you'll see a DOS prompt.  Type WS and press Return to 
get back to the opening menu in WordStar.  The first macro set 
will be ready to use.   (Note:  If you've started WordStar from 
the shell that comes with DOS 4.0 or DOS 5.0, the macro-swapping 
macro will land you in the shell.  Restart WordStar.)

To switch back to the second macro set, hold down Shift and press 
F2.  When you reopen WordStar, the second set will be loaded. 
  
You can execute Short-1 and Short-2 at the opening menu in the 
main WordStar directory or at the opening menu in a WordStar 
subdirectory.

The macros land you in DOS each time you swap macro sets because 
it's necessary to exit WordStar at least momentarily to remove 
the old set and get the new one loaded.  

.lm 6
.rm 60

     The directory designations in some macro sequences           
     include numbers.  See the second full paragraph on page           
     20.  


                                o
          
.lm 1
.rm 65
.pa









     Synonyms



Label:  Synonym

WS4.0, 5.x, 6.0:  ^QJ  (338)

WS7.0:             Sub Main
                   Key ("^QJ")
                   End Sub  (339)

        Function: Displays the thesaurus screen.


WordStar comes from the factory with many predefined function-key 
macros.  But ^QJ is not one of them.  If you're a constant 
thesaurus user, you may want to define ^QJ as a first-level 
function-key macro--a macro you can execute simply by pressing 
one of the F keys.  (See Spellchecking a Word.)  

WordStar 7.0 users:  See also Speller/Thesaurus. 


                                o
     
.pa









     Telephone Numbers



Label: FoneNbr

WS4.0:  ^QS^KB^K3^N^N^X^X^K4^KK^E^KR\WS4\FONENBR^M
        ^KH^QF  (340)

WS5.x:  ^OK\WS5\FONENBR^M^OD^QF<SP>^XU^E^G  (341)

WS6.0:  ^OK\WS\FONENBR^M^OD^QF<SP>^XU^E^G  (342)

WS7.0:   Sub Main
         Key ("^OK\WS\FONENBR{F10}^OD^QF<SP>")
         Key ("^XU^E^G")
         End Sub  (343) 

         Function:  Displays a list of phone numbers.  (Shorthand 
definition required for WordStar 4.0 macro.) 


FoneNbr lets you look up a telephone number without having to 
close the file you have onscreen.  It's an alternative to the 
Go2Name macro described in Name-and-Address Lists.  If you just 
need a list of telephone numbers, and don't need a list of 
addresses, FoneNbr will fill the bill.

Before using the macro, you'll create a document file called 
FONENBR in the main WordStar directory.  Type the dot command 
.LS1 on the top line of the file.  Then begin entering listings.  
The file might start off something like this:  


.LS1


Adams, James                  212 111-1111
Adamson, Betty                212 222-2222
Amberson, Janet               212 333-3333
Anderson, John                212 444-4444
Apperson, Philip              212 555-5555
Atterton, Andrea              212 666-6666


To look up a number, execute FoneNbr.  A search screen will appear.  Type the last name of the person whose number you need.  
Then press Return once (if you're using WordStar 7.0) or twice 
(if you're using an earlier release).  If you use WordStar 5.x, 
6.0 or 7.0, you don't have to capitalize any letters.  
     
Tip:  You may be able to save keystrokes by typing only the first 
four or five letters of a name.  If that sequence of letters 
occurs in two names in the telephone list, the search command 
will find the first of the two.  If it's the wrong name, press 
^L.  The cursor will move to the second occurrence of the 
sequence.      

If you're using WordStar 4.0, the phone list will be inserted in 
the document you're working on.  After looking up a number, press 
^KY.   That will delete the phone list and leave your working 
file as it was before you executed FoneNbr.  

If you're using WordStar 5.x, 6.0 or 7.0, the phone list will 
appear in a window.  After looking up a number, press ^KQ to 
close the window.

.lm 6
.rm 60

     Note that the directory designations in the first two      
     macro definitions include numbers.  See the second      
     full paragraph on page 20.  


                                o
          
.lm 1
.rm 65
.pa









     Time and Date



Label:  Tm&Date

WS4.0:          R^H^K^FTIMEDATE^M  (344)

WS5.0, WS5.5:   R^H^FTIMEDATE^KK^KH^QHT^L^KB^KY^A^KF
                TIMEDATE^M  (345)

WS5.5C, WS6.0:  R$^H^H^FTIMEDATE^KK^KH^QHT^L^KB^KY^A^KF
                TIMEDATE^M  (346)

WS6.0D:         S^S^G^KFTIMEDATE^M^KQN^[^[  (347)

WS7.0A:         Sub Main
                Key ("S^S^G^KFTIMEDATE{F10}")
                PauseForInput ("{F10}", 'Press F10.')
                Key ("^D^KQ")
                IfException
                Def: Key ("N")
                End IfException
                End Sub  (348)

WS7.0C:         Sub Main
                SetHelpLevel (4) : AutoRestore (On)
                Key ("{ALT+F}RTIMEDATE{F10}")
                End Sub  (349)

        Function: Displays the time of day and the date.


Execute the macro at the opening screen or with a file onscreen.  
If you're using WordStar 4.0, 5.x, 6.0 or 7.0C, press any key to 
return to the opening screen or to your file after checking the 
time and date.  If you're using WordStar 7.0A, tap F10 when told 
to press any key to return to WordStar.  (If you forget and press 
another key, a message at the top of the screen will prompt you 
to press F10.)  

Do not assign Tm&Date to a function key if you operate WordStar 
7.0A or 7.0C at help level 4.

You can of course get the time or date by typing TIME or DATE at      
        
a DOS prompt and pressing Return.  The advantage of the Tm&Date 
macro is that it gives you both at once.  And you don't have to 
press Return to get past the "Enter new time" and "Enter new 
date" lines.  Those lines are not displayed.

Note:  Though Tm&Date is designed to run as a macro, you don't 
have to be in WordStar to use it.  You can run it from a DOS 
prompt in any directory.  On a DOS command line, however, it 
won't work like a macro.  You have to type TIMEDATE and press 
Return.
      
Before using the macro, you'll create a simple batch file that 
will reside in the root directory.  At the opening screen in any 
WordStar directory, press N, type the filename \TIMEDATE.BAT and 
press Return.  In the body of the file, type these lines: 
     
     
     
@ECHO OFF
CLS
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
TIME < \CARRIAGE.RTN | FIND "is"
ECHO/
DATE < \CARRIAGE.RTN | FIND "is"
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/
ECHO/

    

If you'd rather skip the typing, copy the TIMEDATE.BAT file from 
the Holy Macro! package, putting it in your root directory.

If you're using a version of DOS earlier than 3.3, omit the @ 
symbol before ECHO OFF at the start of the file.  If you're using 
a version earlier than 3.0, omit all the ECHO/ lines.  (There are 
10 of them above the TIME line and 10 more below the DATE line.)  
Note that the word "is" on the TIME and DATE lines is lowercased.  
        
You'll need to create a one-character auxiliary file to help run 
the macro.  At any WordStar opening screen, press N, type 
\CARRIAGE.RTN and press Return.  When the file opens, enter one 
carriage return.  That's it.  Save the file.  (When you run the 
macro, the two < \CARRIAGE.RTN commands in the batch file tell 
DOS to latch on to the CARRIAGE.RTN file and have it execute two 
Returns needed to display the time and date.  The FIND "is" 
command filters out the "Enter new time" and "Enter new date" 
lines normally displayed when you ask DOS for the time and date.  
See chapter 18 of "Peter Norton's DOS Guide" [Brady, 1989].)  
     
If you've created a C:\BATCH directory for batch files, you can 
put TIMEDATE.BAT in that directory.  Just use the name 
\BATCH\TIMEDATE.BAT when you set up the file.


                                o
     
.pa









     Transposing Paragraphs



Label:  PFlop

WS4.0, 5.0, 5.5C, 6.0:  ^QH^M^KB^KH^F^B^S^S^QD^D^KK^KY^F^F^B
                        ^S^S^QD^D^U  (350)

WS5.5:                  ^OJ^QH^M^Y^S^KB^KH^F^B^S^S^QD^D^KK
                        ^KY^F^F^B^S^S^QD^D^U  (351)

WS7.0:                   Sub Main
                         WSQuiet (On)
                         Key ("^QF^P^M^P^J{TAB}B{F10}")
                         Key ("^KB^KH^F^B^S^S^QD^D^KK^KY")
                         Key ("^F^F^B^S^S^QD^D^U")
                         WSQuiet (Off)
                         End Sub   (352)

        Function:  Transposes two paragraphs.  


Execute the macro with the cursor anywhere in the first of the 
two paragraphs to be transposed.

PFlop deletes the first paragraph and restores it at its new 
location.  Make sure you have enough space in your unerase buffer 
to store the deleted text.  See the third paragraph on page 16.

WordStar 4.0 users:  If you want to transpose the last two 
paragraphs of a file and the final paragraph is not followed by a 
Return, you'll need to fix the line spacing between the two 
paragraphs after executing the macro. 
                                

                                o
     
.pa









     Transposing Words



Label:  FlopWds

WS4.0:       ^D^A^T^D^D^A^D^F^U^K2^QH^M^D^B^Q2^K2^D^F  (353)

WS5.0:       ^OA^D^A^T^D^D^A^D^F^OA^U^D^F  (354)

WS5.5, 6.0:  ^D^A^T^D^D^A^D^F^U^D^F  (355)

WS7.0:        Sub Main
              Key ("^D^A^T^D^D^A^D^F^U^D^F")
              End Sub  (356) 

        Function:  Reverses the order of two words.

  
A shorter macro, ^T^F^U, will also transpose two words, but the 
words must be on the same line and the macro must be executed 
with the cursor on the first character of the first word.  
FlopWds transposes two words whether both are on the same line or 
one is at the end of a line and the other at the start of the 
next line.  The macro can be executed with the cursor on any 
character in the first word, or in the blank space immediately 
after that word.    

WordStar 4.0 users:  The WS4.0 macro automatically realigns a 
paragraph that is thrown out of alignment by a transposition.  


                                o    
      
.pa









     Viewing Shorthand Definitions



Label:  ViewMac

WS4.0, 5.x, 6.0:  ^[?  (357)

        Function:  Displays the Shorthand definition screen.


The macro sequence is brief but somewhat awkward to enter from 
the keyboard.  After executing ViewMac, you can scroll down the 
list of Shorthand definitions by pressing ^Z.  You can scroll 
back up by pressing ^W. 


                                o   
     
.pa









     Window Sizing



Label:  FullWin

WS5.x, 6.0:  ^OM24^M  (358)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^OMF{F10}")
              WSQuiet (Off)
              End Sub  (359)

        Function:  Enlarges the active window to full-screen 
size.




Label:  PartWin

WS5.x, 6.0:  ^OM12^M  (360)

WS7.0:        Sub Main
              WSQuiet (On)
              Key ("^OMH{F10}")
              WSQuiet (Off)
              End Sub  (361) 

        Function:  Divides the screen between two windows.


When you execute FullWin, the window in which the cursor is 
positioned takes over the entire screen.  The cursor remains in 
that window.  If you press ^OK, the other window occupies the 
entire screen.

PartWin restores the default allocation of screen space, so that 
each window occupies half the screen. 


                                o
     
.pa









     Word Counts



Label:  Wordage

WS4.0:       ^KFWC<SP>  (362)

WS5.x, 6.0:  ^K1^KH^K?  (363)

WS7.0:        Sub Main
              Key ("^K?")
              Key ("^QP")
              End Sub  (364)  

        Function:  Counts the words in a file. 


If you're using WordStar 4.0:

The Wordage macro displays a DOS prompt.  The letters WC and a 
blank space appear on the prompt line.  Type the name of any file 
and press Return.  WordStar will display a word count for that 
file.  Press any key to switch off the display.  You'll be 
returned to your position in the file you were working on.

If you're using WordStar 5.x or 6.0:

The macro counts the words in the onscreen file and drops you off 
at the bottom of the file.  You can return to your place in the 
file by pressing ^QP or by executing YMark (see Marking and 
Finding a Place).  

If you're using WordStar 7.0:

The macro pauses after displaying a word count.  Press Esc to 
switch off the word-count box and return to your place in the 
file.
.pa
.mt5
.mb6
.cw12

.heHOLY MACRO!                                                #
.hm2
.fm2
.lm1
.rm65
.ls1
.po 1i
.lh8
.pl66
.op
.fo                                #  
.pn169                                   
     
..         This file will be difficult to read onscreen unless
..      the print-control characters are hidden.  To hide those
..      characters, hold down Ctrl and press the letters O and D.












    5 / T e s t i n g ,   T e s t i n g 









This chapter is for users of WordStar 4.0, 5.x and 6.0.  


     1. Shorthand Test

Among the Holy Macro! files you'll find a sample Shorthand macro 
set that can be used with your WordStar release.  To test the 
macros, follow these steps:

.lm 6
.rm 60

     Make a copy of the Shorthand macro set you're using 
     now.  That set is in a file called WSSHORT.OVR.  At the      
     opening menu, press the letter O.  Type WSSHORT.OVR and      
     press Return.  Type WSSHORT.OLD and press Return.  If      
     you later want to restore your original macro set,      
     change its name from WSSHORT.OLD to WSSHORT.OVR.
       
     Check three settings in WSCHANGE (unless you did so      
     after reading the opening section of chapter 3).  At 
     the DOS prompt in the main WordStar directory, type 
     WSCHANGE WS and press Return.  The WSCHANGE main menu      
     will appear.  

.lm 9
        1. Press DCDB.  The Shorthand buffer size should         
        be 12 or greater.
          
        2. Return to the WSCHANGE main menu by pressing                 
        X's.  At that menu, press DBFL if you're using         
        WordStar 4.0.  Press DBFB if you're using a later 
        release.  You'll see an eight-column display.  With         
        one exception, each entry from 21 (in column 3)         
.he HOLY MACRO!                                               #
.fo
        through 7E (in column 8) should be preceded by an                 
        asterisk.  5C should not be preceded by an 
        asterisk.  

        3. Again at the WSCHANGE main menu, press DBEA.          
        The number of characters that can be unerased should         
        be 2,500 or higher. 

.lm 6

     In the Holy Macro! package you'll find a Shorthand 
     macro set that matches your WordStar release.  The file 
     WSSHORT.40 is for WordStar 4.0, the file WSSHORT.50 for 
     WordStar 5.0, and so on.  Note that there are two files 
     for WordStar 5.5 (including one for Revision C) and two 
     for WordStar 6.0 (including one for Revision D).  
           
     Load the macro set that goes with your WordStar 
     release.  Procedure:  At the opening menu, press the 
     letter O.  Then, depending on which WordStar release 
     you're using, type WSSHORT.40, WSSHORT.50, WSSHORT.55, 
     WSSHORT.55C, WSSHORT.60 or WSSHORT.60D.  Press Return.  
     Type WSSHORT.OVR.  Press Return again.  Answer Y when 
     asked whether to overwrite.        

     At the opening menu, press X to display a DOS prompt.  
     Type WS and press Return to redisplay the WordStar 
     menu.  Purpose:  After switching Shorthand sets, you 
     must leave WordStar at least momentarily to get the      
     new set loaded.  (Keep this in mind if you want to      
     restore your original macro set.)
       
     Create a WordStar subdirectory called BIZ.  The 
     subdirectory is needed to test some macros.  If you'd 
     rather test these macros using one of your own 
     subdirectories, you'll need to modify the macro 
     definitions so that they incorporate whatever 
     subdirectory name you want to use.  
       
     Find the files NAME&AD and WOMBAT in the Holy           
     Macro! package.  Put the NAME&AD file in the main      
     WordStar directory.  Put WOMBAT in the BIZ 
     subdirectory.  

.lm 1
.rm 65

You're ready to start testing macros.  The macro set you have 
loaded is not a recommended set.  It's merely a sampling of the 
macros described in chapter 4.  Many other macros will be found 
there.

Thirty-six macros have been loaded into your Shorthand file.  
Each of the 26 macros assigned to letter keys has a label whose 
first letter matches the letter on the key used to execute the 
macro.  Examples:  Esc D executes a macro called DownZap.  Esc G 
executes a macro called GrafBlk.  Esc K executes a macro called 
KillBak.
                                      
A macro loaded into a key for users of one WordStar release may 
be different from a macro assigned to the same key for users of 
another release.  Where necessary, parenthetical notes indicate 
which macros are for which releases. 
     
Brief descriptions of the macros follow.  The number or letter on 
the key to which a macro is assigned is listed first.  A label 
comes next.  Example:  The first macro is assigned to the numeric 
key 1.  The label is LogMain.  

.pm 1
.lm 4

1--LogMain:  Logs on to the main WordStar directory from any       
   WordStar subdirectory.  The macro can be executed at the       
   opening menu or with a file onscreen.  If a file is onscreen,       
   it will be saved before the macro swaps directories.  To run    
   the macro, press Esc and the number 1.

2--LogBiz:  Logs on to the BIZ subdirectory from another    
   subdirectory or from the main directory.  Execute LogBiz by    
   pressing Esc 2.  The macro can be executed at the opening menu    
   or with a file onscreen.  If a file is onscreen, it will be    
   saved before the directory change.  
 
3--Mv2Main:  Moves a file from a subdirectory to the main          
   WordStar directory.  To test the macro, open the file WOMBAT       
   in the BIZ subdirectory.  Then press Esc 3.  The file will       
   be moved to the main directory.

4--Mv2Biz:  Moves a file to the BIZ subdirectory from another       
   subdirectory or from the main directory.  Open the file WOMBAT    
   in the main directory.  Press Esc 4.  The file will be moved    
   back to the BIZ subdirectory.  

5--WordBlk:  Blocks a word.  Press Esc 5 with the cursor on any 
   character in the word.

6--AddWord:  Extends a block.  With the cursor on any character 
   in the first word of a paragraph, execute WordBlk (above) by 
   pressing Esc 5.  Then execute AddWord by pressing Esc 6 with 
   the cursor on any character in the 10th word of the paragraph.  
   The first 10 words will be blocked.

7--SentBlk-2:  Blocks a sentence.  Press Esc 7 with the cursor 
   anywhere in the sentence.  

8--AddSent:  Adds a sentence to a block.  The macro may be used          
   to add any number of sentences to a block, one at a time.     
   With the cursor anywhere in the first sentence of a paragraph,    
   execute SentBlk-2 (above) by pressing Esc 7.  Then press Esc 8    
   to execute AddSent.  The next sentence will be added to the    
   block.  

9--Go2Name:  Displays a list of names and addresses stored in the       
   file NAME&AD.  Press Esc 9 with any file onscreen in any    directory.  A search prompt will appear.  Assume you're 
   looking for an address listing for Horatio D. Blunt.  Type the 
   name Blunt and press Return twice.  The cursor will land on a 
   listing showing Horatio Blunt's name, address and telephone 
   number.  If you're using WordStar 4.0, press ^KY to clear the 
   address file from the screen after checking the listing.  If 
   you're using WordStar 5.x or 6.0, press ^KQ to close the    
   window in which the list is displayed.       
          
0--CopName-2:  Copies a name and address to a file in which a          
   letter is being drafted.  The macro is used in combination       
   with Go2Name (above).  Open the file WOMBAT in the BIZ 
   subdirectory.  (You can get there by pressing Esc 2.)  Assume 
   that WOMBAT is a letter file.  Position the cursor near the 
   top of the file.  After running Go2Name and landing the cursor 
   on the name of Horatio D. Blunt, execute CopName-2 by pressing 
   Esc 0.  Horatio Blunt's name and address will be copied to the 
   WOMBAT file.  A salutation will be printed below the address.

A--A:Dir:  Displays a list of the files on a floppy disk in Drive    
   A.  Press Esc A to execute the macro, either at the opening    
   menu or with a file onscreen.  After viewing the file list,    
   press any key to return to the opening menu or to your place    
   in the file you were editing.  

B--Bold:  Boldfaces a word.  Press Esc B with the cursor on any 
   character in the word.  (See X-Bold, below.)  
    
C--CopFlop-1 (WordStar 4.0 and 6.0D):  Backs up a file.  Press 
   Esc C with a file onscreen and a floppy in Drive A.  The file 
   will be saved on Drive C and backed up on Drive A.  
  
C--CopFlop-1 (WordStar 5.0, 5.5, 5.5C and 6.0):  Backs up a file.  
   Press Esc C with a file onscreen and a floppy in Drive A.  The 
   document will be saved on Drive C and you'll be dropped off in 
   a file list.  Move the cursor to the name of the onscreen file 
   and press Return to send a copy of the file to Drive A.  If 
   there's a previous copy on Drive A, WordStar will ask whether 
   to overwrite.  
    
D--DownZap-2:  Deletes from the cursor word to the end of the       
   paragraph.  Press Esc D with the cursor on any character in    
   the first word you want erased.
          
E--EndBlk:  Adds one or more paragraphs to a block.  Use GrafBlk 
   (below) to block a paragraph.  Then execute EndBlk by pressing 
   Esc E.  The next paragraph will be added to the block.  

F--FlopWds (WordStar 4.0):  Transposes two words.  Press Esc F    
   with the cursor on any character in the first of the two words    
   to be transposed. 
  
F--FullWin (WordStar 5.x, 6.0):  Allocates all 24 lines of screen    
   space to a file displayed in a window.  Press Esc F.  (See 
   PartWin, below.)
     
G--GrafBlk:  Blocks a paragraph.  Press Esc G with the cursor 
   anywhere in the paragraph.  To add a paragraph to the block, 
   execute EndBlk (above).
     
H--HoldBlk:  Sends a copy of a marked block of text to a holding       
   file called HOLD.  The file is used as a storage closet.  With 
   the cursor anywhere in paragraph 1 of a file, execute GrafBlk 
   (above) by pressing Esc G.  Place the cursor anywhere in 
   paragraph 3 and execute HoldBlk by pressing Esc H.  The first 
   three paragraphs of the file will sent to HOLD.  If you want 
   to delete the marked block from the working file, press ^KY.  
   Blocks sent to the HOLD file are separated by arrows, so you 
   can tell where one block ends and the next begins.  

I--Import (WordStar 4.0):  Triggers a macro used as a substitute 
   for the windows feature found in later WordStar releases.  
   With the cursor anywhere in a file, press Esc I.  A screen 
   used to import files will appear.  Type the name of a file and 
   press Return.  The file will be inserted as a highlighted 
   block in the document being edited.  After looking over the 
   imported file, press ^KY to clear it from the screen.     

I--Ital (WordStar 5.x, 6.0):  Italicizes a word.  Press Esc I 
   with the cursor on any character in the word.

J--Justify (WordStar 4.0):  Reforms a paragraph that has been 
   thrown out of alignment by insertions or deletions.  With the    
   cursor anywhere in an unaligned paragraph, press Esc J.  The 
   cursor returns to the point of execution after the paragraph 
   is reformed. 

J--JunkBtm-2 (WordStar 5.x, 6.0):  Deletes to the end of the    
   file.  Press Esc J with the cursor on any character in the    
   first word you want erased.  The macro performs a save before 
   the deletion.  If you accidentally overdelete, abandon the 
   file immediately with ^KQ, then reopen it.  The text will    
   be as it was before you executed the macro.  

K--KillBak:  Deletes all BAK files in the logged directory.        
   Press Esc K at the opening menu or with a file onscreen.  Then 
   press any key to return to the opening menu or to your place 
   in the file you were editing.

L--LineBlk:  Blocks a line of text.  Press Esc L with the cursor 
   anywhere in the line.  (See TagLine, below.)

M--Mark:  Leaves a place mark in a file when you press Esc M.  To 
   return to the place mark, execute YMark (below).  

N--NxtZap:  Deletes from the cursor word to the start of the next       
   sentence.  Press Esc N with the cursor on any character in the 
   first word you want deleted. 
     
     
O--Omit:  Enters an ellipsis (. . .), usually to indicate that       
   words have been omitted from a direct quotation.  To put an 
   ellipsis between two words, press Esc O with the cursor on the 
   first character in the second word.

P--PFlop (WordStar 4.0):  Reverses the positions of two           
   paragraphs.  Press Esc P with the cursor anywhere in the first    
   of the two paragraphs to be transposed.
  
P--PartWin (WordStar 5.x, 6.0):  Restores the default window 
   display after FullWin (above) has been used to allocate all 
   screen space to one file.  To run the macro, press Esc P. 

Q--QuikSav (WordStar 4.0):  Saves a file and redisplays it for 
   further editing.  The save is usually faster than one 
   performed with ^KS.  To run the macro, press Esc Q. 
    
Q--Quest (WordStar 5.x, 6.0):  Starts a search.  Press Esc Q with 
   the cursor at the top of a file.  The macro leaves a place 
   mark and displays a search screen.  Type any word that appears 
   in the file and press Return twice.  After completing your 
   search, you can return to your previous position by executing 
   the YMark macro (see Y, below).  Note:  When you type the word 
   or words you're looking for, you needn't capitalize any 
   letters, even if one of the words is a proper name.

R--Reopen-1:  Reopens the last active file and returns the cursor 
   to its last position in that file.  To run the macro, press 
   Esc R at the opening menu.  WordStar 5.0 users:  Don't use the 
   macro if you opened a window while the file was last active.)

S--SentZap-2:  Deletes a sentence.  Press Esc S with the cursor 
   anywhere in the sentence.

T--TagLine:  Adds one or more lines to a block.  Place the cursor    
   anywhere on the first line of a file and execute LineBlk    
   (above) by pressing Esc L.  Then place the cursor anywhere on 
   the fourth line of the file and execute TagLine by pressing 
   Esc T.  The first four lines will be blocked. 

U--UpZap-2:  Deletes from the word at the cursor to the top of    
   the paragraph.  Press Esc U with the cursor on any character 
   in the last word you want deleted from the paragraph.  

V--ViewMac:  Displays the Shorthand definition screen when you 
   press Esc V at the opening menu or with a file onscreen.  You 
   may find the macro handy while setting up your macro set.

W--WordZap:  Erases a word.  Press Esc W with the cursor on any 
   character in the word.  

X--XBold:  Extends a boldface string.  With the cursor on any          
   character in the first word of a sentence, execute Bold          
   (above) by pressing Esc B.  Then execute XBold by pressing 
     
   Esc X with the cursor on any character in the last word of the    
   next sentence.  The two sentences will be boldfaced. 

Y--YMark:  Finds and deletes a place mark when you press Esc Y.  
   The macro is used to find marks left by Mark and Quest (above) 
   and is also used in combination with other macros.  (See 
   Marking and Finding a Place in chapter 4.) 
 
Z--ZapGraf:  Deletes a paragraph.  Press Esc Z with the cursor 
   anywhere in the paragraph.

.lm 6
.rm 60

     Important:  Some of the sample macros use directory           
     designations that include numbers.  If you're using      
     WordStar 4.0 or 5.x, it's assumed that your WordStar 
     program files are in a directory called WS4 or WS5.  If 
     you're using WordStar 6.0, it's assumed that the files 
     are in a directory called WS.  If you use a WordStar 
     directory designation in a macro, it must match the 
     name of your WordStar directory.  Example:  If you're 
     running WordStar 4.0 out of a directory called WS, you 
     can't use the directory designation WS4 in a macro.  
     The number must be omitted.  If you need to edit any 
     macro definitions, use ViewMac to display the Shorthand 
     screen.  The affected macros are LogMain, LogBiz, 
     Mv2Main, Mv2Biz and Go2Name.

.lm 1
.rm 65

The sample macros are more fully described in chapter 4.  Consult 
the index.  All macro labels are listed there.  

Note:  You can create two sets of Shorthand macros and switch 
quickly between the two.  See Swapping Shorthand Files in chapter 
4.
     


     
.pa     
.he
.fo                              #














    6 / B a t c h    F i l e s 






 

   
DOS batch files aren't really macros, and WordStar has nothing to 
do with processing them.  But batch files can be used to execute 
multiple commands, just like macros, and you can use WordStar to 
create them.  


     1. Access Menu

If you don't have a utility that displays a menu of your programs 
when you turn on your computer, WordStar will help you build one.  
With the help of batch processing, you can start any program on 
the menu with two keystrokes.  Just type the first character in 
the name of the program and press Return.  After using one 
program, you can switch to another from any DOS prompt by 
pressing just two keys.  
    
If you decide to use some of the simple batch files described in 
this chapter, it may be a good idea to put them in a directory of 
their own.  If you don't already have one, create a directory 
called C:\BATCH.  (At any DOS prompt, type MKDIR C:\BATCH and 
press Return.)

Suggestion:  Read this entire section before creating an access 
menu.  There are two options.  A plain vanilla menu is described 
first.  A color version is described later.

     Option a:
  
Create a nondocument file called \BATCH\MENU.TXT.  Enter several 
blank lines at the top of the file.  Using spaced-out letters, 
type the heading  A c c e s s   M e n u.  Then type the names of .he HOLY MACRO!                                               #
.fo

          
the programs you use regularly.  You may want to include the name 
of an often-used DOS command such as CHKDSK.  Arrange the names 
in one or more columns.  Example:


                     A c c e s s   M e n u

                                                               
          A--Alpha Four                  P--Park

          C--ChkDsk                      Q--Quicken

          L--Lotus                       T--Type Director

          M--Modem                       W--WordStar

          N--Norton                      X--XTree



If you like, you can use equal signs and asterisks to dress up 
the menu a little.  Like this:  



                       =====================

                       A c c e s s   M e n u

                       =====================


  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  *                                                             *
  *        A--Alpha Four                  P--Park               *
  *                                                             *
  *        C--ChkDsk                      Q--Quicken            *
  *                                                             *
  *        L--Lotus                       T--Type Director      *
  *                                                             *
  *        M--Modem                       W--WordStar           *
  *                                                             *
  *        N--Norton                      X--XTree              *
  *                                                             *
  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *



Shortcut:  Find the file MENU.TXT in the Holy Macro! package.  
Copy that file to your BATCH directory, naming the copy 
\BATCH\MENU.TXT.  Then open the file as a nondocument.  (To do 
that at the opening screen in WordStar, press N, type 
\BATCH\MENU.TXT and press Return.)  You'll see a menu like the one above this paragraph, except that the box will contain no 
program names.  Switch off Insert and enter your program names.  
Save the file. 
     
Next, call up the file \AUTOEXEC.BAT as a nondocument.  If the 
file is set up to land you in a DOS shell or to start a program 
when you boot up, you'll have to make some simple changes.  
Example:  If the file starts WordStar 7.0, the command CD\WS may 
appear on the next-to-last line and the command WS on the last 
line.  If so, delete both lines.  The last line should look like 
this:


TYPE \BATCH\MENU.TXT


That line tells AUTOEXEC.BAT that its last function is to display 
the MENU.TXT file.  Like this:



                        =====================

                        A c c e s s   M e n u

                        =====================


  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  *                                                             *
  *        A--Alpha Four                  P--Park               *
  *                                                             *
  *        C--ChkDsk                      Q--Quicken            *
  *                                                             *
  *        L--Lotus                       T--Type Director      *    
  *                                                             *
  *        M--Modem                       W--WordStar           *    
  *                                                             *
  *        N--Norton                      X--XTree              *
  *                                                             *    
  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 

C:\>



At the C:\> prompt under the menu, you'll type a letter to select 
a program and then press Return to start the program.  If you 
type W and press Return, DOS starts WordStar.  If you type A and 
press Return, DOS starts the Alpha Four database program 
(assuming you have it).  And so on.
     
Before you can start programs this way, you'll have to create a 
small batch file for each program on the menu.  To create the 
batch file that starts WordStar, open a nondocument called \BATCH\W.BAT.  If you're using WordStar 5.5, the body of the file 
might look like this:  


@ECHO OFF
CD\WS5
WS
          

Create a batch file for each of the other programs on your menu.  
A Lotus 1-2-3 batch file would be called \BATCH\L.BAT.  An XTree 
batch file would be called \BATCH\X.BAT.  An Alpha Four batch 
file would be called \BATCH\A.BAT.  And so on.  

The batch file for version 2 of Alpha Four would look like this:


@ECHO OFF
CD\ALPHA4V2
A4


The CD\ALPHA4V2 tells DOS to go to the Alpha 4 directory.  The A4 
on the last line opens the program.

The BATCH\C.BAT file (used to run the DOS CHKDSK command) would 
look like this:


@ECHO OFF
CHKDSK /F

  
The command line used to start a program (or to run a DOS command 
such as CHKDSK) always occupies the last line of the batch file.   

Note:  If you're using a version of DOS earlier than 3.3, omit 
the @ symbol before ECHO on the top line of each batch file.

After setting up your batch files, reboot.  You'll then be able 
to open any program with two keystrokes and move quickly from one 
program to another.  If you're in WordStar and want to run Lotus 
1-2-3, just exit to DOS, type L and press Return.  To open XTree, 
type X at any DOS prompt and press Return.  To return to 
WordStar, type W at any DOS prompt and press Return.  

If you've forgotten which programs are listed on your menu, get a 
DOS prompt, type MENU and press Return.
      
     
     Option b:

If you have a color monitor, you can use batch processing to 
display your access menu in two or more colors.  You'll set up a 
batch file for each of your programs, just as you would if you were using the Option a menu.  But you won't use a file called 
MENU.TXT to display the access menu.  Instead, you'll use three 
files called MENU.BAT, MENU.TOP and MENU.BTM.  Find those files 
in the Holy Macro! package and copy them to the BATCH directory.  
Then:
    
Open the \BATCH\MENU.BTM file as a nondocument.  An empty program 
box will be displayed.  Switch off Insert and type the names of 
your programs in the box.  Save the file.  If you're using a 
version of DOS earlier than 3.3, open the file MENU.BAT as a 
nondocument and delete the @ symbol before ECHO OFF on the top 
line.  Finally, open your \AUTOEXEC.BAT file as a nondocument.  
The last line of the file should look like this:  


\BATCH\MENU
     
     
That line tells AUTOEXEC.BAT to run the MENU.BAT file.  And 
MENU.BAT tells DOS to display your menu.  (To produce the 
display, DOS types out two files, MENU.TOP and MENU.BTM.  The two 
files use different foreground colors.)  

Make sure that you have a DOS file called ANSI.SYS on Drive C and 
that the ANSI.SYS device driver is loaded.  If the driver is 
loaded, your \CONFIG.SYS file (which should be opened as a 
nondocument) will include a line something like one of the 
following:


DEVICE=ANSI.SYS

DEVICE=C:\DOS\ANSI.SYS

DEVICEHIGH=ANSI.SYS

DEVICEHIGH=C:\DOS\ANSI.SYS. 


The file MENU.BAT displays the top part of the access menu in 
bold yellow on a blue background and the lower part in bold white 
on blue.  If you don't like the color scheme, you can change it.  
Open \BATCH\MENU.BAT as a nondocument.  Unless you've deleted the 
@ symbol on line 1 of MENU.BAT (because you're using a version of 
DOS earlier than 3.3), the body of the file will look like this: 


@ECHO OFF
ECHO ^[[33;44;1m  
ECHO ^[[0H
ECHO ^[[2J
TYPE \BATCH\MENU.TOP
ECHO ^[[7H
ECHO ^[[37;44;1m
TYPE \BATCH\MENU.BTM
The first two-digit number on line 2 controls the foreground 
color for the top part of the menu.  The 33 on that line stands 
for yellow.  The first two-digit number on line 7 controls the 
foreground color for the bottom part.  The 37 on that line stands 
for white.  If you want both parts of the menu displayed in white 
on blue, change the 33 on line 2 to 37.  If you want the top part 
displayed in cyan on blue, change the 33 on line 2 to 36.  You 
can also change the background color (represented on lines 2 and 
7 by the number 44).  See ANSI.SYS in your DOS manual.

To check out a color combination, get a DOS prompt, type MENU and 
press Return.  
     
Caution:  If you open the MENU.BAT file, don't disturb the escape 
character (^[) on line 2 or 7.  Not all versions of WordStar will 
let you create that character.  If you accidentally delete an 
escape character, try to enter a new one.  Procedure:  Hold down 
Ctrl press P, then release Ctrl and press Esc.  If you see ^[, 
the escape character has been entered.  If you draw a blank, 
borrow an escape character from elsewhere in the file.  First 
move the cursor to one of the lines beginning ECHO ^[[.  Put the 
cursor on the caret (^) before the first left square bracket.  
Press ^KB to start a block.  Press ^D to move the cursor right 
one space.  Press ^KK to end the block.  Move the cursor to the 
position at which you want to restore the missing escape 
character.  Press ^KC to copy the block.  Press ^KH to dissolve 
the block highlighting.
   
If your access menu appears on a blue background, you'll get the 
same background color when you exit to DOS from WordStar.  The 
entire screen (except for the DOS prompt characters) will be 
blue.  But note:  Some programs partially override the color 
settings used by the access menu.  When you exit to DOS from one 
of those programs, only the DOS prompt characters appear on a 
blue background.  The rest of the screen is black.  But getting 
rid of the black is easy.  If you're not getting a blue screen 
when you run DOS commands, just type CLS at the DOS prompt and 
press Return.  
          
        
        
     2. Changing Directories

If you want to move from one WordStar directory to another using 
the method described in the Directory Swapping section of chapter 
4, you must devote one macro key to each directory.  If you have 
lots of directories, that will take lots of keys.  

An alternative is to use batch files to swap directories.  If you 
have a half dozen WordStar directories, all you need to do is 
create a half dozen small batch files.  Then, from WordStar's 
opening screen, you can move from one directory to another by 
pressing X, typing a single character and pressing Return.

The batch file for the main WordStar directory is called 1.BAT.  It is created as a nondocument.  If you're using WordStar 7.0, 
the body of the file might look like this:  


@ECHO OFF
CD\WS
WS


If you have a WordStar subdirectory called BIZ, the batch file 
for that subdirectory might be called 2.BAT and might look like 
this:


@ECHO OFF
CD\WS\BIZ
WS


The batch file for a subdirectory called LTRS might be called 
3.BAT and might look like this:


@ECHO OFF
CD\WS\LTRS
WS


To move from the main directory to WS\BIZ, press X at the opening 
screen, type the number 2 and press Return.  To move from WS\BIZ 
to WS\LTRS, press X, type 3 and press Return.  To move back to 
the main directory, press X, type 1 and press Return.

Note:  If you're using a version of DOS earlier than 3.3, omit 
the @ symbol before ECHO on the top line of each batch file.

To remember which numbers go with which directories, type out a 
list.  Option:  You can create a directory of menus patterned 
after one of the menus described in the previous section.  But 
that may take more time than it's worth.  You'll probably 
memorize the numbers quickly, even without making a conscious 
effort to do so.   

Swapping directories with batch files is somewhat slower than 
doing it with macros.  If you don't have a lot of directories, or 
if you have a lot of spare macro keys, it may be better to use 
the macro method described in chapter 4.
     
     
     
     3. Deleting CRT files

When you use Page Preview, WordStar creates files with CRT 
extensions.  If not erased, they'll accumulate.  A utility called 
DELCRT is supplied with WordStar 5.5, 6.0 and 7.0.  You can delete CRT files by typing DELCRT and pressing Return at the DOS 
prompt in the WordStar directory.  But there's a way to have the 
files erased automatically whenever you boot up.  If your 
AUTOEXEC.BAT file is set up to land you in WordStar, the last two 
lines of the file might look like this:


CD\WS
WS


To have CRT files erased automatically, use these lines instead:


CD\WS
DELCRT
WS


Option:  If you use one of the access menus described in the 
first section of this chapter, you can modify your W.BAT file.  
Example:  If you're using WordStar 7.0, the file should look like 
this:

 
@ECHO OFF
CD\WS
DELCRT
WS


Any CRT files created by Page Preview will then be erased 
whenever you open WordStar.
.pa
.mt5
.mb6
.cw12

.heHOLY MACRO!                                                #
.hm2
.fm2
.lm1
.rm65
.ls1
.po 1i
.lh8
.pl66
.ps off
.op
.fo                                #  
.pn184
     
..         This file will be difficult to read onscreen unless
..      the print-control characters are hidden.  To hide those
..      characters, hold down Ctrl and press the letters O and D.












     N o t e s 









A breakdown of the macro sequences follows. 

When two or more commands in a macro definition perform a single 
task, or closely related tasks, they may be introduced as a unit 
and referred to in the singular.  Commands described separately 
in one note may be combined in a later note and referred to in 
the singular.

The paragraph or sentence in which the cursor is positioned when 
a macro is executed is called the "home paragraph" or "home 
sentence."  

WOMBAT is used as a universal filename.  The name may appear part 
way through a note without prior introduction, the assumption 
being that the reader knows the file in question is WOMBAT.  

A full macro definition appears at the start of each WS7.0 note.  
Example:


     15. LineBlk (7.0):  Sub Main
                         Key ("^QS^KB^KH")
                         PauseForInput ("<SP>")
                         Key ("^QD^KK")
                         End Sub
  

To avoid repetition, the Sub Main and End Sub lines are omitted 
from the step-by-step breakdowns below macro definitions.  For 
the same reason, the characters that enclose Key statements 
     
.fo
           
appear without explanation in the breakdowns.  Illustration:  The 
statement Key ("^QS^KB^KH") in note 15 is broken down like this: 


      Key ("^QS makes sure the cursor is at the left margin.
     ^KB marks the start of a block.
     ^KH") dissolves any block highlighting. (See note 14.) 


In the first line, the explanatory text describes only the 
function of the ^QS command and omits mention of the word "Key" 
and the parenthesis and quotation mark after "Key."  In the third 
line, the explanatory text describes only the function of the ^KH 
command and omits mention of the quotation mark and parenthesis 
after ^KH.  It is assumed that the user has read the Macros 
section of the WordStar Reference manual and understands the 
functions performed by the word "Key" and the parentheses and 
quotation marks.
        
.pa
.pm1
.lm7

1. CopFlop-1 (4.0):  ^KDP^R^M^M^UO^R^MA:^R^MY^MP^R^G^G^M^M^U  

.pm4
   ^KD saves the file. 
    P displays a print screen.
   ^R displays the filename WOMBAT.
   ^M^M^U enters two Returns and switches off the print screen.        
      This and the two preceding commands are used to make       
      sure the right name is in memory for file-copying purposes.              
      If a file is imported or a block exported before WOMBAT is 
      saved by ^KD (above), the name of the imported file or 
      exported block replaces WOMBAT as the filename in memory 
      for copying purposes.  But the name of the last active file 
      is always displayed when P^R is pressed at the opening 
      menu.  The P^R^M^M^U sequence borrows the name WOMBAT from 
      the print screen, ensuring that the right file will be 
      copied.
    O displays a screen used in copying a file.
   ^R^M repeats the filename WOMBAT on a prompt line and       
      executes a Return, displaying the next prompt. 
    A:^R^M identifies the drive on which the copy is to be made, 
      appends the filename WOMBAT to the drive designation and 
      executes a Return, ordering the file copied to Drive A.
    Y answers Yes if WordStar asks whether a previous copy of the 
      file on Drive A should be overwritten.  If there is no       
      previous copy on Drive A, the Y displays the file-delete 
      screen.  
   ^M switches off the file-delete screen if it has been       
      displayed.  The command otherwise has no effect.  
    P^R displays the filename A:WOMBAT on the print screen.  The 
      name is preceded by the drive designation A: because 
      A:WOMBAT was the last file saved. 
   ^G^G deletes the A and the colon in front of WOMBAT.  
   ^M^M^U enters two Returns and switches off the print screen.        
      WOMBAT is now the filename in memory.  The name A:WOMBAT       
      has been removed from memory to avoid possible confusion.        
      If the name is left in memory, and if the user executes one 
      of the file-reopening macros described in chapter 4, the 
      wrong copy of the file (the one on Drive A) comes onscreen.  



.pm1
2. CopFlop-1 (5.x, 6.0):  ^KS^KTA:^X 

.pm4
   ^KS saves the file, keeping it open.
   ^KT displays a screen used in saving a copy of a file under a       
      different name.
    A: enters a drive designation on the ^KT prompt line.
   ^X moves the cursor into a directory file list below the ^KT 
      screen.  The user moves the cursor to the name of the file 
      being copied and presses Return.  WordStar enters the 
      filename on the prompt line after A: and sends a copy of       
      the file to Drive A.
         
.pa
        
.pm1
3. CopFlop-1 (6.0D):  ^KDP^LNUL^MP^UO^QD^A^Q<DELETE>^MA:^R^MR
                      ^Y^M

.pm4
   ^KD saves the file.
    P displays a print screen.  The object is to make certain       
      that the right file is backed up.  If WOMBAT is onscreen 
      and the file AARDVARK is called up in a window, AARDVARK 
      replaces WOMBAT as the filename in memory for copying 
      purposes.  But the print screen always displays the name of       
      the file that was onscreen originally.  CopFlop-1 will 
      borrow that name from the print screen and store the name 
      in memory.  
   ^L moves the cursor to the bottom line on the print screen.
    NUL^M redirects the contents of the onscreen file to a NUL 
      device.  This sends the file nowhere.  (To borrow a 
      filename from the print screen, the macro must carry out 
      some operation before switching off the screen.  
      Redirecting the output accomplishes that purpose.)
    P^U tells WordStar to stop redirecting the output.  
    O displays the file-copy screen.  
   ^QD moves the cursor to the right of the filename displayed on 
      the copy screen.
   ^A moves the cursor back to the start of the filename.  If the       
      filename is preceded by a path (e.g., C:\WS\WOMBAT), the       
      cursor stops on the first letter of the filename (i.e., on       
      the W in WOMBAT).
   ^Q<DELETE> erases any characters to the left of the cursor.        
      If C:\WS\WOMBAT was displayed when the copy screen was       
      switched on, only the filename WOMBAT remains.  If there       
      was no path before the filename, ^Q<DELETE> has no effect.
   ^M^ executes a Return, moving the cursor to a line on which 
      the name of the backup file will be entered.
    A:^R enters a drive designation, then repeats the filename 
      displayed on the first line.  If WOMBAT was on the first 
      line, the name A:WOMBAT appears.
   ^M executes a Return, ordering a copy of the file sent to 
      Drive A.
    R^Y^M performs one of two functions, depending on whether a 
      previous copy of the file has been sent to Drive A.  If no 
      previous copy has been sent, R displays a DOS prompt.  ^Y 
      has no effect.  ^M switches off the prompt.  If there is a       
      previous copy, WordStar asks whether to overwrite and waits 
      for a Y or N answer.  It disregards the R and takes ^Y to       
      mean that the copy is to be overwritten.  ^M has no effect. 
       
.pa    
.pm1
.pl67
4. CopFlop-1 (7.0A):  Sub Main
             WSQuiet (On)
             Key ("^KD")
             WSQuiet (Off)
             Key ("O^QD^A^Q{DEL}")
             PauseForInput ("{ENTER}", ' Check filename. ')
             Key ("{TAB}A:^R{F10}")
             IfException
             Def: Key ("Y")
             End IfException
             WSQuiet (On)
             Key ("D^G^G{F10}^KQ")
             WSQuiet (Off)
             End Sub

.pm4
    WSQuiet (On) switches on the WSQuiet feature to suppress       
      screen flash.  The feature is used in many WordStar 7.0 
      macros to avoid the distraction of having dialog boxes and 
      other displays flash on and off while commands are 
      executed.  Note:  WSQuiet is turned on and off more than 
      once in some macros.  It must be disabled during the 
      execution of some commands.
    Key ("^KD") saves and closes the file WOMBAT.  
    WSQuiet (Off) disables the WSQuiet feature.
    Key (O displays a file-copy screen.
   ^QD moves the cursor to the end of the first line on the copy 
      screen.
   ^A moves the cursor back to the start of the filename.
   ^Q{DEL}") erases any path ahead of the filename.  If the name 
      C:\WS\WOMBAT was displayed, it is shortened to WOMBAT.  The 
      name must appear without a path when copied to the second 
      line of the copy screen by a later command.
    PauseForInput ("{ENTER}", ' Check filename. ') interrupts the 
      macro and tells the user to make sure the right filename is 
      displayed.  The macro restarts when the user presses Enter.
    Key ("{TAB} moves the cursor down a line on the copy screen.
    A:^R enters the drive designation A: and repeats the filename 
      entered on the first line.  A:WOMBAT is displayed.
   {F10}") orders a copy of the file sent to Drive A.
    IfException introduces an IfException clause.
    Def: Key ("Y") answers Yes if WordStar interrupts the macro 
      to ask whether to overwrite an earlier backup version of 
      WOMBAT.  If there is no earlier version, the IfException 
      clause is disregarded.
    End IfException terminates the IfException clause.
    WSQuiet (On) actuates the WSQuiet feature.
    Key ("D displays a screen used in opening a file.  The 
      filename A:WOMBAT appears because it became the 
      filename in memory when WOMBAT was backed up on 
      Drive A. 
   ^G^G{F10}^KQ deletes the A: at the start of the filename, 
      reopens WOMBAT on Drive C, then orders the file 
      abandoned.  WOMBAT replaces A:WOMBAT as the filename in 
      memory.  The change is made so that the right file will 
      come onscreen if the user executes a Reopen macro.
    WSQuiet (Off) disables the WSQuiet feature.
.pl66
.pm1
5. CopFlop-1 (7.0C):  WSQuiet (On)
                      Key ("^KDO^QD^A^Q{DEL}{TAB}A:^R{F10}")
                      IfException
                      Def: Key ("Y")
                      End IfException
                      WSQuiet (Off)
                      Key ("D^G^G{F10}^KQ")

         The macro is essentially the same as the last one.  The 
      filename check is omitted because WS7.0C always displays 
      the correct filename.



.pm1
6. CopFlop-2 (4.0):  ^KDP^R^M^M^UO^R^MA:^R^MY^MP^R^G^G^M^M^U
                      RDIR A: | SORT | MORE^M 

.pm4
         The macro is the same as the one described in note 1       
      except that RDIR A: | SORT | MORE^M is added so that a list 
      of the files on Drive A will be displayed after the backup 
      is completed.  The R in RDIR displays a DOS prompt.  The 
      remaining commands tell DOS to sort the file list and 
      display it a screenful at a time.
        


.pm1
7. CopFlop-2 (6.0D):  ^KDP^LNUL^MP^UO^QD^A^Q<DELETE>^MA:^R^MR
                      ^Y^MRDIR A: | SORT | MORE^M

.pm4
         The macro is the same as the WS6.0D version of CopFlop-1 
      except that RDIR A: | SORT | MORE^M is added so that a list 
      of the files on Drive A will be displayed after the backup       
      is completed.  (See notes 3 and 6.)  



.pm1
8. CopFlop-2 (7.0A):  Sub Main
             WSQuiet (On)
             Key ("^KS")
             WSQuiet (Off)
             Key ("^KO^QD^A^Q{DEL}")
             PauseForInput ("{ENTER}", ' Check filename. ')
             Key ("{TAB}A:^R{F10}")
             IfException
             Def: Key ("Y")
             End IfException
             WSQuiet (On)
             Key ("D^G^G{F10}^KQ")
             WSQuiet (Off)
             Key ("RDIR A: | SORT | MORE {F10}")
             End Sub

.pm4
         The macro is the same as the one described in note 4 
      except that the last WSQuiet (Off) line is followed a Key  
      statement:
    Key ("R displays a DOS prompt.
    DIR A: orders DOS to display the Drive A file list.
    | SORT | MORE {F10}") tells DOS to display the list in sorted 
      form, pausing when the screen fills.



.pm1
9. CopFlop-2 (7.0C):  WSQuiet (On)
                        Key ("^KDO^QD^A^Q{DEL}{TAB}A:^R{F10}")
                        IfException
                        Def: Key ("Y")
                        End IfException
                        Key ("D^G^G{F10}^KQ")
                        WSQuiet (Off)
                        Key ("RDIR A: | SORT | MORE {F10}")

         The macro is the same as the last one except that the 
      filename check is omitted.  (See note 5.)



.pm1
10. CopFlop-3 (4.0):  ^KS^KPN^R^M^M^U^KB<SP>^KK^S^KO^R^MA:^R
                     ^MY^KY^KPN^R^M^M^U 
  
.pm4
   ^KS saves the file, keeping it open.
   ^KPN displays a print screen.  
   ^R displays the name of the onscreen file, WOMBAT.  
   ^M^M^U executes two Returns, then switches off the print             
      screen.  This and the two preceding commands make sure       
      that the right filename is in memory.  The ^KPN^R^M^M^U             
      sequence performs the same function as the P^R^M^M^U       
      sequence described in note 1.  The only difference is that 
      one procedure is begun at the opening menu, the other at 
      the editing screen.  
   ^KB<SP>^KK marks the start of a block, enters a blank space             
      and marks the end of a block. 
   ^S moves the cursor to the blank space between the block       
      markers.
   ^KO displays the file-copy screen.  
   ^R^M repeats the filename WOMBAT on the prompt line and 
      executes a Return, moving the cursor to the next prompt                   
      line. 
    A:^R^M identifies the drive on which the copy is to be made,             
      appends the filename WOMBAT to the drive designation (A:)             
      and executes a Return.     
    Y answers Yes if WordStar interrupts to ask whether a       
      previous version of the file on Drive A should be       
      overwritten.  If no previous version of the file has been       
      sent to Drive A, WordStar does not ask whether to       
      overwrite, and the Y is unspent.  It prints at the last       
      cursor position in the onscreen file.  That puts it inside       
      the block created earlier by ^KB<SP>^KK.  
   ^KY deletes the block, leaving the text as it was before the             
      macro was executed. 
   ^KPN^R^M^M^U repeats a procedure performed near the beginning                   of the macro sequence.  Because a copy of the file has been 
      sent to Drive A, the filename in memory for copying 
      purposes is now A:WOMBAT.  ^KPN^R^M^M^U restores the 
      filename WOMBAT to memory so that CopFlop-3 will perform 
      properly if executed again after further editing of the 
      file.
             
         
          
.pm1
11. CopFlop-3 (5.5, 6.0):  ^KS^KPP^LNUL^M^KP^U^KO^MA:^X

.pm4
   ^KS saves the file, keeping it open.
   ^KPP^LNUL^M^KP^U displays the print screen and borrows the       
      original filename from that screen, making sure that the 
      right name is in memory.  This sequence performs the same 
      function as the P^LNUL^MP^U sequence described in note 3.  
      The only difference is that one procedure is begun at the 
      opening menu, the other at the editing screen.  
   ^KO displays the file-copy screen.  The filename WOMBAT 
      appears on the screen.
   ^M executes a Return, moving the cursor to the second line on 
      the screen.  
    A: enters a drive designation.
   ^X moves the cursor to a directory file list below the copy       
      screen.  The user moves the cursor to the name of the       
      file being copied and presses Return.  WordStar enters the 
      filename on the prompt line after A: and sends a copy of 
      the file to Drive A.
        
        
        
.pm1
12. CopFlop-3 (6.0D):  ^KS^KPP^LNUL^M^KP^U^KB<SP>^KK^S^KO^QD^A
                       ^Q<DELETE>^MA:^R^MY^KY

.pm4
   ^KS saves the file, keeping it open.
   ^KPP^LNUL^M^KP^U displays a print screen and borrows the       
      original filename from that screen, making sure that the       
      right name is in memory.  The sequence performs the same 
      function as the P^LNUL^MP^U sequence described in note 3.              
      The only difference is that one procedure is begun at the             
      opening menu, the other at the editing screen.  
   ^KB<SP>^KK marks the start of a block, enters a blank space 
      and marks the end of a block.
   ^S moves the cursor to the blank space between the block       
      markers.
   ^KO displays the file-copy screen.  The name of the file being 
      edited appears on the screen.
   ^QD^A^Q<DELETE> deletes any path before the filename.  (See       
      ^QD^A^Q<DELETE> in note 3.)
   ^M executes a return, moving the cursor to the next prompt 
      line.
    A:^R^M enters a drive designation, appends the name of the 
      onscreen file and executes a Return, ordering a copy of the 
      file sent to Drive A.
    Y answers Yes if WordStar interrupts to ask whether a             previous backup version of the file on Drive A should be       
      overwritten.  If there is no previous version, WordStar 
      does not ask whether to overwrite, and the Y is unspent.  
      It prints at the last cursor position in the onscreen file.  
      That puts it inside the block created earlier by 
      ^KB<SP>^KK.  
   ^KY deletes the block, leaving the text as it was before the       
      macro was executed. 



.pm1
13. CopFlop-3 (7.0):  Sub Main
              WSQuiet (On)
              Key ("^KS")
              WSQuiet (Off)
              Key ("^KO^QD^A^Q{DEL}")
              PauseForInput ("{ENTER}", ' Check filename. ')
              Key ("{TAB}A:^R{F10}")
              IfException
              Def: Key ("Y")
              End IfException
              End Sub

.pm4
         The macro is the same as the WS7.0A version of CopFlop-1 
      except that a different save command is used so that the 
      file remains onscreen after a backup copy is sent to Drive 
      A.



.pm1
14. LineBlk (4.0, 5.x, 6.0):  ^QS^KB^KH^QD^KK 

.pm4
   ^QS makes sure the cursor is at the left margin.
   ^KB marks the start of a block.     
   ^KH averts a problem that may be caused by hidden blocks.  If 
      a macro enters a ^KB that happens to fall within or above a 
      hidden block, a new block is created.  The block extends 
      from the ^KB to the point where the hidden block ended.  If 
      the macro later enters a ^KK that happens to land on top of 
      the ^KK in the hidden block, the two ^KK's cancel out one 
      another, unblocking the text.  But if the macro enters a 
      ^KH after it has entered ^KB to start the new block, the 
      ^KH will neutralize any ^KK in a hidden block.  
      Illustration:  LineBlk enters a ^KH after ^KB at the start 
      of a line. That neutralizes any hidden block marker that 
      may have been left at the end of the line.  Result:  When 
      LineBlk enters a new ^KK at the end of the line later in 
      the sequence, there is no canceling-out effect, and the 
      line is reblocked.  The same technique can be used in 
      reverse, when a macro marks a block ending before marking a 
      block beginning.  If the macro enters a ^KK that happens to 
      fall within or below a hidden block, a new block is 
      created.  It extends upscreen from the ^KK to the point 
      where the hidden block began.  If the macro later moves the 
      cursor up and enters a ^KB that happens to land on top of       the ^KB in the hidden block, the two ^KB's cancel out one       
      another, unblocking the text.  But if the macro enters a 
      ^KH after entering a ^KK to end the new block, any ^KB in a 
      hidden block will be neutralized.  
   ^QD moves the cursor to the right margin. 
   ^KK marks a new block ending.
        


.pm1
15. LineBlk (7.0):  Sub Main
            Key ("^QS^KB^KH")
            PauseForInput ("<SP>", Press Spacebar to block.')
            Key ("^QD^KK")
            End Sub

.pm4
    Key ("^QS makes sure the cursor is at the left margin.
   ^KB marks the start of a block.
   ^KH") dissolves any block highlighting.  (See note 14.)  
    PauseForInput ("<SP>", 'Press Spacebar to block.') interrupts 
      the macro so that the user can move the cursor to another 
      line if more than one line is to be blocked.  The macro 
      restarts when the user presses the Spacebar. 
    Key ("^QD^KK") moves the cursor to the right margin and marks 
      the end of a block. 



.pm1
16. TagLine (4.0, 5.x, 6.0):  ^F^F^QD^KK 

.pm4
   ^F^F moves the cursor down a line.  
   ^QD moves the cursor to the right margin.
   ^KK marks a new block ending. 
        
        

.pm1
17. GrafBlk (4.0, 5.0, 5.5C, 6.0):  ^QH^M^KB^KH^F^B^S^S^QD^D^KK 

.pm4
   ^QH^M finds the Return just above the home paragraph. 
   ^KB marks the start of a block. 
   ^KH dissolves any block highlighting.  (See note 14.)
   ^F^B positions the cursor below the home paragraph.
   ^S^S^QD moves the cursor to the end of the last line of the 
      home paragraph.  
   ^D positions the cursor on the line below the paragraph.  
      Exception:  If the home paragraph is the last one in a file 
      and is not followed by a Return, ^D has no effect in a 
      document created with WS4.0, 5.5, 6.0 or 7.0.  
   ^KK marks the end of a block.  



.pm1
18. GrafBlk (5.5):  ^OJ^QH^M^Y^S^KB^KH^F^B^S^S^QD^D^KK 

.pm4
   ^OJ inserts a line-justification dot command (.OJ ON) above       
      the home paragraph.  The dot command is used as a dummy.
        
   ^QH^M finds the Return just above the home paragraph.  If a             
      paragraph created with the original version of WS5.5 begins             
      on a line immediately below a page break, ^QH^M can't             
      find the Return ahead of that paragraph.  But if a dot             
      command has been inserted just above the paragraph, ^QH^M                   
      can find the Return after the dot command.  The previous       
      command has placed a dot command at that location to make       
      sure ^QH^M performs properly.  
   ^Y deletes the dot command.  The cursor is at the start of the 
      home paragraph. 
   ^S moves the cursor up a line.
   ^KB^KH^F^B^S^S^QD^D^KK performs as described in the previous       
      note.
        

.pm1
19. GrafBlk (7.0):  Sub Main
            WSQuiet (On)
            Key ("^QF^P^M^P^J{TAB}B{F10}")
            Key ("^KB^KH^F")
            WSQuiet (Off)
            PauseForInput ("<SP>", 'Press Spacebar to block.')
            Key ("^B^S^S^QD^D^KK")
            End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.) 
    Key ("^QF^P^M^P^J{TAB}B{F10}") finds the Return just above 
      the home paragraph.  (The ^QF search command is used in 
      place of ^QG and ^QH in many WordStar 7.0 macros because it 
      runs faster.)
    Key ("^KB^KH marks the start of a block and dissolves any 
      block highlighting.  (See note 14.)
   ^F") moves the cursor into the home paragraph.
    WSQuiet (Off) disables the WSQuiet feature.
    PauseForInput ("<SP>", 'Press Spacebar to block.') interrupts 
      the macro so that the user can move the cursor into a 
      subsequent paragraph if more than one paragraph is to be 
      blocked.  The macro restarts when the user presses the 
      Spacebar. 
    Key ("^B^S^S^QD^D^KK") performs as described in note 17.

        

.pm1
20. EndBlk (4.0, 5.x, 6.0):  ^F^F^B^S^S^QD^D^KK 

.pm4
   ^F^F moves the cursor into the next paragraph.  
   ^B^S^S^QD moves the cursor to the end of the last line of the 
      paragraph.
   ^D^KK positions the cursor on the line below the paragraph and 
      marks the end of a block.  
        
.pa
.pm1
21. MvGrafs (7.0):  Sub Main
            WSQuiet (On)
            Key ("^QF^P^M^P^J{TAB}B{F10}^KB^KH^F")
            WSQuiet (Off)
            PauseForInput ("<SP>", 'Press Spacebar to block.')
            Key ("^B^S^S^QD^D^KK")
            PauseForInput ("<SP>", 'Press spacebar to move.')
            Key ("^QS^KV^KH")
            End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)  
    Key ("^QF^P^M^P^J{TAB}B{F10}^KB finds the Return just above 
      the home paragraph and marks the start of a block.  (See       
      note 19.)
   ^KH dissolves any block highlighting.  (See note 14.)
   ^F") moves the cursor into the home paragraph.
    WSQuiet (Off) disables the WSQuiet feature.
    PauseForInput ("<SP>", 'Press Spacebar to block.') interrupts 
      the macro so that the user can reposition the cursor if 
      more than one paragraph is to be blocked.  The Spacebar is 
      pressed to restart the macro.  
    Key ("^B^S^S^QD^D^KK") places the cursor on the line below 
      the last paragraph to be blocked and marks a block ending.  
    PauseForInput ("<SP>", 'Press Spacebar to move.') interrupts 
      the macro so that the user can place the cursor at the 
      location to which the block is to be moved.  The pause ends 
      when the user presses the Spacebar.
    Key ("^QS^KV^KH") makes sure the cursor is at the left 
      margin, then moves the block and dissolves the block 
      highlighting.



.pm1
22. SentBlk-1 (4.0):  ^QF<SP><SP>^MB^M^F^KB^KH^B^S^S^QD<SP><SP>^A
                      ^QG<SP>^D^D^QY^QB^QF<SP><SP>^M^M^D^D^KK 

.pm4
   ^QF<SP><SP>^MB^M searches backward for two blank spaces in 
      front of the home sentence. 
   ^F moves the cursor to the start of the home sentence. 
   ^KB marks the start of a block. 
   ^KH dissolves any block highlighting.  (See note 14.)
   ^B^S^S positions the cursor on the bottom line of the home       
      paragraph.
   ^QD<SP><SP> moves the cursor to the right end of the line and 
      enters two blank spaces.  If the last sentence of the       
      paragraph is the one to be blocked, the macro will need to 
      find two spaces after that sentence to be able to tell 
      where it ends.  
   ^A^QG<SP> moves the cursor backward one word on the bottom 
      line of the home paragraph, then finds the first blank 
      space after the last word on the line.  
   ^D^D^QY advances the cursor two spaces, then deletes to the       
      end of the line.  SentBlk-1 is one of several macros that       
      leave blank spaces at paragraph endings.  If one or more of       
      these macros are executed repeatedly in the same paragraph,       the blank spaces will accumulate and may eventually run 
      beyond the right margin unless excess spaces are deleted.  
      The ^QY in ^D^D^QY erases any blank spaces after the first 
      two.
   ^QB returns the cursor to the begin-block marker left in the 
      home sentence by ^KB. 
   ^QF<SP><SP>^M^M searches forward for the first of two blank 
      spaces after the home sentence.
   ^D^D advances the cursor two spaces.
   ^KK marks the end of a block.      
       
        
        
.pm1
23. SentBlk-2 (4.0):  ^KK^KH^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG
                      <SP>^D^D^QY^QK^QF<SP><SP>^MB^M^F^QG<SP>^A
                      ^KB^QF<SP><SP>^M^M^D^D^KK 

.pm4
   ^KK enters an end-block marker.  Purpose:  to leave a place       
      mark in the home sentence.  ^KK can sometimes be used as a       
      substitute for a conventional place mark such as ^K2.
      Using ^Q2^K2 to find and erase a ^K2 place mark takes       
      twice as many characters as using ^QB to find a ^KK end-      
      block marker.  The ^KK used here doesn't have to be erased       
      because it will disappear when another ^KK is entered later             
      in the macro sequence.       
   ^KH dissolves any block highlighting.  (See note 14.) 
   ^QH^M<SP><SP> looks backward for a Return and enters two blank             
      spaces on the open line just above the home paragraph.  If       
      the first sentence of the paragraph is the one to be       
      blocked, SentBlk-2 will need to find two spaces ahead of       
      that sentence to be able to tell where it begins.  If the       
      sentence is indented, the indention supplies the necessary       
      spaces.  If the sentence is unindented, ^QH^M<SP><SP>       
      supplies the spaces.  
   ^F moves the cursor to the start of the home paragraph.
   ^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the 
      bottom line of the home paragraph, leaves two blank spaces 
      at the end of the line and deletes any excess blank spaces.              
      (See ^D^D^QY in note 22.)  If the last sentence of the       
      paragraph is the one to be blocked, the macro will need to       
      find two spaces after that sentence to be able to tell       
      where it ends. 
   ^QK finds the ^KK end-block marker left as a place mark in 
      the home sentence.
   ^QF<SP><SP>^MB^M searches backward for two blank spaces in 
      front of the home sentence. 
   ^F^QG<SP>^A moves the cursor to the first character of the             
      home sentence.  If the sentence is in the interior of a       
      paragraph, a single ^F will position the cursor properly.        
      But the macro must deal with variables.  Example:  If the       
      sentence is the first one in an unindented paragraph, the       
      blank spaces used to find the start of the sentence will be       
      on the line above the paragraph.  And the previous command 
      will have positioned the cursor so that ^F alone won't 
      advance it to the start of the home sentence.  The             ^F^QG<SP>^A sequence manipulates the cursor so that it       
      lands in the right place regardless of the situation.
   ^KB marks the start of a block.  
   ^QF<SP><SP>^M^M finds the first of two blank spaces at the end       
      of the home sentence.
   ^D^D^KK advances the cursor two spaces and marks the end of a 
      block.  
        
        

.pm1
24. SentBlk-2 (5.0):  ^OA^KK^KH^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A
                      ^QG<SP>^D^D^QY^QK^OA^QF<SP><SP>^MB^M^F^QG
                      <SP>^A^KB^QF<SP><SP>^M^Y^M^D^D^KK 

.pm4
   ^OA switches off auto-align.  Because of a WordStar 5.0 
      idiosyncrasy, the keyboard may lock in certain situations 
      unless auto-align is temporarily switched off.
   ^KK leaves a place mark.  (See note 23.)  
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QH^M<SP><SP> leaves two blank spaces on the line just above             
      the home paragraph.  If the first sentence of the paragraph             
      is the one to be blocked, the macro will need to find two
      blank spaces ahead of that sentence to be able to tell 
      where it starts.  ^QH^M<SP><SP> supplies the needed spaces 
      if the sentence is unindented or has been indented with the 
      Tab key.  (In a WordStar 5.x document, a Tab does not 
      create hard spaces.)  
   ^F^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the 
      bottom line of the home paragraph, leaves two blank spaces 
      at the end of the line and deletes any excess blank spaces.              
      (See ^A^QG<SP>^D^D^QY in note 22.)  If the last sentence of       
      the paragraph is the one to be blocked, the macro will need       
      to find two spaces after that sentence to be able to tell       
      where it ends.
   ^QK returns the cursor to the place mark left in the home       
      sentence by ^KK.
   ^OA switches auto-align back on.
   ^QF<SP><SP>^MB^M finds two blank spaces before the home 
      sentence.
   ^F^QG<SP>^A moves the cursor to the first character in the       
      home sentence.  (See note 23.)
   ^KB marks the start of a block.  
   ^QF<SP><SP>^M^Y^M finds the first of two blank spaces after       
      the home sentence.  The sequence is the same as one used in             
      note 22 except that here a ^Y is inserted between the two             
      ^M's.  Reason:  The macro used B between two ^M's in an       
      earlier search.  B told WordStar to search backward.  When       
      a macro orders a search in a document created with WordStar       
      5.x, 6.0 or 7.0, the search options line is displayed as it       
      last appeared--in this case with a B on it.  The ^Y between       
      the ^M's deletes the B so that the direction of the second       
      search will be forward. 
   ^D^D^KK advances the cursor two spaces and marks the end of a 
      block.  
         
.pm1
25. SentBlk-2 (5.5):  ^KK^KH^OJ^QH^M^Y^A<SP><SP>^F^B^S^S^QD<SP>
                      <SP>^A^QG<SP>^D^D^QY^QK^QF<SP><SP>^MB^M^F
                      ^QG<SP>^A^KB^QF<SP><SP>^M^Y^M^D^D^KK 

.pm4
   ^KK leaves a place mark in the home sentence.  (See note 23.) 
   ^KH dissolves any block highlighting.  (See note 14.)
   ^OJ enters a dummy dot command just above the home paragraph.              
      (See note 18.)
   ^QH^M finds the Return after the dot command.
   ^Y^A deletes the dot command and moves the cursor up to the 
      blank line just above the home paragraph.
   <SP><SP> enters two blank spaces on the line above the home             
      paragraph.  (See ^QH^M<SP><SP> in note 24.)
   ^F^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the       
      bottom line of the home paragraph, leaves two blank spaces 
      at the end of the line and deletes any excess blank spaces.              
      (See note 22.)
   ^QK finds the ^KK place mark in the home sentence.
   ^QF<SP><SP>^MB^M finds two blank spaces ahead of the sentence.
   ^F^QG<SP>^A moves the cursor to the first character in the       
      home sentence.  (See note 23.)
   ^KB marks the start of a block. 
   ^QF<SP><SP>^M^Y^M^D^D^KK finds the first of two blank spaces       
      after the home sentence, advances the cursor two spaces and             
      marks the end of a block.  (See note 24.)



.pm1
26. SentBlk-2 (5.5C, 6.0):  ^PP^QH^M<SP><SP>^F^B^S^S^QD<SP>SP>^A
                            ^QG<SP>^D^D^QY^QH^PP^G^QF<SP><SP>^MB
                            ^M^F^QG<SP>^A^KB^KH^QF<SP><SP>^M^Y^M
                            ^D^D^KK 

.pm4
   ^PP leaves a place mark.  ^PP is used in place of a 
      conventional place mark to avoid a problem that arises when 
      a paragraph starts on a line immediately below a page break 
      in a document created with WordStar 5.5C, 6.0 or 7.0.  In 
      that situation, a conventional place mark will not remain 
      properly positioned when the next command comes into play.    
   ^QH^M<SP><SP> enters two blank spaces on the line above the             
      home paragraph.  (See note 24.)
   ^F^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the 
      last line of the home paragraph, enters two blank spaces at 
      the end of the line and deletes any excess blank spaces.              
      (See note 22.)  
   ^QH^PP^G finds and erases the place mark left in the home 
      sentence by ^PP. 
   ^QF<SP><SP>^MB^M finds two blank spaces ahead of the sentence.
   ^F^QG<SP>^A^KB moves the cursor to the start of the home       
      sentence and enters a begin-block marker.  (See note 23.)
   ^KH dissolves any block highlighting.  (See note 14.)  
   ^QF<SP><SP>^M^Y^M finds the first of two blank spaces after       
      the home sentence.  (See note 24.)
   ^D^D^KK advances the cursor two spaces and marks the end of a 
      block.  
.pm1
27. SentBlk-2 (7.0): Sub Main
              WSQuiet (On)
              Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>")
              Key ("^QF^PP{TAB}^Y{F10}^G")
              Key ("^QF<SP><SP>{TAB}B{F10}")
              Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH")
              WSQuiet (Off)
              PauseForInput ("<SP>", 'Press Spacebar to block.')
              WSQuiet (On)
              Key ("^PP^B^S^S^QD<SP><SP>^A")
              Key ("^QF<SP>{TAB}^Y{F10}^D^D^QY")
              Key ("^QF^PP{TAB}B{F10}^G")
              Key ("^QF<SP><SP>{TAB}^Y{F10}^D^D^KK")
              WSQuiet (Off)
              End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)  
    Key ("^PP leaves a place mark in the home sentence.  (See       
      note 26.)
   ^QF^P^M^P^J{TAB}B{F10}<SP><SP>") finds the Return just above       
      the home paragraph and leaves two blank spaces.  (See note       
      19.)  
       Key ("^QF^PP{TAB}^Y{F10}^G") returns to and erases the 
      place mark.
    Key ("^QF<SP><SP>{TAB}B{F10}") finds two blank spaces ahead 
      of the home sentence.
    Key ("^F^QF<SP>{TAB}^Y{F10}^A positions the cursor at the 
      start of the home sentence.  (The sequence performs the       
      same function as ^F^QG<SP>^A in note 23.)
   ^KB marks the start of a block.
   ^KH") dissolves any block highlighting.  (See note 14.)
    WSQuiet (Off) disables the WSQuiet feature.
    PauseForInput ("<SP>", 'Press Spacebar to block.') interrupts 
      the macro so that the user can move the cursor if more than 
      one sentence is to be blocked.  The user taps the Spacebar 
      to restart the macro.
    WSQuiet (On) actuates the WSQuiet feature.
    Key ("^PP leaves a place mark in the last sentence to be 
      blocked.
   ^B^S^S^QD<SP><SP> moves the cursor to the end of the last line 
      of the paragraph and enters two blank spaces.  (See note       
      24.)
   ^A") moves the cursor to the start of the last word of the 
      paragraph.
    Key ^QF<SP>{TAB}^Y{F10}^D^D finds the first blank space at 
      the end of the line and advances the cursor two spaces.
   ^QY") deletes to the end of the line to remove any excess       
      blank spaces.  (See note 22.)
    Key ("^QF^PP{TAB}B{F10}^G") returns to and erases the place 
      mark left in the last sentence to be blocked.
    Key ("^QF<SP><SP>{TAB}^Y{F10} finds the first of two blank 
      spaces after the sentence.  
   ^D^D^KK") advances the cursor two spaces and marks the end of 
      a block.  
    WSQuiet (Off) disables the WSQuiet feature.
.pm1
28. AddSent (4.0):  ^F^D^D^KK^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
                    ^QK^QF<SP><SP>^M^M^D^D^KK 

.pm4
   ^F^D^D moves the cursor into the next sentence.
   ^KK marks a place.  (See note 23.) 
   ^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the 
      last line of the home paragraph, enters two blank spaces at 
      the end of the line and deletes any excess blank spaces.              
      (See note 22.)
   ^QK finds the ^KK place mark in the home sentence.
   ^QF<SP><SP>^M^M finds the first of two blank spaces at the end 
      of the sentence. 
   ^D^D^KK advances the cursor two spaces and marks the end of a 
      block.  



.pm1
29. AddSent (5.0):  ^OA^F^D^D^KK^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
                    ^QK^OA^QF<SP><SP>^M^Y^M^D^D^KK 

.pm4
         The macro is the same as the last one except that ^OA is 
      used twice and a ^Y is inserted between two ^M's in a       
      search routine.  (See note 24.) 
        
        
        
.pm1
30. AddSent (5.5, 6.0):  ^F^D^D^KK^B^S^S^QD<SP><SP>^A^QG<SP>^D^D
                         ^QY^QK^QF<SP><SP>^M^Y^M^D^D^KK 

.pm4
         The macro is the same as the last one except that two 
      ^OA's are omitted here.  



.pm1
31. MvSents (7.0):  Sub Main
            WSQuiet (On)
            Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>") 
            Key ("^QF^PP{TAB}^Y{F10}^G")
            Key ("^QF<SP><SP>{TAB}B{F10}")
            Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH^K2^KH")
            WSQuiet (Off)
            PauseForInput ("<SP>", 'Press Spacebar to block.')
            WSQuiet (On)
            Key ("^PP^B^S^S^QD<SP><SP>")
            Key ("^A^QF<SP>{TAB}^Y{F10}^D^D^QY")
            Key ("^QF^PP{TAB}B{F10}^G")
            Key ("^QF<SP><SP>{TAB}^Y{F10}^D^D^KK")
            WSQuiet (Off)
            PauseForInput ("<SP>", 'Press Spacebar to move.')
            Key ("^KV^B^Q2^K2^B^QB^KH")
            End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)
    Key ("^PP leaves a place mark in the home sentence.  (See       
      note 26.) 
   ^QF^P^M^P^J{TAB}B{F10}<SP><SP>") finds the Return above the       
      home paragraph and enters two blank spaces.  (See note 19.) 
    Key ("^QF^PP{TAB}^Y{F10}^G") returns to and erases the place       
      mark.
    Key ("^QF<SP><SP>{TAB}B{F10}") finds two blank spaces ahead 
      of the home sentence.
    Key ("^F^QF<SP>{TAB}^Y{F10}^A moves the cursor to the start 
      of the home sentence.  (The sequence performs the same       
      function as ^F^QG<SP>^A in note 23.)
   ^KB marks the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^K2^KH") leaves a place mark and dissolves any block 
      highlighting created by the ^K2 mark.
    WSQuiet (Off) disables the WSQuiet feature.
    PauseForInput ("<SP>", 'Press Spacebar to block.') interrupts 
      the macro so that the user can move the cursor if more than 
      one sentence is being blocked.  The cursor must be 
      positioned in the last sentence to be blocked.  The macro 
      restarts when the user presses the Spacebar.
    WSQuiet (On) actuates the WSQuiet feature. 
    Key ("^PP leaves a place mark in the last sentence to be 
      blocked.
   ^B^S^S^QD<SP><SP>") moves the cursor to the end of the last 
      line of the paragraph and enters two blank spaces.  (See       
      note 24.)
    Key (^A^QF<SP>{TAB}^Y{F10} moves the cursor back a word, then 
      finds the first blank space at the end of the line.
   ^D^D advances the cursor two spaces.
   ^QY") deletes to the end of the line to remove any excess       
      blank spaces.  (See note 22.)
    Key ("^QF^PP{TAB}B{F10}^G") finds and deletes the place mark 
      in the last sentence to be blocked.
    Key ("^QF<SP><SP>{TAB}^Y{F10} finds the first of two blank 
      spaces after the home sentence.
   ^D^D^KK") advances the cursor two spaces and marks the end of 
      a block.  
    WSQuiet (Off) disables the WSQuiet feature.
    PauseForInput ("<SP>", 'Press Spacebar to move.') interrupts 
      the macro so that the user can reposition the cursor at the 
      location to which the block is to be moved.
    Key ("^KV moves the block.  
   ^B reforms the paragraph in which the block has been inserted.
   ^Q2^K2 returns to and erases the place mark left before the 
      block was moved.  
   ^B reforms the paragraph from which the block was moved.
   ^QB^KH") returns the cursor to the paragraph in which the 
      block has been inserted and dissolves the block 
      highlighting.



.pm1
32. WordBlk (4.0, 5.x, 6.0):  ^D^A^KB^KH^F^KK

.pm4
   ^D^A moves the cursor forward one space, then back to the       
      start of the word to be blocked.  (The ^D is needed when                   the macro is executed with the cursor on the first 
      character of the word.  The cursor must be advanced before 
      the ^A comes into play.  Otherwise, ^A will move the cursor 
      to the start of the previous word.)
   ^KB marks the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^F advances the cursor to the start of the next word.        
      Exception:  If the word to be blocked is the last one on a       
      line, the cursor merely moves to the end of the line. 
   ^KK marks the end of a block.  
        
        

.pm1
33. WordBlk (7.0):  Sub Main
            Key ("^D^A^KB^KH")
            PauseForInput ("<SP>", 'Press Spacebar to block.')
            Key ("^F^KK")
            End Sub 

.pm4
    Key ("^D^A^KB finds the first character of the word at the       
      cursor and marks the start of a block.  (See note 32.)
   ^KH") dissolves any block highlighting.  (See note 14.)
    PauseForInput ("<SP>", 'Press Spacebar to block.') interrupts 
      the macro so that the user can place the cursor on the last 
      word to be blocked.  The macro restarts when the user 
      presses the Spacebar.  
    Key ("^F^KK") moves the cursor, usually to the start of the 
      next word, and marks the end of a block.  (If the cursor is 
      on the last word of a line, ^F moves it to the end of the 
      line.)  



.pm1
34. AddWord (4.0, 5.x, 6.0):  ^F^KK

.pm4
   ^F advances the cursor.  (See Key ("^F^KK") in the previous 
      note.)
   ^KK marks a new block ending. 



.pm1
35. MvMisc (7.0):  Sub Main
           Key ("^D^A^KB^KH^K2^KH")
           PauseForInput ("<SP>", 'Press Spacebar to block.')
           Key ("^F^KK")
           PauseForInput ("<SP>", 'Press Spacebar to move.')
           Key ("^KV^B^Q2^K2^B^QB^KH")
           End Sub

.pm4
    Key ("^D^A^KB finds the first character of the word at the       
      cursor and marks the start of a block.  (See note 32.)
   ^KH dissolves any block highlighting.  (See note 14.)
   ^K2^KH") leaves a place mark and dissolves any highlighting       
      created by the mark.
    PauseForInput ("<SP>", 'Press Spacebar to block.') interrupts       the macro so that the user can move to the cursor to the 
      last word to be blocked.  The macro restarts when the user 
      presses the Spacebar. 
    Key ("^F^KK") advances the cursor, usually to the start of       
      the next word, and marks a block ending.  The remaining 
      commands perform as described in note 31.



.pm1
36. Bold (4.0, 5.x, 6.0):  ^D^A^PB^T^PB^S^U^F

.pm4
   ^D^A finds the first character of the word at the cursor.        
      (See note 32.)
   ^PB enters a print-control symbol ahead of the word.
   ^T deletes the word.
   ^PB enters a second print-control symbol.
   ^S moves the cursor back a space, placing it between the       
      two print-control symbols.
   ^U undeletes the word, leaving it enclosed by the two symbols.  
      (Deleting and undeleting the word makes it possible to 
      position the second print-control symbol in the space       
      immediately after the word to be boldfaced.  The 
      ^PB^T^PB^S^U sequence could be shortened to ^PB^F^PB, but       
      the second print-control symbol would then be positioned at       
      the start of the next word.  That could cause a problem if             
      another macro was run with the cursor on the next word.)
   ^F moves the cursor to the start of the next word.  



.pm1
37. Bold (7.0):  Sub Main
                 Key ("^D^A^PB^T^PB^S^U^F")
                 End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
             
           
           
.pm1
38. XBold (4.0, 5.5, 6.0):  ^K2^QH^B^G^Q2^K2^KH^PB^T^S^U^F

.pm4
   ^K2 leaves a place mark.
   ^QH^B^G finds and erases the print-control symbol at the end 
      of the last boldfaced word.
   ^Q2^K2 returns to the original cursor position and deletes the       
      place mark.
   ^KH dissolves any block highlighting created by ^K2.
   ^PB enters a print-control symbol.
   ^T deletes to the end of the word at the cursor. 
   ^S^U moves the cursor back a space and restores the deleted 
      characters.  This leaves the print-control symbol in the       
      space immediately after the last word in the boldface 
      string.  
   ^F advances the cursor to the start of the next word.  
        
        
.pm1
39. XBold (5.0):  ^OA^K2^QH^B^G^Q2^K2^KH^OA^PB^T^S^U^F 

.pm4
         The macro is the same as the last one except that two       
      ^OA's are added.  (See note 24.)
        
        
        
.pm1
40. XBold (7.0):  Sub Main
                  WSQuiet (On)
                  Key ("^K2^QF^PB{TAB}B{F10}^G^Q2^K2^KH")
                  Key ("^PB^T^S^U^F")
                  WSQuiet (Off)
                  End Sub

.pm4
         The macro differs in format from the one described in       
      note 38 but performs the same functions.  The search       
      command ^QF is used here in place of ^QH (see note 19), and       
      the WSQuiet feature is added (see note 4).



.pm1
41. SBold (4.0):  ^K2^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG<SP>
                  ^D^D^QY^Q2^K2^QF<SP><SP>^MB^M^F^QG<SP>^A^PB
                  ^QF<SP><SP>^M^M^PB 

.pm4
   ^K2 leaves a place mark.
   ^QH^M<SP><SP> leaves two blank spaces ahead of the home             
      paragraph.  (See note 24.)
   ^F^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the 
      last line of the home paragraph, leaves two blank spaces at 
      the end of the line and deletes any excess blank spaces.        
      (See note 22.)
   ^Q2^K2 finds and erases the place mark left in the home 
      sentence.
   ^QF<SP><SP>^MB^M^F^QG<SP>^A^PB finds the start of the home       
      sentence and enters a boldface print-control symbol.  (See                   
      note 23.)  
   ^QF<SP><SP>^M^M^PB finds the first of two blank spaces after 
      the home sentence and enters a boldface print-control 
      symbol.  
             
           

.pm1
42. SBold (5.0):  ^OA^K2^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG
                  <SP>^D^D^QY^Q2^K2^OA^QF<SP><SP>^MB^M^F^QG<SP>
                  ^A^PB^QF<SP><SP>^M^Y^M^PB 

.pm4
         The macro is the same as the last one except that ^OA       
      is used twice and a ^Y is inserted between two M's in a             
      search routine.  (See note 24.)
        
.pa
.pm1
43. SBold (5.5):  ^K2^OJ^QH^M^Y^A<SP><SP>^F^B^S^S^QD<SP><SP>^A
                  ^QG<SP>^D^D^QY^Q2^K2^QF<SP><SP>^MB^M^F^QG<SP>
                  ^A^PB^QF<SP><SP>^M^Y^M^PB 

.pm4
   ^K2 leaves a place mark.
   ^OJ^QH^M^Y^A<SP><SP> leaves two blank spaces ahead of the home             
      paragraph.  (See notes 18 and 25.)  The remaining commands       
      are the same as those described in the previous note except             
      that ^OA is not used here after ^Q2^K2. 



.pm1
44. SBold (5.5C, 6.0):  ^PP^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A^QG
                        <SP>^D^D^QY^QH^PP^G^QF<SP><SP>^MB^M^F^QG
                        <SP>^A^PB^QF<SP><SP>^M^Y^M^PB 

.pm4
   ^PP leaves a place mark.  (See note 26.)
   ^QH^M<SP><SP> leaves two blank spaces above the home             
      paragraph.  (See note 24.)
   ^F^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the 
      last line of the paragraph, enters two blank spaces and 
      deletes any excess spaces.  (See note 14.)  
   ^QH^PP^G returns to and erases the ^PP place mark in the home       
      sentence.  The remaining commands perform as described in       
      note 41.


        
.pm1
45. SBold (7.0):  Sub Main
                  WSQuiet (On)
                  Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>")
                  Key ("^F^B^S^S^QD<SP><SP>")
                  Key ("^A^QF<SP>{TAB}^Y{F10}^D^D^QY")
                  Key ("^QF^PP{TAB}B{F10}^G")
                  Key ("^QF<SP><SP>{TAB}B{F10}")
                  Key ("^F^QF<SP>{TAB}^Y{F10}^A^PB")
                  Key ("^QF<SP><SP>{TAB}^Y{F10}^PB")
                  WSQuiet (Off)
                  End Sub

.pm4
         The macro differs from the last one in format but       
      performs the same functions.  The ^QF search command is       
      used here in place of ^QG and ^QH (see note 19), and the       
      WSQuiet feature is added (see note 4).  
             
         
         
.pm1
46. PBold (4.0, 5.5C, 6.0):  ^QH^M^F^PB^B^S^S^QD<SP>^A^QG<SP>
                             ^PB^QY 

.pm4
   ^QH^M^F^PB finds a Return above the home paragraph, then moves 
      the cursor to the start of the paragraph and enters a 
      boldface print-control symbol.
   ^B^S^S^QD<SP> moves the cursor to the last line of the home 
      paragraph and enters a blank space at the end of the line.
   ^A moves the cursor backward to the first character in the 
      last word of the paragraph.
   ^QG<SP> finds the blank space right after the last word of the 
      paragraph.  (There may be more than one space after that 
      word.  The object is to position the cursor immediately 
      after the word.)  
   ^PB enters a boldface print-control symbol.
   ^QY deletes any excess blank spaces that may have been left at 
      the end of the paragraph.
       
       
       
.pm1
47. PBold (5.0):  ^OA^QH^M^F^PB^B^S^S^QD<SP>^A^QG<SP>^PB^QY^OA 

.pm4
         The macro is the same as the last one except that ^OA is       
      used here at the beginning and end.  (See note 24.)



.pm1
48. PBold (5.5):  ^OJ^QH^M^Y^S^F^PB^B^S^S^QD<SP>^A^QG<SP>^PB^QY 

.pm4
   ^OJ^QH^M^Y places the cursor above the home paragraph.  (See                   
      note 18.)
   ^S^F^PB places the cursor at the start of the first word in       
      the home paragraph and enters a boldface print-control             
      symbol.  The remaining commands perform as described in             
      note 46.
        
        
        
.pm1
49. PBold (7.0):  Sub Main
                  WSQuiet (On)
                  Key ("^QF^P^M^P^J{TAB}B{F10}^F^PB")
                  Key ("^B^S^S^QD<SP>^A")
                  Key ("^QF<SP>{TAB}^Y{F10}^PB^QY")
                  WSQuiet (Off)
                  End Sub

.pm4
         The macro performs the same functions as the one       
      described in note 46.  The ^QF search command is used here       
      in place of ^QG and ^QH (see note 19), and the WSQuiet       
      feature is added (see note 4).



.pm1
50. UnBold (4,0, 5.x, 6.0):  ^QG^B^G^L^G^L

.pm4
   ^QG^B finds the next boldface print-control symbol.  The 
      symbol will be at the start of a boldfaced word or at the 
      start of a string of boldfaced words.  
   ^G deletes the symbol.
   ^L repeats the search for a boldface print-control symbol.  
      The symbol will be at the end of a boldfaced word or at the 
      end of a string of boldfaced words.
   ^G deletes the symbol.
        
        
        
   ^L finds the boldface symbol at the start of the next       
      boldfaced string.



.pm1
51. UnBold (7.0):  Sub Main
                   WSQuiet (On)
                   Key ("^QF^PB{TAB}^Y{F10}^G^L^G^L}")
                   WSQuiet (Off)
                   End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The ^QF search command is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added.  



.pm1
52. Ital (4.0, 5.x, 6.0):  ^D^A^PY^T^PY^S^U^F

.pm4
         The macro italicizes a word.  The sequence is the same       
      as the one described in note 36 except for the print-      
      control symbols.
        


.pm1
53. Ital (7.0):  Sub Main
                 Key ("^D^A^PY^T^PY^S^U^F")
                 End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
54. XItal (4.0, 5.5, 6.0):  ^K2^QH^Y^G^Q2^K2^KH^PY^T^S^U^F

.pm4
         The macro extends an italics string.  The sequence is       
      the same as the one described in note 38 except for the       
      print-control symbol. 



.pm1
55. XItal (5.0):  ^OA^K2^QH^Y^G^Q2^K2^KH^OA^PY^T^S^U^F 

.pm4
         The macro is the same as the one described in note 39             
      except for the print-control symbol.  
        
.pa
.pm1
56. XItal (7.0):  Sub Main
                  WSQuiet (On)
                  Key ("^K2^QF^PY{TAB}B{F10}^G^Q2^K2^KH")
                  Key ("^PY^T^S^U^F")
                  WSQuiet (Off)
                  End Sub

.pm4
         The macro differs in format from the one described in       
      note 54 but perform the same functions.  The search command       
      ^QF is used here in place of ^QH (see note 19), and the       
      WSQuiet feature is added (see note 4).
                  


.pm1
57. UpCase-1 (4.0, 5.x, 6.0):  ^QK^K"^KH 

.pm4
   ^QK finds the end of a marked block.
   ^K" uppercases the words in the block.  
   ^KH dissolves the block highlighting.  



.pm1
58. UpCase-1 (7.0):  Sub Main
                     Key ("^QK^K""^KH")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  



.pm1
59. LoCase-1 (4.0):  ^QK^K'^KH

.pm4
   ^QK finds the end of a marked block.
   ^K' lowercases the words in the block.
   ^KH dissolves the block highlighting.  



.pm1
60. LoCase-1 (5.x, 6.0):  ^QK^K.^KH

.pm4
   ^QK finds the end of a marked block.
   ^K. lowercases all letters in the block except first letters 
      of sentences and the letter I when that letter is used       
      standing alone.  
   ^KH dissolves the block highlighting.  
        


.pm1
61. LoCase-1 (7.0):  Sub Main
                     Key ("^QK^K.^KH")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  
.pm1
62. UpCase-2 (4.0, 5.x, 6.0):  ^KK^QB^D^A^S^KB^QK^F^KK^K"^KH

.pm4
   ^KK marks the end of a block.  The ^KK is used as a place 
      mark.  
   ^QB returns the cursor to a begin-block marker left by the 
      user in the first word to be uppercased.
   ^D^A^S^KB marks the start of a new block in front of the word.
   ^QK finds the ^KK end-block marker in the last word to be 
      uppercased.  
   ^F^KK moves the end-block marker to the right of the word.
   ^K" uppercases the words in the block.
   ^KH dissolves the block highlighting. 

     

.pm1
.rm 67
63. UpCase-2 (7.0): Sub Main
             Key ("^D^A^KB^KH")
             PauseForInput ("<SP>", 'Press Spacebar to uppercase.')
             Key ("^F^KK^K""^KH")
             End Sub

.pm4
.rm 65
    Key ("^D^A^KB finds the first character in the word at the       
      cursor and marks the start of a block.  (See note 32.)
   ^KH") dissolves any block highlighting.  (See note 14.)
    PauseForInput ("<SP>", 'Press Spacebar to uppercase.') 
      interrupts the macro so that the user can move the cursor 
      to the last word to be uppercased.  The macro restarts when 
      the user presses the Spacebar. 
    Key ("^F^KK moves the cursor to the start of the next word 
      and marks the end of a block.
   ^K""^KH") uppercases the block and dissolves the block 
      highlighting. 



.pm1
64. LoCase-2 (4.0):  ^KK^QB^D^A^S^KB^QK^F^KK^K'^KH

.pm4
         The macro works like the one described in note 62 except       
      that the block is lowercased.  



.pm1
65. LoCase-2 (5.x, 6.0):  ^KK^QB^D^A^S^KB^QK^F^KK^K.^KH

.pm4
         The macro is the same as the last one except that ^K.       
      is used in place of ^K' to lowercase the block.  (See ^K.       
      in note 60.)
        


.pm1
66. LoCase-2 (7.0):  Sub Main
                     Key ("^D^A^KB^KH")
                     PauseForInput ("<SP>")
                     Key ("^F^KK^K.^KH")
                     End Sub

         The macro works like the one described in note 63 except       
      that the block is lowercased.  



.pm1
67. AltFont (4.0):  ^QS.PS OFF^M.RM80^M.CW10^M.PO12^M 

.pm4

   ^QS makes sure the cursor is at the left margin.   
   .PS OFF^M switches off proportional font (if it's on), then       
      executes a Return. 
   .RM80^M sets the right margin at column 80, then executes a 
      Return. 
   .CW10^M sets character width at 10/120ths of an inch, then 
      executes a Return. 
   .PO12^M sets the page offset at 12 spaces, then executes a 
      Return.  



.pm1
68. NorFont (4.0):  ^QS.PS OFF^M.RM65^M.CW12^M.PO8^M 

.pm4
   ^QS.PS OFF^M performs as described in the previous note.
   .RM65^M sets the right margin at column 65, then executes a 
      Return. 
   .CW12^M sets character width at 12/120ths of an inch, then 
      executes a Return. 
   .PO8^M sets the page offset at eight spaces, then executes a 
      Return. 
        
        
        
.pm1
69. ProFont (4.0):  ^QS.PS^M.RM65^M.PO14^M. 

.pm4
   ^QS makes sure the cursor is at the left margin. 
   .PS^M turns on proportional font, then executes a Return. 
   .RM65^M sets the right margin at column 65, then executes a 
      Return. 
   .PO14^M sets the page offset at 14 spaces, then executes a 
      Return. 



.pm1
70. TsRoman (5.0):  .PO1.35"^M.RM5.40"^M^P=Times US 12^M

.pm4
   .PO1.35"^M sets the page offset at 1.35 inches and executes a 
      Return. 
   .RM5.40"^M sets the right margin at 5.40 inches and executes a 
      Return.
   ^P= displays the Directory of Fonts.
    Times US 12^M types the name of a font on the Directory of 
      Fonts prompt line and executes a Return, placing a <Times 
      US 12> font tag in the text.
        
.pm1
71. TsRoman (5.5, 6.0):  .PO1.35"^M^OFSTimes^M

.pm4
   .PO1.35"^M sets a 1.35-inch page offset and executes a Return.
   ^OFS displays the Select Paragraph Style screen.
    Times^M types a font name on the Select Paragraph Style 
      prompt line and executes a Return, placing a <Times> font 
      tag in the text.



.pm1
72. TsRoman (7.0):  Sub Main
                    Key (".PO1.35""{ENTER}^OFSTimes{F10}")
                    End Sub

.pm4
        The macro differs from the last one in format but 
      performs the same functions.



.pm1
73. BodyTxt (5.0):  ^P=COURIER 10 R8^M

.pm4
   ^P= displays the Directory of Fonts.
    COURIER 10 R8^M types a font name on the Directory of Fonts 
      prompt line and executes a Return, placing a <COURIER 10 
      R8> font tag in the text.



.pm1
74. BodyTxt (5.5, 6.0):  ^OFSBody Text^M

.pm4
   ^OFS displays the Select Paragraph Style screen.
    Body text types a font name on the Select Paragraph Style 
      prompt line and executes a Return, placing a <Body text> 
      font tag in the text.



.pm1
75. BodyTxt (7.0):  Sub Main
                    Key ("OFSBody text{F10}")
                    End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  
        
        
        
.pm1
76. DateLtr (4.0):  ^QS^[@^M^M^KR\WS4\DATECOMP^M^Y

.pm4
   ^QS makes sure the cursor is at the left margin.
   ^[@ enters the current date. 
   ^M^M executes two Returns, moving the cursor down two lines.
   ^KR\WS4\DATECOMP^M imports the file DATECOMP.
   ^Y deletes a dot command at the top of the DATECOMP file.
        
        
.pm1
77. OpenLtr (5.x):  S^KR\WS5\DATECOMP^M^QG*^Y^[@^M^M

.pm4
    S Opens a Speed Write file.
   ^KR\WS5\DATECOMP^M imports the file DATECOMP.
   ^QG*^Y finds an asterisk left in the DATECOMP file and deletes 
      the line on which the asterisk was entered.
   ^[@ enters the current date.
   ^M^M executes two Returns after the date.
       


.pm1
78. OpenLtr (6.0):  S^KR\WS\DATECOMP^M^QG*^Y^[@^M^M
.pm4

         The macro is the same as the last one except for             
      the directory designation.



.pm1
79. OpenLtr (7.0):  Sub Main
                    WSQuiet (On)
                    Key ("S^KR\WS\DATECOMP{F10}")
                    Key ("^QF*{TAB}^Y{F10}^Y^M@")
                    Key ("{ENTER}{ENTER}")
                    WSQuiet (Off)
                    End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added (see note 4). 
        
         

.pm1
80. KillBak (4.0):  R^H^K^FDEL *.BAK^M 

.pm4
         If the macro is executed at the opening menu:   
    R displays a DOS prompt.
   ^H^K^F has no effect.  
    DEL *.BAK^M deletes any files with BAK extensions.
      
         If the macro is executed with a file onscreen:
    R enters an R at the cursor.
   ^H deletes the R.  
   ^K^F displays a DOS prompt.
    DEL *.BAK^M deletes any files with BAK extensions.
        
        
        
.pm1
81. KillBak (5.0, 5.5):  R^H^FDEL *.BAK^KK^KH^QHD^KB^KY^A^KJ
                         *.BAK^M 

.pm4
         If the macro is executed at the opening menu:
    R displays a DOS prompt.
   ^H^F has no effect. 
    DEL *.BAK^K deletes any files with BAK extensions.  The       
      remaining characters in the macro have no effect.  Once ^K 
      sets the DOS command in motion, any subsequent characters       are disregarded.

         If the macro is executed with a file onscreen:
    R enters an R at the cursor.  
   ^H deletes the R.    
   ^F moves the cursor forward.  If the cursor is at the start of       
      a Tab indention when the macro is executed, the soft spaces       
      in the indention will be deleted unless the cursor is       
      advanced before the next command.  ^F makes sure the cursor 
      is safely positioned.  Whether the macro is executed at the 
      start of an indention or just above an indention, ^F will 
      jump the cursor to the next word.  
    DEL *.BAK enters the characters DEL *.BAK in the text.
   ^KK^KH marks the end of a block and dissolves any block 
      highlighting.  (See note 14.)
   ^QHD searches backward for the D in DEL *.BAK. 
   ^KB enters a begin-block marker.  DEL *.BAK is blocked. 
   ^KY deletes the block, leaving the text as it was before the       
      macro was executed.
   ^A moves the cursor backward, leaving it at or near the 
      position it occupied before it was advanced by ^F, above.  
   ^KJ*.BAK^M deletes any files with BAK extensions.



.pm1
82. KillBak (5.5C, 6.0):  R$^H^H^FDEL *.BAK^KK^KH^QHD^KB^KY^A
                         ^KJ*.BAK^M 
.pm4

         If the macro is executed at the opening menu:
    R displays a DOS prompt.
    $ enters a dollar sign, overwriting any characters previously       
      entered on the prompt line.  Unlike earlier WordStar 
      releases, WS5.5C, 6.0 and 7.0 redisplay previous entries 
      when the DOS prompt is called up.  
   ^H deletes the dollar sign, clearing the prompt line.
   ^H (repeated) has no effect.  The remaining commands       
      perform as described in the previous note. 

         If the macro is executed with a file onscreen:
    R$ enters an R and a dollar sign in the text.
   ^H^H erases the R and the dollar sign.   The remaining       
      commands perform as described in the previous note.
        
        
        
.pm1
83. KillBak (6.0D):  S^S^G^KFDEL *.BAK^M^KQN^[^[

.pm4
         If the macro is executed at the opening menu:
    S opens a Speed Write file.  The file is used as a dummy.
   ^S^G tries to move the cursor back a space and erase a 
      character but can do neither because the Speed Write file 
      is empty.
   ^KF displays a DOS prompt.  
    DEL *.BAK^M deletes all files with BAK extensions.  (The 
      remaining commands will be executed before the opening menu       is redisplayed.)  
   ^KQ orders the Speed Write file abandoned.  Since nothing has 
      been entered in the file, WordStar carries out the order 
      without asking for confirmation.  
    N calls up a screen used in opening a nondocument file.
   ^[^[ switches off the screen.
                   
         If the macro is executed with a file onscreen:
    S enters the letter S in the text.  
   ^S moves the cursor back a space.  
   ^G deletes the S. 
   ^KFDEL *.BAK^M deletes all files with BAK extensions.  (The 
      remaining commands will be executed before the file is 
      redisplayed.)  
   ^KQ orders the file abandoned.
    N countermands the ^KQ order by answering No when WordStar 
      asks if the file is to be abandoned even though changes 
      have been made in the text.  There will always have been 
      changes since the last save.  The S^S^G at the start of             
      the sequence makes sure of that.  If there were no changes,       
      WordStar would carry out the ^KQ order without asking for       
      confirmation, clearing the file from the screen.
   ^[^[ switches the Shorthand menu on and off. 
        
        
        
.pm1
84. KillBak (7.0):  Sub Main
                    SetHelpLevel (4) : AutoRestore (On)
                    Key ("{ALT+F}RDEL<SP>*.BAK{F10}{ESC}")
                    End Sub

.pm4
    SetHelpLevel (4) : sets the help level at 4.  Help level 4 is 
      used so that the macro will work whether it is executed at 
      the opening screen or at the editing screen, and whether 
      the default help level is 0, 1, 2, 3 or 4.
    AutoRestore (On) restores editing settings to their defaults 
      after the macro has run.
    Key ("{ALT+F}R displays a DOS command line.
    DEL<SP>*.BAK{F10} tells DOS to delete all BAK files in the 
      logged directory.
   {ESC}") clears the message "Press any key to return to 
      WordStar."




.pm1
85. JunkBtm-1 (4.0, 5.0, 5.5C, 6.0):  ^KS^QH^M^D^QT^Z 

.pm4
   ^KS saves the file, keeping it open.
   ^QH^M finds the Return above the home paragraph.
   ^D moves the cursor to the start of the home paragraph.
   ^QT^Z deletes to the end of the file.
        
        
.pm1
86. JunkBtm-1 (5.5):  ^KS^OJ^QH^M^Y^QT^Z

.pm4
         The macro is the same as the last one except that                   
      ^OJ^QH^M^Y is used in place of ^QH^M^D.  (See note 18.)


.pm1
87. JunkBtm-1 (7.0):  Sub Main
                      WSQuiet (On)
                      Key ("^KS^QF^P^M^P^J{TAB}B{F10}")
                      Key ("^D^QT^Z")
                      WSQuiet (Off)
                      End Sub

.pm4
         The macro performs the same functions as the one 
      described in note 83.  The ^QF search command is used here       
      in place of ^QH (see note 19), and the WSQuiet feature is       
      added (see note 4).



.pm1
88. JunkBtm-2:  ^KS^D^A^QT^Z 

.pm4
   ^KS saves the file, keeping it open.
   ^D^A finds the first character in the word at the cursor.        
      (See note 32.)
   ^QT^Z deletes to the end of the file.
        
        
        
.pm1
89. JunkBtm-2 (7.0):  Sub Main
                      Key ("^KS^D^A^QT^Z")
                      End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  
        
        
       
.pm1
90. ZapPage (5.x, 6.0):  ^QS^KB^KH^QI+^M^KK^KY

.pm4
   ^QS makes sure the cursor is at the left margin.
   ^KB marks the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QI+^M moves the cursor to the top of the next page.
   ^KK marks the end of a block.  
   ^KY deletes the block.
.pa
.mt5
.mb6
.cw12
.heHOLY MACRO!                                                #
.hm2
.fm2
.lm1
.rm65
.ls1
.po 1i
.lh8
.pl66
.ps off
.op
.fo
.op
.pn216
.lm7
91. ZapPage (7.0):  Sub Main
                    WSQuiet (On)
                    Key ("^QS^KB^KH^QI+{F10}^KK^KY")
                    WSQuiet (Off)
                    End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The WSQuiet feature is added.  
      (See note 4.)
        


.pm1
92. DownZap-1 (4.0):  ^KK^KH^QH^M<SP><SP>^QK^QF<SP><SP>^MB^M^F
                      ^QG<SP>^A^KB^B^S^S^QD^KK^KY 

.pm4
   ^KK leaves a place mark.  (See note 23.)
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QH^M<SP><SP> leaves two blank spaces on the line just above             
      the home paragraph.  If the first sentence of the paragraph       
      is to be part of the block that will be deleted, the       
      macro will need to find two spaces ahead of that sentence       
      to be able to tell where it starts.
   ^QK finds the ^KK place mark in the home sentence.  
   ^QF<SP><SP>^MB^M finds two blank spaces ahead of the home 
      sentence. 
   ^F^QG<SP>^A^KB moves the cursor forward to the first character       
      of the home sentence and marks the start of a block.  (See       
      note 23.)
   ^B^S^S^QD^KK moves the cursor to the end of the last line       
      of the paragraph and marks the end of a block.
   ^KY deletes the block.



.pm1
93. DownZap-1 (5.0):  ^OA^KK^KH^QH^M<SP><SP>^QK^OA^QF<SP><SP>^MB
                      ^M^F^QG<SP>^A^KB^B^S^S^QD^KK^KY 

.pm4
         The macro is the same as the last one except that two       
      ^OA's are added.  (See note 24.)
        


.pm1
94. DownZap-1 (5.5):  ^KK^KH^OJ^QH^M^Y^A<SP><SP>^QK^QF<SP><SP>^MB
                      ^M^F^QG<SP>^A^KB^B^S^S^QD^KK^KY 

.pm4
         The macro is the same as the WS4.0 version except that             
      ^OJ^QH^M^Y^A is used in place of ^QH^M.  (See note 18.) 
       
       
       
.pm1
95. DownZap-1 (5.5C. 6.0):  ^PP^QH^M<SP><SP>^QG^PP^G^QF<SP><SP>^M
                            ^B^M^F^QG<SP>^A^KB^KH^B^S^S^QD^KK^KY  

.pm4
   ^PP leaves a place mark.  (See note 26.)
        
   ^QH^M<SP><SP> finds the Return above the home paragraph and       
      enters two blank spaces.  (See note 24.)
   ^QG^PP^G returns to and erases the place mark in the home 
      sentence.
   ^QF<SP><SP>^M^B^M^F^QG<SP>^A finds two blank spaces ahead of 
      the home sentence, then moves the cursor to the start of       
      the sentence.  (See note 23.)
   ^KB^KH enters a begin-block marker and dissolves any block       
      highlighting.  (See note 14.)
   ^B^S^S^QD^KK^KY moves the cursor to the end of the last line 
      of the home paragraph, enters an end-block marker and 
      deletes the block.
        


.pm1
96. DownZap-1 (7.0):  Sub Main
                      WSQuiet (On)
                      Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>")
                      Key ("^QF^PP{TAB}^Y{F10}^G")
                      Key ("^QF<SP><SP>{TAB}B{F10}")
                      Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH")
                      Key ("^B^S^S^QD^KK^KY")
                      WSQuiet (Off)
                      End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The ^QF search command is       
      used here in place of ^QG and ^QH (see note 19), and the       
      WSQuiet feature is added (see note 4).



.pm1
97. DownZap-2 (4.0, 5.x, 6.0):  ^D^A^KB^KH^B^S^S^QD^KK^KY 

.pm4
   ^D^A finds the first character in the word at the cursor.              
      (See note 32.)  
   ^KB marks the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^B^S^S moves the cursor to the last line of the home 
      paragraph.
   ^QD moves the cursor to the end of the line.
   ^KK^KY marks the end of a block and deletes the block.



.pm1
98. DownZap-2 (7.0):  Sub Main
                      Key ("^D^A^KB^KH^B^S^S^QD^KK^KY")
                      End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
        
.pa
.pm1
99. NxtZap (4.0):  ^D^A^KB^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY^QB
                   ^QF<SP><SP>^M^M^KK^KY^B^QP 

.pm4
   ^D^A finds the first character in the word at the cursor.              
      (See note 32.)  
   ^KB marks the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the last       
      line of the home paragraph, enters two blank spaces at the       
      end of the line and deletes any excess blank spaces.  (See             
      notes 22 and 24.)
   ^QB finds the block marker in the home sentence.
   ^QF<SP><SP>^M^M finds the first of two blank spaces after the 
      home sentence.
   ^KK marks the end of a block.  
   ^KY deletes the block.
   ^B realigns the paragraph.
   ^QP returns the cursor to the point of execution.



.pm1
100. NxtZap (5.0):  ^OA^D^A^KB^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D
                    ^QY^QB^OA^QF<SP><SP>^M^Y^M^KK^KY 
.pm4

         The macro is the same as the last one with these 
      exceptions:
         Two ^OA's are added.  (See note 24.)
         A ^Y is used between two ^M's in a search routine.  (See             
      note 24.) 
         The ^B^QP sequence at the end of the WS4.0 macro is       
      omitted here.  The paragraph will realign automatically if       
      auto-align is on.



.pm1
101. NxtZap (5.5, 6.0):  ^D^A^KB^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D
                         ^QY^QB^QF<SP><SP>^M^Y^M^KK^KY

.pm4
         The macro is the same as the one described in note 99             
      with these exceptions:
         A ^Y is used between two ^M's in a search routine.  (See             
      note 24.)
         The ^B^QP at the end of the WS4.0 macro is omitted here.  
      The paragraph will realign automatically if auto-align is 
      on.  
     


.pm1
102. NxtZap (7.0):  Sub Main
                    WSQuiet (On)
                    Key ("^D^A^KB^KH^B^S^S^QD<SP><SP>")
                    Key ("^A^QF<SP>{TAB}^Y{F10}^D^D^QY")
                    Key ("^QB^QF<SP><SP>{TAB}^Y{F10}^KK^KY")
                    WSQuiet (Off)
                    End Sub
.pm4

         The macro differs from the last one in format but 
      performs the same functions.  The ^QF search command is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added (see note 4). 



.pm1
103. ZapGraf (4.0, 5.0, 5.5C, 6.0):  ^QH^M^KB^KH^F^B^S^S^QD^D
                                     ^KK^KY 

.pm4
         The macro is the same as the one described in note 17       
      except that a ^KY is added to delete the paragraph. 
             
           

.pm1
104. ZapGraf (5.5):  ^OJ^QH^M^Y^S^KB^KH^F^B^S^S^QD^D^KK^KY 

.pm4
         The macro is the same as the one described in note 18       
      except that a ^KY is added to delete the paragraph.  
        
        
        
.pm1
105. ZapGraf (7.0):  Sub Main
             WSQuiet (On)
             Key ("^QF^P^M^P^J{TAB}B{F10}")
             Key ("^KB^KH")
             WSQuiet (Off)
             PauseForInput ("<SP>", 'Press Spacebar to delete.')
             Key ("^F^B^S^S^QD^D^KK^KY")
             End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)
    Key ("^QF^P^M^P^J{TAB}B{F10}") finds the Return above the 
      paragraph.
    Key ("^KB^KH") marks the start of a block and dissolves any 
      block highlighting.  (See note 14.)
    WSQuiet (Off) disables the WSQuiet feature.
    PauseForInput ("<SP>", 'Press Spacebar to delete.') 
      interrupts the macro so that the user can reposition the 
      cursor, if necessary.  The macro restarts when the user 
      presses the Spacebar.
    Key ("^F^B^S^S^QD^D places the cursor below the last 
      paragraph to be erased.
   ^KK^KY") marks the end of a block and deletes the paragraph.  



.pm1
106. SentZap-1 (4.0):  ^QF<SP><SP>^MB^M^F^KB^KH^B^S^S^QD<SP><SP>
                       ^A^QG<SP>^D^D^QY^QB^QF<SP><SP>^M^M^D^D^KK
                       ^KY^B^QP

.pm4
         The macro is the same as the one described in note 22       
      except that ^KY^B^QP is added to delete the sentence,       
      realign the paragraph and reposition the cursor.  
.pm1
107. SentZap-2 (4.0):  ^KK^KH^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>^A
                       ^QG<SP>^D^D^QY^QK^QF<SP><SP>^MB^M^F^QG
                       <SP>^A^KB^QF<SP><SP>^M^M^D^D^KK^KY^B^QP 

.pm4
         The macro is the same as the one described in note 23       
      except that ^KY^B^QP is added to delete the sentence,       
      realign the paragraph and reposition the cursor.  
        
        
        
.pm1
108. SentZap-2 (5.0):  ^OA^KK^KH^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>
                       ^A^QG<SP>^D^D^QY^QK^OA^QF<SP><SP>^MB^M^F
                       ^QG<SP>^A^KB^QF<SP><SP>^M^Y^M^D^D^KK^KY 

.pm4
         The macro is the same as the one described in note 24       
      except that ^KY is added to delete the sentence.



.pm1
109. SentZap-2 (5.5):  ^KK^KH^OJ^QH^M^Y^A<SP><SP>^F^B^S^S^QD<SP>
                       <SP>^A^QG<SP>^D^D^QY^QK^QF<SP><SP>^MB^M^F
                       ^QG<SP>^A^KB^QF<SP><SP>^M^Y^M^D^D^KK^KY 

.pm4
         The macro is the same as the one described in note 25       
      except that ^KY is added to delete the sentence.
        


.pm1
110. SentZap-2 (5.5C, 6.0):  ^PP^QH^M<SP><SP>^F^B^S^S^QD<SP><SP>
                             ^A^QG<SP>^D^D^QY^QH^PP^G^QF<SP><SP>
                             ^MB^M^F^QG<SP>^A^KB^KH^QF<SP><SP>^M
                             ^Y^M^D^D^KK^KY

.pm4
         The macro is the same as the one described in note 26       
      except that ^KY is added to delete the sentence. 


       
.pm1
111. SentZap-2 (7.0):  Sub Main
                       WSQuiet (On)
                       Key ("^PP^QF^P^M^P^J{TAB}B{F10}")
                       Key ("<SP><SP>^F^B^S^S^QD<SP><SP>")
                       Key ("^A^QF<SP>{TAB}^Y{F10}^D^D^QY")
                       Key ("^QF^PP{TAB}B{F10}^G")
                       Key ("^QF<SP><SP>{TAB}B{F10}")
                       Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH") 
                       Key ("^QF<SP><SP>{TAB}^Y{F10}^D^D^KK^KY")
                       WSQuiet (Off)
                       End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)
    Key ("^PP leaves a place mark.  (See note 26.)
   ^QF^P^M^P^J{TAB}B{F10}") finds the Return above the home       
      paragraph.  (See note 19.)
    Key ("<SP><SP> leaves two blank spaces.  (See note 24.)
   ^F^B^S^S^QD<SP><SP>") moves the cursor to the end of the last 
      line of the home paragraph and leaves two blank spaces.
    Key ("^A^QF<SP>{TAB}^Y{F10} moves the cursor back one word, 
      then finds the first of the two spaces at the end of the 
      line.  
   ^D^D^QY") advances the cursor two spaces and deletes any       
      excess blank spaces.  (See note 22.)
    Key ("^QF^PP{TAB}B{F10}^G") returns to and erases the place 
      mark in the home sentence.
    Key ("^QF<SP><SP>{TAB}B{F10}") finds two blank spaces ahead 
      of the home sentence.
    Key ("^F^QF<SP>{TAB}^Y{F10}^A moves the cursor to the start       
      of the home sentence.  (The sequence performs the same       
      function as ^F^QG<SP>^A in note 23.)
   ^KB^KH") enters a begin-block marker and dissolves any block 
      highlighting.  (See note 14.)
    Key("^QF<SP><SP>{TAB}^Y{F10} finds the first of two blank 
      spaces after the home sentence.
   ^D^D^KK^KY") advances the cursor two spaces, enters an end-
      block marker and deletes the sentence.  
    WSQuiet (Off) disables the WSQuiet feature.



.pm1
112. JunkTop-1 (4.0, 5.x, 6.0):  ^KS^B^KK^KH^QR^KB^KY 

.pm4
   ^KS saves the file, keeping it open.
   ^B positions the cursor below the home paragraph.
   ^KK marks the end of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QR moves the cursor to the top of the file.
   ^KB marks the start of a block.  
   ^KY deletes the block.
        
        
        
.pm1
113. JunkTop-1 (7.0):  Sub Main
                       Key ("^KS^B^KK^KH^QR^KB^KY")
                       End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
114. JunkTop-2 (4.0, 5.x, 6.0):  ^KS^F^KK^KH^QR^KB^KY  

.pm4
   ^KS saves the file, keeping it open.
   ^F advances the cursor a word.  
   ^KK marks the end of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QR moves the cursor to the top of the file.
   ^KB marks the start of a block.  
   ^KY deletes the block.
        
.pm1
115. JunkTop-2 (7.0):  Sub Main
                       Key ("^KS^F^KK^KH^QR^KB^KY")
                       End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
        


.pm1
116. UpZap-1 (4.0):  ^KK^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY^QK
                     ^QF<SP><SP>^M^M^D^D^KK^QH^M^F^KB^KY^B^QP 

.pm4
   ^KK marks a place.  (See note 23.)
   ^KH dissolves any block highlighting.  (See note 14.)
   ^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the       
      end of the last line of the home paragraph, leaves two       
      blank spaces and deletes any excess spaces.  (See notes 22       
      and 24.)
   ^QK finds the ^KK place mark in the home sentence. 
   ^QF<SP><SP>^M^M finds the first of two blank spaces at the end 
      of the home sentence. 
   ^D^D^KK advances the cursor two spaces and marks the end of a 
      block.  
   ^QH^M finds a Return above the home paragraph. 
   ^F advances the cursor to the first word of the home 
      paragraph.
   ^KB marks the start of a block.  
   ^KY deletes the block. 
   ^B reforms the paragraph.
   ^QP moves the cursor to the beginning of the paragraph.  
        
        
        
.pm1
117. UpZap-1 (5.0):  ^OA^KK^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
                     ^QK^OA^QF<SP><SP>^M^Y^M^D^D^KK^QH^M^F^KB^KY

.pm4
         The macro is the same as the last one with these       
      exceptions:
         Two ^OA's are added and a ^Y is inserted between two       
      ^M's in a search routine.  (See note 24.)
         The ^B^QP at the end of the WS4.0 macro is omitted here.  
      The paragraph will realign itself automatically if auto-
      align is on.



.pm1
118. UpZap-1 (5.5):  ^KK^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY^QK
                     ^QF<SP><SP>^M^Y^M^D^D^KK^OJ^QH^M^Y^S^F^KB^KY

.pm4
   ^KK^KH^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY^QK performs as       
      described in note 116.
   ^QF<SP><SP>^M^Y^M finds the first of two blank spaces at the 
      end of the home sentence.
   ^D^D^KK advances the cursor two spaces and marks the end of a 
      block. 
   ^OJ^QH^M^Y moves the cursor to the left margin on the top line             
      of the home paragraph.  (See note 18.)
   ^S^F moves the cursor to the start of the first word in the       
      home paragraph.  
   ^KB^KY marks the start of a block and deletes the block.
        


.pm1
119. UpZap-1 (5.5C, 6.0):  ^PP^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY
                           ^QH^M^F^KB^KH^QG^PP^G^QF<SP><SP>^M^Y^M
                           ^D^D^KK^KY

.pm4
   ^PP leaves a place mark.  (See note 26.)
   ^B^S^S^QD<SP><SP>^A^QG<SP>^D^D^QY moves the cursor to the end 
      of the last line of the home paragraph, leaves two blank       
      spaces and deletes any excess spaces.  (See notes 22 and       
      24.)
   ^QH^M^F^KB finds the Return above the home paragraph, then 
      moves the cursor to the beginning of the paragraph and 
      marks the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QG^PP^G finds and deletes the ^PP place mark in the home       
      sentence.
   ^QF<SP><SP>^M^Y^M finds the first of two blank spaces after 
      the home sentence.
   ^D^D^KK advances the cursor two spaces and marks the end of a 
      block.  
   ^KY deletes the block.
        
        
        
.pm1
120. UpZap-1 (7.0):  Sub Main
                     WSQuiet (On)
                     Key ("^PP^B^S^S^QD<SP><SP>")
                     Key ("^A^QF<SP>{TAB}^Y{F10}")
                     Key ("^D^D^QY^QF^P^M^P^J{TAB}B{F10}")
                     Key ("^F^KB^KH^QF^PP{TAB}^Y{F10}^G")
                     Key ("^QF<SP><SP>{TAB}^Y{F10}^D^D")
                     Key ("^KK^KY")
                     WSQuiet (Off)
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG and ^QH (see note 19), and the       
      WSQuiet feature is added (see note 4).



.pm1
121. UpZap-2 (4.0):  ^F^KK^KH^QH^M^F^KB^KY^B^QP 

.pm4
   ^F advances the cursor a word.
   ^KK marks the end of a block. 
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QH^M finds the Return above the home paragraph. 
   ^F moves the cursor to the start of the home paragraph. 
   ^KB marks the start of a block.  
   ^KY deletes the block. 
   ^B reforms the paragraph. 
   ^QP moves the cursor to the start of the paragraph.
             


.pm1
122. UpZap-2 (5.0):  ^F^KK^KH^QH^M^F^KB^KY 

.pm4
         The macro is the same as the last one except that the 
      ^B^QP at the end is omitted here.  The paragraph will 
      realign itself if auto-align is on.  



.pm1
123. UpZap-2 (5.5):  ^F^KK^KH^OJ^QH^M^Y^S^F^KB^KY

.pm4
   ^F^KK advances the cursor a word and marks the end of a block.
   ^OJ^QH^M^Y places the cursor at the left margin on the top       
      line of the home paragraph.  (See note 18.) 
   ^S^F moves the cursor to the start of the first word in the       
      home paragraph.  
   ^KB marks the start of a block.  
   ^KY deletes the block.



.pm1
124. UpZap-2 (5.5C, 6.0):  ^F^PP^QH^M^F^KB^KH^QG^PP^G^KK^KY

.pm4
   ^F^PP advances the cursor a word and leaves a place mark.              
      (See note 26.)
   ^QH^M^F^KB finds the Return above the home paragraph, moves 
      the cursor to the first word of the home paragraph and 
      marks the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QG^PP^G finds and deletes the ^PP place mark left in the home       
      sentence.
   ^KK marks the end of a block.  
   ^KY deletes the block.



.pm1
125. UpZap-2 (7.0):  Sub Main
                     WSQuiet (On)
                     Key ("^F^PP^QF^P^M^P^J{TAB}B{F10}")
                     Key ("^F^KB^KH^QF^PP{TAB}^Y{F10}^G")
                     Key ("^KK^KY")
                     WSQuiet (Off)
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG and ^QH (see note 19), and the       
      WSQuiet feature is added (see note 4). 
.pm1
126. PvsZap (4.0):  ^KK^KH^QH^M<SP><SP>^QK^QF<SP><SP>^MB^M^F^QG
                    <SP>^A^KB^QK^F^KK^KY^B^QP 

.pm4
   ^KK leaves a place mark.  (See note 23.)    
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QH^M<SP><SP> leaves two blank spaces on the line above the       
      home paragraph.  If the home sentence is the first one in a       
      paragraph, the macro will need to find two spaces ahead of 
      that sentence to be able to tell where it starts.
   ^QK finds the ^KK place mark in the home sentence.
   ^QF<SP><SP>^MB^M finds two blank spaces ahead of the home             
      sentence.
   ^F^QG<SP>^A moves the cursor to the start of the home                   
      sentence.  (See note 23.)
   ^KB marks the start of a block.  
   ^QK again finds the ^KK place mark in the home sentence.
   ^F advances the cursor a word.  
   ^KK marks the end of a block. 
   ^KY deletes the block.
   ^B^QP reforms the paragraph and returns the cursor to the 
      point of deletion.



.pm1
127. PvsZap (5.0):  ^OA^KK^KH^QH^M<SP><SP>^QK^QF<SP><SP>^MB^M^F
                    ^QG<SP>^A^KB^QK^OA^F^KK^KY 

.pm4
         The macro is the same as the last one except that two       
      ^OA's are added (see note 24) and the ^B^QP at the end of 
      the WS4.0 sequence is omitted here.  ^B is not needed to 
      reform the paragraph because it will reform itself. 



.pm1
128. PvsZap (5.5):  ^KK^KH^OJ^QH^M^Y^A<SP><SP>^QK^QF<SP><SP>^MB^M
                    ^F^QG<SP>^A^KB^QK^F^KK^KY 

.pm4
   ^KK marks the end of a block.  
   ^KH dissolves any block highlighting.  (See note 14.)
   ^OJ^QH^M^Y^A<SP><SP> leaves two blank spaces on the line above             
      the home paragraph.  (See note 18.)  If the macro is       
      executed in the first sentence of a paragraph, it will need             
      to find two spaces ahead of that sentence to be able to             
      tell where it begins.  
   ^QK returns the cursor to the ^KK block marker. 
   ^QF<SP><SP>^MB^M^F^QG<SP>^A^KB^QK^F^KK^KY performs as             
      described in note 126.



.pm1
129. PvsZap (5.5C, 6.0):  ^PP^QH^M<SP><SP>^QG^PP^QF<SP><SP>^MB^M
                          ^F^QG<SP>^A^KB^KH^QG^PP^G^F^KK^KY 

.pm4
   ^PP leaves a place mark.  (See note 26.) 
   ^QH^M<SP><SP> leaves two blank spaces on the line above the                   home paragraph.  (See note 24.)
   ^QG^PP finds the ^PP place mark in the home sentence.  
   ^QF<SP><SP>^MB^M finds two blank spaces ahead of the home       
      sentence.
   ^F^QG<SP>^A moves the cursor to the start of the home                   
      sentence.  (See note 23.)
   ^KB marks the start of a block. 
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QG^PP^G finds and deletes the ^PP place mark in the home       
      sentence.
   ^F^KK advances the cursor a word and marks the end of a block.  
   ^KY deletes the block.



.pm1
130. PvsZap (7.0):  Sub Main
                    WSQuiet (On)
                    Key ("^PP^QF^P^M^P^J{TAB}B{F10}<SP><SP>")
                    Key ("^QF^PP{TAB}^Y{F10}")
                    Key ("^QF<SP><SP>{TAB}B{F10}")
                    Key ("^F^QF<SP>{TAB}^Y{F10}^A^KB^KH")
                    Key ("^QF^PP{TAB}^Y{F10}^G^F^KK^KY")
                    WSQuiet (Off)
                    End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG and ^QH (see note 19), and the       
      WSQuiet feature is added (see note 4).



.pm1
131. WordZap (4.0): ^D^A^T^B^QP 

.pm4
   ^D^A finds the start of the word at the cursor.  (See note       
      32.)  If the cursor is in a space between words, it moves       
      to the beginning of the last word back.  
   ^T deletes the word.
   ^B^QP reforms the paragraph and returns the cursor to the 
      point of deletion.  



.pm1
132. WordZap (5.x, 6.0):  ^D^A^T

.pm4
         All commands perform as described in the previous note.  



.pm1
133. WordZap (7.0):  Sub Main
                     Key ("^D^A^T")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
.pm1
134. ADirect (4.0):  R^H^K^FDIR A: | SORT | MORE^M 

.pm4
         If the macro is executed at the opening menu:
    R displays a DOS prompt.
   ^H^K^F has no effect.  
    DIR A: | SORT | MORE^M displays a sorted list of the files on 
      Drive A one screenful at a time.

         If the macro is executed with a file onscreen:
    R enters an R in the text.
   ^H erases the R.
   ^K^F displays a DOS prompt.
    DIR A: | SORT | MORE^M displays a sorted list of the files on 
      Drive A one screenful at a time.



.pm1
135. ADirect (5.0, 5.5):  R^H^FDIR A: | SORT | MORE^KK^KH^QHD
                         ^KB^KY^A^KFDIR A: | SORT | MORE^M 

.pm4
         If the macro is executed at the opening menu:  
    R displays a DOS prompt.  
   ^H^F has no effect. 
    DIR A: | SORT | MORE^K displays a sorted list of the files on 
      Drive A one screenful at a time.  The remaining characters 
      have no effect.  Once the ^K sets the DOS command in 
      motion, any subsequent characters are disregarded.
   
         If the macro is executed with a file onscreen:
    R enters an R in the text.  
   ^H deletes the R.   
   ^F advances the cursor a word.  
    DIR A: | SORT | MORE enters the characters DIR A: | SORT | 
      MORE in the text.
   ^KK^KH marks the end of a block and dissolves any block 
      highlighting.  (See note 14.) 
   ^QHD searches backward for the D in DIR. 
   ^KB marks the start of a block.  DIR A: | SORT | MORE is       
      blocked.  
   ^KY deletes the block, leaving the text as it was before the       
      macro was executed.
   ^A moves the cursor backward, leaving it at or near the       
      spot it occupied before it was advanced by ^F, above.
   ^KF displays a DOS prompt.
    DIR A: | SORT | MORE^M displays a sorted list of the files on 
      Drive A one screenful at a time.



.pm1
136. ADirect (5.5C, 6.0):  R$^H^H^FDIR A: | SORT | MORE^KK^KH
                          ^QHD^KB^KY^A^KFDIR A: | SORT | MORE^M 

.pm4
         The macro is the same as the last one except that a       
      dollar sign and a second ^H are added near the start of the                   
      sequence.  (See note 82.) 
        
.pm1
137. ADirect (6.0D):  S^S^G^KFDIR A: | SORT | MORE^M^KQN^[^[

.pm4
    S^S^G^KF displays a DOS prompt whether the macro is 
      executed at the opening menu or with a file onscreen.         
      (See note 83.)
    DIR A: | SORT | MORE^M displays a sorted list of the files on       
      Drive A, pausing when the screen fills.  
   ^KQN^[^[ performs as described in note 83.



.pm1
.rm 66
138. ADirect (7.0A):  Sub Main
                      Key ("S^S^G^KFDIR A: | SORT | MORE {F10}")
                      PauseForInput ("{F10}", 'Press F10.')
                      Key ("^D^KQ")
                      IfException
                      Def: Key ("N")
                      End IfException
                      End Sub

.pm4
.rm 65
         The macro is patterned after the WS60.D version.  A 
      PauseForInput function is added to keep some commands from       
      being processed prematurely.  An IfException clause is       
      added to supply an N keystroke, if needed. 

        

.pm1
139. ADirect (7.0C):  Sub Main
                      SetHelpLevel (4) : AutoRestore (On)
                      Key ("{ALT+F}RDIR A: | SORT | MORE {F10}")
                      End Sub 

.pm4
    SetHelpLevel (4) : sets the help level at 4.  (See note 84.)
    AutoRestore (On) restores editing settings to their defaults 
      after the macro has run.
    Key ("{ALT+F} displays a pulldown screen.
    R displays a DOS command line.
    DIR A: | SORT | MORE {F10}") tells DOS to display the file 
      list on Drive A in sorted form, one screenful at a time.  



.pm1
140. ViewCee (4.0):  R^H^K^FCDIR^M 

.pm4
    R^H^K^F displays a DOS prompt whether the macro is run at the       
      opening menu or with a file onscreen.  (See note 134.) 
    CDIR^M runs the commands in the batch file CDIR.
        
.pa
.pm1
141. ViewCee (5.0, 5.5):  R^H^FCDIR^KK^KH^QHC^KB^KY^A^KF
                          CDIR^M 

.pm4
         If the macro is executed at the opening menu:   
    R displays a DOS prompt.
   ^H^F has no effect.
    CDIR^K runs the batch file CDIR.  The remaining characters 
      have no effect.  Once the DOS command is set in motion by 
      ^K, all subsequent commands are ignored.

         If the macro is executed with a file onscreen:
    R enters an R in the text.
   ^H deletes the R.
   ^F advances the cursor a word.  
    CDIR enters the characters CDIR in the text. 
   ^KK^KH marks the end of a block and dissolves any block 
      highlighting.  (See note 14.)
   ^QHC^KB searches backward for the C in CDIR and marks the 
      start of a block.  CDIR is blocked.
   ^KY deletes the block, leaving the text as it was before the       
      macro was executed.  
   ^A moves the cursor backward, leaving it at or near the 
      position it occupied before it was advanced by ^F, above.  
   ^KFCDIR^M displays a DOS prompt and runs the batch file CDIR. 



.pm1
142. ViewCee (5.5C, 6.0):  R$^H^H^FCDIR^KK^KH^QHC^KB^KY^A^KF
                           CDIR^M 

.pm4
         The macro is the same as the last one except that a       
      dollar sign and a second ^H are added near the start of the                   
      sequence.  (See note 82.)



.pm1
143. ViewCee (6.0D):  S^S^G^KFCDIR^M^KQN^[^[

.pm4
    S^S^G^KF displays a DOS prompt whether the macro is executed 
      at the opening menu or with a file onscreen.  (See note 
      83.)
    CDIR^M runs the commands in the batch file CDIR.  
   ^KQN^[^[ performs as described in note 83.
        
        
        
.pm1
144. ViewCee (7.0A):  Sub Main
                      Key ("S^S^G^KFCDIR{F10}")
                      PauseForInput ("{F10}", 'Press F10.') 
                      Key ("^D^KQ")
                      IfException
                      Def: Key ("N")
                      End IfException
                      End Sub
     
.pm4

         The macro is the same as the WS7.0A version of ADirect       
      (note 138) except that ^KFCDIR is used in place of ^KFDIR       
      A: | SORT | MORE.  ^KFCDIR tells DOS to run a batch file.  



.pm1
145. ViewCee (7.0C):  Sub Main
                      SetHelpLevel (4) : AutoRestore (On)
                      Key ("{ALT+F}RCDIR{F10}")
                      End Sub

.pm4
         The macro is the same as the WS7.0C version of ADirect 
      (note 139) except that it runs a batch file called CDIR.  
      (See text.)



.pm1
146. LogMain (4.0):  ^KD^ML\WS4^M 

.pm4
         If the macro is executed at the opening menu:
   ^KD displays a screen used in opening a file.  (WordStar 
      disregards the ^K in ^KD and takes the D to mean that a       
      file is to be opened.) 
   ^M switches off the open-file screen.
    L\WS4^M logs on to the main WordStar directory. 

         If the macro is executed with a file onscreen:
   ^KD saves the file.
   ^M has no effect.
    L\WS4^M logs on to the main WordStar directory.



.pm1
147. LogMain (5.0, 5.5):  ^R^K^DL\WS5^M  
.pm4

         If the macro is executed at the opening menu:
   ^R displays a DOS prompt.
   ^K switches off the prompt.
   ^D is not read by WordStar.
    L\WS5^M logs on to the main WordStar directory.  

         If the macro is executed with a file onscreen:
   ^R moves the cursor up one screen (or to the top of the file 
      if the top is less than a screen away).
   ^K^D saves the file.
    L\WS5^M logs on to the main WordStar directory.  



.pm1
148. LogMain (5.5C):  ^R$^H^K^DL\WS5^M 

.pm4
         The macro is the same as the last one except that a 
      dollar sign and ^H are added near the start of the             
      sequence.  (See note 82.)  
.pl68
.pm1
149. LogMain (6.0):  ^R$^H^K^DL\WS^M 

.pm4
         The macro is the same as the last one except for the       
      directory designation.



.pm1
150. LogMain (7.0):  Sub Main
                     WSQuiet (On)
                     Key ("{F10}L\WS{F10}")
                     WSQuiet (Off)
                     End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature. (See note 4.)
    Key ("{F10} executes a save if a file is onscreen.  If the       
      macro is executed at the opening menu, F10 has no effect.  
    L\WS{F10}") logs on to the main WordStar directory. 
    WSQuiet (Off) disables the WSQuiet feature.        
                   
        

.pm1
151. LogBiz (4.0):  ^KD^ML\WS4\BIZ^M 

.pm4
            The macro is the same as the WS4 version of LogMain       
      except for the directory designation. 



.pm1
152. LogBiz (5.0, 5.5):  ^R^K^DL\WS5\BIZ^M 

.pm4
            The macro is the same as the WS5.0/5.5 version of       
      LogMain except for the directory designation.
        
        
        
.pm1
153. LogBiz (5.5C):  ^R$^H^K^DL\WS5\BIZ^M 

.pm4
            The macro is the same as the WS5.5C version of         
      LogMain except for the directory designation.



.pm1
154. LogBiz (6.0):  ^R$^H^K^DL\WS\BIZ^M 

.pm4
         The macro is the same as the WS6.0 version of LogMain 
      except for the directory designation.
        
        
        
.pm1
155. LogBiz (7.0):  Sub Main
                    WSQuiet (On)
                    Key ("{F10}L\WS\BIZ{F10}")
                    WSQuiet (Off)
                    End Sub

.pm4
         The macro is the same as the WS7.0 version of LogMain 
      except for the directory designation.
.pl66
.pm1
156. Omit (4.0):  ^PV^PV.^PO.^PO.<SP>^B^QP 

.pm4
   ^PV^PV enters the characters ^V^V.  
   .^PO.^PO. enters three ellipsis dots, preceding the second and       
      third with binding-space characters so that all three dots       
      will remain on the same line if copy is shifted around       
      during editing.
   <SP> enters a blank space.
   ^B^QP reforms the paragraph and returns the cursor to the 
      point of execution. 
        
        
        
.pm1
157. Omit (5.x, 6.0):  ^PV^PV.^PO.^PO.<SP> 

.pm4
         The macro is the same as the last one except that the       
      ^B^QP at the end is omitted here.  The paragraph will 
      reform itself if auto-align is on.



.pm1
158. Omit (7.0):  Sub Main
                  Key ("^PV^PV.^PO.^PO.<SP>")
                  End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
        


.pm1
159. Go2Page (4.0, 5.x, 6.0):  ^K1^KH^QI

.pm4
   ^K1^KH leaves a hidden place mark.  If there is a hidden block 
      in the text, entering ^K1 will re-highlight the block.  ^KH 
      extinguishes any highlighting.
   ^QI displays a screen used to find a specified page.



.pm1
160. Go2Page (7.0):  Sub Main
                     Key ("^K1^KH^QI")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
161. Footsie-1:  (4.0):  ^QS.LS1^M____________________^M.LS2^M
                         ^QH_^F^M^M

.pm4
   ^QS makes sure the cursor is at the left margin.
   .LS1^M sets line spacing at 1 and executes a Return. 
   ____________________^M enters a 20-space-wide ruled line below 
      the .LS1 and executes a Return. 
   .LS2^M enters a double-spacing dot command and executes a 
      Return. 
   ^QH_^F searches backward for the last character of the ruled 
      line, places the cursor on that character and then moves 
      the cursor forward so that it is clear of the line.  (This 
      sequence leaves the cursor above the .LS2 dot command 
      entered earlier.) 
   ^M^M executes two Returns, placing the cursor two lines below 
      the ruled line.  (.LS2, which will restore double spacing 
      after the footnote, remains below the cursor.  It is pushed 
      down one line each time a line is added to the text of the 
      footnote.)
        
        
        
.pm1
.rm 70
162. Footsie-2 (4.0):  ^QS.LS1^M.RM80^M.CW10^M____________________^M 
                       .LS2^M.RM65^M.CW12^M^QH_^F^M^M 

.pm4
.rm 65
   ^QS.LS1^M makes sure the cursor is at the left margin, sets       
      line spacing at 1 and executes a Return.
   .RM80^M moves the right margin to column 80 and executes a       
      Return.
   .CW10^M changes character width from 12/120ths of an inch       
      (pica font) to 10/120ths of an inch (elite font). 
   ____________________^M.LS2^M performs as described in the 
      previous note.
   .RM65^M returns the right margin to column 65.  (The .RM65 
      will be below the cursor while the text of the footnote is       
      entered.) 
   .CW12^M restores character width to 12/120ths of an inch.      
      (The .CW12 also will be below the cursor while the       
      footnote is entered.)
   ^QH_^F^M^M performs as described in the previous note. 



.pm1
163. Footsie-3 (4.0):  ^QS.LS1^M.RM80^M____________________^M^M
                       ^PT^PT^M.LS2^M.RM65^M^QH^T 

.pm4
   ^QS.LS1^M.RM80^M performs as described in the previous       
      note.
   ____________________^M performs as described in note 161.  
   ^M executes a Return.  
   ^PT switches on superscript printing.  
   ^PT (repeated) stands by to switch off superscript printing at 
      the end of the footnote. 
   ^M executes a Return.
   .LS2^M sets line spacing at 2 and executes a Return.
   .RM65^M returns the right margin to column 65 and executes a 
      Return.
   ^QH^T searches backward for the second ^T.  The cursor lands 
      on that ^T and pushes it along as the text of the footnote 
      is entered.  At the end of the footnote, the second ^T 
      switches off superscript printing.
          
.pm1
164. WideHd:  ^QS.XW1B0E1B67^M.XR1B50^M^PW^PR^M^QH^R 

.pm4
   ^QS makes sure the cursor is at the left margin.
   .XW1B0E1B67^M enters custom print-control code and executes       
      a Return.  The code is entered in dot-command form.  It       
      temporarily replaces any other print-control code       
      assigned to the W key. 
   .XR1B50^M enters code used to switch off a head font and       
      then executes a Return.  The code temporarily replaces       
      any other print-control code assigned to the R key. 
   ^PW^PR enters the characters used in the text to enclose the       
      head.  Only the ^W and ^R show onscreen.
   ^M executes a Return.
   ^QH^R moves the cursor to the ^R following the ^W.  The ^R is 
      pushed along as the head is typed and winds up at the end 
      of the line, in position to switch off the head font when 
      the file is printed.
             


.pm1
165. SubHd:  ^QS.XE1B0E1B0F^M.XR1B50^M^PE^PR^M^QH^R 

.pm4

         The macro performs the same function as WideHd (above), 
      except that it uses a different print-control key (E) and 
      enters code for a smaller head.
        
        

.pm1
166. DblHd:  ^QS.XW1B0E1B67^M.XE1B0E1B0F^M.XR1B50^M 

.pm4
         The macro combines the .XW and .XE code used in the             
      two previous macros, and incorporates the .XR code used             
      to switch off both head fonts.



.pm1
167. DownBar (4.0, 5.x, 6.0):  ^QS^KB^KH^QD^KK^F^F

.pm4
   ^QS^KB makes sure the cursor is at the left margin and marks 
      the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)  
   ^QD^KK moves the cursor to the right margin and marks the end 
      of a block.  
   ^F^F moves the cursor to the next line down.



.pm1
168. DownBar (7.0):  Sub Main
                     HideDots (On) : AutoRestore (On)
                     Key ("^QS^KB^KH^QD^KK^F^F")
                     End Sub

.pm4
         The macro differs from the last one in format but       
      performs the same functions.  The HideDots feature is added       to hide dot commands, and AutoRestore is used to restore       
      the editing settings in effect before the command was run.  
        
        
        
.pm1
169. UpBar (4.0, 5.x, 6.0):  ^QD^KK^KH^QS^KB^A^A

.pm4
   ^QD^KK moves the cursor to the right margin and marks the end 
      of a block.
   ^KH dissolves any block highlighting.  (See note 14.)  
   ^QS^KB moves the cursor to the left margin and marks the start 
      of a block.  
   ^A^A moves the cursor to the next line up. 
        
        
        
.pm1
170. UpBar (7.0):  Sub Main
                   HideDots (On) : AutoRestore (On)
                   Key ("^QD^KK^KH^QS^KB^A^A")
                   End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
        


.pm1
171. DownBlk (4.0, 5.x, 6.0):  ^QH^M^D^KB^KH^B^S^S^QD<SP>^A^QG
                               <SP>^KK^QD^F^F

.pm4
   ^QH^M finds the Return above the home paragraph.
   ^D^KB moves the cursor to the beginning of the home paragraph       
      and marks the start of a block. 
   ^KH dissolves any block highlighting.  (See note 14.)
   ^B^S^S^QD<SP> positions the cursor at the end of the last line 
      of the home paragraph and enters a blank space.
   ^A^QG<SP> moves the cursor backward to the start of the last       
      word of the paragraph, then finds the blank space       
      immediately after the last word.  
   ^KK marks the end of a block.  
   ^QD moves the cursor to the right end of the line.  This 
      command is needed to position the cursor correctly if 
      excess blank spaces have been left at the end of the       
      paragraph.
   ^F^F advances the cursor to the next paragraph.



.pm1
172. DownBlk (7.0):  Sub Main
                     HideDots (On) : WSQuiet (On)
                     AutoRestore (On)
                     Key ("^QF^P^M^P^J{TAB}B{F10}")
                     Key ("^D^KB^KH^B^S^S^QD<SP>^A")
                     Key ("^QF<SP>{TAB}^Y{F10}^KK")
                     Key ("^QD^F^F")
                     End Sub
.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG and ^QH (see note 19), and the       
      HideDots, WSQuiet and AutoRestore features are added.        
      HideDots hides dot commands, WSQuiet performs as described       
      in note 4 and AutoRestore restores the editing settings in       
      effect before the macro was run.



.pm1
173. UpBlk (4.0, 5.x, 6.0):  ^QH^M^D^KB^KH^B^S^S^QD<SP>^A^QG<SP>
                             ^KK^QB^QS^A^A
.pm4

   ^QH^M^D^KB^KH^B^S^S^QD<SP>^A^QG<SP>^KK performs as described       
      in note 171.
   ^QB finds the begin-block marker at the start of the home 
      paragraph.
   ^QS moves the cursor to the left margin on the top line of the 
      paragraph.  If the paragraph is unindented, the cursor will 
      already be at the margin, and ^QS will have no effect.
   ^A^A moves the cursor to the next paragraph up. 
        


.pm1
174. UpBlk (7.0):  Sub Main
                   Key ("^QF^P^M^P^J{TAB}B{F10}")
                   Key ("^D^KB^KH^B^S^S^QD<SP>")
                   Key ("^A^QF<SP>{TAB}^Y{F10}^KK")
                   Key ("^QB^QS^A^A")
                   End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used in place of ^QG and ^QH.  (See note 19.)
        
        
        
.pm1
175. BakFile (4.0):  ^QS^KB^K3^N^N^X^X^K4^KK^E^KPN^R^M^M^U^KR^R^M 

.pm4
   ^QS makes sure the cursor is at the left margin.      
   ^KB^K3 marks the start of a block and enters a place mark.
   ^N^N inserts two blank lines below the cursor.
   ^X^X moves the cursor down two lines.
   ^K4^KK enters a place mark and marks the end of a block.
   ^E moves the cursor up a line, placing it inside the block.
   ^KPN^R^M^M^U displays a print screen, repeats the name of the       
      file being edited, executes two Returns, then switches off       
      the print screen.  If the file WOMBAT is onscreen and the       
      user has imported a file or exported a block before running 
      BakFile, the name of the imported file or exported block 
      will have replaced WOMBAT as the filename in memory.  But 
      the name of the active file can always be called up on the 
      print screen.  ^KPN^R^M^M^U borrows that name from the 
      print screen to make sure the right name is in memory.  
   ^KR displays a screen used in importing a file.  
   ^R^M repeats the filename WOMBAT and executes a Return.  (When 
      WordStar sees that the filename is that of the document 
      onscreen, it imports the BAK version of that file.)  



.pm1
176. Import (4.0, 5.x, 6.0):  ^QS^KB^K3^N^N^X^X^K4^KK^E^KR

.pm4
         All commands perform as described in the previous note.



.pm1
177. Import (7.0):  Sub Main
                    Key ("^QS^KB^K3^N^N^X^X^K4^KK^E^KR")
                    End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
178. ImpBoil (4.0):  ^QS^KB^N^N^X^X^KK^E^KR\WS4\BOIL\

.pm4
   ^QS^KB^N^N^X^X^KK^E performs functions described in note 175.  
      (Two place marks used by the macro described in that note       
      are omitted here.)  
   ^KR displays a screen used to import a file.
   \WS4\BOIL\ identifies the directory from which the file is to 
      be imported.
        


.pm1
179. ImpBoil (5.x):  ^QS^KB^N^N^X^X^KK^E^KR\WS5\BOIL\ 

.pm4
         The macro is the same as the last one except for the 
      directory designation.
        


.pm1
180. ImpBoil (6.0):  ^QS^KB^N^N^X^X^KK^E^KR\WS\BOIL\ 

.pm4
        The macro is the same as the one described in note 178 
      except for the directory designation.



.pm1
181. ImpBoil (7.0):  Sub Main
                     Key ("^QS^KB^N^N^X^X^KK^E^KR\WS\BOIL\")
                     End Sub

.pm4

         The macro performs the same functions as the one       
      described in note 178, using a different format and       
      different directory designation.  
        
.pm1
182. Indent-1 (4.0):  ^QS.LM6^M.RM60^M

.pm4
   ^QS makes sure the cursor is at the left margin.
   .LM6^M sets the left margin at column 6 and executes a Return.
   .RM60^M sets the right margin at column 60 and executes a 
      Return.



.pm1
183. Indent-1 (5.x, 6.0):  ^QS.RR1^M

.pm4
   ^QS makes sure the cursor is at the left margin.
   .RR1 tells WordStar to indent the left and right margins one-half 
      inch each.
   ^M executes a Return, leaving the .RR1 dot command on a line 
      by itself.  
        


.pm1
184. Indent-1 (7.0):  Sub Main
                      Key ("^QS.RR1{ENTER}")
                      End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
185. Outdent-1 (4.0):  ^QS.LM1^M.RM65^M

.pm4
         The macro restores the previous margins.  
       


.pm1
186. Outdent-1 (5.x, 6.0):  ^QS.RR0^M

.pm4
         The macro restores the previous margins.  



.pm1
187. Outdent-1 (7.0):  Sub Main
                       Key ("^QS.RR0{ENTER}")
                       End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
188. Indent-2 (4.0):  ^QH^M^D.LM6^M.RM60^M.PM6^M^B^QP 

.pm4
   ^QH^M searches backward for a Return.   
   ^D advances the cursor to the next line.  
   .LM6^M sets the left margin at six spaces and executes a 
      Return.
        
   .RM60^M sets the right margin at 60 spaces and executes a       
      Return.
   .PM6^M sets the paragraph margin at 6 and executes a Return.
   ^B reforms the paragraph below the dot commands, so that it 
      conforms to the new margin settings.  (If Indent-2 is 
      executed below the last line of text in a file, there is no 
      paragraph to reform, and ^B has no effect.)
   ^QP returns the cursor to the start of the paragraph.  (If the 
      macro is executed below the last line of text in a file, 
      ^QP has no effect.)



.pm1
189. Indent-2 (5.x, 6.0):  ^QH^M^D.RR1^M

.pm4
   ^QH^M finds the Return above the home paragraph.  (If the 
      macro is executed below the last line of text in a file, it 
      finds the Return after the last paragraph.)
   ^D advances the cursor to the next line.
   .RR1^M indents the margin on either side and executes a 
      Return.  Text in the paragraph below the dot command is 
      reformed.  (If the macro is executed below the last line of 
      text in a file, it controls the margins when a paragraph is 
      added to the file.)  



.pm1
190. Indent-2 (7.0):  Sub Main
                      WSQuiet (On)
                      Key ("^QF^P^M^P^J{TAB}B{F10}^D.RR1{ENTER}")
                      WSQuiet (Off)
                      End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QH (see note 19), and the WSQuiet       
      feature is added (see note 4).
        
        
        
.pm1
191. Outdent-2 (4.0):  ^QH^M^D.LM1^M.RM65^M.PM0^M^B^QP

.pm4
         The macro restores normal margins after Indent-2 is used 
      to set indented margins.  
        


.pm1
192. Outdent-2 (5.x, 6.0):  ^QH^M^D.RR0^M

.pm4
         The macro restores normal margins after Indent-2 is used 
      to set indented margins.  
        
.pa
.pm1
193. Outdent-2 (7.0):  Sub Main
                       WSQuiet (On)
                       Key ("^QF^P^M^P^J{TAB}B{F10}^D.RR0{ENTER}")
                       WSQuiet (Off)
                       End Sub

.pm4
.rm 65
         The macro restores normal margins after Indent-2 is used 
      to set indented margins.  



.pm1
194. Hanger (4.0):  ^QS.PM1^M.LM4^M

.pm4
   ^QS makes sure the cursor is at the left margin.
   .PM1^M sets the paragraph margin at one space and executes a 
      Return. 
   .LM4^M sets the left margin at four spaces and executes a 
      Return.
        
        

.pm1
195. Hanger (5.x, 6.0):  ^QS.PM0.0"^M.LM0.3"^M

.pm4
   ^QS makes sure the cursor is at the left margin.
   .PM0.0"^M sets the paragraph margin at zero inches and 
      executes a Return. 
   .LM0.3"^M sets the left margin at 0.3 inches and executes a 
      Return.



.pm1
196. Hanger (7.0):  Sub Main
                    Key ("^QS.PM0.0""{ENTER}.LM0.3""{ENTER}")
                    End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
        
        
         
.pm1
197. HoldBlk (4.0):  ^KH^F^D^B^S^S^QD^D^KK^QB^X^QS^N---->^N^KW
                      $^M^KFY^KF^Y^M^X^Y^Y^KFCOPY<SP>HOLD+$<SP>
                      HOLD^M 

.pm4
   ^KH dissolves any block highlighting.  (See note 14.)
   ^F^D^B^S^S^QD moves the cursor to the end of the last line of 
      the paragraph.  
   ^D^KK positions the cursor on the line below the paragraph and 
      marks the end of a block.  
   ^QB returns the cursor to the beginning of the block.  
   ^X moves the cursor down a line.
   ^QS^N inserts a blank line.
    ----> enters a separator mark on the blank line.
   ^N leaves a blank line below the separator mark.
   ^KW$^M orders the block sent to a file called $. 
   ^KFY^KF^Y^M answers Yes if WordStar interrupts to ask whether       
      a previous version of the file $ should be overwritten.  
      WordStar disregards the first ^KF in the sequence because 
      it is waiting for a Y or N answer.  The Y after ^KF 
      confirms that the file is to be overwritten.  The second 
      ^KF displays a DOS prompt.  The ^Y after the second ^KF has 
      no effect.  ^M switches off the DOS prompt so that the 
      sequence can continue.  If WordStar does not ask whether to 
      overwrite because there is no previous version of the file 
      $, the first ^KF in ^KFY^KF^Y^M displays a DOS prompt.  Y 
      and the second ^KF enter a Y and an F on the prompt line.  
      Then ^Y^M clears the prompt line and switches off the DOS 
      prompt.  A single Y could be used in place of ^KFY^KF^Y^M 
      if WordStar always asked whether to overwrite a previous             
      version of the file.  But if the macro was being executed             
      for the first time, the question would not arise, and the Y             
      would be unspent.  Result:  It would print in the text.  
      The ^KFY^KF^Y^M sequence hides the Y on a DOS prompt line 
      so that it can't print. 
   ^X moves the cursor down a line in the onscreen file.
   ^Y^Y deletes the line on which the separator mark was left, 
      then erases a blank line left below the mark.   
   ^KF displays a DOS prompt.
    COPY HOLD+$ HOLD^M tells DOS to append a copy of the       
      file $ to a file called HOLD and to use HOLD as the name of       
      the combined file.  If there is not already a HOLD file,       
      the macro creates one and copies $ to that file.



.pm1
198. HoldBlk (5.x, 6.0):   ^KH^F^D^B^S^S^QD^D^KK^OA^QB^X^QS^N
                            ---->^N^KWHOLD^M^A^X^Y^Y^OA 

.pm4
   ^KH^F^D^B^S^S^QD^D^KK performs as described in the previous 
      note.
   ^OA switches off auto-align.  Line spacing may be disturbed if             
      auto-align is left on.
   ^QB^X^QS^N---->^N performs as described in the previous note.
   ^KWHOLD^M^A orders the block sent to a file called HOLD.  If 
      such a file already exists, the ^A at the end of 
      ^KWHOLD^M^A tells WordStar to append the block to that 
      file.  If such a file does not exist, WordStar won't ask 
      whether to append and the ^A will be unspent.  It will 
      merely move the cursor backward one word or less in the 
      onscreen file.  (Ordinarily, an A is not preceded by a 
      control character when used to tell WordStar to append.  
      But if the control character ahead of A is omitted here, 
      and if WordStar doesn't ask whether to append, the A will 
      print at the cursor in the text.) 
   ^X^Y^Y performs as described in the previous note.
   ^OA switches auto-align back on. 
        
.pa
        
.pm1
199.  HoldBlk (7.0): Sub Main
              WSQuiet (On)
              Key ("^QF^P^M^P^J{TAB}B{F10}^KB^KH^F")
              WSQuiet (Off)
              PauseForInput ("<SP>", 'Press Spacebar to copy.')
              WSQuiet (On)
              Key ("^B^S^S^QD^D^KK^OA^QB^X^QS^N---->^N")
              Key ("^KWHOLD{F10}")
              IfException
              Def: Key ("A")
              End IfException 
              Key ("^X^Y^Y^OA")
              WSQuiet (Off)
              End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)
    Key ("^QF^P^M^P^J{TAB}B{F10}^KB finds the Return above the 
      home paragraph and marks the start of a block.  (See note       
      19.)
   ^KH dissolves any block highlighting.  (See note 14.)
   ^F)" moves the cursor into the home paragraph.  
    WSQuiet (Off) disables the WSQuiet feature.
    PauseForInput ("<SP>", 'Press Spacebar to copy.') interrupts 
      the macro so that the user can move the cursor, if 
      necessary.  The cursor must be positioned in the last 
      paragraph to be blocked.  The macro restarts when the user 
      presses the Spacebar. 
    WSQuiet (On) actuates the WSQuiet feature.
    Key ("^B^S^S^QD^D^KK places the cursor below the last 
      paragraph to be blocked and marks the end of a block.
   ^OA temporarily switches off auto-align.  Line spacing may be 
      disturbed if auto-align is left on.
   ^QB returns the cursor to the start of the block.
   ^X^QS^N moves the cursor down a line and inserts a blank line.
    ---->^N") enters a separator mark and inserts a blank line 
      below the mark.
    Key ("^KWHOLD{F10}") orders a copy of the block sent to a 
      file called HOLD.
    IfException introduces an IfException clause.
    Def: Key ("A") supplies a response if WordStar interrupts the 
      macro to ask a question.  If a HOLD file exists, the 
      question will be whether to append the block to that file 
      or overwrite.  The A in Key ("A") selects the append 
      option.
    End IfException terminates the IfException clause.
    Key ("^X moves the cursor down a line in the onscreen file.
   ^Y^Y deletes the line on which the separator mark was left, 
      then erases a blank line left below the mark.   
   ^OA") switches auto-align back on.
    WSQuiet (Off) disables the WSQuiet feature.
        
.pa
        
.pm1
200. SglSpc (4.0):  ^QS.LS1^M 

.pm4
   ^QS makes sure the cursor is at the left margin.
   .LS1^M sets line spacing at 1 and executes a Return.  
       
       
       
.pm1
201. DblSpc (4.0):  ^QS.LS2^M 

.pm4
         The macro is the same as the last one except for the       
      line-spacing number.



.pm1
202. Mark (4.0, 5.x, 6.0):  ^K1^KH 

.pm4
   ^K1 leaves a place mark.
   ^KH hides the mark.  (See note 159.)  
        


.pm1
203. Mark (7.0):  Sub Main
                  Key ("^K1^KH")
                  End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  



.pm1
204. YMark (4.0, 5.x, 6.0): ^Q1^K1^KH 

.pm4
   ^Q1^K1 finds and erases a ^K1 place mark. 
   ^KH extinguishes any block highlighting.  (See note 159.)



.pm1
205. YMark (7.0):  Sub Main
                   Key ("^Q1^K1^KH")
                   End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
206. TopFile (4.0, 5.x, 6.0): ^K1^KH^QR

.pm4
   ^K1 leaves a place mark.
   ^KH hides the mark.  (See note 159.)
   ^QR moves the cursor to the top of the file.
        
.pa
.pm1
207. TopFile (7.0):  Sub Main
                     Key ("^K1^KH^QR")             
                     End Sub 

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
        
        

.pm1
208. BtmFile (4.0, 5.x, 6.0):  ^K1^KH^QC

.pm4
   ^K1 leaves a place mark.
   ^KH hides the mark.  (See note 159.) 
   ^QC moves the cursor to the bottom of the file.



.pm1
209. BtmFile (7.0):  Sub Main
                     Key ("^K1^KH^QC")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
210. LMargin (4.0, 5.x, 6.0): ^K1^KH^QS

.pm4
   ^K1 leaves a place mark.
   ^KH hides the mark.  (See note 159.)   
   ^QS moves the cursor to the left margin.



.pm1
211. LMargin (7.0):  Sub Main
                     Key ("^K1^KH^QS")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
212. RMargin (4,0, 5.x, 6.0):  ^K1^KH^QD

.pm4
   ^K1 leaves a place mark.
   ^KH hides the mark.  (See note 159.)
   ^QD moves the cursor to the right margin.



.pm1
213. RMargin (7.0):  Sub Main
                     Key ("^K1^KH^QD")
                     End Sub
     
.pm4

         The macro differs from the last one in format but 
      performs the same functions.



.pm1
214. Mv2Main (4.0):  ^KQE^R^M\WS4\^R^M

.pm4
   ^KQ orders the file abandoned.
    E displays the rename-file screen at the opening menu.
   ^R^M displays the filename WOMBAT on the top line of the 
      rename-file screen and executes a Return.
   \WS4\^R^M enters the path of the main WordStar directory, 
      redisplays the filename WOMBAT and executes a Return.  If 
      there is already a file named WOMBAT in the main directory, 
      WordStar displays an error message.  



.pm1
215. Mv2Main (5.0):  ^KT\WS5\^R^ME^T^T^M$^MRDEL $^M 

.pm4
         If the file WOMBAT is being moved and there is no file       
by that name in the destination directory:   
   ^KT orders the file saved under a different name.
   \WS5\^R^M identifies the destination directory, appends the 
      filename WOMBAT to the directory designation and enters a 
      Return, starting the copying process.  The opening menu in 
      the source directory is displayed after the copy is made.
    E calls up a rename-file screen in the source directory.  The 
      name \WS5\WOMBAT is displayed.  
   ^T^T deletes the \WS5\ from the filename.  The object is to 
      display the name of the WOMBAT file in the source 
      directory.  That is the file to be renamed.  
   ^M enters a Return, displaying the prompt line on which the 
      new name is to be entered.
    $ identifies the new filename as $.  
   ^M enters a Return, completing the name change.
    RDEL $^M deletes the file $ (formerly WOMBAT) in the             
      source directory.  The filename has been changed because             
      DOS would otherwise have no way of knowing which file to             
      delete.  Renaming the file gives the macro a known filename 
      to enter on the DOS prompt line.  (The DOS file-delete 
      command DEL is used in place of the WordStar delete       
      command Y because Y would cause a malfunction if there were 
      already a file called WOMBAT in the destination directory.        
      Reason:  If WordStar finds a file by the same name in the       
      destination directory, it interrupts to ask whether to       
      overwrite and waits for a Y or N answer.  But it does not       
      interrupt unless it has worked its way through the rest of       
      the macro sequence without finding a Y or an N.  If a Y       
      is used later in the sequence, WordStar will find it--      
      and take it to mean that the file in the destination       
      directory is to be overwritten.)  
        
.pa
         If there is already a file named WOMBAT in the       
destination directory: 
   ^KT\WS5\^R performs the same function as when there is no file 
      named WOMBAT in the destination directory.
   ^M executes a Return.  WordStar interrupts to ask if the       
      WOMBAT file in the destination directory should be       
      overwritten.  The user types N to prevent an overwrite.        
        
        
        
.pm1
216. Mv2Main (5.5):  ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS5\^M^X
                     ^KB<SP>^E^KK^KY^KR^T^T^M^KD^KQE^T^T^M$
                     ^MY$^M 

.pm4
         If the file WOMBAT is being moved and there is no file       
by that name in the destination directory:
   ^OK displays a screen used in opening a window.  
   ^F^F^F^F^A<SP>^A^H^A^H^A^T makes sure the filename displayed 
      on the window screen is in proper form.  If the file has 
      just been printed, the filename will include a  path--e.g.,       
      C:\WS5\BIZ\WOMBAT.  The ^F^F^F^F^A<SP>^A^H^A^H^A^T       
      sequence performs a series of cursor movements and       
      deletions to strip the path from the filename, so that it       
      comes out WOMBAT.  Unless the path is removed, the macro 
      will later misfire.  The path-stripping sequence works       
      whether the path consists of a directory name only or a       
      directory name and a subdirectory name.  (How it works can       
      best be seen by entering the sequence from the keyboard       
      after displaying a print screen with ^KPP.)
   \WS5\^M enters a directory designation ahead of the filename       
      WOMBAT and executes a Return.  A file named \WS5\WOMBAT is 
      opened in the window.  The directory designation \WS5\ is       
      used ahead of WOMBAT so that the file will be stored in the       
      main WordStar directory when saved. 
   ^X^KB<SP>^E^KK^KY probes the \WS5\WOMBAT file to make sure it       
      contains no text.  Since there is no such file in the 
      destination directory, no text will be found.  The ^X at 
      the start of the ^X^KB<SP>^E^KK^KY sequence tries to move 
      the cursor down a line, but there is no second line to move 
      to, so the cursor remains on line 1.  ^KB<SP> marks the 
      start of a block and enters a blank space.  ^E tries to 
      move the cursor up a line, but there is no higher line to 
      move to, so the cursor remains on line 1.  ^KK marks the 
      end of a block.  ^KY deletes the block, leaving the 
      \WS5\WOMBAT file empty.  (Had the file contained text, the 
      blocking procedure would have failed, and the macro would 
      have been interrupted, as will be described later.) 
   ^KR tells WordStar a file is to be imported.  The name       
      \WS5\WOMBAT is displayed on a prompt line.
   ^T^T deletes the \WS5\ ahead of WOMBAT.  
   ^M executes a Return.  The file WOMBAT is imported.  Because 
      the directory designation has been stripped from the       
      filename, the copy of WOMBAT in the source directory is       
      copied into the window.  It is the file that was onscreen       
      before the window was opened. 
   ^KD saves the imported file, storing it in the main WS5 
      directory.  The window closes.
   ^KQ abandons the file that was onscreen when the macro was       
      executed.  The opening menu is displayed. 
    E displays a screen used in renaming a file.  The WOMBAT file 
      in the source directory will be renamed so that it can be 
      erased.  \WS5\WOMBAT appears on a prompt line.    
   ^T^T deletes the \WS5\.  The name WOMBAT is now displayed.
   ^M executes a Return, sending the cursor to the line on which             
      the new filename will be entered.
    $^M enters the filename $ and executes a Return, completing             
      the name change.
    Y$^M deletes the file $, formerly WOMBAT.  (The file has been             
      given a new name because Mv2Main would otherwise have             
      no way of deleting the file.  When the file-delete command       
      Y is entered at the opening menu, no filename appears on       
      the screen.  Renaming the file gives the macro a known       
      filename to enter on the file-delete screen.) 

         If there is already a file named WOMBAT in the             
destination directory:
   ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS5\^M performs as described       
      above.  The macro has just opened a file called WOMBAT in       
      the destination directory.    
   ^X^KB<SP>^E^KK^KY probes the file to see if it contains any       
      text.  If there were no text in the file, the macro would       
      be able to proceed, as described earlier.  But because the       
      file contains text, the ^X^KB<SP>^E^KK^KY sequence forces       
      the macro to fail.  The ^X at the start of the sequence       
      moves the cursor down a line.  ^KB<SP> marks the start of a       
      block and enters a blank space.  ^E moves the cursor up a       
      line.  ^KK tries to mark the end of a block, but an error       
      message flashes, telling the user that an end-block marker       
      is at or before a begin-block marker.  That signals that       
      there is already text in the file.  

      

.pm1
217. Mv2Main (6.0):  ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS\^M^X
                     ^KB<SP>^E^KK^KY^KR^T^T^M^KD^KQE^T^T^M$
                     ^MY$^M 

.pm4
         The macro is the same as the last one except for the       
      directory designation.



.pm1
218. Mv2Main (6.0D):  ^KQE^QD^A^Q<DELETE>^M\WS\^R^M

.pm4
   ^KQ orders the file abandoned.
    E displays a rename-file screen at the opening menu.
   ^QD moves the cursor to the right end of the filename WOMBAT 
      on the top line of the rename-file screen.
   ^A moves the cursor left to the start of the filename.  
   ^Q<DELETE> deletes any path ahead of the filename.
   ^M executes a Return, sending the cursor to the second line of 
      the rename-file screen.
   \WS\^R^M enters the path of the main WordStar directory, 
      places the filename WOMBAT after the path and executes a 
      Return.
        
        
        
.pm1
219. Mv2Main (7.0A):  Sub Main
             Key ("^KQE^QD^A^Q{DEL}")
             PauseForInput ("{ENTER}", ' Check filename. ')
             Key ("{TAB}\WS\^R{F10}")
             End Sub

.pm4
    Key ("^KQE closes the file and displays a rename-file 
      screen.
   ^QD^A^Q{DEL}") erases any path ahead of the displayed 
      filename.
    PauseForInput ("{ENTER}", ' Check filename. ') interrupts the 
      macro so that the user can verify that the correct filename 
      is displayed.  The macro resumes when the user presses 
      Enter. 
    Key ("{TAB} moves the cursor to the next line on the 
      rename-file screen.
   \WS\^R{F10}") enters the path of the main WordStar directory, 
      copies the filename displayed on the first line and orders 
      the file renamed. 



.pm1
220. Mv2Main (7.0C):   Sub Main
                       WSQuiet (On)
                       Key ("^KDE^QD^A^Q{DEL}{TAB}\WS\^R{F10}")
                       WSQuiet (Off)
                       End Sub

.pm4
         The macro performs essentially the same functions as the 
      last one.  The filename check is omitted because WS7.0C 
      will always display the correct name.



.pm4
.pm1
221. Mv2Biz (4.0):  ^KQE^R^M\WS4\BIZ\^R^M

.pm4
         The macro is the same as the WS4.0 version of Mv2Main       
      except for the directory designation.   
                
        

.pm1
222. Mv2Biz (5.0):  ^KT\WS5\BIZ\^R^ME^T^T^T^M$^MRDEL $^M 

.pm4
         The macro is the same as the WS5.0 version of Mv2Main       
      except for the directory designation and the number of ^T's       
      in the sequence.  (Extra characters must be deleted here, 
      so an extra ^T is used.) 
.pm1
223. Mv2Biz (5.5):  ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS5\BIZ\^M
                    ^X^KB<SP>^E^KK^KY^KR^T^T^T^M^KD^KQE^T^T^T^M$
                    ^MY$^M 

.pm4
         The macro is the same as the WS5.5 version of Mv2Main       
      except for the directory designation and the number of T's                   
      in the sequence.  (See previous note.)



.pm1
224. Mv2Biz (6.0):  ^OK^F^F^F^F^A<SP>^A^H^A^H^A^T\WS\BIZ\^M^X
                    ^KB<SP>^E^KK^KY^KR^T^T^T^M^KD^KQE^T^T^T^M$
                    ^MY$^M 

.pm4
         The macro is the same as the WS6.0 version of Mv2Main       
      except for the directory designation and the number of ^T's                   
      in the sequence.  (See note 222.)



.pm1
225. Mv2Biz (6.0D):  ^KQE^QD^A^Q<DELETE>^M\WS\BIZ\^R^M

.pm4
         The macro is the same as the WS6.0D version of Mv2Main       
      except for the directory designation.



.pm1
226. Mv2Biz (7.0A):  Sub Main
            Key ("^KQE^QD^A^Q{DEL}")
            PauseForInput ("{ENTER}", ' Check filename. ')
            Key ("{TAB}\WS\BIZ\^R{F10}")
            End Sub

.pm4
         The macro is the same as the WS7.0A version of Mv2Main 
      except for the directory designation.



.pm1
227. Mv2Biz (7.0C):  Sub Main
            WSQuiet (On)
            Key ("^KDE^QD^A^Q{DEL}{TAB}\WS\BIZ\^R")
            Key ("{F10}")
            WSQuiet (Off)
            End Sub

.pm4
         The macros is the same as the WS7.0C version of Mv2Main 
      except for the directory designation.  



.pm1
228. Go2Name (4.0):  ^QS^KB^K3^N^N^X^X^K4^KK^E^KR\WS4\NAME&AD^M
                     ^KH^QF 

.pm4
   ^QS makes sure the cursor is at the left margin near the top       
      of a document in which an address file is to be inserted.
   ^KB^K3 marks the start of a block and leaves a place mark.
   ^N^N inserts two blank lines below the cursor.
   ^X^X moves the cursor down two lines.
   ^K4^KK leaves a place mark and marks the end of a block.
   ^E moves the cursor up a line, placing it inside the block.
   ^KR\WS4\NAME&AD^M imports the address file NAME&AD.  The ^KB       
      begin-block marker and ^K3 place mark are ahead of the       
      address file.  The ^KK end-block marker and the ^K4 place       
      mark are below the file.  The address file is highlighted. 
   ^KH dissolves the highlighting and hides the place marks left 
      by ^K3 and ^K4. 
   ^QF displays a search screen so that the user can enter a name 
      to be located in the address file.



.pm1
229. Go2Name (5.x):  ^QS^OK\WS5\NAME&AD^M^QF<SP>^XU^E^G 

.pm4
   ^QS makes sure the cursor is at the left margin.
   ^OK\WS5\NAME&AD^M opens a window on the address file NAME&AD.
   ^QF<SP> displays a search screen.  A blank space (<SP>) is 
      entered after ^QF in case no other searches have been 
      conducted earlier in the work session.  Something must be 
      entered on the top line of the search screen to permit the       
      following commands to work.
   ^XU moves the cursor to the second line on the search screen       
      and enters a U, telling WordStar to disregard uppercasing       
      and lowercasing when searching for a string of characters             
      to be entered by the user. 
   ^E^G returns the cursor to the top line of the search       
      screen and deletes the blank space left earlier.  The user 
      now types the name to be located in the address file.



.pm1
230. Go2Name (6.0):  ^QS^OK\WS\NAME&AD^M^QF<SP>^XU^E^G 

.pm4
         The macro is the same as the last one except for       
      the directory designation.
        


.pm1
231. Go2Name (7.0):  Sub Main
                     WSQuiet (On)
                     Key ("^QS^OK\WS\NAME&AD{F10}")
                     WSQuiet (Off)
                     Key ("^QF<SP>^XU^E^G")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The WSQuiet feature is added.  
      (See note 4.)
.pa
.mt5
.mb6
.cw 12
.heHOLY MACRO!                                                #
.hm2
.fm2
.lm1
.rm65
.ls1
.po 1i
.lh8
.pl66
.ps off
.op
.fo
.pn251
232. CopName-1 (4.0):  ^QS^KB^QG*^E^QD^KK^E^QD^M^Q3^S^KC^Q3^K3
                       ^KB^Q4^K4^KK^KY 

.pm4
   ^QS makes sure the cursor is at the left margin on the top 
      line of an address listing.  
   ^KB marks the start of a block.
   ^QG* finds an asterisk ahead of a telephone number on the last 
      line of the listing.
   ^E moves the cursor up to the salutation line above the phone 
      number.
   ^QD^KK moves the cursor to the right margin and marks the end 
      of a block.   
   ^E moves the cursor up to the City-State-ZIP line.
   ^QD^M moves the cursor to the right margin and executes a 
      Return, leaving a blank line above the salutation line. 
   ^Q3 finds a place mark left by the Go2Name macro.  The mark is 
      at the top of the imported address file.
   ^S moves the cursor backward, forcing it up one line and 
      leaving it above the imported address file.
   ^KC copies the blocked address listing to the file that was       
      onscreen before the Go2Name and CopName-1 macros were       
      executed. 
   ^Q3^K3 finds and erases the place mark at the top of the 
      address file.
   ^KB marks the start of a new block at the beginning of the 
      address file.
   ^Q4^K4 finds and erases the place mark at the end of the 
      address file.
   ^KK^KY marks the end of a new block and deletes the block, 
      clearing the address file from the screen.



.pm1
233. CopName-1 (5.x, 6.0):  ^QS^KB^QG*^E^QD^KK^E^QD^M^OK^KA^OK
                            ^KQY

.pm4
   ^QS^KB^QG*^E^QD^KK^E^QD^M blocks the address listing.  (See 
      the previous note.)  The listing is displayed in a lower       
      window. 
   ^OK moves the cursor to the upper window.
   ^KA copies the blocked address listing to the upper window.
   ^OK^KQY closes the lower window. 
        


.pm1
234. CopName-1 (7.0):  Sub Main
                       WSQuiet (On)
                       Key ("^QS^KB^QF*{TAB}^Y{F10}^E^QD^KK")
                       Key ("^E^QD{ENTER}^OK^KA^OK^KQ")
                       IfException
                       Def: Key ("Y")
                       End IfException  
                       WSQuiet (Off)
                       End Sub
     
.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)
    Key ("^QS makes sure the cursor is at the left margin.
   ^KB marks the start of a block.
   ^QF*{TAB}^Y{F10) finds an asterisk ahead of a telephone number 
      on the last line of an address listing.
   ^E^QD moves the cursor up to the salutation line, then to the 
      end of that line.
   ^KK") marks the end of a block. 
    Key ("^E^QD{ENTER} places a blank line between the last line 
      of the address and the salutation line.
   ^OK^KA copies the address and salutation to the upper 
      window.
   ^OK^KQ") closes the lower window.
    IfException introduces an IfException clause.
    Def: Key ("Y") supplies a response (Yes) when WordStar asks 
      whether to abandon NAME&AD even though changes have been 
      made in the file.
    End IfException terminates the IfException clause.  
    WSQuiet (Off) disables the WSQuiet feature.
        
        
        
.pm1
235. CopName-2 (4.0):  ^QS^KB^QG\^G^Q<DELETE>^QD<SP>^A^QG<SP>^D^U
                       ^QF***^M^M^E^E^QD^KK^E^QD^M^QB^QG*^G^S^T^L
                       ^G^S^T^Q3^S^KC^Q3^K3^KB^Q4^K4^KK^KY^Y 

.pm4
   ^QS makes sure the cursor is at the left margin on the top       
      line of an address listing.  The following listing is used 
      for illustration:  

          Andersen\Jerald B.
          *
          *
          12345 Junipero Serra Boulevard
          Los Angeles, California 90000-0000
          Dear Mr. Andersen:
          213-000-0000
                  ***

   ^KB marks the start of a block at the beginning of the 
      address.
   ^QG\^G finds and deletes the backslash after Andersen.
   ^Q<DELETE> erases to the left margin, deleting the name 
      Andersen but holding the name in memory.
   ^QD<SP> moves the cursor to the right margin and enters a       
      blank space after Jerald B. 
   ^A moves the cursor back a word, to the middle initial B.
   ^QG<SP> searches forward for a blank space.  The command       
      ^QD<SP> (above) has left a space after Jerald B.  If the       
      user left a blank space there earlier, there will be two       
      spaces, and ^QG<SP> will find the first of the two.  
   ^D advances the cursor a space.  Whether the user has left one 
      space or none after Jerald B., the cursor is properly       
      positioned for the next command.
           
        
   ^U undeletes the last name.  The full name Jerald B. Andersen       
      now appears on the first line.  
   ^QF***^M^M finds the three asterisks on the last line of the 
      listing.
   ^E^E moves the cursor up to the Dear Mr. Andersen: line.  
   ^QD^KK moves the cursor to the end of the line and marks the 
      end of a block.  The first six lines of the listing are 
      blocked.
   ^E moves the cursor up to the Los Angeles, California 90000-
      0000 line.  
   ^QD^M moves the cursor to the end of the line and executes a 
      Return, leaving a blank line above the salutation 
      line.
   ^QB finds the ^KB block marker left at the start of the 
      listing.
   ^QG*^G finds and deletes the asterisk on the second line of 
      the listing, leaving the line empty.  If there were no 
      asterisk on that line because a title had been entered 
      there, the ^G would harmlessly delete one of the three 
      asterisks left below the phone-number line, outside the 
      marked block.
   ^S moves the cursor back a space.
   ^T removes the blank second line.  If the second line were not 
      blank, ^T would perform a harmless deletion below the 
      marked block.
   ^L repeats the ^QG* search order, finding the asterisk on the 
      third line of the listing.  If there were no asterisk on 
      that line, the cursor would move to one of the asterisks 
      left below the phone number.
   ^G deletes the asterisk, leaving the third line empty.  If 
      there were no asterisk on that line, ^G would erase one of 
      the asterisks below the phone number.   
   ^S^T moves the cursor back a space and removes the blank third 
      line.  If the third line were not blank, ^T would perform a 
      harmless deletion below the marked block.
   ^Q3 finds a place mark left by the Go2Name macro.  The mark             
      is at the top of the imported address file NAME&AD.
   ^S moves the cursor backward, forcing it up one line and 
      leaving it above the imported address file.
   ^KC places a copy of the blocked address near the top of the 
      letter file that was onscreen before the Go2Name and 
      CopName-2 macros were executed.
   ^Q3^K3 finds and erases the place mark at the top of the       
      imported address file.
   ^KB marks the start of a new block at the beginning of the 
      address file.
   ^Q4^K4 finds and erases the place mark at the end of the 
      address file.
   ^KK^KY marks the end of a new block and deletes the block, 
      clearing the address file from the screen.
   ^Y removes an unwanted blank line below the salutation.
             
.pa
.pm1
236. CopName-2 (5.x, 6.0):  ^QS^KB^QG\^G^Q<DELETE>^QD<SP>^A^QG  
                            <SP>^D^U^QF***^M^Y^M^E^E^QD^KK^E^QD
                            ^M^QB^QG*^G^S^T^L^G^S^T^OK^KA^OK^KQY 

.pm4
         The macro performs the same functions as the last one 
      except that the sequence ^Q3^S^KC^Q3^K3^KB^Q4^K4^KK^KY at 
      the end of that macro is omitted here and replaced by the 
      following:
   ^OK moves the cursor from the lower window, where an address 
      has been blocked, to the upper window.
   ^KA copies the blocked address to a letter file in the upper 
      window.
   ^OK moves the cursor to the lower window.
   ^KQY closes the lower window.



.pm1
237. CopName-2 (7.0):  Sub Main
                       WSQuiet (On)
                       Key ("^QS^KB^QF\{TAB}^Y{F10}^G^Q{DEL}")
                       Key ("^QD<SP>^A^QF<SP>{TAB}^Y{F10}")
                       Key ("^D^U^QF***{TAB}^Y{F10}^E^E^QD^KK")
                       Key ("^E^QD{ENTER}^QB^QF*{TAB}^Y{F10}^G")
                       Key ("^S^T^L^G^S^T^OK^KA^OK^KQ")
                       IfException
                       Def: Key ("Y")
                       End IfException 
                       WSQuiet (Off)
                       End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added (see note 4).



.pm1
238. PreSort (4.0, 5.x, 6.0):  ^QS^QG^M*^T^S^L*^T^S^L*^T^L*^T^L*
                               ^T^L*^T^L*^T^X^[P 

.pm4
   ^QS makes sure the cursor is at the left margin.
   ^QG^M* finds the Return after the first line of an address 
      listing and enters an asterisk as a place mark.  (The mark 
      will be used by the Rebuild macro, below.)
   ^T deletes the Return.  The second line of the listing is 
      joined to the first.
   ^S moves the cursor back a space.  
   ^L repeats the ^QG^M search order, sending the cursor to the 
      next Return.  
    * enters an asterisk as a place mark. 
   ^T^S^L*^T^L*^T^L*^T^L*^T^L*^T deletes the Return, then finds 
      and deletes the next five Returns, entering a place mark 
      between each field.  All eight fields are now on the same 
      line.
           
   ^X moves the cursor down to the first line of the second       
      listing.  
   ^[P tells WordStar to run the PreSort macro again so that the 
      second listing will be reformatted.  At the end of that 
      listing, ^[P will again order the macro repeated, and so 
      on, until all lines are reformatted.
        
        
        
.pm1
239. PreSort (7.0):  Sub Main
                     WSQuiet (On)
                     Loop:  Key ("^QS^QF^P^M^P^J{TAB}^Y{F10}")
                     Key ("*^T^S^L*^T^S^L*^T^L*^T^L*^T^L*^T")
                     Key ("^L*^T^X")
                     GoTo Loop
                     WSQuiet (Off)
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added (see note 4).



.pm1
240. Rebuild (4.0):  ^QS^QG*^G^M^D^L^G^M^D^L^G^M^L^G^M^L^G^M
                     ^L^G^M^L^G^M^X^[R 

.pm4
   ^QS makes sure the cursor is at the left margin on the top 
      line of a sorted address file.  All the fields in each 
      address listing are on a single line.
   ^QG* finds the first asterisk left as a place mark by the 
      PreSort macro (above).
   ^G^M deletes the asterisk and executes a Return, leaving the 
      first field in the listing on a line by itself.
   ^D^L moves the cursor forward a space and repeats the ^QG* 
      search order to locate a place mark after the second field.  
      (The ^D is needed because the cursor may be on an asterisk 
      left at the start of the second field to indicate that the 
      field is blank.  If so, the asterisk must be retained.  If 
      used with later WordStar releases, the search order would 
      advance the cursor from that asterisk to the one after the 
      second field.  But the WS4.0 search order won't find the 
      right asterisk unless the cursor is first nudged forward.)  
   ^G^M deletes the place mark after the second field and 
      executes a Return, leaving the field on a line by itself.
   ^D^L^G^M^L^G^M^L^G^M^L^G^M^L^G^M finds and deletes five more 
      place marks, executing a Return after each deletion.  Each       
field in the listing is now on line by itself.
   ^X moves the cursor down to the first line of the second 
      listing.  
   ^[R tells WordStar to repeat the Rebuild macro so that the 
      second listing will be reformatted.  At the end of that 
      listing, ^[P will again order the macro repeated, and so 
      on, until all listings are reformatted.
.pm1
241.  Rebuild (WS5.x, 6.0:  ^QS^QG*^G^M^L^G^M^L^G^M^L^G^M^L^G^M
                            ^L^G^M^L^G^M^X^[R 

.pm4
         The macro is the same as the last one except that two 
      unneeded ^D's are omitted.  
        
        
        
.pm1
242. Rebuild (7.0):  Sub Main
                     WSQuiet (On)
                     Loop:  Key ("^QS^QF*{TAB}^Y{F10}^G{ENTER}")
                     Key ("^L^G{ENTER}^L^G{ENTER}^L^G{ENTER}")
                     Key ("^L^G{ENTER}^L^G{ENTER}^L^G{ENTER}")
                     Key ("^X")
                     GoTo Loop
                     WSQuiet (Off)
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added (see note 4).



.pm1
243. Merge (4.0, 5.x, 6.0):  ^QS^K2^QG*^G^L^G^Q2^K2^QG\^G^Q
                             <DELETE>^QD<SP>^A^QG<SP>^D^U^QG
                             ^M*^T^S^L*^T^S^L*^T^L*^T^QG,^F*
                             ^QD^A*^QG^M*^T^X^Y^Y^[M 

.pm4
   ^QS makes sure the cursor is at the left margin on the top 
      line of an address listing.  Each field in the listing is 
      on a line by itself.
   ^K2 leaves a place mark.
   ^QG*^G finds and deletes an asterisk.  If an asterisk has been 
      left on the second line the listing to mark a blank field, 
      that asterisk must be erased.  Reason:  The macro will 
      later leave an asterisk at the start of each field.  If 
      asterisks left to mark blank fields are not first removed, 
      each of those fields will be marked with one asterisk too 
      many.  If an asterisk has not been left on the second line             
      to mark a blank field, ^QG*^G will harmlessly delete one of 
      the three asterisks left on the last line of the listing.              
      That line is not needed (and will be deleted by a later             
      command).  
   ^L^G repeats the ^QG* search order and deletes the next 
      asterisk.  If an asterisk has been left on the third line 
      of the listing to mark a blank field, that asterisk will be 
      erased.  Otherwise, ^L^G will harmlessly delete one of the 
      asterisks on the last line of the listing.
   ^Q2^K2 finds and deletes the place mark left at the start of 
      the listing.
   ^QG\^G^Q<DELETE>^QD<SP>^A^QG<SP>^D^U moves the surname at the 
        
        
        
      start of the top line to the end of that line.  (See note       
      235.)
   ^QG^M finds a Return at the end of the first line.  
   *^T enters an asterisk and deletes the Return.  The second       
      line of the listing is joined to the first.  If a listing       
      has a blank second line (because the addressee has no       
      title), the blank line is removed.  
   ^S^L moves the cursor back a space and repeats the search for 
      a Return.  (The ^S is needed to position the cursor 
      properly when the macro has to deal with blank lines.)  
   *^T enters an asterisk and deletes the next Return.  The       
      third line of the listing is joined to the top line.  If a       
      listing has a blank third line (because no company name is       
      used), that line is removed.   
   ^S^L moves the cursor back a space and repeats the search for 
      a Return.     
   *^T enters an asterisk and deletes the next Return.  The       
      street address on the fourth line of the listing is joined       
      to the three fields on the top line.  If the second and       
      third lines of a listing were originally blank, the fourth       
      line is joined to the first, and three asterisks appear       
      before the street-address, to indicate that the two       
      preceding fields were left blank.  
   ^L*^T repeats the search for a Return, enters an asterisk and 
      deletes the Return.  The City-State-ZIP line is joined to 
      the top line.  
   ^QG, finds the comma between the city and state names.  
   ^F* moves the cursor to the first letter of the state name and 
      enters an asterisk before that letter.
   ^QD moves the cursor to the right margin.
   ^A* moves the cursor back to the first number in the ZIP code 
      and enters an asterisk before that number.  The city, state 
      and ZIP code are now marked as separate fields.  (This 
      permits the user to merge-print selectively, omitting 
      listings that do not match a certain city name, state name 
      or ZIP number.  See the WordStar manual.)
   ^QG^M finds the Return after the ZIP code at the end of the 
      line.
   *^T enters an asterisk and deletes the Return.  The       
      salutation line is joined to the fields on the top line.        
      The first six fields are now on that line.
   ^X moves the cursor down a line.
   ^Y deletes the phone-number line.
   ^Y deletes the line on which three asterisks were left below 
      the phone number.  
   ^[M orders the macro repeated.  When the next listing is       
      reformatted, ^[M will again order the macro repeated, and       
      so on, until all listings have been reformatted.
        
.pa
        
.pm1
244. Merge (7.0):  Sub Main
                   WSQuiet (On)
                   Loop: Key ("^QS^K2^QF*{TAB}^Y{F10}^G^L")
                   Key ("^G^Q2^K2^QF\{TAB}^Y{F10}^G^Q{DEL}")
                   Key ("^QD<SP>^A^QF<SP>{TAB}^Y{F10}^D^U")
                   Key ("^QF^P^M^P^J{TAB}^Y{F10}*^T^S^L")
                   Key ("*^T^S^L*^T^L*^T^QF,{TAB}^Y{F10}")
                   Key ("^F*^QD^A*^QD*^T^X^Y^Y")
                   GoTo Loop
                   WSQuiet (Off)
                   End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added (see note 4).
        
        
        
.pm1
245. Header-1 (4.0, 5.x, 6.0):  ^QS^KB^KH^QD^KK^QR.MT6^M^M^M^E
                                .H1<SP>^KC^KH^QD^M.H2<SP>Page
                                <SP>#<SP>of<SP><SP>pages^M.H3
                                <SP>^[@^E^QD^QH<SP> 

.pm4
   ^QS makes sure the cursor is at the left margin.
   ^KB marks the start of a block.  The cursor is at the 
      beginning of the inside address near the top of a letter.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QD^KK moves the cursor to the right of the addressee's name       
      and marks the end of a block.  The name is blocked.  
   ^QR.MT6^M^M^M finds the top of the file, enters a dot command 
      to set the top margin and executes three Returns.
   ^E moves the cursor up a line.  One blank line is left below 
      .MT6 to keep the header from printing on page 1.
   .H1<SP>^KC enters a header dot command, leaves a blank space 
      and copies the addressee's name from the block created 
      earlier.  
   ^KH hides the block.
   ^QD^M moves the cursor to the end of the line and executes a       
      Return. 
   .H2<SP>Page<SP>#<SP>of<SP><SP>pages^M enters a second header 
      line and executes a Return.
   .H3<SP>^[@ enters a third header line to print the date.
   ^E^QD^QH<SP> places the cursor in the second of the two blank 
      spaces before "pages" one the second header line. The user 
      enters a number there to complete the header.
        
.pa
.pm1
.rm66
246. Header-1 (7.0):  Sub Main
                        WSQuiet (On)
                        Key ("^QS^KB^KH^QD^KK^QR.MT6{ENTER}")
                        Key ("{ENTER}{ENTER}^E.H1<SP>^KC^KH^QD")
                        Key ("{ENTER}.H2<SP>Page<SP>#<SP>of<SP>")
                        Key ("<SP>pages{ENTER}.H3<SP>^M@^E^QD")
                        Key ("^QF<SP>{TAB}B{F10}")
                        WSQuiet (Off)
                        End Sub 

.pm4
.rm65
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QH (see note 19), and the WSQuiet       
      feature is added (see note 4).
        
        
        
.pm1
247. Header-2 (4.0, 5.x, 6.0):   ^QS^KB^KH^QD^KK^QR.MT6^M^M^M^E
                                 .H1<SP>^KC^KH^QD^M.H2<SP>Page
                                 <SP>#^M.H3<SP>^[@ 

.pm4
         The macro is the same as the last one except that the       
      second header line is shortened and the ^E^QD^QH<SP>       
      sequence at the end is omitted.  
         
        
        
.pm1
248. Header-2 (7.0):  Sub Main
                      Key ("^QS^KB^KH^QD^KK^QR.MT6{ENTER}")
                      Key ("{ENTER}{ENTER}^E.H1<SP>^KC^KH^QD")
                      Key ("{ENTER}.H2<SP>Page<SP>#{ENTER}")
                      Key (".H3<SP>^M@")
                      End Sub 

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
249. WinMain (5.x): ^OK\WS5\

.pm4
   ^OK displays a screen used in opening a window.
   \WS5\ enters a directory path.



.pm1
250. WinMain (6.0):  ^OK\WS\ 

.pm4
         The macro is the same as the last one except for the       
      directory designation.
        
.pa
.pm1
251. WinMain (7.0):  Sub Main
                     Key ("^OK\WS\")
                     End Sub

.pm4
        The macro performs like the one described in note 249,       
      using a different directory designation.



.pm1
252. WinBiz (5.x):  ^OK\WS5\BIZ\

.pm4
         The macro is the same as the WS5.x version of WinMain       
      except that a subdirectory name is added.  



.pm1
253. WinBiz (6.0):  ^OK\WS\BIZ\

.pm4
         The macro is the same as the WS6.0 version of WinMain       
      except that a subdirectory name is added.  
        
        
        
.pm1
254. WinBiz (7.0):  Sub Main
                    Key ("^OK\WS\BIZ\")
                    End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
255. Park (4.0):  ^KS^KQRSHIPDISK^M  

.pm4
         If the macro is executed at the opening menu: 
   ^KS has no effect.
   ^KQ has no effect.
    R displays a DOS prompt.
    SHIPDISK^M tells DOS to park the hard disk.

         If the macro is executed with a file onscreen: 
   ^KS saves the file, keeping it open.
   ^KQ orders the file abandoned.  
    RSHIPDISK^M displays a DOS prompt and orders the hard disk 
      parked.  



.pm1
256. Park (5.0, 5.5):  ^R^K^DRSHIPDISK^M 

.pm4
         If the macro is executed at the opening menu:
   ^R displays a DOS prompt.
   ^K switches off the prompt.
   ^D has no effect.  The command is not read by WordStar.
        
    RSHIPDISK^M redisplays the DOS prompt and orders the hard       
      disk parked.

         If the macro is executed with a file onscreen:
   ^R moves the cursor up one screen, or to the top of the file 
      if there is not a full screen of text above the cursor.
   ^K^D saves the file.
    RSHIPDISK^M displays a DOS prompt and orders the hard disk       
      parked.



.pm1
257. Park (5.5C, 6.0):  ^R$^H^K^DRSHIPDISK^M 

.pm4
         The macro is the same as the last one except that a             
      dollar sign and ^H are added near the start of the                   
      sequence.  (See note 82.)  



.pm1
258. Park (7.0A):  Sub Main
                   Key ("{F10}S^S^G^KFSHIPDISK{F10}")
                   PauseForInput ("{F10}", 'Press F10.')
                   Key ("^D^KQ")
                   IfException
                   Def: Key ("N")
                   End IfException
                   End Sub

.pm4
    Key ("{F10} saves the file if one is onscreen.  If the macro 
      is executed at the opening screen, {F10} has no effect.  
      The rest of the macro is patterned after the WS7.0A version 
      of ADirect.  (See note 138.)

         

.pm1
259. Park (7.0C):  Sub Main
                   SetHelpLevel (4) : AutoRestore (On)
                   Key ("{F10}{ALT+F}RSHIPDISK{F10}")
                   End Sub 

.pm4
    SetHelpLevel (4) : sets the help level at 4. (See note 84.)
    AutoRestore (On) restores default editing settings after the 
      macro has run.
    Key ("{F10} saves the file if one is onscreen.  The command 
      has no effect if the macro is run at the opening screen.
    {ALT+F}RSHIPDISK{F10}") displays a DOS command line and tells 
      DOS to run the parking utility SHIPDISK.



.pm1
260. PrtBlk (4.0):  ^KH^F^D^B^S^S^QD^KK^KWPRINT^MY^Q<DELETE>
                    ^KPNPRINT^[^KH

.pm4
   ^KH dissolves any block highlighting.  (See note 14.)
   ^F^D^B^S^S^QD^KK places the cursor at the end of the last line 
      of the home paragraph and marks the end of a block.  
   ^KWPRINT^M orders the block copied to a file called PRINT.    
    Y tells WordStar to overwrite any previous version of the 
      PRINT file.  If there is no previous version, the Y will be 
      unspent and will print in the text, at the start of the 
      block.
   ^Q<DELETE> erases to the left margin, deleting the Y if it has       
      printed in the text.  If no Y has printed, the command has 
      no effect.
   ^KPNPRINT^[ prints the block.
   ^KH dissolves the block highlighting.
             
             
        
.pm1
261. PrtBlk (5.x, 6.0):  ^KH^F^D^B^S^S^QD^KK^KWPRINT^MY^Q<DELETE>
                         ^KPPPRINT^K^KH

.pm4
         The macro is the same as the last one except that 
      ^KPPPRINT^K is used in place of ^KPNPRINT^[ to order the       
      block printed.  



.pm1
262. PrtBlk (7.0):  Sub Main
            WSQuiet (On)
            Key ("^QF^P^M^P^J{TAB}B{F10}^KB^KH")
            WSQuiet (Off)
            PauseForInput ("<SP>", 'Press Spacebar to print.')
            WSQuiet (On)
            Key ("^F^D^B^S^S^QD^KK^KWPRINT{F10}")
            IfException
            Def: Key ("Y")
            End IfException
            Key ("^KPPRINT^K^KH")
            WSQuiet (Off)
            End Sub

.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)
    Key ("^QF^P^M^P^J{TAB}B{F10} finds the Return above the home       
      paragraph.  (See note 19.)
   ^KB^KH") marks the start of a block and dissolves any block 
      highlighting.  (See note 14.)
    WSQuiet (Off) disables the WSQuiet feature.
    PauseForInput ("<SP>", 'Press Spacebar to print.') interrupts 
      the macro to permit the user to move the cursor, if 
      necessary, so that it will be in the last paragraph to be 
      printed.  The macro restarts when the user presses the 
      Spacebar. 
    WSQuiet (On) actuates the WSQuiet feature. 
    Key ("^F^D^B^S^S^QD^KK moves the cursor to the end of the 
      last paragraph to be printed and marks the end of a block.
   ^KWPRINT{F10}") writes the block to a file called PRINT. 
    IfException introduces an IfException clause.
    Def: Key ("Y") supplies a keystroke to be entered by the       macro if there is already a file called PRINT and WordStar 
      asks whether to overwrite it.  
    End IfException terminates the IfException clause.
    Key ("KPPRINT^K^KH") prints the block, then extinguishes the 
      block highlighting.
    WSQuiet (Off) disables the WSQuiet feature.



.pm1
263. PrtEnvl-1 (4.0):  ^QS^N^K2^KRENV1^M^QF^P^M^P^J^P^M^P^J^M^M
                       ^X^X^X^KB^L^X^X^X^KK^KY^L^X^X^KK^Q2^K2^KB
                       ^KWENV1^MY^KPNENV1^[^L^X^X^X^KK^KY

.pm4
   ^QS makes sure the cursor is at the left margin on the top 
      line of an address in a letter file.
   ^N enters a blank line under the cursor.
   ^K2 leaves a place mark.
   ^KRENV1^M imports the file ENV1.
   ^QF^P^M^P^J^P^M^P^J^M^M^X^X^X finds a double Return in the 
      ENV1 file, then moves the cursor down three lines.  The 
      cursor is at the start of the last address copied to ENV1.  
      If ENV1 is being used for the first time, the cursor moves 
      to the start of a dummy address.
   ^KB marks the start of a block.
   ^L repeats the ^QF^P^M^P^J^P^M^P^J^M^M search, sending the 
      cursor to a double Return below the address.
   ^X^X^X^KK^KY moves the cursor down three lines, marks the end 
      of a block and deletes the block.  The last-used address is 
      erased.  The cursor is at the start of the address in the 
      onscreen letter file.
   ^L repeats the ^QF^P^M^P^J^P^M^P^J^M^M search, sending the 
      cursor to the end of the address.
   ^X^X^KK drops the cursor two lines and marks a block ending.  
   ^Q2^K2 finds and erases the ^K2 place mark left at the start 
      of the imported ENV1 file.  
   ^KB marks the start of a block.  The block extends from the 
      start of the ENV1 file to the end of the address in the 
      onscreen letter.
   ^KWENV1^M orders the block written to the file ENV1.
    Y answers Yes when WordStar asks whether to overwrite the 
      existing ENV1 file.
   ^KPNENV1^[ prints the new ENV1 file to an envelope.
   ^L again repeats the ^QF^P^M^P^J^P^M^P^J^M^M search, sending 
      the cursor to the end of the dot-command field in the 
      imported ENV1 file.
   ^X^X^X moves the cursor down three lines.
   ^KK^KY marks the end of a block and deletes the block.  All 
      remaining characters in the imported ENV1 file are erased.  
        
        
        
.pm1
264. PrtEnvl-1 (5.x, 6.0):  ^QS^KB^KH^QF^P^M^P^J^P^M^P^J^M^Y^M
                            ^KK^OK\WS\ENV1^M^L^M^M^M^QT^Z^KA^KD
                            ^KPP\WS\ENV1^K^KH 
     
.pm4
   ^QS makes sure the cursor is at the left margin on the top 
      line of an address in a letter file.
   ^KB marks the start of a block.  
   ^KH hides any block highlighting.  (See note 14.)
   ^QF^P^M^P^J^P^M^P^J^M^Y^M finds the double Return after the       
      last line of the address.
   ^KK marks the end of a block.  The address is blocked.
   ^OK\WS\ENV1^M opens a window on a file called ENV1.
   ^L repeats the ^QF^P^M^P^J^P^M^P^J^M^Y^M search, finding a 
      double Return above the last address sent to the ENV1 file.  
      If ENV1 is being used for the first time, the cursor moves 
      to a double Return above a dummy address. 
   ^M^M^M^QT^Z enters three Returns and deletes to the end of the 
      file.  The last-used address is erased.
   ^KA copies the blocked address from the letter file in the 
      upper window to the ENV1 file in the lower window.
   ^KD saves the ENV1 file.  The lower window closes.
   ^KPP\WS\ENV1^K prints the file to an envelope.  
   ^KH dissolves the highlighting on the blocked address in the 
      letter file.  



.pm1
265. PrtEnvl-1 (7.0):  Sub Main
                       WSQuiet (On)
                       Key ("^QS^KB^KH^QF^P^M^P^J^P^M^P^J{TAB}")
                       Key ("^Y{F10}^KK^OK\WS\ENV1{F10}^L{ENTER}")
                       Key ("{ENTER}{ENTER}^QT^Z^KA^KD^KP\WS\ENV1")
                       Key ("^K^KH")
                       WSQuiet (Off)
                       End Sub  

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added (see note 4).



.pm1
266. PrtEnvl-2 (4.0):  ^QS^N^K2^KRENV2^M^QG@^X^QS^KB^QF^P^M^P^J
                       ^P^M^P^J^M^M^X^X^X^KK^KY^L^X^X^KK^Q2^K2
                       ^KB^KWENV2^MY^KPNENV2^[^QT@^Y^KH 
     
.pm4
         The macro performs essentially the same functions as the 
      one described in note 263, using a different ENV file.  A 
      ^QG@ search is run to find a place mark in the ENV2 file.  



.pm1
267. PrtEnvl-2 (5.x, 6.0):  ^QS^KB^KH^QF^P^M^P^J^P^M^P^J^M^Y^M^X
                            ^X^KK^OK\WS\ENV2^M^QG@^QS^X^QT^Z^KA
                            ^KD^KPP\WS\ENV2^K^KH  
          
.pm4
         The macro performs essentially the same functions as the 
        
      one described in note 264, using a different ENV file.  A 
      ^QG@ search is run to find a place mark in the ENV2 file.  
        
        
        
.pm1
268. PrtEnvl-2 (7.0):  Sub Main
               WSQuiet (On)
               Key ("^QS^KB^KH^QF^P^M^P^J^P^M^P^J{TAB}")
               Key ("^Y{F10}^X^X^KK^OK\WS\ENV2{F10}")
               Key ("^QF@{TAB}{F10}^QS^X^QT^Z^KA^KD")
               Key ("^KP\WS\ENV2^K^KH")
               WSQuiet (Off)
               End Sub  

.pm4
         The macro differs from the last one in format but 
      performs the same functions.  The search command ^QF is       
      used here in place of ^QG (see note 19), and the WSQuiet       
      feature is added (see note 4).



.pm1
269. QuikPrt-1 (4.0):  ^KDP^R^[

.pm4
   ^KD saves and closes the file.
    P^R^[ prints the file.



.pm1
270. QuikPrt-1 (5.x, 6.0):  ^KDP^K

.pm4
   ^KD saves and closes the file.
    P^K prints the file.



.pm1
271. QuikPrt-1 (7.0A):  Sub Main
               Key ("^KDP")
               PauseForInput ("{ENTER}", ' Check filename. ')
               Key ("^K")
               End Sub

.pm4
    Key ("^KDP") saves the file and displays the print screen.
    PauseForInput ("{ENTER}", ' Check filename. ') interrupts the 
      macro so that the user can verify that the correct filename is 
      displayed.  The macro resumes when the user presses Enter.
    Key ("^K") prints the file.



.pm1
272. QuikPrt-1 (7.0C):  Sub Main
               WSQuiet (On)
               Key ("^KDP^K")
               WSQuiet (Off)
               End Sub
     
.pl67
.pm4
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)
    Key ("^KDP^K") saves the file, displays the print screen and 
      prints the file.
    WSQuiet (Off) disables the WSQuiet feature.



.pm1
273. QuikPrt-2 (4.0):  ^KS^KPN^R^[

.pm4
   ^KS saves the file, keeping it open.
   ^KPN^R^[ prints the file.



.pm1
274. QuikPrt-2 (5.x, 6.0):  ^KS^KPP^K

.pm4
   ^KS saves the file, keeping it open.
   ^KPP^K prints the file.
        
        
        
.pm1
275. QuikPrt-2 (7.0A):  Sub Main
               Key ("^KS^KP")
               PauseForInput ("{ENTER}", ' Check filename. ')
               Key ("^K")
               End Sub 

.pm4
         The macro is the same as the WS7.0A version of QuikPrt-1 
      except that a different save command is used so that the 
      file remains onscreen.



.pm1
276. QuikPrt-2 (7.0C):  Sub Main
                        WSQuiet (On)
                        Key ("^KS^KP^K")
                        WSQuiet (Off)
                        End Sub 

.pm4
         The macro is the same as the WS7.0C version of QuikPrt-1 
      except that a different save command is used so that the 
      file remains onscreen.  



.pm1
277. QuikPrt-3 (7.0):  Sub Main
               Key ("^QR^QL")
               IfException
               Def: Key ("^U")
               End IfException
               Key ("^OP")
               PauseForKey ("")
               Key ("^KDP")
               PauseForInput ("{ENTER}", 'Press Enter to print.')
               Key ("^K")
               End Sub
.pl66
.pm4
    Key ("^QR^QL") moves the cursor to the top of the file and 
      starts the spellchecker.  
    IfException introduces an IfException clause.
    Def: Key ("^U") enters an undo command to switch off the 
      spellchecker after the last flagged word has been checked.
    End IfException terminates the IfException clause.
    Key ("^OP") runs Page Preview.
    PauseForKey ("") performs a dummy function, providing a 
      needed transition between commands after the user presses 
      Esc to turn off Page Preview. 
    Key ("^KDP") saves the file and displays the print screen.
    PauseForInput ("{ENTER}", 'Press Enter to Print.') interrupts 
      the macro for user input.  
    Key ("^K") prints the file when the user presses Enter.  



.pm1
278. RfmFile-1 (4.0, 5.x, 6.0):  ^QR^QU 

.pm4
   ^QR moves the cursor to the top of the file. 
   ^QU reforms the file.



.pm1
279. RfmFile-1 (7.0):  Sub Main
                       Key ("^QR^QU")
                       End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
280. RfmFile-2 (4.0, 5.x, 6.0):  ^QR^QU^QR 

.pm4
         The macro is the same as the one described in note 278       
      except that a ^QR is added to send the cursor back to the       
      top of the file after the text is reformed.
        
        
        
.pm1
281. RfmFile-2 (7.0):  Sub Main
                       Key ("^QR^QU^QR")
                       End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
282. RfmFile-3 (4.0, 5.x, 6.0):  ^K2^QR^QU^Q2^K2^KH 

.pm4
   ^K2 marks a place. 
   ^QR^QU sends the cursor to the top of the file, then reforms 
      the file. 
           
   ^Q2^K2 finds and erases the place mark, leaving the cursor         
      where it was when RfmFile-3 was executed. 
   ^KH extinguishes any block highlighting that may have been       
      created by ^K2 at the start of the sequence.  
           
        
        
.pm1
283. RfmFile-3 (7.0):  Sub Main
                       Key ("^K2^QR^QU^Q2^K2^KH")
                       End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
                


.pm1
284. Justify-1 (4.0):  ^D^K2^QH^M^F^B^Q2^K2^KH^S 

.pm4
   ^D Advances the cursor one space.  (See ^S, below.)
   ^K2 leaves a place mark. 
   ^QH^M finds the Return above the home paragraph. 
   ^F moves the cursor forward to the first character of the home       
      paragraph. 
   ^B reforms the paragraph.     
   ^Q2^K2 finds and erases the place mark in the home sentence. 
   ^KH extinguishes any block highlighting that may have been 
      created by ^K2 in the previous command.  
   ^S moves the cursor back one space.  Purpose:  to return the       
      cursor to the position it occupied before it was moved       
      forward by the ^D at the start of the sequence.  If the ^D       
      and ^S are omitted, and if the macro is executed at the       
      start of a line, the cursor may wind up at the end of the       
      previous line.



.pm1
285. Justify-2 (4.0):  ^QH^M^F^B^F 

.pm4
   ^QH^M^F^B finds the Return above the home paragraph, moves the             
      cursor forward to the first character of the home 
      paragraph, then reforms the paragraph. 
   ^F moves the cursor to the start of the next paragraph.
         
        
        
.pm1
286. Justify-3 (4.0):  ^QH^M^F^B^QP 

.pm4
   ^QH^M^F^B finds the Return above the home paragraph, moves the 
      cursor forward to the first character of the home 
      paragraph, then reforms the paragraph.   
   ^QP returns the cursor to the start of the home paragraph.  
        
.pa
.pm1
287. Reopen-1 (4.0):  D^R^M^QP 

.pm4
    D displays a screen used in opening a file. 
   ^R displays the name of the last active file.
   ^M executes a Return, reopening the file. 
   ^QP returns the cursor to its last position in the file.
        
        

.pm1
288. Reopen-1 (5.0, 6.0D):  D^M^QP 

.pm4
         The functions are described in the previous note.  The 
      ^R is omitted here because the name of the last active file 
      will appear on the screen automatically.
             
              
             
.pm1
289. Reopen-1 (5.5, 6.0):  P^LNUL^MP^UD^M^QP 

.pm4
    P displays a print screen.  The object is to make sure the 
      right file is reopened.  If the file WOMBAT is onscreen and 
      the file AARDVARK is called up in a window, AARDVARK 
      becomes the filename in memory.  If the user closes the 
      window, saves WOMBAT, returns to the opening menu and 
      presses D to open a document, the filename AARDVARK will       
      appear on the prompt line--even though WOMBAT was the last       
      active file.  But the print screen will display the name of 
      the last active file.  Reopen-1 will borrow the name from 
      that screen and store the name in memory. 
   ^LNUL^M moves the cursor to the bottom line on the print screen 
      and redirects the contents of the file WOMBAT to a NUL 
      device.  (See note 3.)
    P^U tells WordStar to stop redirecting the contents of the 
      file.
    D displays a screen used in opening a file.  The filename 
      borrowed from the print screen appears on the prompt line. 
   ^M^QP reopens the file and returns the cursor to its last 
      position in the file.  



.pm1
290. Reopen-1 (7.0):  Sub Main
                      Key ("D{F10}^QP")
                      End Sub

.pm4
         The macro differs in format from the one described in       
      note 288 but performs the same functions.  
        


.pm1
291. Reopen-2 (4.0):  D^R^M 

.pm4
            The macro is the same as the WS4.0 version of       
      Reopen-1 except that the ^QP at the end is omitted here so
        
      that the cursor will be positioned at the top of the             
      reopened file.



.pm1
292. Reopen-2 (5.5, 6.0):   P^LNUL^MP^UD^M
.pm4

         The macro is the same as the WS5.5/6.0 version of             
      Reopen-1 except that the ^QP at the end is omitted here so 
      that the cursor will be positioned at the top of the             
      reopened file.



.pm1
293. Reopen-3 (4.0):  D^R^M^QC 

         The macro is the same as the WS4.0 version of Reopen-1       
      except that the ^QP is replaced by a ^QC, so that the       
      cursor will move to the end of the file.



.pm1
294. Reopen-3 (5.0, 6.0D):  D^M^QC 

.pm4
         The macro is the same as the WS5.0/6.0D version of       
      Reopen-1 except that the ^QP is replaced by a ^QC, so       
      that the cursor will move to the end of the file.  



.pm1
295. Reopen-3 (5.5, 6.0):  P^LNUL^MP^UD^M^QC

.pm4
         The macro is the same as the WS5.5/6.0 version of       
      Reopen-1 except that the ^QP is replaced by ^QC, so that       
      the cursor will move to the end of the file.



.pm1
296. Reopen-3 (7.0):  Sub Main
                      Key ("D{F10}^QC")
                      End Sub

.pm4
         The macro performs the same functions as the one       
      described in note 294, differing only in format.



.pm1
297. XTree (4.0):  R^H^K^FXTREE^M 

.pm4
         If the macro is executed at the opening menu:  
    R displays a DOS prompt.
   ^H^K^F has no effect.
    XTREE^M runs the file-management program XTREE.  
        
        
        
         If the macro is executed with a file onscreen:  
    R enters an R in the text.
   ^H erases the R.
   ^K^F displays a DOS prompt.  
    XTREE^M runs XTREE.
        
        
        
.pm1
298. XTree (5.0, 5.5):  R^H^FXTREE^KK^KH^QHX^KB^KY^A^KFXTREE^M 

.pm4
         If the macro is executed at the opening menu: 
    R displays a DOS prompt.
   ^H^F has no effect.
    XTREE^K tells DOS to run XTREE.  The remaining characters 
      have no effect.  Once the command is set in motion by the       
      ^K after XTREE, no additional command characters are       
      recognized. 
             
         If the macro is executed with a file onscreen:   
    R prints an R in the text.
   ^H deletes the R.
   ^F advances the cursor.  (See ^F in note 81.)
    XTREE enters the characters XTREE in the text. 
   ^KK marks the end of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^QHX searches backward for the X in XTREE. 
   ^KB marks the start of a block.  XTREE is blocked. 
   ^KY deletes the block, leaving the text as it was before the       
      macro was executed.
   ^A moves the cursor backward.  It was advanced by ^F, above.
   ^KF displays a DOS prompt.
    XTREE^M tells DOS to run XTREE.



.pm1
299. XTree (5.5C, 6.0):  R$^H^H^FXTREE^KK^KH^QHX^KB^KY^A^KF
                         XTREE^M

.pm4
         The macro is the same as the last one except that a       
      dollar sign and a second ^H are added near the start of the             
      sequence.  (See note 82.) 



.pm1
300. XTree (6.0D):  S^S^G^KFXTREE^M^KQN^[^[

.pm4
    S^S^G^KF displays a DOS prompt whether the macro is 
      executed at the opening menu or with a file onscreen.  (See       
      note 83.)
    XTREE^M runs the program XTREE.
   ^KQN^[^[ performs as described in note 83.
        
.pa
.pm1
301. XTree (7.0A):  Sub Main
                    Key ("S^S^G^KFXTREE{F10}")
                    PauseForInput ("{F10}", 'Press F10.')
                    Key ("^D^KQ")
                    IfException
                    Def: Key ("N")
                    End IfException
                    End Sub

.pm4
        The macro is patterned after the WS7.0A version of       
      ADirect.  (See note 138.)



.pm1
302. XTree (7.0C):  Sub Main
                    SetHelpLevel (4) : AutoRestore (On)
                    Key ("{ALT+F}RXTREE{F10}")
                    End Sub

.pm4
         The macro is patterned after the WS7.0C version of 
      ADirect.  (See note 139.)   



.pm1
303. QuikSav (4.0):  ^KDD^R^M^QP 

.pm4
   ^KD saves the file. 
    D^R^M reopens the file. 
   ^QP returns the cursor to its last position in the file.



.pm1
304. HiScree (4.0, 5.x, 6.0):  ^K1^KH^QQ^R9

.pm4
   ^K1^KH leaves a hidden place mark.  (See note 159.)
   ^QQ^R tells WordStar to scroll upscreen continuously.
    9 sets the speed of the scroll.



.pm1
305. HiScree (7.0):  Sub Main
                     Key ("^K1^KH^QQ^R9")
                     End Sub

.pm4
        The macro differs from the last one in format but 
      performs the same functions.



.pm1
306. LoScree (4.0, 5.x, 6.0):  ^K1^KH^QQ^C9

.pm4
   ^K1 leaves a hidden place mark.  (See note 159.)
   ^QQ^C tells WordStar to scroll downscreen continuously.
    9 sets the speed of the scroll.
        
.pm1
307. LoScree (7.0):  Sub Main
                     Key ("^K1^KH^QQ^C9")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
308. NxtPage (5.x, 6.0):  ^QI+^M

.pm4
         The macro advances the cursor to the next page.
        
        
         
.pm1
309. NxtPage (7.0):  Sub Main
                     WSQuiet (On)
                     Key ("^QI+{F10}")
                     WSQuiet (Off)
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
310. PvsPage (5.x, 6.0):  ^QI-^M 

.pm4
         The macro moves the cursor to the top of the previous       
      page.



.pm1
311. PvsPage (7.0):  Sub Main
                     WSQuiet (On)
                     Key ("^QI-{F10}")
                     WSQuiet (Off)
                     End Sub

      The macro differs from the last one in format but performs 
      the same functions.



.pm1
312. NxtGraf (4.0, 5.x, 6.0):  ^B^QG<SP>^F^D^QS^S^F 

.pm4
   ^B positions the cursor below the home paragraph.
   ^QG<SP> finds the next blank space.  Depending on the setting, 
      that space may be on an open line below the home paragraph, 
      after a dot command above the next paragraph, in an 
      indention before the next paragraph, or after the first 
      word of the next paragraph.
   ^F^D moves the cursor forward.  The cursor is now somewhere 
      near the start of the first line of the next paragraph, the 
      position depending on which of several variables the             macro has dealt with so far. 
   ^QS moves the cursor to the left margin, if it's not already       
      there.
   ^S^F moves the cursor up a line, then forward and down to the       
      first word of the paragraph.  (The ^S is necessary when       
      copy is single-spaced and paragraphs are unindented.  If       
      the ^S is omitted, the ^F will move the cursor to the 
      second word of the paragraph instead of the first.)



.pm1
313. NxtGraf (7.0):  Sub Main
                     HideDots (On) : WSQuiet On
                     AutoRestore (On)
                     Key ("^B^QF<SP>{TAB}^Y{F10}^F^D")
                     Key("^QS^S^F")
                     End Sub

.pm4
    HideDots (On) : hides dot commands while the macro is 
      running.  If a blank space has been left after a dot 
      command between paragraphs, the space is hidden.  The fewer 
      spaces the macro has to deal with when moving the cursor 
      between paragraphs, the more likely it is that the macro 
      will perform properly.  
    WSQuiet (On) actuates the WSQuiet feature.  (See note 4.)
    AutoRestore (On) restores editing settings to their defaults 
      after the macro has run.
    Key ("^B^QF<SP>{TAB}^Y{F10}^F^D") performs the same functions 
      as ^B^QG<SP>^F^D in the previous note.
    Key ("^QS^S^F") performs as described in the previous note.
        


.pm1
314. PvsGraf (4.0, 5.0., 5.5C, 6.0):  ^QS^S^A^QH<SP>^QH^M^F 

.pm4
   ^QS makes sure the cursor is at the left margin.  
   ^S^A moves the cursor backward.  If PvsGraf has been executed 
      in the first line of a paragraph, the cursor lands at the 
      end of the last line of the previous paragraph.  Exception:  
      If the home paragraph is preceded by one or more dot 
      commands, the cursor lands on the first character of the 
      dot command immediately above the home paragraph.
   ^QH<SP> searches backward for a blank space.  If several dot 
      commands precede the home paragraph, ^QH<SP> usually jumps             
      the cursor over those commands so that it will be properly             
      positioned for the next command.
   ^QH^M searches backward for a Return.  If a three-paragraph 
      document is being edited and if PvsGraf has been executed 
      at the start of the third paragraph, ^QH^M finds the Return 
      just above paragraph 2.
   ^F moves the cursor to the start of the target paragraph.  If       
      PvsGraf is executed at the start of paragraph 3, the cursor 
      moves to the start of paragraph 2.  Note:  If the cursor is 
      not on the top line of a paragraph when PvsGraf is run, the 
        
      macro moves the cursor back to the start of that paragraph       
      rather than to the start of the previous paragraph. 



.pm1
315. PvsGraf (5.5):  ^QS^S^A^QH<SP>^QH^I^F

.pm4
         The macro is the same as the last one except that       
      ^QH^I is used near the end in place of ^QH^M.  ^QH^I looks       
      backward for a Tab indention.  (^QH^M, which searches       
      backward for a Return, won't work in a paragraph created       
      with the original version of WS5.5 if the first line of the       
      paragraph is immediately below a page break.)  



.pm1
316. PvsGraf (7.0):  Sub Main
                     HideDots (On) : WSQuiet (On)
                     AutoRestore (On)
                     Key ("^QS^S^A^QF<SP>{TAB}B{F10}")
                     Key ("^QF^P^M^P^J{TAB}B{F10}^F")
                     End Sub

.pm4
    HideDots (On) : WSQuiet (On) performs as described in note       
      313.  
    AutoRestore (On) restores editing settings to their defaults 
      after the macro has run.  The remaining commands perform as 
      described in note 314 except that the search command ^QF is 
      used here in place of ^QH.  (See note 19.) 
        
         

.pm1
317. NxtSent (4.0, 5.x, 6.0):  ^QG.^F^QG<SP>^F^QH<SP>^L^F^F^S^QH
                               <SP>^F^QG<SP>^A  

.pm4
   ^QG. searches forward for a period.
   ^F^QG<SP>^F^QH<SP>^L^F^F^S^QH<SP>^F^QG<SP>^A advances the       
      cursor to the start of the next sentence.  The sequence 
      performs a variety of forward and backward movements that       
      normally land the cursor in the correct position whether 
      the next sentence is in the same paragraph as the home       
      sentence or is in the next paragraph.  NxtSent also takes       
      into account that other macros may have left extra blank       
      spaces at the end of the last line of a paragraph, at the       
      end of a dot-command line just above a paragraph, or on an       
      open line between paragraphs.  
        


.pm1
318. NxtSent (7.0):  Sub Main
                     HideDots (On):  WSQuiet (On)
                     AutoRestore (On)
                     Key ("^QF.{TAB}^Y{F10}")
                     Key ("^F^QF<SP>{TAB}^Y{F10}^A")
                     End Sub
.pm4
    HideDots (On) : performs as described in note 313.  
    WSQuiet (On) performs as described in note 4. 
    AutoRestore (On) restores editing settings to their defaults 
      after the macro has run.  
    Key ("^QF.{TAB}^Y{F10}") searches forward for a period.
    Key ("^F^QF<SP>(TAB}^Y{F10}^A") places the cursor on the 
      first character of the next sentence.  (The sequence       
      performs the same function as ^F^QG<SP>^A in note 23.)



.pm1
319. PvsSent (4.0, 5.x, 6.0):  ^A^A^QH<SP>^A^QH.^F^QG<SP>^F^QH
                               <SP>^L^F^F^S^QH<SP>^F^QG<SP>^A  

.pm4
   ^A^A moves the cursor backward, the extent of the movement 
      depending on the position of the cursor when the macro is 
      executed.  
   ^QH<SP>^A^QH. moves the cursor to the next preceding blank 
      space, then back one word, then to the next preceding 
      period (usually the period ahead of the previous sentence).  
   ^F^QG<SP>^F^QH<SP>^L^F^F^S^QH<SP>^F^QG<SP>^A moves the cursor       
      to the start of the previous sentence.  The sequence 
      performs a variety of forward and backward movements that       
      normally land the cursor in the correct position whether       
      the previous sentence is in the same paragraph as the home             
      sentence or is in the previous paragraph.  
        


.pm1
320. PvsSent (7.0):  Sub Main
                     HideDots (On) : WSQuiet (On)
                     AutoRestore (On)
                     Key ("^QF.{TAB}B{F10}^L")
                     Key ("^F^QF<SP>{TAB}^Y{F10}^A")
                     End Sub

.pm4
    HideDots (On) : performs as described in note 313.
    WSQuiet (On) performs as described in note 4.
    AutoRestore (On) restores editing settings to their defaults 
      after the macro has run.  
    Key ("^QF.{TAB}B{F10}^L") searches backward for a period, 
      then repeats the search to find the period ahead of the 
      previous sentence.
    Key ("^F^QF<SP>{TAB}^Y{F10}^A") moves the cursor to the start 
      of the previous sentence.  (The sequence performs the same       
      function as ^F^QG<SP>^A in note 23.)  



.pm1
321. Quest (5.x, 6.0): ^K1^KH^QF<SP>^XU^E^G

.pm4
   ^K1^KH leaves a hidden place mark.  (See note 159.)
   ^QF<SP> displays a search screen and enters a space on the top 
        
        
        
      prompt line.  If no previous search has been performed       
      during the current work session, the line will be blank       
      when the screen is displayed.  Something must be entered on       
      the line so that the next command will perform properly.
   ^XU moves the cursor to the second prompt line and enters a U,       
      telling WordStar to disregard uppercasing and lowercasing       
      when searching for the characters to be entered later on       
      the top prompt line.
   ^E^G moves the cursor back to the top line and deletes the       
      blank space left earlier.  



.pm1
322. Quest (7.0):  Sub Main
                   Key ("^K1^KH^QF<SP>^XU^E^G")
                   End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
         
        

.pm1
323. FindRep (5.x, 6.0):  ^K1^KH^QA<SP>^X^Y^XANR^E^E^Y

.pm4
   ^K1^KH leaves a hidden place mark.  (See note 159.)
   ^QA<SP> displays the find-and-replace screen and enters a 
      blank space on the top prompt line.  If no previous search 
      has been performed during the current work session, the 
      line will be blank when the screen is displayed.  Something 
      must be entered on the line to permit the next command to 
      perform properly.
   ^X moves the cursor to the second prompt line.  If any 
      characters were entered on the line during a find-and-
      replace routine performed earlier in the work session, 
      those characters are redisplayed.
   ^Y makes sure the second line is clear.
   ^X moves the cursor to the third prompt line.
    ANR selects the options A, N and R.
   ^E^E^Y returns the cursor to the first prompt line and removes 
      the blank space entered there at the start of the sequence.



.pm1
324. FindRep (7.0):  Sub Main
                     Key ("^K1^KH^QA<SP>^X^Y^XANR^E^E^Y")
                     End Sub

.pm4
        The macro differs from the last one in format but 
      performs the same functions.
        
.pa
.pm1
325. DblFind (7.0):  Sub Main
                     Key ("^K1^KH^QF<SP>^XU^E^G")
                     PauseForInput ("{ENTER}")
                     IfException
                     NCM: Key ("^U^QA<SP>^X^Y^XANR^E^E^Y")
                     Stop
                     End IfException
                     Key ("{ENTER}")
                     End Sub 

.pm4
    Key ("^K1^KH leaves a hidden place mark.  (See note 159.)
   ^QF displays a search screen.
   <SP> enters a blank space on the first line of the screen.  If 
      no previous search has been performed during the current 
      work session, the line will be blank when the screen is 
      displayed.  Something must be entered on the line before 
      the macro can proceed.  
   ^XU moves the cursor to the second prompt line and enters a U,       
      telling WordStar to disregard uppercasing and lowercasing             
      when searching for any characters that may be entered later 
      on the top prompt line.
   ^E^G") moves the cursor back to the top line and deletes the 
      blank space entered there.
    PauseForInput ("{ENTER}") interrupts the macro so that the 
      user can choose between conducting a search or a search-and 
      replace operation.  The macro resumes when the user presses 
      Enter.
    IfException introduces an IfException clause.
    NCM: Key ("^U^QA<SP>^X^Y^XANR^E^E^Y") tells WordStar to run 
      the commands enclosed in parentheses if there is no cursor 
      movement (NCM) before the user presses the Enter key to 
      terminate the pause.  If there is no such movement (because 
      the user has entered nothing before pressing Enter), the ^U 
      command switches off the search screen.  ^QA displays the 
      search-and-replace screen.  <SP> enters a blank space on 
      the first line of the screen.  (See <SP> above.)  ^X^Y 
      moves the cursor to the second line of the screen and 
      erases any characters that may have been left there during 
      a previous search-and-replace operation.  ^XANR moves the 
      cursor to the third line of the screen and tells WordStar 
      that options A, N and R have been selected for the 
      search-and-replace operation.  ^E^E^Y moves the cursor back 
      to the top line and deletes the blank space left there, 
      leaving the user in position to enter the characters that 
      will be replaced if a search-and-replace routine is 
      performed.  
    Stop halts the macro if the commands in the IfException 
      clause have been processed.
    End IfException terminates the IfException clause.
    Key ("{ENTER}") sets the search operation in motion if the 
      commands in the IfException clause have not been processed.  
      Those commands are bypassed if the user enters something on 
      the first line of the search screen instead of pressing 
      Enter to switch off that screen and switch on the 
      search-and-replace screen.
.pm1
326. SplFile (4.0, 5.x, 6.0):  ^K1^KH^QR^QL 

.pm4
   ^K1^KH leaves a hidden place mark.
   ^QR moves the cursor to the top of the file. 
   ^QL spellchecks the file.
        
        

.pm1
327. SplFile (7.0):  Sub Main
                     Key ("^K1^KH^QR^QL")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.
        
         
        
.pm1
328. SplPrev (7.0):  Sub Main
                     Key ("^K1^KH^QR^QL")
                     IfException
                     Def: Key ("^U")
                     End IfException
                     Key ("^KS^QR^OP")
                     End Sub

.pm4
    Key ("^K1^KH leaves a hidden place mark.
   ^QR^QL") moves the cursor to the start of the file and starts 
      the spelling checker.  
    IfException introduces an IfException clause.  
    Def: Key ("^U") supplies a keystroke to be entered by the 
      macro when the spelling check is completed.  The keystroke 
      must be entered to switch off a screen showing the number 
      of words checked.  
    End IfException terminates the IfException clause.
    Key ("^KS^QR saves the file, keeping it onscreen, and moves       
      the cursor to the top of the file.
   ^OP") runs Page Preview.  



.pm1
329. SplWord (4.0, 5.x, 6.0):  ^QN

.pm4
       The macro checks the spelling of the word at the cursor.
                


.pm1
330. SplWord (7.0):  Sub Main
                     Key ("^QN")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same function.
        
.pa
.pm1
.pl67
331. SplSyn (7.0):  Sub Main
                    Key ("^QN")
                    Key ("^QJ")
                    End Sub 

.pm4
    Key ("^QN") checks the spelling of the word at the cursor.
    Key ("^QJ") switches on the thesaurus screen when the user 
      presses Esc to turn off the spellcheck screen.

   

.pm1
332. Short-1 (4.0):  O\WS4\SET1^M\WS4\WSSHORT.OVR^MYX

.pm4
    O displays a screen used in copying a file.
   \WS4\SET1^M enters the name of the file to be copied and       
      executes a Return.
   \WS4\WSSHORT.OVR^M enters the filename to be assigned to the 
      copy and executes a Return.
    Y answers Yes when WordStar asks whether to overwrite the 
      WSSHORT.OVR file already in the main directory of WS4.0.
    X displays a DOS prompt.



.pm1
333. Short-1 (5.x):  O\WS5\SET1^M\WS5\WSSHORT.OVR^MYX

.pm4
         The macro is the same as the WS4.0 version of Short-1       
      except for the directory designations. 



.pm1
334. Short-1 (6.0):  O\WS\SET1^M\WS\WSSHORT.OVR^MYX

.pm4
         The macro is the same as the WS4.0 version of Short-1       
      except for the directory designations.
        
        
        
.pm1
335. Short-2 (4.0):  O\WS4\SET2^M\WS4\WSSHORT.OVR^MYX

.pm4
         The macro is the same as the WS4.0 version of Short-1       
      except for the first filename.



.pm1
336. Short-2 (5.x):  O\WS5\SET2^M\WS5\WSSHORT.OVR^MYX

.pm4
         The macro is the same as the WS5.x version of Short-1       
      except for the first filename.



.pm1
337. Short-2 (6.0):  O\WS\SET2^M\WS\WSSHORT.OVR^MYX

.pm4
         The macro is the same as the WS6.0 version of Short-1             
      except for the first filename. 
.pl66
.pm1
338. Synonym (4.0, 5.x, 6.0):  ^QJ

.pm4
         The macro displays synonyms for the word at the cursor. 



.pm1
339. Synonym (7.0):  Sub Main
                     Key ("^QJ")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same function.
        


.pm1
340. FoneNbr (4.0):  ^QS^KB^K3^N^N^X^X^K4^KK^E^KR\WS4\FONENBR^M
                     ^KH^QF 

.pm4
         The macro is the same as the one described in note 228             
      except for the filename.



.pm1
341. FoneNbr (5.x):  ^OK\WS5\FONENBR^M^OD^QF<SP>^XU^E^G 

.pm4
   ^OK\WS5\FONENBR^M opens a window on the file FONENBR.
   ^OD hides any Tab markers that may have been left between 
      names and telephone numbers in the FONENBR file.
   ^QF<SP>^XU^E^G displays a search screen.  (See note 321.)
        
        
         
.pm1
342. FoneNbr (6.0):  ^OK\WS\FONENBR^M^OD^QF<SP>^XU^E^G 

.pm4
         The macro is the same as the last one except for the       
      directory designation.



.pm1
343. FoneNbr (7.0):  Sub Main
                     Key ("^OK\WS\FONENBR{F10}^OD^QF<SP>")
                     Key ("^XU^E^G")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
344. Tm&Date (4.0):  R^H^K^FTIMEDATE^M

.pm4
    R^H^K^F displays a DOS command line whether the macro is 
      executed at the opening menu or at the editing screen.        
      (See note 80.)
    TIMEDATE^M runs the TIMEDATE batch file.
        
.pm1
345. Tm&Date (5.0, 5.5):  R^H^FTIMEDATE^KK^KH^QHT^L^KB^KY^A
                         ^KFTIMEDATE^M 

.pm4
         The macro is structured like the one describe in note       
      81.  The difference is that Tm&Date runs a batch file       
      instead of deleting BAK files.



.pm1
346. Tm&Date (5.5C, 6.0):  R$^H^H^FTIMEDATE^KK^KH^QHT^L^KB^KY
                          ^A^KFTIMEDATE^M

.pm4
         The macro is structured like the one described in note       
      82.  The difference is that Tm&Date runs a batch file       
      instead of deleting BAK files.  
         


.pm1
347. Tm&Date (6.0D):  S^S^G^KFTIMEDATE^M^KQN^[^[

.pm4
    S^S^G^KF displays a DOS command line whether the macro is 
      executed at the opening menu or at the editing screen.        
      (See note 83.)
    TIMEDATE^M runs the batch file TIMEDATE.
   ^KQN^[^[ performs as described in note 83.
        
        
        
.pm1
348. Tm&Date (7.0A):  Sub Main
                      Key ("S^S^G^KFTIMEDATE{F10}")
                      PauseForInput ("{F10}", 'Press F10.')
                      Key ("^D^KQ")
                      IfException
                      Def: Key ("N")
                      End IfException
                      End Sub

.pm4
         The macro is patterned after the WS7.0A version of       
      ADirect.  (See note 138.  Also see notes 83 and 137.)



.pm1
349. Tm&Date (7.0C):  Sub Main
                      SetHelpLevel (4) : AutoRestore (On)
                      Key ("{ALT+F}RTIMEDATE{F10}")
                      End Sub

.pm4
         The macro is patterned after the WS7.OC version of 
      ADirect  (See note 139.)
        
.pa
.pm1
.pl67
350. PFlop (4.0, 5.0, 5.5C, 6.0):  ^QH^M^KB^KH^F^B^S^S^QD^D^KK
                                   ^KY^F^F^B^S^S^QD^D^U

.pm4
   ^QH^M finds the Return above the home paragraph.  It will be 
      assumed the home paragraph is paragraph 1.
   ^KB marks the start of a block.
   ^KH dissolves any block highlighting.  (See note 14.)
   ^F^B^S^S^QD^D^KK places the cursor at the end of the last line 
      of the home paragraph and marks the end of a block.  
   ^KY erases paragraph 1.
   ^F^F moves the cursor into paragraph 2.
   ^B^S^S^QD^D positions the cursor one line below paragraph 2.
   ^U undeletes the home paragraph (formerly paragraph 1), 
      placing it after paragraph 2.  



.pm1
351. PFlop (5.5):  ^OJ^QH^M^Y^S^KB^KH^F^B^S^S^QD^D^KK^KY^F^F^B
                   ^S^S^QD^D^U  

.pm4
         The macro is the same as the last one except that       
      ^OJ^QH^M^Y^S is used at the start in place of ^QH^M.  (See                   
      note 18.)
        
        
        
.pm1
352. PFlop (7.0):  Sub Main
                   WSQuiet (On)
                   Key ("^QF^P^M^P^J{TAB}B{F10}")
                   Key ("^KB^KH^F^B^S^S^QD^D^KK^KY")
                   Key ("^F^F^B^S^S^QD^D^U")
                   WSQuiet (Off)
                   End Sub

.pm4
         The macro performs the same functions as the one             
      described in note 350.  The search command ^QF is used here       
      in place of ^QH (see note 19), and the WSQuiet feature is             
      added.
        
        
        
.pm1
353. FlopWds (4.0):  ^D^A^T^D^D^A^D^F^U^K2^QH^M^D^B^Q2^K2^D^F 

.pm4
   ^D^A^T deletes the first of the two words to be transposed.    
   ^D^D^A^D^F moves the cursor through the second of the two 
      words and leaves it at the start of the next word.  
      Ordinarily, ^F would accomplish the same purpose.  The       
      extra characters are needed when the macro is executed with       
      the cursor on the last word in a line.
   ^U unerases the deleted word.
   ^K2^QH^M^D^B leaves a place mark, moves the cursor to the 
      start of the home paragraph and reforms the paragraph. (The 
      transposition may have thrown the paragraph out of 
      alignment.)
   ^Q2^K2 returns to and erases the place mark.
   ^D^F advances the cursor a word.
.pl66
.pm1
354. FlopWds (5.0):  ^OA^D^A^T^D^D^A^D^F^OA^U^D^F

.pm4
   ^OA switches off auto-align.  The cursor may become 
      incorrectly positioned in certain situations if auto-align 
      is left on.
   ^D^A^T^D^D^A^D^F performs as described in the previous note.
   ^OA switches auto-align on.
   ^U unerases the deleted word. 
   ^D^F advances the cursor a word. 



.pm1
355. FlopWds (5.5, 6.0):  ^D^A^T^D^D^A^D^F^U^D^F

.pm4
         The macro is the same as the last one except that two       
      ^OA's are omitted.



.pm1
356. FlopWds (7.0):  Sub Main
                     Key ("^D^A^T^D^D^A^D^F^U^D^F")
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same functions.



.pm1
357. ViewMac (4.0, 5.x, 6.0):  ^[? 

.pm4
   ^[ displays the Shorthand menu.  
    ? displays the Shorthand definition screen.



.pm1
358. FullWin (5.x, 6.0):  ^OM24^M

.pm4
   ^OM displays a screen used to change the size of a window.
    24^M allocates the entire screen to the active window and 
      executes a Return.
        
        
         
.pm1
359. FullWin (7.0):  Sub Main
                     WSQuiet (On)
                     Key ("^OMF{F10}")
                     WSQuiet (Off)
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same function.  F is used in place of 24 to       
      display a full-screen window.  The WSQuiet feature is 
      added.  (See note 4.)
        
.pa
.pm1
360. PartWin (5.x, 6.0):  ^OM12^M

.pm4
         The macro allocates 12 lines to the active window.

       

.pm1
361. PartWin (7.0):  Sub Main
                     WSQuiet (On)
                     Key ("^OMH{F10}")
                     WSQuiet (Off)
                     End Sub

.pm4
         The macro differs from the last one in format but 
      performs the same function.  H is used in place of 12 to 
      allocate half the screen to each window.  The WSQuiet 
      feature is added.  (See note 4.)



.pm1
362. Wordage (4.0):  ^KFWC<SP>

.pm4
   ^KF displays a DOS prompt.
    WC<SP> enters WC (for Word Count) on the prompt line and 
      leaves a blank space.  The user types a filename and 
      presses Return.
    


.pm1
363. Wordage (5.x, 6.0):  ^K1^KH^K? 

.pm4
   ^K1^KH leaves a hidden place mark.  (See note 159.)
   ^K? does a word count.  The cursor will be left at the bottom 
      of the file.  The user can return to the place mark by       
      executing YMark (note 204) or by pressing ^QP.

     
.pm1
364. Wordage (7.0):  Sub Main
                     Key ("^K?")
                     Key ("^QP")
                     End Sub

.pm4
    Key ("^K?") does a word count.  The cursor is left at the 
      bottom of the file.  The user presses Esc to close the 
      word-count box.  
    Key ("^QP") returns the cursor to the position it occupied 
      when the macro was executed.  
.pa
.mt5
.mb6

.heHOLY MACRO!                                                #
.hm2
.fm2
.lm1
.rm65
.ls1
.cw12
.po 1i
.lh8
.ps off
.pl66
.op
.fo                                #  
.pn286

..         This file will be difficult to read onscreen unless
..      the print-control characters are hidden.  To hide those
..      characters, hold down Ctrl and press the letters O and D.












     I n d e x *









                    addresses
                      copying to letter, 106-108
                      finding, 105-106
                      lists of, 102-105
                      printing to envelopes, 125-128
                      use of in creating headers, 116-118
                    AddSent, 34 (200)
                    AddWord, 37-38 (202)
                    ADirect, 70 (227-228)
                    AltFont, 47 (210)
                    AutoRestore function, example of use,
                           note 84 (214)


                    ^B, line spacing and, 19, 95
                    backups, 22-26
                    BakFile, 85 (236-237)
                    BAK files
                      deleting, 54
                      importing, 85-86
                    batch files, 73, 162-163, 176-183
                    blocks
                      adding lines to, 27-28
                      adding paragraphs to, 30
                      adding sentences to, 34-35

                      


*Macro labels are boldfaced.  Parenthetical references are to 
endnote page numbers.
.fo


     
     



                    blocks (continued)
                      adding words to, 37-38
                      copying, 29, 37
                      lowercasing, 44, 45-46
                      marking lines as, 27-28
                      marking paragraphs as, 29-31, 38
                      marking sentences as, 32-36, 38
                      marking words as, 37-38
                      moving, 29, 30-31, 35-36, 37, 38
                      printing, 123-124
                      storing in holding file, 93-94
                      uppercasing, 44, 45
                      unerasing, 16
                    BodyTxt, 49-50 (211)
                    Bold, 39 (203)
                    Boldface symbols
                      enclosing miscellaneous strings in, 39-40
                      enclosing paragraphs in, 41
                      enclosing sentences in, 40-41
                      enclosing words in, 39
                      deleting, 42
                    BtmFile, 97 (244)


                    case, converting, 44-46
                    control characters, double, 20
                    CopFlop-1, 22-23 (186-189)
                    CopFlop-2, 23-24 (189-190)
                    CopFlop-3, 25 (190-192)
                    CopName-1, 106 (251-252)
                    CopName-2, 107 (252-254)
                    CRT files, 153, 182-183


                    date, current, 161-163
                    DateLtr, 51 (211)
                    DblFind, 150 (278)
                    DblHd, 82 (234)
                    DblSpc, 95 (243)
                    deletions
                      of BAK files, 54
                      of boldface symbols, 42
                      of CRT files, 182-183
                      to end file, 55-56
                      to end page, 57

     
     
     
     
     
     



                    deletions (continued)
                      to end paragraph, 58-59
                      to end sentence, 60-61
                      of italics symbols, 43
                      of paragraphs, 62
                      of sentences, 63-64
                      to start file, 65
                      to start paragraph, 66-67
                      to start sentence, 68
                      of words, 69
                    directories, swapping, 74-75, 181-182
                    DOS programs, running, 137-138
                    DownBar, 83 (234-235)
                    DownBlk, 84 (235-236)
                    DownZap-1, 58 (216-217)
                    DownZap-2, 59 (217)


                    ellipses, entering, 76-77
                    EndBlk, 30 (194)
                    endnotes, see notes
                    Enter key, 3
                    envelopes, printing, 125-128
                    erasures, see deletions
                    

                    file-list displays
                      Drive A, 70-71
                      Drive C, 72-73
                    files
                      backing up, 22-26
                      batch, 73, 162-163, 176-183
                      importing, 85-88
                      moving, 99-101
                      printing, 129-130
                      reforming, 131-132
                      reopening, 135-136
                      spellchecking, 151-153
                    FindRep, 148 (277)
                    FlopWds, 165 (283-284)
                    FoneNbr, 159 (281)
                    fonts
                      changing, 47-50
                      using page offsets with, 49
                    footnotes, entering, 79-80










                    Footsie-1, 79 (232-233)
                    Footsie-2, 79-80 (233)
                    Footsie-3, 80 (233)
                    FullWin, 167 (284)
                    function-key macros (WS4.0-6.0)
                      default definitions for, 8
                      definition screen for, illus., 5, 6
                      display of labels for, 6
                      entering definitions for, 4-7
                      execution of, 7
                      length limits, 17


                    Go2Name, 102 (249-250)
                    Go2Page, 78 (232) 
                    GrafBlk, 29 (193-194)


                    Hanger, 91 (240)
                    hard drive, parking, 121-122
                    Header-1, 116 (258-259)
                    Header-2, 118 (259)
                    headings, 81-82
                    HideDots function, example of use, note
                           313 (274)
                    HiScree, 140 (272)
                    HoldBlk, 93 (240-242)
                    holding files, 93-94


                    IfException clause, examples of use,
                           note 4 (188), note 199 (242)
                    ImpBoil, 88 (237)
                    Import, 87 (237)
                    importation
                      of BAK files, 85-86
                      of other files, 87-88
                    Indent-1, 89 (238)
                    Indent-2, 90 (238-239)
                    indentions
                      of text, 89-92
                      as used in this handbook, 21
                    Ital, 42 (207)
                    italic symbols
                      enclosing miscellaneous strings in, 42-43










                    italic symbols (continued)
                      enclosing paragraphs in, 43
                      enclosing sentences in, 43
                      enclosing words in, 42
                      deleting, 43
     
     
                    JunkBtm-1, 55 (214-215)
                    JunkBtm-2, 55-56 (215)
                    JunkTop-1, 65 (221)
                    JunkTop-2, 65 (221-222)
                    Justify-1, 133 (268)
                    Justify-2, 133 (268)
                    Justify-3, 123 (268)


                    ^KH, hiding blocks with, note 14 (192-193)
                    KillBak, 54 (212-214)
                    ^KK, as place mark, note 23 (196)


                    letters
                      dating and signing, 51-53
                      numbering pages of, 116-118
                    LineBlk, 27 (192-193)
                    lines
                      blocking, 27-28
                      highlighting, 83
                    line spacing, 95
                    LMargin, 97 (244)
	            LoCase-1, 44 (208)
                    LoCase-2, 45 (209-210)
                    LogBiz, 74 (231)
                    LogMain, 74 (230-231)
                    LoScree, 140 (272-273)


                    macros
                      alternate set of for Shorthand, 156-157
                      functions of described, 17
                      numbers appended to labels of, 19
                      reference numbers for, 17
                      testing with WS4.0-6.0, 169-175
                      testing with WS7.0, 13-14











                    macros (continued)
                      two-step Shorthand definitions for, 11-12
                      uppercased letters in, 19-20     
                    Mark, 96 (243)
                    Merge, 112 (256-258)
                    merge printing, 112-115
                    Mv2Biz, 99-100 (248-249)
                    Mv2Main, 99 (245-248)
                    MvGrafs, 30 (195)
                    MvMisc, 38 (202-203)
                    MvSents, 35 (200-201)


                    names and addresses, see addresses
                    NorFont, 47 (210)
                    notes, 184-285
                      reference numbers for, 17
                    NxtGraf, 142 (273-274)
                    NxtPage, 141 (273)
                    NxtSent, 144 (275-276)
                    NxtZap, 60 (218-219)


                    O, when underlined, 19
                    Omit, 76 (232)
                    OpenLtr, 52 (212)
                    Outdent-1, 89-90 (238)
                    Outdent-2, 91 (239-240)
                    

                    ^P, as Shorthand command prefix, 10
                    paragraphs
                      blocking, 29-31
                      copying, 29
                      deleting, 62
                      highlighting, 84
                      moving, 29, 30-31
                      reforming, 133-134
                      transposing, 164
                    Park, 121 (260-261)
                    PartWin, 167 (285)
                    PauseForInput function, examples of use,
                           note 4 (188), note 15 (193)
                    PBold, 41 (205-206)
                    PFlop, 164 (283)










                    phone lists, 159-160
                    place marks, 96-98, 146-152
                    ^PP
                      how to enter, 21
                      as place mark, note 26 (198)
                    PreSort, 108-109 (254-255)
                    Preview, 130, 152-153
                    ProFont, 48 (210)
                    program access menu, 176-181 
                    PrtBlk, 123 (261-263)
                    PrtEnvl-1, 125 (263-264)
                    PrtEnvl-2, 127 (264-265)
                    PvsGraf, 142 (274-275)
                    PvsPage, 141 (273)
                    PvsSent, 144 (276)
                    PvsZap, 68 (225-226)


                    ^Q{DEL}, 18
                    ^Q<DELETE>, 18
                    ^QP, as macro, 11
                    Quest, 146 (276-277)
                    QuikPrt-1, 129 (265-266)
                    QuikPrt-2, 129-130 (266)
                    QuikPrt-3, 130 (266-276)
                    QuikSav, 139 (272)


                    Rebuild, 110 (255-256)
                    Reopen-1, 135 (269)
                    Reopen-2, 135 (269-270)
                    Reopen-3, 136 (270)
                    Return
                      key name, 3
                      using to switch off file list, 25-26
                    RfmFile-1, 131 (267)
                    RfmFile-2, 131 (267)
                    RfmFile-3, 131-132 (267-268)
                    RMargin, 97-98 (244-245)


                    save, with WS4.0, 139
                    SBold, 40 (204-205)
                    scrolling 
                      by page, 141










                    scrolling (continued)
                      by paragraph, 142-143
                      by screen, 140
                      by sentence, 144-145
                    searches, 146-150
                    SentBlk-1, 32 (195-196)
                    SentBlk-2, 32-33 (196-199)
                    sentences
                      blocking, 32-36
                      deleting, 63-64
                      moving, 35-36
                    SentZap-1, 63 (219)
                    SentZap-2, 63-64 (220-221)
                    SetHelpLevel function, example of use,
                           note 84 (214)
                    SglSpc, 95 (243)
                    Short-1, 156 (280)
                    Short-2, 156 (280)
                    Shorthand
                      assigning macros to F keys, 17-18
                      defining macros for, 8-12
                      definition screen for, illus., 9-10
                      displaying definition screen for, 166
                      executing macros with, 11
                      menu for, illus., 9
                      swapping macro sets, 156-157
                      two-step macro definitions for, 11-12  
                    <SP>, as used in macros, 18
                    spaces, double, 33-34, 36, 41, 59, 61, 64,
                           67, 68
                    spellchecks, 151-155
                    SplFile, 151 (279)
                    SplPrev, 152 (279)
                    SplSyn, 155 (280)
                    SplWord, 154 (279)
                    subdirectories, references to, 20
                    SubHd, 81 (234)
                    Synonym, 158 (281)


                    TagLine, 27 (193)
                    telephone numbers, 103, 104, 105, 159-160
                    time of day, 161-163
                    Tm&Date, 161 (281-282)
                    TopFile, 96 (243-244)










                    transpositions
                      of paragraphs, 164
                      of words, 165
                    TsRoman, 48 (210-211)


                    UnBold, 42 (206-207)
                    UpBar, 83 (235)
                    UpBlk, 84 (236)
                    UpCase-1, 44 (208)
                    UpCase-2, 45 (209)
                    UpZap-1, 66 (222-223)
                    UpZap-2, 67 (223-224)


                    ViewCee, 72 (228-230)
                    ViewMac, 166 (284)


                    WideHd, 81 (234)
                    WinBiz, 119 (260)
                    windows
                      changing size of, 167
                      opening, 119-120
                    WinMain, 119 (259-260)
                    Wordage, 168 (285)
                    WordBlk, 37 (201-202)
                    words
                      blocking, 37-38
                      checking spelling of, 151-155
                      counting, 168
                      deleting, 69
                      finding synonyms for, 155, 158
                      transposing, 165
                    WordStar
                      5.x, defined, 17
                      5.5C, macros for, 17
                      6.0D, macros for, 17
                      7.0
                        macros for, 13-15
                        copying macro files, 13-14 
                        Reference manual, 13
                      opening menu, 2
                    WordZap, 69 (226)
                    WSCHANGE, modifying, 16, 169-170










                    WSQuiet function, example of use,
                           note 4 (188) 


                    XBold, 39 (203-204)
                    XItal, 42-43 (207-208)
                    XTree, 137 (270-272)


                    YMark, 96, (243)


                    ZapGraf, 62 (219)
                    ZapPage, 57 (215-216)
.pa
