}  `LASERJET                                                                                                              } ..
..   Manual for MICKEE 6.D.4L
..   The Mouse Interface for the Control-Key Editing Environment
..   Supporting WordStar 6.D Pulldown Menus and Advanced Page Preview 
..
..   Copyright 1989, 1990, and 1991 by Robert J. Sawyer
..
..   This file is formatted for printing by WordStar 6.0 with 
..   a single 10-pitch fixed-width font that uses the IBM
..   extended character set.  Bold and underline are the only 
..   print attributes required.  Italic text is used, but only for 
..   decorative purposes.  
..
..   Issue ^P? while in document mode to select your own printer.  
..   Make sure the two font tags below both show a 10-pitch fixed-width
..   font, ideally with the IBM extended character set (you can jump 
..   to the font tags by issuing ^Q=).
..
..   This file contains several page offset (.po) dot commands.  The values
..   are correct for LaserJet IIP/IID/III/IIID printers, which have .3" of
..   dead space at the left side of the page.  For other printers, these
..   values may be too little.  
..
..   The title page and table of contents appear at the end of this file.
..   Please manually shuffle them to the front of your printout.  
..
.tc .pf on
.tc .rr-----------------------------------------------------------!-R
.tc
.tc
.tc
.tc
.tc .oc on 
.tc T A B L E   O F   C O N T E N T S
.tc .oc off
.tc
.tc
.tc
.tc
.sb on
.sv R=RR
.mt 1"
.mb 1"
.lm 0"
.rm 6.5"
.pm 0
.tb 0.5"
.hm 0.22"
.pl 11"
.ls 1
.po 0.7"
.op
.fo
.oj off
.aw on
..
.. do NOT change this line height!
.lh 12pt
.h1 
 	ll]'
    D  D Sawyer / MICKEE 6.D.4L / #
.hm3
.tc Highlights 
 	h0*.
  &#/r&
..
.. check font specified on the next line:  it must be 10-pitch fixed-width
.. and ideally should contain the IBM extended character set.  
..


   D  D HIGHLIGHTS


 

 	 
 MICKEE Version 4.0 Release 6.D.4L is a mouse interface for 
WordStar 6.0 Revision D and above using Help-Level 4.  This 
release works exclusively with Logitech and compatible three-
button mice (either older beige models or newer white models) and 
Logitech TrackMan trackballs.  MICKEE has been tested with 
Logitech Mouseware Versions 4.00, 4.10, and 5.00.  (Other 
versions of MICKEE are available:  see Appendix A at the end of 
this manual.)


 	 
 Although fully protected by copyright, MICKEE can be freely 
used with any registered copy of WordStar.  Among MICKEE's 
features are:  

.pm 1
.tb 0.3"
.lm 0.3"

 	h 
 Context sensitivity:  MICKEE always knows what you're doing.  

 	
 It responds correctly whether you are at the Opening Menu, 

 	
 editing a file, using the thesaurus, in a dialog box, in a 

 	
 pulldown menu, or using Advanced Page Preview.  


 	h 
 Simple one-button operation:  The left mouse button always 

 	
 brings down a pulldown menu if one isn't already active.  The 

 	
 left button also always selects an option from a pulldown 

 	
 menu.  (With WordStar International's WS.DEF, on the WordStar 

 	
 Advanced Customization diskette, you have to remember to press 

 	
 the middle button to pull down a menu and the left button to 

 	
 select-- very confusing!).  


 	h 
 Pointing and shooting:  At all WordStar file, font, PIX, and 

 	
 other directories; at words in the thesaurus; at submenu names 

 	
 in the Notes and Paragraph-Style menus; at note types in the 

 	
 Convert-Notes dialog box; at subdirectory names; and at disk 

 	
 drive letters, page numbers, suggested spelling corrections, 

 	
 and window sizes.  


 	h 
 Fast block manipulation:  Buttons mark the current sentence or 

 	
 paragraph; button combinations set beginning and ending block 

 	
 markers, move blocks with reformat at the source and 

 	
 destination, and hide or reveal marked blocks.  


 	h 
 Full support for Advanced Page Preview:  Use APP's pulldown 

 	
 menus to select functions, or use the mouse buttons to magnify 

 	
 or reduce the image, jump back to a full-page view, or adjust 

 	
 the viewing window.  


 	h 
 Works with any number of screen rows:  MICKEE works fine 

 	
 whether you install WordStar for the standard 25 lines, 43-

 	
 line EGA mode, or 50-line VGA mode.  
.pa  5   2                     
.lm 0"
.pm 0
.tc
.tc Files
 	h0*.
  &#/r&
FILES


.pm1
.lm 1.5"
.tb .5", 1.5"

 	 
 MICKEE consists of these three files:

MICKEE.DOC
 	
 
 This manual
WS.MNU
 	T
 	
 Compiled, ready-to-use version of MICKEE
WS.DEF
 	T
 	
 Source code for MICKEE (replaces the file of the 

 	


 same name that comes with WordStar)
.pm0
.lm1



.tc
.tc Installation 1:  Modifying WordStar
 	h0*.
  &#/r&
INSTALLATION 1:  MODIFYING WORDSTAR



 	 
 To use MICKEE, you must install WordStar to use the Help-
Level-4 pulldown menus.  If you want WordStar's pulldowns to 
behave like proper mouse menus, you should use the new feature in 
WordStar 6.0 Rev. D that prevents cursor run-on in these menus.  
If you want the cursor to behave like a proper mouse cursor in 
text mode-- traversing blank lines without snapping back to 
column 1-- you'll also want to turn on the new feature in 
WordStar 6.0 Rev. D that allows this.  Finally, to make Help-
Level 4 more usable, you may want to turn on the option that 
allows classic commands to be issued directly from the Level 4 
Opening Menu.  


 	 
 To make these changes, run WINSTALL, the WordStar 
customization utility.  Select "Customize WordStar (WSCHANGE)."  
Specify WS.EXE as the filename to modify and WS.EXE again as the 
filename to which changes should be saved.  


 	 
 If you are using a Help Level other than 4 (that is, if you 
have installed WordStar for Classic menus), begin with step 1.  
If you are already using Help-Level 4, begin with step 2.  

.lm 0.5"
.pm 1
1.
 	 
 Mandatory:  to activate use of WordStar's pulldown menus, go 

 	
 to WSCHANGE menu D (WordStar), B (Editing settings), A (Edit 

 	
 screen, help level), A (Help level, which is label INIHLP).  

 	
 Select 4.  Issue ^X to jump to the WSCHANGE exit point.  

 	
 Answer "n" to the "Are you through making changes?" 

 	
 question.  

2.
 	 
 Highly recommended:  to prevent cursor run-on in the 

 	
 pulldown menus, go to WSCHANGE menu D (WordStar), B (Editing 

 	
 settings), A (Edit screen, help level), 3 (Edit screen, help 

 	
 level menu#3), K (Turn cursor wrap on pull-downs on or off, 

 	
 which is label WRPPUL).  Select OFF.  Issue ^X to jump to 

 	
 the WSCHANGE exit point.  Answer "n" to the "Are you through 

 	
 making changes?" question.  

.cp4  4   2                     
3.
 	 
 Recommended:  To make the cursor not snap back to column 1 

 	
 when passing over a blank line, go to WSCHANGE menu D 

 	
 (WordStar), B (Editing settings), H (WordStar 

 	
 compatibility), K (Vertical cursor movement, which is label 

 	
 SAMCOL).  Select 2.  Answer "n" to the "Are you through 

 	
 making changes?" question.  

4.
 	 
 Recommended:  To allow you to issue classic commands from 

 	
 WordStar's Help-Level-4 Opening Menu (such as "D" to open a 

 	
 document or "X to exit WordStar) without having to first 

 	
 activate a pulldown menu, go to WSCHANGE menu D (WordStar), 

 	
 B (Editing settings), H (WordStar compatibility), I (Classic 

 	
 commands at Opening pull-down menu, which is label PULFLG).  

 	
 Make sure this is set to ON.  (Note:  As of 6.0D, this 

 	
 feature is on by default, but if you've used WordStar's 

 	
 auto-patcher to transfer your customizations from a previous 

 	
 release of WordStar, this may have been reset to off.)
.lm1
.pm 0


 	 
 Once again, issue ^X to jump to the WSCHANGE exit point, but 
this time answer "y" to the "Are you through making changes?" 
question.  




.pm 0
.lm 1
.tc 
.tc Installation 2:  Modifying MICKEE 
 	h0*.
  &#/r&
INSTALLATION 2:  MODIFYING MICKEE



 	 
 I've provided the annotated source code for MICKEE (file 
WS.DEF) for those who care to modify the way MICKEE works.  


 	 
 To modify MICKEE, use WordStar to edit WS.DEF in non-
document mode.  There are a few items in WS.DEF you might 
particularly want to modify.  They are described below.


Mouse Sensitivity

Near the beginning of WS.DEF are the settings for the horizontal 
and vertical mouse sensitivity.  If you prefer a more responsive 
mouse, decrease these numbers.  If a less responsive mouse is to 
your liking, increase these numbers.  


Cursor Movement in Text

     Since most writing is word- rather than character-oriented, 
while editing MICKEE causes the cursor to jump left and right by 
whole words instead of characters.  This should simplify the 
marking of text blocks.  When the cursor is within a pulldown 
menu, a dialog box, or Advanced Page Preview, the left and right 
mouse movements are reprogrammed to correspond to the left and 
right arrow keys.  
   6   2                     

 	 
 If you don't like MICKEE moving the cursor by words instead 
of characters, open WS.DEF in non-document mode.  Find the lines 
that say:


 	 
 LMword:        TYPE 1                    ; ^A


 	 
 RMword:        TYPE 6                    ; ^F

Change them to say:


 	 
 LMword:        TYPE 0,75                 ; <Left Arrow>

 	 
 RMword:        TYPE 0,77                 ; <Right Arrow>


Default Find Options


 	 
 MICKEE'S "Mark Sentence" feature uses WordStar's own Find 
capability.  In so doing, it clears the values in the Find dialog 
box.  MICKEE is a polite rodent, though.  It resets the default 
Find options after each operation.  As supplied, MICKEE resets 
the defaults to UA, meaning "ignore case" and "align text if 
making a replacement."  If you would like to change these 
defaults, follow the instructions given in the WS.DEF file to 
edit the text of the line that begins "marksentb" (it's very near 
the end of the file).  


Valid Disk Drives


 	 
 Finally, you may find that MICKEE's log-disk pop-up menu 
shows drive letters that are not valid on your system, or lists 
them in an order you don't like.  This pop-up is easily 
modifiable, and instructions are given in the WS.DEF file, 
starting with the line "Log-Drive pop-up."  


Compiling a New MICKEE


 	 
 To make your changes take effect, you have to recompile 
MICKEE (that is, turn it into a form usable by the Logitech 
mouse).  Here's how:


 	 
 Copy WS.DEF to your mouse subdirectory, which should contain 
the Logitech program NEWMENU.EXE, and issue the command:


 	!
 C>NEWMENU WS


 	 
 That's it!  Your revised MICKEE is ready to roll.  
.pa  1   2                     
.tc
.tc Loading MICKEE 
 	h0*.
  &#/r&
LOADING MICKEE



 	 
 If you use Logitech's CLICK.EXE to automatically switch 
mouse menus when you change programs, use WordStar's non-document 
mode to edit the file CLICK.SRC, which came with your Logitech 
mouse.  If no entry for WS exists, add this line:  


 	!
 WS menu 3buttons        ; WordStar 6.0D (MICKEE)


 	 
 If a WS entry does exist, then edit it to look like the one 
above.  You must then recompile CLICK using the Logitech 
NEWCLICK.EXE program.  Do that by issuing this command:


 	VV!
 C>NEWCLICK


 	 
 If you (1)store WS.MNU in your mouse subdirectory, and 
(2)have that subdirectory on your DOS PATH, and (3) run the 
Logitech programs MOUSE, LOGIMENU, and CLICK in your AUTOEXEC.BAT 
file, then MICKEE will load automatically each time you start 
WordStar.  (LOGIMENU.COM is the Logitech-supplied mouse-interface 
loader; note that if you have an older beige Logitech mouse, this 
program is simply called MENU.COM.)  However, I prefer not to use 
CLICK, because it takes up memory.  Instead, I like to start 
WordStar with a batch file containing these lines:

.tb 1.8"

 	 
 c:\mouse\logimenu c:\mouse\ws

 	 
 c:\ws\ws %1 %2 %3

 	 
 c:\mouse\logimenu off
.tb 0.5"


 	 
 (Substitute "menu" for "logimenu" if you have an older beige 
Logitech mouse; substitute the actual drive and subdirectory 
containing your WordStar program files for "c:\ws"; substitute 
the actual drive and subdirectory containing your mouse files for 
"c:\mouse".)  


 	 
 The first line of this batch file loads MICKEE; the second 
loads WordStar with any filename and command-line switches you 
specify; the third shuts the mouse off when you exit WordStar so 
that MICKEE commands won't accidentally be activated in another 
program.  


 	 
 I wrote MICKEE to be very frugal with your precious RAM, 
since WordStar demands so much of it.  MICKEE is content with 
just three kilobytes of RAM.  By default, Logitech's LOGIMENU.COM 
program sets aside a five-kilobyte buffer for the currently 
active compiled menu; you can reduce that to the three kilobytes 
MICKEE needs by loading LOGIMENU the first time after you start 
your computer with this command line (perhaps in your 
AUTOEXEC.BAT file), freeing up two kilobytes of RAM:


 	HH!
 C>LOGIMENU /3

(Or, C>MENU /3, for older beige Logitech mice.)   6   2                     
.pa
.tc
.tc Checking Which Release of MICKEE is Loaded 
 	h0*.
  &#/r&
CHECKING WHICH RELEASE OF MICKEE IS LOADED



 	 
 To check which release of MICKEE you have loaded, open a 
file, issue ^KL (or use MICKEE to choose "Change drive / 
directory..." from the "File" pulldown menu), and press the 
middle mouse button.  You'll see your MICKEE release number to 
the left of the list of drive letters.  This manual is for 
release 6.D.4L, which only works with Logitech three-button 
pointing devices and WordStar 6.0 Rev. D or later.  To clear the 
release display, click on the happy face at the right end of the 
menu.  




.tc
.tc How MICKEE Knows What's Going On 
 	h0*.
  &#/r&
HOW MICKEE KNOWS WHAT'S GOING ON



 	 
 MICKEE reads your screen while you're working.  If it sees 
the letter "W" (part of the word "WORDSTAR") on line 1 beginning 
at column 37, it knows you're at the Opening Menu.  If it sees an 
"E" (part of word "EDIT" at the right end of the EDIT pulldown 
menu bar) on line 2 beginning at column 73, it knows you're 
editing a file.  If you are editing a file, it then looks for a 
right-pointing arrowhead character at line 2, column 1.  If such 
a character is visible, MICKEE knows you've already activated a 
pulldown menu and programs the mouse buttons accordingly.  If 
that character is not visible, then MICKEE assumes your cursor is 
inside the document, and, again, programs the mouse buttons 
accordingly.  


 	 
 MICKEE checks to see if you are inside a dialog box or 
Classic menu by looking for a  character (part of the border 
around Classic menus and dialog boxes) in line 2 at column 1.  If 
it finds one, it then checks to see which menu or dialog box you 
are in by reading the name off the screen, and then programs the 
buttons accordingly.  


 	 
 If it doesn't find the  character, and has also been unable 
to find the "W" in WORDSTAR or the "E" in "EDIT," it then assumes 
you must be in Advanced Page Preview and once more reprograms the 
mouse buttons.  (Unfortunately, there is no way to suppress 
cursor wrapping in Advanced Page Preview's pulldown menus.)  
.pa  `	-   2                     
.tb 0.5"
.lm 0"
.pm 0
.tc
.tc Compatibility Notes 
 	h0*.
  &#/r&
COMPATIBILITY NOTES




 	 
 MICKEE supports every standard WordStar screen installation, 
including the default 25-line mode; 43-line EGA mode; and 50-line 
VGA mode.  Indeed, MICKEE support any number of screen rows, so 
long as you are using 80 columns.  (The Logitech mouse software 
only supports 80-column screens.)



.cp4
Non-English-Language WordStars


 	 
 MICKEE may fail if you are using a non-English-language 
version of WordStar, because the word "EDIT" in the pulldown menu 
bar may be different.  The following code fragment in WS.DEF 
appears several times.  It is responsible for finding the "E" at 
the beginning of the word "EDIT."  You can do a WordStar global 
search-and-replace of this code fragment to make MICKEE check for 
any other ASCII character instead.  Make sure the character you 
specify is not the same one that appears at screen row 2 column 
73 in the OPENING pulldown menu bar.  If it is, try matching the 
character at a different screen column instead.


 	::!
 MATCH 2,73,,"E",


 	 
 MICKEE's pop-up menus are all in English, but can be changed 
by editing WS.DEF in non-document mode.  




.cp4
Non-Standard Menu Box-Drawing Characters


 	 
 MICKEE may also fail if you've changed the characters 
WordStar uses for drawing boxes around menus (WSCHANGE label 
BOXCHR), because it needs to be able to identify the  character 
that appears at the upper-left corner of menus and dialog boxes.  
Because this character appears in WS.DEF as a naked extended 
character (without the ^[ and ^\ fences WordStar normally puts 
around extended characters) you cannot change it to another 
extended character by using WordStar.  If you must change this 
character in WS.DEF, do so with a straight hexadecimal byte 
editor, such as NU.EXE, part of The Norton Utilities.  
Alternatively, reset the default box-drawing characters by 
running WSCHANGE, selecting menu E (patching), = (Enter User Area 
address), specifying BOXCHR, and typing these six bytes:


 	!
 CD BA C9 C8 BB BC


.cp4  5   2                     
UltraVision


 	 
 UltraVision, from Personics, improves EGA and VGA text 
quality in all applications, and gives users full control over 
their color palettes.  It also provides many non-standard screen 
sizes, and a wide choice of screen fonts.  You can use MICKEE 
under UltraVision with whichever font you like, and with any 
number of rows, but because of the limitations of the Logitech 
software noted above, MICKEE will only work on 80-column screens.  


.cp4
ScreenExtender


 	 
 ScreenExtender, from Stairway Software, lets you dynamically 
reset screen dimensions from within WordStar.  ScreenExtender 
causes WordStar to work in graphics mode.  This makes it 
incompatible with MICKEE, which must be able to read the screen 
in text mode to know in which part of WordStar you are working.




.tc
.tc Mouse Interfaces and InSet 
 	h0*.
  &#/r&
MOUSE INTERFACES AND INSET




 	 
 InSet, the graphics-integration program included with 
WordStar6.0, is mouse-aware.  However, it's also a bully.  If 
you activate InSet while editing (either by issuing ^P& or by 
selecting "Start InSet" from the "Other" Edit Pulldown menu), 
your mouse will work fine while you are in InSet (the left button 
will issue the equivalent of <Enter>; the middle button, <Space>; 
the right button, <Esc>).  However, when you leave InSet and 
return to editing, InSet will shut off MICKEE (or any other 
compiled Logitech mouse interface).  


 	 
 Charles Edwards has come up with a fix for this.  His fix is 
extensively documented in the file LOGINS.ARC in Library 7 (6/5.5 
Preview/Grphcs) of the CompuServe WordStar Forum.  If you have 
access to CompuServe, I strongly recommend you download Charles's 
file and read his entire instructions.  In case you don't have a 
CompuServe account, here's a quick version of what Charles came 
up with.


 	 
 Charles's fix has only been tested by him with versions 3.41
and 4.00 of the Logitech mouse software, and by me with version 
4.10.  Although the instructions he provides are for WordStar 
5.5C, they seem to work equally well with 6.0D.


 	 
 Warnings:  (1) If you make this patch, you should always run 
WordStar with Logitech's MOUSE.COM loaded.  If you don't and 
particularly if you use an early version of MS-DOS (such as 2.0), 
your system may crash when you invoke InSet.  (2) MICKEE will be 
temporarily disabled when printing a document in the background    6   2                     that contains InSet graphics.  (3) MICKEE will be disabled for 
the remainder of your editing session if you print-to-disk a 
document containing InSet graphics.  (4) You can't use this fix 
if you're already using WordStar's EXTRA patch area for something 
else.


 	 
 Make a back-up copy of your current version of WS.EXE and 
store it in a safe place.  

.cp2

 	 
 Use WordStar's non-document mode to create a file named 
LOGINSET.PAT in the directory that contains your WordStar program 
files.  Type these five lines exactly, and make sure the last 
line ends with a hard carriage return (alternatively, open the 
file containing this manual, MICKEE.DOC, and block write these 
lines to a file):

.aw off
.cp6

INISUB=E9,AB,0D
UNISUB=E9,B3,0D
ULUNPT=E9,14,0A
EXTRA=B8,00,00,CD,33,B8,6C,29,CD,33
=C3,3D,03,00,74,05,B8,00,00,CD,33,C3

.aw on


Go to WSCHANGE menu E (Patching), A (Patch from file), and 
specify the filename LOGINSET.PAT.  When patching is complete, 
exit WSCHANGE. 

.cp3

 	 
 As I said, Charles has provided much more detailed and 
complete instructions in his file LOGINS.ARC and I recommend that 
you acquire this file and read it.


 	 
 If you don't want to make the patch described above, you can 
still work around InSet's bad manners.  Assuming your mouse 
subdirectory is included in your DOS PATH statement, you can 
reload MICKEE after using InSet by temporarily exiting to DOS 
with ^KF and running:


 	HH!
 C>LOGIMENU WS

(or C>MENU WS, if yours is an older beige mouse).  This command 
sequence can be placed in a Shorthand macro, if you like.  (If 
you do so, you may wish to turn off WordStar's prompt to "Press 
any key to return to WordStar."  This is a new option with 
WordStar 6.0D, available at WSCHANGE menu D (WordStar), B 
(Editing settings), A (Edit screen, help level), 3 (Edit screen, 
help level menu#3), J (Turn "Return to WordStar" prompt on or 
off, which is label RUNMSG).  Set it to OFF.  


 	 
 Or, if you prefer, after running InSet, simply save and exit 
WordStar with ^KX then run WordStar again.  
.pa  5   2                     
.tc
.tc Opening Menu Tips and Tricks 
 	h0*.
  &#/r&
OPENING MENU TIPS AND TRICKS



 	 
 Many old-time WordStar users dislike the new Help-Level-4 
Opening Menu because the <Esc> key does not work to activate 
Shorthand macros, even if "Classic commands at Opening pull-down 
menu" is turned on in WSCHANGE (which, starting with 6.0D, is the 
default).  Rich Zuris of WordStar International has provided a 
workaround for this:  with Classic commands on, [ (the opening 
square bracket character) will activate Shorthand from the 
Opening Menu.  


 	 
 There is one big undocumented advantage to using Help-Level 
4 at the Opening Menu, as discovered by Ed Zollars of the 
CompuServe WordStar Forum:  you do not first have to pull down a 
menu to specify that you want to open a file in the default 
editing mode or that you want to change the logged subdirectory.  
Simply point and shoot.  If you point at a filename, WordStar 
will open that file; if you point at a subdirectory name, 
WordStar will log onto that subdirectory.  


 	 
 I found another undocumented goody myself.  If you want to 
change help levels, and have "Classic commands at Opening pull-
down menu" turned on, rather than using the "Change help level" 
command on the Pulldown "Other" menu, you can simply type H 
followed by the help level number you want.  H2 will drop you 
down to Help-Level 2; H4 will scoot you back up to Help-Level 4.  
(One reason to temporarily drop down is that there is no Help-
Level-4 equivalent to the Classic command FF, which sets the 
directory filename mask.)
.pa     2                     
.bp off
.tc
.tc Using MICKEE at the Opening Menu 
 	h0*.
  &#/r&
Using MICKEE at the Opening Menu

.rm 0.7"
.co2, 0.3"  0   0                    

  






  











.rm 6.5"
.tc
.tc Using MICKEE within a Dialog Box 
 	h0*.
  &#/r&
Using MICKEE at the Log Drive/Directory Dialog Box
.rm 0.7"


.rm 6.5"

 	 
 WordStar 6.0 has always let you point and shoot at 
subdirectories, but with MICKEE you now can also point and shoot 
at drive letters.  
.rm 0.7"


  







  










  

.cb  4  0                     
.rm 5.5"
At the Opening Menu, the Left button selects the file 
or subdirectory the cursor is pointing to, or, if you 
are not pointing to a file or subdirectory, it then 
pulls down the File menu.  If a menu is currently 
pulled down, then the left button selects whatever menu 
choice you point to.  

The Right button safely cancels.  If your cursor is in 
the file directory, it jumps the cursor back up to the 
pulldown menu bar.  If a menu has been pulled down, the 
right button closes the pulldown menu without making a 
selection.  

The middle button and the mouse chords (simultaneous 
presses of multiple buttons) are disabled at the 
Opening Menu.  











The Left button logs the subdirectory specified by name 
in the dialog box, if the cursor is there, or logs the 
subdirectory highlighted in the directory listing.  
Tip:  A quick way to navigate your current disk is to 
point-and-shoot at the .. directory entry to move up to 
the parent of the current subdirectory, then point-and-
shoot again at the subdirectory you want.  

The Middle button pops up a point-and-shoot listing of 
drive letters.  The default order is:


 	hh!
 C D E F G H I J K L M N O P Q R S T U V W X Y Z A B

but you can change this to whatever you wish by 
following the instructions in the WS.DEF file.  Note 
that the middle button also reveals your MICKEE release 
number.  To leave this pop-up without changing logged 
disks, click on the happy face at the far right.  

The Right button exits.  




   6 0                     
.co1  2  2                    
.rm 6.5"
.tc
.tc Using MICKEE while Editing a File 
 	h0*.
  &#/r&
Using MICKEE while Editing a File



 	 
 I believe most editing functions can be performed more 
efficiently by using the keyboard rather than a mouse.  However, 
block manipulations are a possible exception.  MICKEE's 
functionality while editing is therefore biased towards marking 
and moving blocks of text, but you can, of course, use your mouse 
under MICKEE to select any WordStar operation listed on the 
pulldown menus.  


.rm 0.7"
.co2, 0.3"  `'
   `'
                    

  



  










  







 



 



 






.cb  4  `'
                     
.rm 5.5"
The Left button brings down the File pulldown menu if 
you are editing, or makes a selection from a pulldown 
menu if you are already in a menu.  

The Middle button marks the sentence containing the 
cursor as a block.  Pressing the middle button again 
marks the next sentence in the document.  MICKEE 
defines a sentence by the method recommended in most 
style guides for manuscript format, requiring two 
spaces after the terminal punctuation.  This way, 
sentences ending with punctuation other than periods 
will be marked correctly and abbreviations such as 
"Dr." will not confuse MICKEE about where a sentence 
ends.  

The Right button marks the paragraph containing the 
cursor as a block.  Pressing the right button again 
marks the next paragraph in the document.  MICKEE 
defines a paragraph as text beginning and ending with a 
single hard carriage return, so you can also use this 
feature to mark isolated lines, such as titles.  
Paragraphs can be indented or not as you please.  

Pressing the Left and Middle buttons simultaneously 
will set WordStar's BEGIN block marker, <B>, just as if 
you had issued ^KB.  

Pressing the Middle and Right buttons simultaneously 
will set WordStar's END block marker, <K>, just as if 
you had issued ^KK.  

Pressing the Left and Right buttons simultaneously will 
move the currently marked block, reformatting the text 
both at the source and destination locations, and then 
hide the block.  

Pressing All Three buttons simultaneously will hide the 
currently marked block, if it is visible, or reveal the 
currently marked block, if it is hidden, just as if you 
had issued ^KH.  
.co1  5 5                    
.tc
.tc Using MICKEE with the Thesaurus 
 	h0*.
  &#/r&
Using MICKEE with the Thesaurus


.rm 0.7"
.co2, 0.3"  /   /                    

  








  











  



 



 

.cb  $  /                     
.rm 5.5"
The Left button selects the word under the cursor in 
the thesaurus window.  If that word is a synonym for 
the word in the document, the synonym is swapped into 
the underlying document, replacing the original word, 
and the thesaurus window is closed.  If instead you are 
looking at the screen that says "Word not found-- near 
alphabet guesses," then the left button will look up 
synonyms for the highlighted near-alphabetic word.  

The Middle button gives you definitions for the word 
under the cursor, assuming definitions are available 
for that word.  The first press gives you the first 
definition.  If that's the only definition, the 
definition will end with a period.  If there is more 
than one definition available, the definition will end 
with a semicolon.  In that case, subsequent presses of 
the middle button will bring up the remaining 
definitions.  When you reach the last definition, you 
can return to the main thesaurus window by pressing the 
right button.  

The Right button exits the thesaurus (or leaves the 
definition function and returns to thesaurus, if you 
were looking at definitions).  

Pressing the Left and Middle buttons simultaneously 
cross-references the highlighted word, just as if you'd 
typed L.  

Pressing the Middle and Right buttons simultaneously 
returns to the previous word, just as if you'd typed P.  


The left-and-right and all-button mouse chords are 
disabled within the thesaurus.  
.co1   '  '                    
.rm 6.5"
.tc
.tc Using MICKEE in Spell, Size-Window, Go-to-Page, Convert-Notes
.tc Dialog Boxes and at the Paragraph-Style and Notes Menus 
 	h0*.
  &#/r&
.aw off
Using MICKEE in the Spell, Size-Window, Go-to-Page, Convert-Notes
Dialog Boxes and at the Paragraph-Style and Notes Menus
.aw on


.rm 0.7"
.co2, 0.3"  .   .                    

  



























  




  

.cb   
)  .                     
.rm 5.5"
The Left button pops up a menu of choices.  

In the Spelling dialog box, these choices will let you 
select WordStar's suggested corrections by number, or 
issue the More, Bypass, Add, Enter Correction, Global 
replace, Ignore, or Exclude commands.   

In the Size-Window dialog box, these choices will let 
you select a full screen for each document, or one-half 
screen in normal 25-line mode, 43-line EGA mode, or 50-
line VGA mode.  

In the Go-to-Page dialog box, you will have the option 
of pointing and shooting at specific page numbers from 
1 to 18, or selecting the next (N) or previous (P) 
page.  

In the Paragraph-Style and Notes menus, the choices 
correspond to submenu names.  The MICKEE copyright 
notice appears on MICKEE's pop-up Notes menu.  

In the Convert-Notes dialog box, you are shown a list 
of the note types to which you can convert.  

If you are happy with the way things are, and want to 
leave the pop-up menu without making a choice, click on 
the happy face at the bottom of the menu.  

The Middle button does the same thing as if you'd 
issued ^K or <F10>, closing a dialog box and executing 
(the middle button does nothing in the Spelling dialog 
box).  

The Right button, as always, exits.  


The mouse chords are disabled within these dialog 
boxes.  
.co1  @+ @+                    
.rm 6.5"
.tc
.tc Using MICKEE in All Other Dialog Boxes 
 	h0*.
  &#/r&
Using MICKEE in All Other Dialog Boxes



 	 
 Within all other dialog boxes (such as "Edit Paragraph 
Style" [^OFD] or "Margins & Tabs" [^OL, among other commands]), 
MICKEE's buttons function as follows:       

.rm 0.7"
.co2, 0.3"  ,   ,                    

  



  


  

.cb  "  ,                     
.rm 5.5"
The Left button issues <Enter>.  This moves the cursor 
to the next field in the dialog box, or, if you are on 
the last field, closes the dialog box and executes.  

The Middle button does the same thing as if you'd 
issued ^K or <F10>, closing a dialog box and executing.  

The Right button, as always, exits.  


The mouse chords are disabled within dialog boxes.  
.co1  ! !                    
.rm 6.5"
.tc
.tc Using MICKEE with Advanced Page Preview 
 	h0*.
  &#/r&
Using MICKEE with Advanced Page Preview



.rm 0.7"
.co2, 0.3"  .   .                    

  












  



  




 





 





 






.cb  /  .                     
.rm 5.5"
The Left button pulls down the last menu you used, if 
no menu is currently active, or selects a choice from a 
menu, if a menu is pulled down.  The same choice you 
used previously will initially be highlighted in the 
menu, so, for instance, after you've issued "Go to/Next 
page" once, double clicks of the left button will step 
you through your document a page at a time.  If you 
select "Go to/Specified page" or "Options/Scan range," 
you can move the mouse up and down to increase or 
decrease the page number in the dialog box until the 
one you want is shown, then press the left button again 
to select that page number.  

The Middle button toggles the grid display on and off.  
Note that Advanced Page Preview only shows the grid if 
you are viewing all or part of a single page.  

The Right button cancels and closes the pulldown menu 
without making a selection, if a pulldown is active, or 
exits Advanced Page Preview and returns to WordStar 
editing mode if no menu is active.  

Pressing the Left and Middle buttons simultaneously 
magnifies the current display, just as if you'd pressed 
<Plus>.  Subsequent presses further magnify the image 
until you reach the greatest-possible magnification, 
"4xzoom."  

Pressing the Middle and Right buttons simultaneously 
reduces the current display, just as if you'd pressed 
<Minus>.  Subsequent presses further reduce the image 
until you reach the greatest-possible reduction, the 
"thumbnail display."

Pressing the Left and Right buttons simultaneously 
shows a single entire page, unless you are already 
looking at a such a display, in which case this does 
nothing.  

Pressing All Three buttons simultaneously brings up a 
miniature version of the current page, if you are 
looking at a single entire page or a magnified portion 
of an entire page, just as if you had pressed <Ins>.  
You can then adjust the Advanced Page Preview viewing 
window by moving the mouse.  When you have the window 
positioned the way you want it, either press the left 
button or simply pause for a moment and the display 
will change to a close-up of the selected area.  
.co 1  5 5                    
.bp dis
.rm 6.5"
.tc
.tc Appendix A:  Other Versions of MICKEE 
 	h0*.
  &#/r&
Appendix A:  Other Versions of MICKEE


MICKEE 2.0



 	 
 The first publicly available incarnation of MICKEE was 
version 2.0.  Exclusively for Logitech mice, it supported 
WordStar 4.0, The Word Finder thesaurus (which, back then, was a 
separate memory-resident program instead of an integral part of 
WordStar), and the Notepad of Borland's Sidekick.  


 	 
 WordStar 4.0 was not particularly mouse-suitable, so I did a 
lot of things in Version 2.0 of MICKEE to overcome those 
limitations, including providing many of my own pop-up menus.  
WordStar 5.0 and above provide built-in pulldown menus.  Rather 
than reinvent the wheel, I decided with subsequent versions to 
instead support the WordStar pulldowns.  In later versions, I've 
only provided pop-ups when needed to fill in gaps in WordStar's 
point-and-shoot interface.  


 	 
 In later versions, I also dropped support for the Sidekick 
Notepad for three reasons:  first, Sidekick has been superseded 
by Sidekick Plus; second, WordStar 5.0 and above are memory 
hungry, leaving little room for memory-resident programs such as 
Sidekick; and, third, a key reason for using Sidekick with 
WordStar-- to provide a second editing window-- has been 
obviated by the inclusion a second window within the WordStar 
editor.  


 	 
 MICKEE 2.0 attempted to overcome cursor run-on at the ends 
of text lines by reading the column-number indicator in the 
status line and stopping when that number got into the 60s.  This 
was an appropriate solution for WordStar 4.0, a word processor 
designed for use with fixed-width fonts.  It's not as applicable 
to the world of proportional fonts, so I've left it out of later 
versions (WordStar International also made it a lot more 
difficult to program this by left-justifying instead of right-
justifying the column numbers in the status line in 5.0 and 
above).  If you're interested in seeing exactly how this trick 
was implemented, MICKEE 2.0 is still available, with annotated 
source code, as MICKEE.ARC in the "Earlier WordStars" Library 
(Library 13, at this writing) of The WordStar Forum on the 
CompuServe Information Service.  


 	 
 Finally, MICKEE 2.0 was shareware; all later versions, 
including this current one, are not.  You may use them freely in 
conjunction with any registered copy of WordStar.  (All versions 
of MICKEE, however, are copyright by Robert J. Sawyer).  
.pa  2   2                     
MICKEE 3.0 (Releases 5.5.3L and 5.5.3M)



 	 
 MICKEE 3.0 was the first to support WordStar's own pulldown 
menus and Advanced Page Preview.  It supported WordStar versions 
5.0, 5.5, and 6.0 through Rev. C.


 	 
 MICKEE Version 2.0 only worked with Logitech mice.  Releases 
of MICKEE Version 3.0 are available for both Logitech three-
button mice (release 5.5.3L, file MICKEE.COM in Library 2 
(WordStar 6/5.5 Editor) of the CompuServe WordStar Forum) and 
Microsoft two-button mice (release 5.5.3M, file MICKMS.COM in 
Library 2 of The WordStar Forum).  Three-button Logitech mice are 
significantly more versatile than two-button Microsoft mice 
(three buttons provide seven different combinations; two buttons 
only provide three combinations), so the Logitech release has 
more features.  


 	 
 Because versions of WordStar prior to 6.0 Rev. D had no 
built-in way of controlling cursor run-on in pulldown menus, 
MICKEE 3.0 used a complex system of identifying which menu choice 
was highlighted to determine when to stop moving the cursor.  
Although this worked well, I'm glad to be rid of it:  the 
compiled version of the current MICKEE, version 4.0, is now 
significantly smaller thanks to the elimination of this code 
(MICKEE 4.0 requires a 3K LOGIMENU buffer; version 3.0 needed 
4k).  Also, you no longer need to install MICKEE for a particular 
set of WordStar screen colors.


 	 
 Finally, version 3.0 had a bug that nobody reported but I 
eventually stumbled on myself:  selecting the "File" pulldown 
from WordStar's Opening Menu, then clicking on "Open a 
nondocument file...," caused MICKEE's "Notes" menu to be 
displayed.  That's fixed in this current version.
.pa  #   2                     
.rm 6.5"
.tc
.tc Appendix B:  MICKEE and Other Mouse Software 
 	h0*.
  &#/r&


Appendix B:  MICKEE AND OTHER MOUSE SOFTWARE



 	 
 The fundamental difference between MICKEE and the best-known 
commercial mouse driver for WordStar ("the other product") is 
that the other product uses its own separate mouse cursor.  That 
approach has the advantage of letting you move the cursor 
anywhere on the screen.  On the other hand, it also places all 
sorts of overhead on mouse operations when used with an 
application, such as WordStar, that does not have integral mouse 
support.  


 	 
 For instance, to open a file with MICKEE, you simply point 
to the filename and click once.  To scroll the screen, you just 
move the mouse up or down.  To switch from one WordStar pulldown 
menu to the one next to it, you merely move the cursor to the 
right or left.  In the other product, to open a file you have to 
click once to synchronize the mouse cursor with the text cursor 
and a second time to actually make the selection.  To scroll the 
screen, you have to reposition the cursor to the top or bottom of 
the screen, then hold a button.  To change pulldown menus, you 
have to click on the name of the next menu.  I find MICKEE much 
smoother and faster to use.  MICKEE is also completely invisible 
when you aren't using the mouse; the other product's secondary 
mouse cursor blinks at you all the time.  


 	 
 The biggest advantage of the other product's system is that 
it allows you to drag the mouse to mark a block of text.  I, 
however, found its implementation of that to be flaky, requiring 
an extraordinarily steady hand.  Also, the other product is prone 
to leaving "mouse droppings"-- extraneous highlighted characters 
left in the wake of the free-floating mouse cursor.  MICKEE does 
not have this problem.  


 	 
 MICKEE was designed specifically for WordStar, and no other 
product, rather than being a generic mouse driver adapted to 
WordStar.  MICKEE's development was guided solely by the 
following six WordStar-related design goals.  



.cp6
.p# 1,9.
6 
                 9. .1.1.1.1.1.1                6  SUPPORTING THE WORDSTAR HELP-LEVEL 4 INTERFACE


 	 
 The other product uses its own idiosyncratic pop-up menus, 
favoring the particular biases of the developer and undermining 
the logic of the WordStar interface.  MICKEE uses WordStar's own 
Help-Level4 SAA pulldowns and dialog boxes exclusively.  This 
means that MICKEE can easily be used with WordStar 
International's "The WordStar Course" and with the lessons 
provided in the manual that comes with WordStar.  In addition to 
preventing cursor run-on in pre-6.0D versions (see Appendix A), 
MICKEE supports the Help-Level 4 interface by:   6   2                     
.pa
Smoothing the Gaps in the Help-Level 4 Interface:


 	 
 In almost all instances, choices from Help-Level 4 menus 
either:

(a) execute a function and return you to editing mode (e.g., 
"Save file, resume editing" on the "File" pulldown); or 

(b) take you directly to a dialog box (e.g., "Set up columns" on 
the "Layout" pulldown).  


 	 
 Since MICKEE supports cursor navigation in dialog boxes, 
this is fine.  However, there are two pulldown menu options that 
are exceptions, taking you to Classic-style choose-a-letter 
submenus:  "Paragraph styles..." on the "Style" pulldown and 
"Footnote/endnote..." on the "Other" pulldown.  MICKEE bridges 
these gaps by providing point-and-shoot capability at these 
submenus.


.cp4
Reducing Switching Between the Mouse and the Keyboard


 	 
 If a selection from a pulldown menu takes you to a dialog 
box with one user-entry field, rather than making you return to 
the keyboard to deal with that field, MICKEE provides a pop-up 
menu of choices.  At the Spelling dialog box, MICKEE lets you 
point-and-shoot at suggested corrections by letter, and at any 
other speller command.  At the Go-to-Page dialog box, MICKEE lets 
you point-and-shoot at a scroll-bar of page numbers and at 
commands for the next or previous page.  At the Convert-Notes 
dialog box, MICKEE lets you point-and-shoot at note types.  At 
the Log dialog box, MICKEE lets you point-and-shoot at 
subdirectories and drive letters.  




.cp6
6 
                 9. .1.1.1.1.1.1                6  SUPPORTING ADVANCED PAGE PREVIEW


 	 
 The other product is baffled by Advanced Page Preview, 
because APP works in graphics mode.  Not MICKEE.  MICKEE provides 
full support for the Advanced Page Preview pulldowns, for cursor 
positioning, for adjusting the viewing window, and so on.  



.cp6
6 
                 9. .1.1.1.1.1.1                6  TAKING FULL ADVANTAGE OF THE HARDWARE


 	 
 The other product only uses two mouse buttons.  Releases of 
MICKEE for three-button Logitech pointing devices take full 
advantage of the seven combinations that these three buttons 
provide.  Of course, if used haphazardly, these combinations 
could result in a steep learning curve.  MICKEE avoids this by 
adhering to two design principles.     6   2                    
   6   2                    
.cp2

 	 
 First, I've used buttons as consistently as possible across 
all WordStar modes (the left button, for instance, always makes a 
selection or presents a menu from which to select; the right 
button always cancels safely).  


 	 
 Second, I've placed logically paired functions on the left-
and-middle and the middle-and-right mouse-button chords:


.cp7
.mb5
.tb 2.8", 5.0"

 	 
 
 	
(# 
 
WORDSTAR MODE
 	
 
  
 	
(# 
  

 	 
 
 	
(# 
 

While Editing
 	
 
 begin block
 	(# 
 end block
In Thesaurus
 	@ 
 next word
 	$	(# 
 previous word
In Advanced Page Preview
 	 
 magnify image
 	T(# 	
 reduce image




.tb .5"
.cp6
6 
                 9. .1.1.1.1.1.1                6  FULLY CUSTOMIZABLE


 	 
 One of WordStar's strengths is its customizability.  The 
other product is a canned application, and not modifiable by the 
user.  MICKEE comes with a complete, annotated, easy-to-change 
definition file-- the actual source code for the mouse 
interface!  You can modify MICKEE to your heart's content, or 
even build your own mouse interface (for personal, private, non-
commercial use, of course) using MICKEE's screen-sensing 
functions as a skeleton.  In true WordStar fashion, MICKEE's 
documented customization options range from the obvious (setting 
mouse speed) to the arcane (whether MICKEE moves by characters or 
words when in edit mode).



.cp6
6 
                 9. .1.1.1.1.1.1                6   MINIMAL RAM REQUIREMENTS


 	 
 WordStar is quite a RAM hungry application, leaving little 
room for memory-resident programs.  Both MICKEE and the other 
product require that Logitech's MOUSE.COM be loaded into memory.  
With version 4.10 of the Logitech software, MOUSE.COM takes up 
13K of RAM.  On top of MOUSE.COM, the other product requires 28K 
of additional RAM.  MICKEE simply requires that the Logitech 
program LOGIMENU.COM (or MENU.COM) be loaded, which takes 11K, if 
you use a 3K menu buffer.  That means that MICKEE takes 17 
kilobytes less of your precious memory than does the other 
product.  



.cp6  4   2                     
6 
                 9. .1.1.1.1.1.1                6   FREE


 	 
 I've been a WordStar user since 1983.  Since then, I've 
accumulated thousands of dollars worth of WordStar add-ons, all 
of which were designed to overcome shortcomings in WordStar, and 
all of which are now obsolete because the WordStar program has 
subsequently incorporated their functionality.  Among the 
products I've spent money on that no longer benefit me at all:  
Math*, an add-on math module for WordStar (superseded by 
WordStar's ^QM and ^KM); MailMerge (now an integral part of 
WordStar); StarIndex and DocuMate (replaced by WordStar's 
internal indexer); Pair (to identify mismatched print controls, 
rendered obsolete by WordStar's addition of video attributes for 
each type of print control); The Word Finder for WordStar 3.3 and 
Webster's New World Thesaurus (superseded by WordStar's ^QJ); 
InSet (now an integral part of WordStar); and Software Bridge 
(now, as Star Exchange, included with WordStar).  

.cp2

 	 
 Well, we all know that WordStar International must 
eventually add integrated mouse support to WordStar, so it seems 
to me that a commercial mouse driver would just end up being 
another entry in the above list of products that cost money but 
ceased to be of any use.  Because of that, I've decided to not 
charge at all for MICKEE.  Enjoy.










 	!
 --30--












Toronto Writer Robert J. Sawyer is one of the system operators of 
the CompuServe WordStar Forum, past moderator of the WordStar 
Special Interest Group of the Osborne Users Club of Toronto (a 
FOG Affiliated Member Organization), a member of the WordStar 
Advisory Board, author of several articles about WordStar for 
Profiles:  The Magazine for Kaypro Users, and a contributor to 
WSI's WordStar News customer newsletter.  He is also author of 
the science fiction novel Golden Fleece (Warner Books/Popular 
Library, December 1990, ISBN 0-445-21078-8.)   7   3                     
.pa
.tc
.tc Quick Reference Card 
 	h0*.
  &#/r&
.tc .pf dis
.tc .pa
..                    QUICK REFERENCE CARD
.he
.. NOTE: If you change this line height, the complete quick reference card
.. will not fit on a single 11-inch page!
.lh 9pt
.mt 0.4"
.mb 0.4"
.bp off
.po 1
.rm 7.6"

 	!
 MICKEE 6.D.4L:  Mouse Interface for the Control-Key Editing Environment


 	!
 Supporting WordStar 6.0D Pulldown Menus and Advanced Page Preview





 	88!
 LEFT BUTTON              MIDDLE BUTTON              RIGHT BUTTON



 	!
 WordStar's Opening Menu


 Pulldown Menu / Select  Cancel Safely (Esc)    




 	,,!
 Log Drive/Directory Dialog Box


 Log Directory           Log Drive / Release #   Cancel Safely (Esc)    




 	!
 Editing a File


 Pulldown Menu / Select  Mark Sentence           Mark Paragraph         

 Begin Block Marker (^KB)                        

  End Block Marker (^KK)                          

 Move Marked Block     <> Move Marked Block     

 Hide or Show Marked Block (^KH)                                          




 	!!
 Thesaurus


 Select Word (Enter)     Define Word (K/N)       Cancel Safely (Esc)    

 Cross Reference (L)                             

  Previous Word (P)                               
                         



 	Z Z ! 
 Spell, Size, Go-to-Page, Convert Dialog Boxes/Paragraph-Style & Notes Menus


 Pop-up Menu of Choices  Execute (^K)            Cancel Safely (Esc)    




 	dd!
 Other Dialog Boxes


 Next Field (Enter)      Execute (^K)            Cancel Safely (Esc)    




 	! 
 Page Preview


 Pulldown Menu / Select  Toggle Grid             Cancel Safely (Esc)    

 Magnify Image (Plus)                            

  Reduce Image (Minus)                            

 Show Entire Page      <> Show Entire Page      

 Adjust Window (Ins)                                                      





 	$	$	!
 Copyright 1989, 1990, and 1991 by Robert J. Sawyer   Q   3                     
.pa
.lh 12pt
.po 0.7"
.rm 6.5"
.mt 1"
.mb 1"
.bp on





 	,,!
 M I C K E E   4 . 0


 	!
 Mouse Interface for the Control-Key Editing Environment



 	jj!
 Supporting WordStar 6.0D

 	!
 and Advanced Page Preview



 	!
 * * *



 	!
 Release 6.D.4L


 	!
 For Three-Button LOGITECH Mice and TrackMan Trackballs



 	!
 * * *



 	!
 Software and Manual by 

 	::!
 Robert J. Sawyer



 	!
 * * *



 	FF!
 Copyright 1989, 1990, and 1991 by Robert J. Sawyer

 	,,!
 All Rights Reserved



 	,,!
 118 Betty Ann Drive

 	,,!
 Willowdale, Ontario

 	!
 Canada  M2N 1X4



 	!
 CompuServe:  76702,747

 	!
 GEnie:  RJ.SAWYER



 	!
 * * *



 	!
 30 January 1991
.pa  1   `9                     
.tb 6.2"


.oc on 

 	@@
 T A B L E   O F   C O N T E N T S
.oc off





Highlights 
 	#+.3
   1

Files
 	(+.9
   2

Installation 1:  Modifying WordStar
 	+.
   2

Installation 2:  Modifying MICKEE 
 	+.
   3

Loading MICKEE 
 	!+./
   5

Checking Which Release of MICKEE is Loaded 
 	\
+.
   6

How MICKEE Knows What's Going On 
 	d+.
   6

Compatibility Notes 
 	+.*
   7

Mouse Interfaces and InSet 
 	+.#
   8

Opening Menu Tips and Tricks 
 	4+.!
  10

Using MICKEE at the Opening Menu 
 	d+.
  11

Using MICKEE within a Dialog Box 
 	d+.
  11

Using MICKEE while Editing a File 
 	+.
  12

Using MICKEE with the Thesaurus 
 	+.
  13

Using MICKEE in Spell, Size-Window, Go-to-Page, Convert-Notes
Dialog Boxes and at the Paragraph-Style and Notes Menus 
 	8+.
  14

Using MICKEE in All Other Dialog Boxes 
 	,+.
  15

Using MICKEE with Advanced Page Preview 
 	x+.
  16

Appendix A:  Other Versions of MICKEE 
 	+.
  17

Appendix B:  MICKEE and Other Mouse Software 
 	+.
  19

Quick Reference Card 
 	+.)
  23
.pa  1   2                     
.. end of file
