
REM !!!! Batch file RTFprog shows progress of conversion !!!!

REM ===========================================================================

REM * RTFSS.BAT produces SINGLE-SPACED output    (by running macro _RTF-SS.WSM)
REM * RTF15.BAT produces 1.5-LINE-SPACING output (by running macro _RTF-15.WSM)
REM * RTFDS.BAT produces DOUBLE-SPACED output    (by running macro _RTF-DS.WSM)

REM The only difference in these batch files is which of the above macros is 
REM called on line 234 of this file, and which TEXT / ENDTEXT display is
REM active starting at line 57 of this file.

REM ===========================================================================

REM Converts the WordStar file specified on the command line to RTF format for 
REM importing into Microsoft Word or other modern wordprocessors.

REM This batch file should be run under 4DOS

REM Begun Saturday, October 12, 2002
REM Wednesday, October 4, 2023
REM Robert J. Sawyer
REM sawyer@sfwriter.com | https://sfwriter.com

REM This file specifically calls WordStar program files folder C:\WS
REM and requires RTF code fragments to be in folder C:\WS\RTF-RJS

REM This file assumes WordStar printer definition file ASCII.PDF (or, as
REM Rob has renamed it, ASCII.WSP) has been patched to produce output files
REM named ASCII.TXT rather than the default output file name of ASCII.WS.
REM **** If local version isn't working, check to make sure all occurrences
REM **** in the batch file of filename ASCII.WS have been changed to ASCII.TXT

REM Pathing updated for Monday, December 19, 2011
REM Pathing updated Monday, July 20, 2015 to put temp files in c:\ws\temp\rtf\rtf

REM Known bug: for some reason, large WordStar files don't convert 
REM italics properly unless the final character in the WordStar 
REM document (except for any final CR/LF or ".pa" dot command) is an 
REM italics print toggle: ^PY.

rem  Main RTF stylesheet numbers and names (and there are others, as well)
rem
rem   \s31  Heading 1          H1
rem   \s32  Heading 2          H2
rem   \s33  Heading 3          H3
rem   \s34  MS Subhead         H4
rem   \s13  MS After Break     MS1
rem   \s19  MS Blank Line      MS0
rem   \s15  MS Body Copy       MS
rem   \s12  MS Centered        MSCENTER
rem   \s11  MS Right           MSRIGHT

REM == [ Activate one appropriate TEXT / ENDTEXT secion below ]========================
REM ===================================================================================
REM ===================================================================================
REM | @cls
REM | TEXT
REM | 
REM |             WordStar-to-RTF file conversion Ŀ 
REM |            ͵ 
REM |                                                        
REM |                                                        
REM |               This version produces a          
REM |               SINGLE-SPACED RTF file.          
REM |                                                 
REM |                                                        
REM |                                                        
REM |                                                        
REM |               If you prefer a double-spaced    
REM |               manuscript-style RTF file,              
REM |               run batch file RTFDS (or use     
REM |               RTF15 for 1.5-line spacing).             
REM |                                                        
REM |            ͵ 
REM |             Run RTFprog to monitor conversion progress  
REM |            
REM | 
REM | ENDTEXT    
REM | pause

REM ===================================================================================
REM ===================================================================================
@cls
TEXT

            WordStar-to-RTF file conversion Ŀ 
           ͵ 
                                                       
                                                       
              This version produces a        18-point 
              file with 1.5-line spacing.    leading! 
                                                       
                                                       
                                                       
                                                       
              If you prefer single-spaced,            
              run batch file RTFSS; for               
              double-spaced, use RTFDS.               
                                                       
                                                       
           ͵ 
            Run RTFprog to monitor conversion progress  
           

ENDTEXT    
REM pause

REM ===================================================================================
REM ===================================================================================
REM | @cls
REM | TEXT
REM | 
REM |             WordStar-to-RTF file conversion Ŀ 
REM |            ͵ 
REM |                                                        
REM |                                                        
REM |               This version produces a          
REM |                                                       
REM |               DOUBLE-SPACED manuscript file.    
REM |                                                        
REM |                                                        
REM |                                                        
REM |               If you prefer single-spaced,     
REM |               file, run batch file RTFSS       
REM |               (or just RTF) instead, or use    
REM |               RTF15 for 1.5-line spacing.              
REM |                                                        
REM |            ͵ 
REM |             Run RTFprog to monitor conversion progress  
REM |            
REM | 
REM | ENDTEXT    
REM | pause

REM ===================================================================================
REM ===================================================================================

md c:\ws\temp\rtf > nul
md c:\ws\temp\rtf\rtf > nul
del C:\WS\RTF-RJS\title.txt > nul
copy C:\WS\RTF-RJS\notitle.txt C:\WS\RTF-RJS\title.txt > nul

del c:\ws\temp\rtf\rtf\done-ok.txt > nul
copy C:\WS\RTF-RJS\done-ok.txt c:\ws\temp\rtf\rtf\done-ok.txt > nul
describe c:\ws\temp\rtf\rtf "No conversion macros run yet"

del c:\ws\temp\rtf\RTF\Oldest.rtf > nul
ren c:\ws\temp\rtf\RTF\Older.rtf c:\ws\temp\rtf\RTF\Oldest.rtf > nul
ren c:\ws\temp\rtf\RTF\new.rtf c:\ws\temp\rtf\RTF\Older.rtf > nul

del c:\ws\temp\rtf\rtf\%1.rtf > nul
del c:\ws\temp\rtf\rtf\temprtf > nul
del c:\ws\temp\rtf\rtf\temprtf.rtf > nul
del c:\ws\temp\rtf\rtf\temprtf.mrg > nul
del c:\ws\temp\rtf\rtf\ascii.txt > nul
del c:\ws\temp\rtf\rtf\*.wbk > nul

copy %1 c:\ws\temp\rtf\rtf\temprtf
c:
cd\ws-temp\rtf

REM |  Original _RTF1.WSM split into five smaller macros on Wednesday, July 3, 2019,
REM |  in hopes of preventing slowdowns (under 4DOS) and hangs (under vDosPlus).

REM |  "default0" is "default0.exe," a WordStar 7.0 version with all
REM |  values left as defaults, except some delays set to zero.
REM |  Note that default0.exe has the default values set for label
REM |  MOVCHR, which specifies which charaters are moved over by 
REM |  ^A and ^F commands.  I use different values in WS.CFG.

rem |  describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF1"
rem |  c:\ws\pristine temprtf /m _RTF1
rem |  describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF1 completed okay"

REM PAUSE

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-0"
c:\ws\pristine temprtf /m _RTF-0
describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-0 completed okay"

REM PAUSE

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-1"
c:\ws\pristine temprtf /m _RTF-1
describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-1 completed okay"

REM PAUSE

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-2"
c:\ws\pristine temprtf /m _RTF-2
describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-2 completed okay"

REM PAUSE

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-3"
c:\ws\pristine temprtf /m _RTF-3
describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-3 completed okay"

REM PAUSE

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-4"
c:\ws\pristine temprtf /m _RTF-4
describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-4 completed okay"

REM PAUSE

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-5"
c:\ws\pristine temprtf /m _RTF-5
describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-5 completed okay"

REM PAUSE

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-6"
c:\ws\pristine temprtf /m _RTF-6
describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-6 completed okay"

REM PAUSE

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-7"
c:\ws\pristine temprtf /m _RTF-7
describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-7 completed okay"

ws5asc temprtf temprtf.mrg /H /P

REM PAUSE

REM =============================================================================== 
REM =============================================================================== 

REM !! ===[ This section is the only part that changes between RTF*.BAT files ]====

REM * _RTF-SS.WSM produces SINGLE-SPACED output   
REM * _RTF-15.WSM produces 1.5-LINE-SPACING output 
REM * _RTF-DS.WSM produces DOUBLE-SPACED output   

REM STEP 1: SELECT ONE:
REM describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-SS"
    describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-15"
REM describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-DS"

REM STEP 2: SELECT ONE:
REM c:\ws\pristine temprtf.mrg /m _RTF-SS
    c:\ws\pristine temprtf.mrg /m _RTF-15
REM c:\ws\pristine temprtf.mrg /m _RTF-DS

REM STEP 3: SELECT ONE:
REM describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-SS completed okay"
    describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-15 completed okay"
REM describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-DS completed okay"

REM =============================================================================== 
REM =============================================================================== 

c:\ws\sawyer temprtf.mrg /p /x

del New.rtf > nul
copy ascii.txt New.rtf > nul
del C:\TEMP\RTF\From-WS.rtf > nul
copy ascii.txt C:\TEMP\RTF\From-WS.rtf > nul

describe c:\ws\temp\rtf\rtf\done-ok.txt "Running macro _RTF-8"
c:\ws\pristine /n C:\TEMP\RTF\From-WS.rtf /m _RTF-8
rem describe c:\ws\temp\rtf\rtf\done-ok.txt "Macro _RTF-8 completed okay"
describe c:\ws\temp\rtf\rtf\done-ok.txt "Conversion to RTF completed!"

del c:\ws\temp\rtf\rtf\latest.rtf > nul

del c:\ws\temp\rtf\rtf\latest.rtf > nul
copy C:\TEMP\RTF\From-WS.rtf c:\ws\temp\rtf\rtf\latest.rtf > nul
del C:\TEMP\RTF\sawyer~1.doc > nul
copy C:\TEMP\RTF\sawyer~1.doc c:\ws\temp\rtf\rtf > nul

del C:\TEMP\RTF\From-WS.bak > nul

REM ===== Open resulting RTF output file in Microsoft Word:

REM Below is the command line for Dell Optiplex 7010
REM C:\PROGRA~1\MICROS~1\OFFICE\WINWORD C:\TEMP\RTF\From-WS.rtf
REM C:\PROGRA~1\MICROS~1\OFFICE12\WINWORD C:\TEMP\RTF\From-WS.rtf
C:\PROGRA~1\MICROS~1\OFFICE12\WINWORD /mSawyerDocx

REM Below is the command line for Asus Unit 2: Afsan
REM C:\PROGRA~1\MI1933~1\Office\WINWORD C:\TEMP\RTF\From-WS.rtf
REM C:\PROGRA~1\MI1933~1\Office\WINWORD /mSawyerDocx

REM Below is the command line for Asus Unit 1: Hak
REM C:\PROGRA~1\MICROS~3\OFFICE\WINWORD C:\TEMP\RTF\From-WS.rtf
REM C:\PROGRA~1\MICROS~3\OFFICE\WINWORD /mSawyerDocx

REM Below is the command line for Dell D410 Livingroom
REM C:\PROGRA~1\MICROS~2\OFFICE\WINWORD C:\TEMP\RTF\From-WS.rtf
REM C:\PROGRA~1\MICROS~2\OFFICE\WINWORD  /mSawyerDocx

REM Below is the command line for Purism Librem 13
REM C:\PROGRA~1\MICROS~2\OFFICE\WINWORD C:\TEMP\RTF\From-WS.rtf
REM C:\PROGRA~1\MICROS~2\OFFICE\WINWORD /mSawyerDocx

exit
exit
exit
exit
exit
