                             MailMerge Cantonese


                                by Louie Crew

                     The Chinese University of Hong Kong

     From August 1989 

               Academic Foundations
               Rutgers University
               175 University 
               Newark, NJ 07101
     
               201-648-5434
               201-485-4503

               CompuServe No. 73517,147  
               Bitnet:lcrew@draco FAX 201-648-5700 Attn. Conklin #156

               ==============================================

Note:  This material first appeared in the Hong Kong Computer Journal 
       (February 1985) and was awarded "Best Article of 1985" by the Hong Kong 
       Computer Society.  
     
               ==============================================



     My personal computer teaches me Cantonese vocabulary.  I have not 

hired an expert linguist or a computer programmer, nor have I employed BASIC 

or other more complicated programming languages.  Instead, I have used the 

simple features of a popular word-processing program.  Novices can use these 

same methods to learn Cantonese vocabulary on their own personal computers.  

With a little imagination, they can also adapt the techniques here for other 

important tasks far removed from form letters. 

     MicroPro developed MailMerge, as the name implies, to facilitate form 

letters created within WordStar, MicroPro's word-processing  program.   But 

MailMerge techniques can merge a vast variety of other texts, such as the 

data of Cantonese vocabulary for each new lesson assigned me at the Chinese 

Language Center of The Chinese University of Hong Kong.   With one 

Mailmerged file I store vocabulary data, and with two other MailMerge files 

I review the data. 


                            Building Word Lists


     With the file ENTER (Figure 1) I store two kinds of vocabulary:  1) all 

data for new vocabulary in any one lesson in Speak Cantonese Book One, by 

Parker Po-Fei Huang and Gerard P. Kok;  2) any additional words which my 

teacher or other individuals teach me.  

     When I boot the computer with WordStar, the screen first displays a 

"No-File Menu."  To create a data file for either type of new vocabulary, I

first press "M" for the MergePrint option on this menu, and then respond:  

(Boldface indicates the material to type in response to the prompts which 

WordStar displays on the screen)  


                Name of file to mergeprint? ENTER<cr>
                                           ________
                    Disk file output (Y/N): Y_
                          Output file name: Lesson1<ESC>
                                            ________

Of course, I can specify any other name I like, such as AUX1 for extra words 

which my teacher or a friend has given me.  I find it helpful to create many 

smaller word lists so that I can more easily review words for special 

purposes, such as tests, where I might not want to focus on mastering a 

more informal vocabulary.  

     Here's a sample entry to the prompts with which ENTER continues:


                 Word in Chinese.........ho'i 
                 Word in English.........sea 
                 Measure, if applicable..go
                   ----------------------
                    'adj'   = adjectives  
                    'adv'   = adverbs     
                    'c'     = conjunctions
                    'i'     = interjection
                    'n'     = nouns       
                    'pn'    = pronouns    
                    'pp'    = prepositions
                    'v'     = verbs       
                    'x'     = phrases or other expressions
                    ----------------------
                 Part of speech..........n
                 Lesson no./80=misc......8  [useful if I later want to
                                            retrieve from some combined 
                                            lessons] 
                                          
                 1 = most difficult, 2 = next most difficult, etc., 
                    10 = least difficult
                                          
                 How difficult...........1 [if I don't know the word;
                                            10 if I know it fully]



.cp 3                 
     Speak Cantonese Book One conveniently uses various graphic conventions 
                 
to distinguish among the seven Cantonese tones: 
                 
.cp  6
                 
               ^  =  high level
                 
               `  =  high falling  
                 
               '  =  high rising
                 
        no marker =  mid level
                 
              'h  =  low rising
                 
               h  =  low level
                 
              `h  =  low falling
                 

In the Huang/Kok text the diacritical marks appear over the letters whose 

tones they mark, as they cannot do on the screen with WordStar.  That is, on 

screen I see o^ not o^.  This slight difference causes no real problem, 

however:  even when I put the marks just after the letter, I still 

graphically mark all major tone distinctions.  For example, the distinct 

pair ho`i (open, start) and ho'i (sea) appear just as clearly distinguished on 

my screen when I enter them as ho`i and ho'i.

     All files similarly force me to master the appropriate measure words 

for nouns before I credit myself with knowing them.   

     I can close my file and end my session with ENTER by typing just one 

character when ENTER prompts me to enter yet another word:  


                    Word in Chinese........../

        
The slash tells the computer to close the new file and return to the "No-

File Menu" of WordStar.



.cp 7
                         Learn By Selective Review



     While I learn something just from typing the entries to store them for 

the first time, the computer serves the most when it reviews these words 

systematically and efficiently.  Left to other devices--such as word lists 

or index cards--I often waste an enormous amount of time, especially when I 

continue to look at what I already know.     I need to sort out what I know 

from what I don't know, so that I focus mainly on the latter.   

     Files M and M1 (Figures 2-3) work together automatically to review all 

words in any vocabulary data file I specify.  But they do much more: they 

also sort.  Each time that I use File M to review a file, it writes to a new 

file the ones that I miss so that I can review them and write to yet another 

file only the ones that I missed.....until, if I pay attention, I will have 

"known" all words at least once.  Of course I need to repeat the full lesson 

periodically.  I feel that I must get a perfect score with the full file at 

least twice before I can begin to assume that I really know it.  In any 

review, short-term memory too easily passes for long-term memory.  Hence, I 

must carefully review the files that contain the words which took me the 

longest time to "learn."

     To keep up with these files, I conventionally name permanent files with 

alphabetic names (like Lesson 1, AUX1, etc.) and temporary files (i.e., 

those created in the review cycle of any one setting) with numeric names 

(like 1, 2,...). Thus, when I begin a new sitting, I know that I can safely 

ignore or even erase files named by numbers only, since they contain 

duplicates of items in the alphabetic files.  Still, I often rename the file 

with the highest number--i.e., the one which contains the words which took 

me the longest time to "learn"--and begin my new session with it.  For 

example, I might rename file 8 to HARD6 to keep more permanently for review 

the words in LESSON6 that I did not get correctly until the eighth attempt.  

Likely I still do not know those words well. 


.cp 6
                       Features Special to Cantonese


     The computer forces me to attend closely to problems special to 

Cantonese.  Since tone and measure do not play similar roles in English, as 

a native speaker of English I need special discipline to attend to them.

     When I used flashcards to review my Chinese vocabulary, I often 

thought I understood the tones and measures.  I would ask as I looked at one 

side of the flashcard.  "What's the tone?  What's the measure?" 

     When I turned over the card, I would see the tone and measure and often 

think to myself, "Ah, yes, that's what I thought it was!", especially when I 

had gotten the letters of the words correctly in my mind.  

     The computer more precisely tests me.  With it, I do not just think my 

answer and then check it against a correct answer on the other side of a 

card.  Instead, I quickly type my answers and then the computer juxtaposes 

the correct answer.  Of course I could also write out my answers before 

peeking at flashcards, but writing them legibly would delay the process 

tediously.  At the keyboard, I speed along quickly with the real business of 

learning. 

     The computer revealed that often I did not know the tones and measures 

which I had marked as correct in flashcard reviews, yet I had not knowingly  

cheated.  I suspect that with flashcards I erred more from linguistic habit 

than from a moral flaw.  When I study other languages, I usually 

need to demonstrate that I know only a word's spelling.  The computer forces 

me to attend to Cantonese tones and measures much more rigorously and  tells 

me when I have not done so. 


.cp 7
                                Easy to Use


     Using the computer to review is no more complicated than counting from 

1-10.  To activate File M (which automatically reads and activates File M1), 

I again first type M from the No-File Menu and then follow the prompts:


               Name of file to mergeprint? M<cr>
                                           _____
                   Disk file output (Y/N): Y_
                         Output file name: 1<ESC>
                                           ________


     Notice that here I have specified 1 for my new temporary review file. I 

routinely begin with 1 and add 1 for each round.   

     The screen next prompts:  "At which level of difficulty, if any, would 

you like to review words?"  If I specify a lower number (1-5), I will 

review only those words that I have filed as most difficult for me.  If I 

enter a higher number (10 maximum) I will review all words in a file.   I 

can later specify a new level of difficulty for any word  by entering the 

data file with WordStar's "N" (non-document) option. 

     Next the computer allows me to specify a review of words according to 

part of speech, or to review all.  Finally,  the computer lets me specify 

whether to prompt first with English or with Chinese.  Of course, one must 

master both approaches before one knows a vocabulary list. 

     Then the computer reviews each word in the file specified.  The user 

may choose to save items, one by one, to the new file; or the user may 

"ignore" the word in the new file.  In either case, the file being reviewed 

always remains in tact completely unless the user specifically deletes it, 

as with the "Y" (delete) option from WordStar's No-File Menu.       

     With only minor changes, any WordStar user can adapt the programming 

techniques here to facilitate a wide variety of other computer-assisted 

instruction, especially with rote material which requires one to sift and 

resift the known from the unknown.    For example, one could change the 

prompts for Chinese and English here to specify instead any other kind of 

vocabulary building, even within a single language.

     Of course, these drills in no way replace a teacher.  Nor can the 

drills substitute for the greatest test of the learner's vocabulary skills, 

namely, intelligible use of the vocabulary in conversation with native 

speakers.  The drills can, however, ready a learner for these bigger 

challenges. 

.pa
          Figure 1:   ENTER, a Mergefile to store vocabulary data 

.uj 0 

      ..    This file creates a data file of new vocabulary words
      ..    for any one lesson.  
      .PL 1
      .MT 0
      .MB 0
      .PO 0
      ..
      ..    The first four dot commands above the new text in ways that  
      ..    File M (Figure 2) can read.   Add  .OP as a fifth opener
      ..    if your version of WordStar automatically includes a page number 
      ..    when printing. 
      ..
      .CS     
      .. 
      ..  .CS (above) clears the screen.  .DM statements prompt from the screen.
      ..
      .DM To end the session, enter '/' for the Chinese:
      .DM
      .DM 
      ..
      ..  .AV lines prompt at the screen for the information and then assign
      ..  them the variable names after the commas here.  The texts of the 
      ..  .AV prompts require quotation marks.  Texts of .DM lines do not. 
      ..
      .AV "Word in Chinese..........",WORD-C
      .IF &WORD-C& = "/" GOTO FINISHED
      ..
      ..  IF statements set up conditions, here the condition for finishing 
      ..  any use of ENTER.  That is, if the user enters / for the prompt 
      ..  for "Word in Chinese", the program will terminate by going to the 
      ..  line marked  .EF FINISHED
      ..
      .AV "Word in English..........",WORD-E
      .AV "Measure, if applicable...",MEASURE
      .DM    -------------------------
      .DM    'adj'   = adjectives                       
      .DM    'adv'   = adverbs                          
      .DM    'c'     = conjunctions                       
      .DM    'i'     = interjections                      
      .DM    'n'     = nouns                              
      .DM    'pn'    = pronouns                          
      .DM    'pp'    = prepositions                      
      .DM    'v'     = verbs                              
      .DM    'x'     = phrases or other useful expressions
      .DM    ---------------------------------------------
      .AV "Part of speech...........",POFSPEECH
      .AV "Lesson no./80=misc.......",LESSON
      .DM
      .DM 1 = most difficult, 2 = next most difficult, etc., 
      .DM 10 = least difficult
      .DM
      .AV "How difficult............",LEVEL
      .CS
      .DM Is the full entry correct?
      .DM
      .DM Chinese:              &WORD-C&
      .DM English:              &WORD-E&
      .DM Measure:              &MEASURE&
      .DM Part of Speech:       &POFSPEECH&
      .DM Lesson no.:           &LESSON&
      .DM Level of difficulty:  &LEVEL&
      .DM
      .AV "Y/N   ",P
      .IF &P& = "N" .OR. &P& = "n" GOTO WRONG
      ..
      .. 
      .. The IF line above allows you to start again from scratch if you
      .. have made a mistake.
      ..
      "&WORD-C&","&WORD-E&","&MEASURE&","&POFSPEECH&","&LESSON&","&LEVEL&"
      ..
      .. Note: only the line just above lacks a dot command
      .. and hence it alone can write (store) the data into your 
      .. new file.  Quotation marks, ampersands, and commas must appear 
      .. exactly as illustrated.
      ..
      .IF &P& = "Y" .OR. &P& = "y" GOTO NEXT
      .EF WRONG
      .. 
      .. The next .AV command stops the program to let you observe your
      .. mistake before you start the incorrect entry again from scratch.
      ..
      .AV "Hit <> and re-enter this item from the start.  ",P
      .EF NEXT
      .. 
      .. The next command (.FI ENTER) repeats the program ENTER 
      .. indefinitely until you enter a slash at the first prompt.
      ..
      .FI ENTER
      .EF FINISHED
----------------------------------------------------------------------
.uj 1

                             Note to Figure 1:


     Note well:  Only  Versions 3.3 or later of WordStar and MailMerge 

allow the conditional commands here. 

     Data must be typed exactly.  The `.'  in the "dot commands" must appear 

in the first column for MailMerge to recognize a command.  

     Warning:  extra blanks at the end of any lines risk error messages that 

will halt the program.   A carriage return (and only one) must appear after 

the word FINISHED in the last line.

     Observe all conventions here, such as the ampersands around the 

variables, the commas after input prompts and before the variable names 

assigned to them, etc.   WordStar and MailMerge ignore lines which begin 

with two periods '..' so you may omit those line if you feel you do not need 

the comments in them. 

     I have  formatted all files here to juxtapose on an 80-column screen 

the correct version and the version entered from the keyboard.  Those who 

use screens with a different number of columns should experiment with other 

spacing for the best visual arrangements.
.pa
.uj 0
            Figure 2:  M, a Mergefile to review vocabulary data


     ..     As in Figure 1, the first four commands here format 
     ..     new file made here.  Again, add .OP if your version of 
     ..     WordStar normally includes page numbers.
     .PL 1
     .MT 0
     .MB 0
     .PO 0
     .CS
     .AV "Type the file name of the lesson that you want to review:  ",FILE
     .CS
     .DM 1 = Only the most difficult   2 = The most + the next most difficult,
     .DM                   &c......    10 = All 
     .DM 
     .DM
     .DM At which level of difficulty, if any, would you 
     .AV "like to review words?  ",DIFFICULTY
     .CS
     .DM  Regarding parts of speech:
     .DM
     .DM  Type in lower case  adj  to review only adjectives
     .DM                      adv  to review only adverbs
     .DM                       c   to review only conjunctions
     .DM                       i   to review only interjections
     .DM                       n   to review only nouns
     .DM                      pn   to review only pronouns
     .DM                      pp   to review only prepositions
     .DM                       v   to review only verbs
     .DM                       x   to review only phrases or other useful 
     .DM                           expressions
     .DM
     .DM                    SPACE  to review all classes                           
     .DM
     .AV CATEGORY
     .CS
     .DM Type 'C' to review words in Chinese, 'E' to review words in English: 
     .DM
     .AV LANGUAGE
     .CS
     .FI M1
----------------------------------------------------------------------------
.uj 1     
                             Note for Figure 2

     Files M and File M1 (Figures 2 and 3) function as one file, in that the 

last line of the File M automatically initiates File M1.  We must name them 

as separate files, however.  Otherwise, a user would have to answer all 

questions in File M for each word reviewed, not just once for the sitting.  

That is, File M prompts for the general conditions which will select the 

individual vocabulary items which File M1 calls forth.
.pa
.uj 0

            Figure 3:  M1, a Mergefile which continues File M


     .CS
     ..
     ..   In the next two lines, .DF tells the computer to review 
     ..   the file specified in File M, and .RV specifies the order 
     ..   or the variables as configured with the file ENTER. 
     ..      
     .DF &FILE&
     .RV WORD-C,WORD-E,MEASURE,POFSPEECH,LESSON,LEVEL
     ..  
     ..  The next three lines channel the review according to the other 
     ..  criteria which you specified in File M.
     .. 
     .IF &LEVEL& > "&DIFFICULTY&" GOTO ENDOF
     .EX &CATEGORY& = "" .OR. &POFSPEECH& = "&CATEGORY&" GOTO ENDOF
     .IF &LANGUAGE& = "E" .OR. &LANGUAGE& = "e"  GOTO ENGLISH
     ..
     ..  The rest of the program divides into two halves,
     ..  the first of which prompts with Chinese versions, the 
     ..  second of which prompts with the English. 
     .. 
     .DM                               &WORD-C&
     .DM
     .DM
     .AV "Type the meaning in English:  ",P
     .DM
     .DM The correct answer:           &WORD-E&
     .EX &POFSPEECH& = "N" .OR. &POFSPEECH& = "n" GOTO 
     .DM
     .AV "Type its measure:             ",P
     .DM
     .DM The correct measure:          &MEASURE&
     .EF
     .DM
     .DM     Type 'R' to review the word in the next round.
     .DM     Type 'I' to ignore this word in the next round.
     .DM
     .AV CHOICE
     .IF &CHOICE& = "I" .OR. &CHOICE& = "i" GOTO ENDOF
     "&WORD-C&","&WORD-E&","&MEASURE&","&POFSPEECH&","&LESSON&","&LEVEL&"
     .IF &CHOICE& = "R" .OR. &CHOICE& = "r" GOTO ENDOF
     ................................................................
     ..  The dotted line above marks where the second half begins, 
     ..  i.e., the place where the program prompts with English versions,
     ..  not with Cantonese.  
     .. 
     .EF ENGLISH
     .DM                               &WORD-E&
     .DM
     .DM
     .AV "Type the meaning in Chinese:  ",P 
     .DM
     .DM
     .DM The correct answer:           &WORD-C&
     .EX &POFSPEECH& = "N" .OR. &POFSPEECH& = "n" GOTO 
     .AV "Type its measure:             ",P
     .DM
     .DM
     .DM The correct measure:          &MEASURE&
     .EF  
     .DM
     .DM     Type 'R' to review the word in the next round.
     .DM     Type 'I' to ignore this word in the next round.
     .DM
     .AV CHOICE
     .IF &CHOICE& = "I" .OR. &CHOICE& = "i" GOTO ENDOF
     "&WORD-C&","&WORD-E&","&MEASURE&","&POFSPEECH&","&LESSON&","&LEVEL&"
     .EF ENDOF
--------------------------------------------------------------------------
.uj 1

                             Note for Figure 3


     Note that the .AV command forces MailMerge to stop even when the 

program makes no more use of the data, as when an .AV command prompts the 

user to type the correct answers.  Thus, the command steers the program in 

much the same way BASIC allows "INPUT" to do.

     Of course, one may choose to have the program check the user's inputs 

for correctness (e.g., IF &P& <> &WORD-C& GOTO), but users have to pay more 

attention if they check for themselves.  Also, when several answers may be 

correct, the computer does not help if it declares an answer wrong merely 

because it does not list all correct choices in the arbitrary order by which 

they had entered the master file. 

.pa
