}  pOPTRA-3L    K                                                                                                           } ..
..              THIS IS A WORDSTAR DOCUMENT FILE
..            Select your own printer by issuing ^P?
..                and save this file with ^KS
..
..    This file uses only features found in WordStar version 5.0.
..
..
.pl 11"
.mt 1"
.mb 1"
.rm 6.5"
.lh 12/72"
.pn 1
.fo
.oj off
.oc on
.ul off


 	
    D  F D O S Y M S E Q
.ul on


 	!
 A Utility for Producing WordStar ^P!-Style User Print Controls




 	

!
 Program by John G. Bennett

 	xx!
 CompuServe 72431,1407



 	@@!
 Documentation by Robert J. Sawyer

 	!
 CompuServe 76702,747



 	!
 September 1990
.oc off
.he    D  D                                                      DOSYMSEQ / #




LICENSE


The DOSYMSEQ program and source code are copyright 1990 by 
JohnG. Bennett.  This manual is copyright 1990 by RobertJ. 
Sawyer.  They all may be freely distributed, but only for 
non-commercial uses.  




FILES


.tb 2"
DOSYMSEQ.EXE
 	 
 Compiled, ready-to-run program
DOSYMSEQ.C
 	 

 Annotated C-language source code
DOSYMSEQ.DOC
 	 
 This manual




INTRODUCTION


With WordStar version 5.0 and above, you can create "User Print 
Controls," which are special formatting tags that contain code 
you wish to send directly to your printer.  From within WordStar, 
you can create such a tag by issuing ^P! and filling in the 
fields in the dialog box that appears, including manually typing 
the codes you want sent to your printer.

WordStar then saves the codes you have typed into a symmetrical 
sequence, a special data format that WordStar treats as a single 
character for cursor movement purposes (for instance, ^D will    6   3                     jump over a symmetrical sequence even if the sequence is many 
kilobytes in length).  Symmetrical sequences are used for many 
types of formatting in WordStar, including font tags, color 
choices, and PIX graphic tags.  These symmetrical sequences are 
invisible when print control display is off (^OD).  However, User 
Print Controls are special.  When print control display is off, 
they show a descriptive string of characters you have specified.  
When display is on, they show the code that will be sent to the 
printer.  

Note:  WordStar International Corporation recommends that you do 
not use User Print Controls to access functions for which 
WordStar already has specific commands.  For instance, to select 
landscape printing on a laser printer, use .PR OR=L rather than a 
User Print Control.  

There are two problems with using the ^P! dialog box to create 
User Print Controls.  The first is that you manually have to type 
the code you want to send to your printer.  This is awkward 
because of the limited editing ability you have in this dialog 
box.  It also means you have to re-type code that you might 
already have from another source.  For instance, if you print to 
disk with WordStar or another program, you create a file 
containing the code that would normally be sent to your printer.  
However, even if you have the code captured in a file, you still 
have to retype it in the ^P! dialog box (unless you have a 
PostScript or LaserJet printer-- see Appendix B below).  

The second drawback is that you are limited to 65 displayable 
columns of printer code in the ^P! dialog box ("displayable 
columns" meaning that control codes, such as ^[, which is Escape, 
take up two of your 65 characters).  The symmetrical sequence 
format actually allows for a total number of code characters 
almost one thousand times greater, namely 64 kilobytes (however, 
see the cautionary note on long symmetrical sequences below).  

DOSYMSEQ overcomes these problems by letting you create a User 
Print Control similar to the kind you'd make with ^P!, but using 
print codes that are already in a separate file.  This lets you 
write your codes in WordStar's non-document mode or make easy use 
of codes already captured by printing to disk.  (Note, though, 
that if you simply print a file to disk with WordStar it will 
contain in addition to the codes you want, WordStar's printer 
initialization string and deinitialization string.  You'll 
probably want to edit these out, since if they're encountered in 
the middle of a file, they may override font choices, eject 
paper, and so on.)
.pa  0   2                     
RUNNING DOSYMSEQ


To run DOSYMSEQ, simply type DOSYMSEQ from the DOS command line.  
Note:  DOSYMSEQ takes two optional command-line switches, 
described later in this manual.  

To abort DOSYMSEQ, issue ^C at any time.  

When you run DOSYMSEQ, it asks you four questions, as follows.  



1.  Which file contains the code you want to send to the printer?

You can specify just the filename if it's in the current 
subdirectory, or a full drive and path plus the filename.  See 
the section below called "The /B Command-Line Switch" for 
acceptable formats for your code files.  

Keep the following in mind when creating the file that contains 
the codes you want sent to your printer:

.pm 1
.tb .4"
.lm .4"
1.
 	h 
 If you create or edit your printer code file with WordStar, 

 	
 you must use non-document mode.

2.
 	h 
 Because of a bug, WordStar does not allow the direct entering 

 	
 of Escape in a file simply by issuing ^P^[.  If you want to 

 	
 get an Escape character into a WordStar file, you must use 

 	
 this work-around:  enter some other character (such as the 

 	
 tilde,~) in the place of each Escape character.  Then, do a 

 	
 ^QA find-and-replace operation:  find the other character, 

 	
 and replace it with ^[ (entered by issuing ^P<Esc> or ^P then 

 	
 the left square bracket).

3.
 	h 
 WordStar places special fence characters around every 

 	
 extended character, even in non-document mode.  Therefore, if 

 	
 you need an extended character (one with a decimal ASCII 

 	
 value greater than 127) in your printer code file, do not 

 	
 insert it directly from WordStar's ^P0 menu or by using <Alt> 

 	
 and the numeric keypad.  Instead, you must use DOSYMSEQ's 

 	
 special notation, \ followed by a decimal ASCII number or \x 

 	
 followed by a hexadecimal ASCII number, as described below in 

 	
 the section on the /B command-line switch.

4.
 	h 
 Although in theory the maximum length for a symmetrical 

 	
 sequence is 65,539 characters, in testing DOSYMSEQ some very 

 	
 weird things happened when the code to be sent to the printer 

 	
 exceeded about 2,000 characters (for instance, opening a file 

 	
 containing such a User Print Control, toggling ^OD, then 

 	
 abandoning the file with ^KQ would result in the codes to be 

 	
 sent to the printer appearing as part of the file directory 

 	
 header on WordStar's Opening Menu).  Joe Masters of WordStar 

 	
 International Corporation is investigating this WordStar bug.   6   2                     
.pa
.pm0
.lm1
WordStar 6 comes with a variety of sample code files that 
DOSYMSEQ can incorporate into User Print Controls.  The files on 
the WordStar Program disk with the extension .HP are for printing 
on LaserJet printers; those on the PostScript disk with the 
extension .PS are for printing on PostScript printers.




2.  To which file should I write the User Print Control 
Symmetrical Sequence?

Again, you can specify just a filename, or a full drive and path 
plus the filename.  If the file already exists, DOSYMSEQ will ask 
you if you want to overwrite it.  If you say "N" for no, you'll 
be asked again to provide a filename.  Once DOSYMSEQ finishes, 
this file will consist entirely of your User Print Control 
symmetrical sequence.




3.  What descriptive characters would you like to have displayed 
on-screen when ^OD (print control display) is off?

You can type any characters you want, up to a maximum of 254.  If 
your User Print Control lets you print a 3/4 fraction symbol, 
then you might simply type "3/4" here.  If your User Print 
Control lets you print the lowercase Greek letter alpha (), you 
might want to enter that character from the extended character 
set (the caution given above about not directly entering extended 
characters into the printer code file does not apply here:  you 
can freely use extended characters at this prompt).  To get an 
extended character, hold down the <Alt> key and tap out on the 
numeric keypad the individual digits of the decimal ASCII code 
for the character you want (there's an appendix listing these 
code numbers in your WordStar Reference Manual).  For alpha, 
which is decimal 224, you'd tap out 2, then 2 again, then 4, then 
release <Alt>.  (Note:  with certain memory-resident programs 
loaded, especially keyboard-macro programs, you may have to hold 
down both <Alt> and <Shift> when tapping out numbers on the 
numeric keypad.)

On the other hand, rather than trying to represent directly what 
the User Print Control will print out, sometimes you'll want to 
describe the function the User Print Control performs.  For 
instance, "Solid black box, one inch square."  Now, here's the 
problem:  WordStar will display this as text in your document 
(although in the attribute usually used for boldface).  If you 
want more separation from the regular text than that, you can 
fence descriptions with brackets or with chevrons (the French 
quotation marks),  and .  You can add chevrons at the beginning 
and end of your descriptive text by holding down <Alt> and 
tapping out 1,7,4 and 1,7,5 on the numeric keypad.     6   2                     
.pa
4.  How many inches should this code account for on the printer?
Enter just the number; do not enter any units.

If the code you are sending to the printer prints an object at 
the current cursor position, enter the horizontal width of that 
object (for instance, if you're printing an alpha in a 10-pitch 
font, enter 0.1.  If you're printing a one-inch square black box, 
enter 1).  On the other hand, if your codes do not print an 
object at the current cursor position (for instance, they instead 
print a border around the page), enter 0.  

WordStar's status-line inch counter will jump by whatever amount 
you specify here as you move over this User Print Control in a 
document.  It will also use this width to make justification and 
word-wrap occur at the correct places.  Note, however, that 
Advanced Page Preview ignores this value.  In this special case, 
Advanced Page Preview will not accurately reflect your printout:  
word-wrap and justification will show at the correct points, but 
the actual spacing of text along the line containing the User 
Print Control will be incorrect.




USING YOUR USER PRINT CONTROL


To use your User Print Control, simply read it into a WordStar 
document file by issuing ^KR and specifying the same filename 
(with drive and path, if the file is not in the currently logged 
directly) to which you told DOSYMSEQ to write the User Print 
Control.  

You can block mark and move the User Print Control within a file 
just as you would any other part of the file.

You can place a User Print Control in a header or footer line if 
you want it to print on every page (useful if your User Print 
Control produces a page border, for instance).  

You can also have the user print control inserted at print time, 
if you like, by using the .FI file-insert command and specifying 
the same filename you told DOSYMSEQ to write the print control 
to:


 	jj!
 .FI D:\PATH\FILENAME.EXT
.pa  /   2                     
THE /B COMMAND-LINE SWITCH


By default, DOSYMSEQ expects the input file to be in ASCII 
format.  Spaces, tabs, carriage returns, and line feeds are 
ignored.

If a ^Z is encountered it is taken as an end-of-file marker and 
is not included in the User Print Control.  (If WSCHANGE label 
SETEOF is set to FF, WordStar will place ^Z characters at the end 
of non-document files; if SETEOF is set to 00, it won't.)

You may enter the Escape character in your code file as either ^[ 
(one control code, not caret and left square bracket) or as the 
backslash character (\).  You can also enter a \ followed by one, 
two, or three digits to specify a character's decimal ASCII 
value:

.tb 2" 3"

 	 
 \32
 	 
 space

 	 
 \77
 	 
 capital "M"

Or, you can enter the backslash, an "x" or "X," and the 
character's hexadecimal ASCII value:


 	 
 \x20
 	8 
 space

 	 
 \x4d
 	8 
 capital "M"

You can get a literal backslash by entering \\ or \92 or \x5C.

If you prefer to have everything in your file copied directly 
without change into the User Print Control, including 
backslashes, spaces, tabs, carriage returns, line feeds, and ^Z 
characters, use the /B command-line switch.  This turns off all 
translation of the input file, treating it as a binary file.




THE /P COMMAND-LINE SWITCH


By default, DOSYMSEQ only writes the output to a file.  However, 
if you specify the /P command-line switch it will also send the 
printer codes (but not the description) to the printer (LPT1) at 
the same time as it writes the output file.  This will allow you 
to test your printer codes directly.  Note that only the printer 
codes are sent:  no carriage return or form feed is added to 
them, since whether or not one of these is needed varies from 
printer to printer.  (If your printer does not eject the page 
after using the /P switch, take the printer off-line and hit the 
form-feed button).  When the /P switch is used, DOSYMSEQ checks 
to see if the printer is ready (by looking for standard IBM/Epson 
error signals).  If it's not ready, DOSYMSEQ will give you an 
error message and wait for you to press any key.     6   2                     
.pa
APPENDIX A:  The Format of a User Print Control


A WordStar ^P!-style User Print Control symmetrical sequence 
consists of a series of bytes, as follows:


.pm 1
.lm 1.5"
.tb 1.5"
One Byte:
 	8
 
 1D hex, which is WordStar's symmetrical sequence 

 	


 delimiter.

Two Bytes:
 	
 
 Total length of the symmetrical sequence minus 

 	


 three, in back-word order (that is, the count is 

 	


 stored low-order byte first and is the sum of all 

 	


 the characters in the symmetrical sequence minus 

 	


 3; thus the count can be added to the starting 

 	


 address of the sequence to point to the second 

 	


 length count as specified below).

One Byte:
 	8
 
 0F hex (identifies this as a User Print Control).

Two Bytes:
 	
 
 Horizontal space to account for on the page, in 

 	


 1800ths of an inch (back-word order).

One Byte:
 	8
 
 Number of characters in the description provided 

 	


 by the user.

String:
 	
 
 The description provided by the user.

String:
 	
 
 The code to be sent to the printer.

Two Bytes:
 	
 
 Again, total length of the symmetrical sequence 

 	


 minus three, in back-word order.

One Byte:
 	8
 
 Again, 1D hex, the symmetrical sequence delimiter.
.pm0
.lm1
.pa  #   2                     
APPENDIX B:  Calling another file from the ^P! Dialog Box



If you have a PostScript printer and WordStar 5.0 or above, you 
can call another file from within a ^P! User Print Control.  If 
you have a PCL printer (such as a Hewlett-Packard LaserJet) or 
any printer that uses WordStar's DRIVERN.OVR, and WordStar 6.0 or 
above, you can also call a file.  

To find out if your printer PDF uses DRIVERN.OVR, issue this 
command from the DOS prompt:

.oc on

 	
 TYPE D:\PATH\FILENAME.PDF
.oc off

where D:\PATH is the drive and directory that contains your 
WordStar program files (normally C:\WS5 or C:\WS for a hard-disk 
install or A: for a floppy-disk install) and FILENAME is the name 
of your printer as shown on WordStar's ^P? "Change Printer" 
screen.  

To use the file-insertion technique, issue ^P!.  In the 
"Characters to send to printer" field of the dialog box, type the 
following:

.oc on  0   2                    

 	jj
 %F"D:\PATH\FILENAME.EXT"
.oc off

The quotation marks are required.  At print time, WordStar will 
insert the contents of the specified file.  Note that this file 
must contain printer codes or a document that has been printed to 
disk; it can't be a normal WordStar document file.

Now, if this capability exists, why use DOSYMSEQ?  Four reasons.  
First, DOSYMSEQ works for all printers, not just those that use 
DRIVERN.OVR.  Second, DOSYMSEQ allows you to insert the code file 
directly into your WordStar document.  That way, it can't be lost 
or separated from the main document when backing up files, 
transferring files to other users, and so on.  Third, by using 
DOSYMSEQ's default mode (no /B command-line switch), you can 
create User Print Controls containing absolutely any character.  
If you simply used WordStar to create files to be called by %F, 
you'd be unable to send ^Z or any extended character to your 
printer.  Fourth, DOSYMSEQ's translation feature makes it easier 
to enter and proofread some codes.  For example, if the printer 
code requires a length byte, as Epson graphics codes do, it is 
easier to enter and proofread this byte as \ followed by the 
decimal number you want than as the corresponding ASCII 
character.  
.pa  1   2                     
APPENDIX C:  Other User Print Control Utilities


You might be interested in other User Print Control support files 
available through the CompuServe WordStar Forum in Library 4 
(6/5.5 Laser Printers).  

LSRBOX.COM creates User Print Controls for use on Hewlett-Packard 
compatible laser printers to draw lines and boxes using the 
printer's PCL commands.  The boxes can be empty, filled with a 
gray scale, or filled with a standard Hewlett Packard graphics 
pattern.  

HOLLOW.COM creates User Print Controls to print hollow (outline) 
text characters using the HP-GL/2 language built into the 
Hewlett-Packard LaserJet III and IIID printers.  

PRINT.99 is a set of User Print Controls for printing multiple 
copies of a document from a LaserJet's memory, instead of 
repeatedly downloading the same document to the printer.  










.oc on

 	!
 * * *
.oc off
.pa      2                     
